/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.reports.filter.declarationparser;

import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.reports.filter.declaration.ForecastRunFilter;
import com.helpsystems.enterprise.core.reports.filter.declarationparser.FilterDeclarationParser;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class ForecastRunFilterParser
implements FilterDeclarationParser<ForecastRunFilter> {
    private static final Logger logger = Logger.getLogger(ForecastRunFilterParser.class);
    private static final String FORECAST_MODEL_PARAM = "-forecastModel";
    private static final String FORECAST_GENERATION_DATE_PARAM = "-date";
    private static final String FORECAST_GENERATION_TIME_PARAM = "-time";
    private static final String FORECAST_LAST_GENERATION_PARAM = "-lastGen";
    private static final int FORECAST_MODEL_PARAM_ID = 16;
    private static final int FORECAST_GENERATION_DATE_PARAM_ID = 17;
    private static final int FORECAST_GENERATION_TIME_PARAM_ID = 18;

    @Override
    public void parseParameters(ForecastRunFilter forecastRunFilter, Object ... objectArray) {
        String string;
        Object object;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n = -1;
        block7: for (int i = 0; i < objectArray.length; ++i) {
            object = objectArray[i];
            string = (String)object;
            if (FORECAST_MODEL_PARAM.equalsIgnoreCase(string)) {
                n = 16;
                continue;
            }
            if (FORECAST_GENERATION_DATE_PARAM.equalsIgnoreCase(string)) {
                n = 17;
                continue;
            }
            if (FORECAST_GENERATION_TIME_PARAM.equalsIgnoreCase(string)) {
                n = 18;
                continue;
            }
            if (FORECAST_LAST_GENERATION_PARAM.equalsIgnoreCase(string)) {
                forecastRunFilter.setLastGeneration(true);
                continue;
            }
            if (string.startsWith("-")) {
                n = -1;
                continue;
            }
            switch (n) {
                case 16: {
                    if (string2 == null) {
                        string2 = string;
                        continue block7;
                    }
                    throw new IllegalArgumentException("Wrong parameter order/definition.");
                }
                case 17: {
                    if (string3 == null) {
                        string3 = string;
                        continue block7;
                    }
                    throw new IllegalArgumentException("Wrong parameter order/definition.");
                }
                case 18: {
                    if (string4 == null) {
                        string4 = string;
                        continue block7;
                    }
                    throw new IllegalArgumentException("Wrong parameter order/definition.");
                }
            }
        }
        Date date = null;
        if (!forecastRunFilter.isLastGeneration()) {
            try {
                if (string3 == null || string4 == null) {
                    object = "Report cannot be generated: Report Last Generation is required parameter.";
                    logger.error(object);
                    throw new IllegalStateException((String)object);
                }
                object = new SimpleDateFormat("yyyyMMdd HHmmss");
                date = ((DateFormat)object).parse(string3 + " " + string4);
            }
            catch (ParseException parseException) {
                string = "Report cannot be generated: Wrong parameter order/definition.";
                logger.error((Object)string);
                throw new IllegalArgumentException(string, parseException);
            }
            if (date != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Calculated forecast generation date: " + date.getTime() + " from: " + string3 + " " + string4));
                    object = Calendar.getInstance();
                    ((Calendar)object).setTimeInMillis(date.getTime());
                    logger.debug((Object)("Calculated forecast generation date: " + ScheduleLogger.formatTimeStampTZ((Calendar)object)));
                }
                forecastRunFilter.setGenerationDate(date.getTime());
            } else {
                logger.warn((Object)"Forecast generation date was null (not calculated).");
            }
        } else {
            forecastRunFilter.setGenerationDate(new Long(0L));
        }
        if (string2 == null) {
            object = "Report cannot be generated: Report Forecast Model is required parameter.";
            logger.error(object);
            throw new IllegalStateException((String)object);
        }
        forecastRunFilter.setForecastModel(string2);
    }
}

