/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.forecast;

import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.scheduler.ForecastableEvent;
import com.helpsystems.enterprise.core.scheduler.PersistableEnum;
import com.helpsystems.enterprise.core.scheduler.PersistanceCodeToEnumMap;

public enum ForecastedObjectType implements PersistableEnum<String>
{
    JOB("Job"),
    JOB_SUITE("JobSuite"),
    MEMBER_JOB("JobSuiteMemberJob"),
    AGENT_EVENT("AgentEventMonitor");

    private String persistanceCode;
    private static PersistanceCodeToEnumMap<String, ForecastedObjectType> map;

    private ForecastedObjectType(String string2) {
        this.persistanceCode = string2;
    }

    @Override
    public String persistanceCode() {
        return this.persistanceCode;
    }

    public static ForecastedObjectType persistanceCodeToEnum(String string) {
        ForecastedObjectType forecastedObjectType = map.get(string);
        if (forecastedObjectType == null) {
            String string2 = MessageUtil.formatMsg((String)"There is no {0} enum constant associated with code: {1}.", (Object[])new Object[]{map.getEnumName(), string});
            throw new IllegalStateException(string2);
        }
        return forecastedObjectType;
    }

    public static ForecastedObjectType forecastableEventToEnum(ForecastableEvent forecastableEvent) {
        return ForecastedObjectType.forecastableEventTypeToEnum(forecastableEvent.getType());
    }

    public static ForecastedObjectType forecastableEventTypeToEnum(ForecastableEvent.ForecastableEventType forecastableEventType) {
        switch (forecastableEventType) {
            case JOB_SUBMISSION: {
                return JOB;
            }
            case JOB_SUITE: {
                return JOB_SUITE;
            }
            case MEMBER_JOB: {
                return MEMBER_JOB;
            }
            case AGENT_EVENT_OCCURS: {
                return AGENT_EVENT;
            }
        }
        throw new IllegalArgumentException(MessageUtil.formatMsg((String)"There is no {0} associated with ForecastableEvent type: {1}.", (Object[])new Object[]{map.getEnumName(), forecastableEventType}));
    }

    static {
        map = new PersistanceCodeToEnumMap((Enum[])ForecastedObjectType.values());
    }
}

