/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.forecast;

import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.busobj.PrereqEventType;
import com.helpsystems.enterprise.core.scheduler.PrereqStatusType;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public abstract class ForecastPrereqEvent {
    long eventID;
    long agentID;
    Calendar timestamp;

    public ForecastPrereqEvent(long l, long l2, Calendar calendar) {
        ValidationHelper.validateReqFieldNotZero((String)"Event ID", (long)l);
        ValidationHelper.checkForNull((String)"Timestamp", (Object)calendar);
        this.eventID = l;
        this.agentID = l2;
        this.timestamp = calendar;
    }

    public long getAgentID() {
        return this.agentID;
    }

    public long getEventID() {
        return this.eventID;
    }

    public abstract PrereqEventType getEventType();

    public abstract PrereqStatusType getStatus();

    public Calendar getTimestamp() {
        return this.timestamp;
    }

    public void setAgentID(long l) {
        this.agentID = l;
    }

    public void setTimestamp(Calendar calendar) {
        this.timestamp = calendar;
    }

    public boolean equals(Object object) {
        if (object instanceof ForecastPrereqEvent) {
            ForecastPrereqEvent forecastPrereqEvent = (ForecastPrereqEvent)object;
            return forecastPrereqEvent.eventID == this.eventID && forecastPrereqEvent.agentID == this.agentID && forecastPrereqEvent.timestamp.getTimeInMillis() == this.timestamp.getTimeInMillis();
        }
        return false;
    }

    public String toString() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm z");
        simpleDateFormat.setTimeZone(this.getTimestamp().getTimeZone());
        return simpleDateFormat.format(this.getTimestamp().getTime()) + " " + this.getEventType() + " " + this.eventID + " " + this.getStatus() + " on Agent " + this.agentID;
    }
}

