/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.exec;

import com.helpsystems.common.tl.PeerDescriptor;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.enterprise.core.busobj.CommandSet;
import com.helpsystems.enterprise.core.busobj.CommandSetCommand;
import com.helpsystems.enterprise.core.busobj.JobEndedReasonCode;
import com.helpsystems.enterprise.core.exec.ExecutableJob;
import com.helpsystems.enterprise.core.exec.JobCompletionInfo;
import com.helpsystems.enterprise.core.scheduler.ScheduleJob;
import java.io.Serializable;
import java.util.ArrayList;
import junit.framework.TestCase;

public class JobCompletionInfoTest
extends TestCase {
    private ArrayList<CommandSetCommand> commands;
    private CommandSet commandSet;
    private ScheduleJob scheduleJob;
    private ExecutableJob job;
    private JobCompletionInfo info;

    protected void setUp() throws Exception {
        super.setUp();
        this.commandSet = new CommandSet();
        this.commands = new ArrayList();
        for (int i = 1; i <= 10; ++i) {
            this.commands.add(new CommandSetCommand("echo " + i));
        }
        for (CommandSetCommand commandSetCommand : this.commands) {
            this.commandSet.addCommand(commandSetCommand);
        }
        this.scheduleJob = new ScheduleJob();
        this.scheduleJob.setCommandSet(this.commandSet);
        this.job = new ExecutableJob();
        this.job.setScheduleJob(this.scheduleJob);
        this.info = new JobCompletionInfo(this.job);
    }

    protected void tearDown() throws Exception {
        this.info = null;
        this.job = null;
        this.scheduleJob = null;
        this.commandSet = null;
        this.commands = null;
        super.tearDown();
    }

    public void testGetExecutableJob() {
        JobCompletionInfoTest.assertEquals((Object)((Object)this.job), (Object)((Object)this.info.getExecutableJob()));
    }

    public void testSetJobLogFilename() {
        this.info.setJobLogFilename("joblogFilename");
        JobCompletionInfoTest.assertEquals((String)"joblogFilename", (String)this.info.getJobLogFilename());
    }

    public void testSetCompletionCode() {
        for (char c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
            this.info.setCompletionCode(c);
            JobCompletionInfoTest.assertEquals((char)c, (char)this.info.getCompletionCode());
        }
    }

    public void testSetFailedAtCommandSequence() {
        this.info.setFailedAtCommandSequence(-3);
        JobCompletionInfoTest.assertEquals((int)-1, (int)this.info.getFailedAtCommandSequence());
        this.info.setFailedAtCommandSequence(-1);
        JobCompletionInfoTest.assertEquals((int)-1, (int)this.info.getFailedAtCommandSequence());
        this.info.setFailedAtCommandSequence(1);
        JobCompletionInfoTest.assertEquals((int)1, (int)this.info.getFailedAtCommandSequence());
        this.info.setFailedAtCommandSequence(5);
        JobCompletionInfoTest.assertEquals((int)5, (int)this.info.getFailedAtCommandSequence());
        this.info.setFailedAtCommandSequence(23);
        JobCompletionInfoTest.assertEquals((int)23, (int)this.info.getFailedAtCommandSequence());
    }

    public void testSetCause() {
        Throwable throwable = new Throwable();
        this.info.setCause(throwable);
        JobCompletionInfoTest.assertEquals((Object)throwable, (Object)this.info.getCause());
    }

    public void testSetPeerID() {
        PeerDescriptor peerDescriptor = new PeerDescriptor("address", 2012, 4, "WINDOZE");
        PeerID peerID = PeerID.createPeerID((String)"hardwareKey", (Serializable)((Object)"instanceIdentifier"), (PeerDescriptor)peerDescriptor);
        this.info.setPeerID(peerID);
        JobCompletionInfoTest.assertEquals((Object)peerID, (Object)this.info.getPeerID());
    }

    public void testSetTerminationReason() {
        this.info.setTerminationReason("terminationReason");
        JobCompletionInfoTest.assertEquals((String)"terminationReason", (String)this.info.getTerminationReason());
    }

    public void testSetWhenEnded() {
        this.info.setWhenEnded(123948217438L);
        JobCompletionInfoTest.assertEquals((long)123948217438L, (long)this.info.getWhenEnded());
    }

    public void testSetWhenStarted() {
        this.info.setWhenStarted(12395534438L);
        JobCompletionInfoTest.assertEquals((long)12395534438L, (long)this.info.getWhenStarted());
    }

    public void testSetJobLogProcessingFinished() {
        this.info.setJobLogProcessingFinished(false);
        JobCompletionInfoTest.assertFalse((boolean)this.info.isJobLogProcessFinished());
        this.info.setJobLogProcessingFinished(true);
        JobCompletionInfoTest.assertTrue((boolean)this.info.isJobLogProcessFinished());
    }

    public void testSetJobExecLogTransferred() {
        this.info.setJobExecLogTransferred(false);
        JobCompletionInfoTest.assertFalse((boolean)this.info.isJobExecLogTransferred());
        this.info.setJobExecLogTransferred(true);
        JobCompletionInfoTest.assertTrue((boolean)this.info.isJobExecLogTransferred());
    }

    public void testSetJobEndedReasonCode() {
        this.info.setJobEndedReasonCode(JobEndedReasonCode.AGENT_ENDED);
        JobCompletionInfoTest.assertEquals((Object)JobEndedReasonCode.AGENT_ENDED, (Object)this.info.getJobEndedReasonCode());
        this.info.setJobEndedReasonCode(JobEndedReasonCode.AGENT_MISSING);
        JobCompletionInfoTest.assertEquals((Object)JobEndedReasonCode.AGENT_MISSING, (Object)this.info.getJobEndedReasonCode());
        this.info.setJobEndedReasonCode(JobEndedReasonCode.COMMAND_FAILURE);
        JobCompletionInfoTest.assertEquals((Object)JobEndedReasonCode.COMMAND_FAILURE, (Object)this.info.getJobEndedReasonCode());
        this.info.setJobEndedReasonCode(JobEndedReasonCode.ENDED_MANUALLY);
        JobCompletionInfoTest.assertEquals((Object)JobEndedReasonCode.ENDED_MANUALLY, (Object)this.info.getJobEndedReasonCode());
    }

    public void testDeprecatedConstructor() {
        this.info = new JobCompletionInfo();
        JobCompletionInfoTest.assertEquals((int)-1, (int)this.info.getFailedAtCommandSequence());
    }
}

