/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.exec;

import com.helpsystems.common.tl.PeerID;
import com.helpsystems.enterprise.core.busobj.EnterpriseVersionedObject;
import com.helpsystems.enterprise.core.busobj.JobEndedReasonCode;
import com.helpsystems.enterprise.core.exec.ExecutableJob;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JobCompletionInfo
extends EnterpriseVersionedObject {
    public static final char COMPLETION_CODE_FAIL = 'F';
    public static final char COMPLETION_CODE_SUCCESS = 'C';
    public static final char COMPLETION_CODE_ERROR = 'E';
    public static final char COMPLETION_CODE_CANCELED = 'A';
    public static final int DID_NOT_FAIL = -1;
    private static final long serialVersionUID = -9177041420198673945L;
    private String joblogFilename;
    private char completionCode;
    private Throwable badThing;
    private PeerID peerID;
    private PeerID filePeerID;
    private ExecutableJob ej;
    private int failedAtCommandSequence = -1;
    private ArrayList<Long> startedSAPInterceptedJobIDs = new ArrayList();
    private String terminationData;
    private String terminationReason;
    private JobEndedReasonCode jobEndedReasonCode;
    private long whenStarted;
    private long whenEnded;
    private boolean jobLogProcessingFinished;
    private boolean fileTransferFinished;
    private boolean jobExecLogTransferred;
    private Map<Long, List<String>> agentOutputFileMap;
    private boolean wasTerminatedByServer;
    private boolean supportingOutputDistribution = true;

    public JobCompletionInfo() {
        this.agentOutputFileMap = new HashMap<Long, List<String>>();
    }

    public JobCompletionInfo(ExecutableJob executableJob) {
        this.ej = executableJob;
        this.agentOutputFileMap = new HashMap<Long, List<String>>();
    }

    public ExecutableJob getExecutableJob() {
        return this.ej;
    }

    public String getJobLogFilename() {
        return this.joblogFilename;
    }

    public void setJobLogFilename(String string) {
        this.joblogFilename = string;
    }

    public char getCompletionCode() {
        return this.completionCode;
    }

    public void setCompletionCode(char c) {
        this.completionCode = c;
    }

    public int getFailedAtCommandSequence() {
        return this.failedAtCommandSequence;
    }

    public void setFailedAtCommandSequence(int n) {
        this.failedAtCommandSequence = n < 0 ? -1 : n;
    }

    public ArrayList<Long> getStartedSAPInterceptedJobIDs() {
        return this.startedSAPInterceptedJobIDs;
    }

    public void setStartedSAPInterceptedJobIDs(ArrayList<Long> arrayList) {
        this.startedSAPInterceptedJobIDs = arrayList;
    }

    public Throwable getCause() {
        return this.badThing;
    }

    public void setCause(Throwable throwable) {
        this.badThing = throwable;
    }

    public PeerID getPeerID() {
        return this.peerID;
    }

    public void setPeerID(PeerID peerID) {
        this.peerID = peerID;
    }

    public PeerID getFilePeerID() {
        return this.filePeerID;
    }

    public void setFilePeerID(PeerID peerID) {
        this.filePeerID = peerID;
    }

    public String getTerminationReason() {
        return this.terminationReason;
    }

    public void setTerminationReason(String string) {
        this.terminationReason = string;
    }

    public long getWhenEnded() {
        return this.whenEnded;
    }

    public void setWhenEnded(long l) {
        this.whenEnded = l;
    }

    public long getWhenStarted() {
        return this.whenStarted;
    }

    public void setWhenStarted(long l) {
        this.whenStarted = l;
    }

    public boolean isJobLogProcessFinished() {
        return this.jobLogProcessingFinished;
    }

    public void setJobLogProcessingFinished(boolean bl) {
        this.jobLogProcessingFinished = bl;
    }

    public boolean isFileTransferFinished() {
        return this.fileTransferFinished;
    }

    public void setFileTransferFinished(boolean bl) {
        this.fileTransferFinished = bl;
    }

    public boolean isJobExecLogTransferred() {
        return this.jobExecLogTransferred;
    }

    public void setJobExecLogTransferred(boolean bl) {
        this.jobExecLogTransferred = bl;
    }

    public void setJobEndedReasonCode(JobEndedReasonCode jobEndedReasonCode) {
        this.jobEndedReasonCode = jobEndedReasonCode;
    }

    public JobEndedReasonCode getJobEndedReasonCode() {
        return this.jobEndedReasonCode;
    }

    public String toString() {
        String string = "";
        string = string + "\n peerID: " + this.peerID;
        string = string + "\n joblogFilename: " + this.joblogFilename;
        string = string + "\n completionCode: " + this.completionCode;
        string = string + "\n failedAtCommandSequence: " + this.failedAtCommandSequence;
        string = string + "\n terminationReason: " + this.terminationReason;
        string = string + "\n jobEndedReasonCode: " + this.jobEndedReasonCode;
        string = string + "\n whenStarted: " + this.whenStarted;
        string = string + "\n whenEnded: " + this.whenEnded;
        string = string + "\n jobLogProcessingFinished: " + this.jobLogProcessingFinished;
        string = string + "\n jobExecLogTransferred: " + this.jobExecLogTransferred;
        string = string + "\n wasTerminatedByServer: " + this.wasTerminatedByServer;
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAgentOutputFile(Map<Long, List<String>> map) {
        Map<Long, List<String>> map2 = this.agentOutputFileMap;
        synchronized (map2) {
            this.agentOutputFileMap.putAll(map);
        }
    }

    public String getTerminationData() {
        return this.terminationData;
    }

    public void setTerminationData(String string) {
        this.terminationData = string;
    }

    public void setTerminatedByServer(boolean bl) {
        this.wasTerminatedByServer = bl;
    }

    public boolean wasTerminatedByServer() {
        return this.wasTerminatedByServer;
    }

    public boolean isSupportingOutputDistribution() {
        return this.supportingOutputDistribution;
    }

    public void setSupportingOutputDistribution(boolean bl) {
        this.supportingOutputDistribution = bl;
    }

    public Map<Long, List<String>> getAgentOutputFile() {
        return this.agentOutputFileMap;
    }
}

