/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj.traps;

import com.helpsystems.enterprise.core.busobj.traps.EnterpriseSNMPTrap;
import java.sql.Timestamp;
import junit.framework.TestCase;

public class EnterpriseSNMPTrapTest
extends TestCase {
    private EnterpriseSNMPTrap trap;

    protected void setUp() throws Exception {
        super.setUp();
        this.trap = new EnterpriseSNMPTrap();
    }

    protected void tearDown() throws Exception {
        this.trap = null;
        super.tearDown();
    }

    public void testGetServerDateTime() {
        Timestamp timestamp = Timestamp.valueOf("2009-01-02 03:04:05.123456789");
        this.trap.setServerDateTime(timestamp);
        EnterpriseSNMPTrapTest.assertEquals((Object)timestamp, (Object)this.trap.getServerDateTime());
    }

    public void testServerDateTimeVariableBindings() {
        Timestamp timestamp = Timestamp.valueOf("2009-01-02 03:04:05.123456789");
        this.trap.setServerDateTime(timestamp);
        EnterpriseSNMPTrapTest.assertEquals((String)"2009-01-02", (String)this.trap.getVariableBinding("1.3.6.1.4.1.6872.2.1.1.5"));
        EnterpriseSNMPTrapTest.assertEquals((String)"03:04 CST", (String)this.trap.getVariableBinding("1.3.6.1.4.1.6872.2.1.1.6"));
    }

    public void testServerDateTimeRejectsNullValue() {
        try {
            this.trap.setServerDateTime(null);
            EnterpriseSNMPTrapTest.fail((String)"setServerDateTime() allowed null value");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testGetSeverity() {
        this.trap.setSeverity("WR");
        EnterpriseSNMPTrapTest.assertEquals((String)"WR", (String)this.trap.getSeverity());
        EnterpriseSNMPTrapTest.assertEquals((String)"WR", (String)this.trap.getVariableBinding("1.3.6.1.4.1.6872.2.1.1.9"));
    }

    public void testSetSeverityRejectsInvalidValue() {
        try {
            this.trap.setSeverity("BOGUS");
            EnterpriseSNMPTrapTest.fail((String)"setSeverity() accepted invalid value");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetText() {
        this.trap.setText("text");
        EnterpriseSNMPTrapTest.assertEquals((String)"text", (String)this.trap.getText());
        EnterpriseSNMPTrapTest.assertEquals((String)"text", (String)this.trap.getVariableBinding("1.3.6.1.4.1.6872.2.1.1.7"));
        this.trap.setText(null);
        EnterpriseSNMPTrapTest.assertEquals((String)"text", (String)this.trap.getText());
        EnterpriseSNMPTrapTest.assertEquals((String)" ", (String)this.trap.getVariableBinding("1.3.6.1.4.1.6872.2.1.1.7"));
    }

    public void testGetType() {
        this.trap.setType(16);
        EnterpriseSNMPTrapTest.assertEquals((int)16, (int)this.trap.getType());
    }

    public void testSetTypeRejectsInvalidValue() {
        try {
            this.trap.setType(293842834);
            EnterpriseSNMPTrapTest.fail((String)"setType() accepted invalid value");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testEqualsObject() {
        this.trap.setType(16);
        this.trap.setServerDateTime(Timestamp.valueOf("2009-01-02 03:04:05.123456789"));
        this.trap.setSeverity("AT");
        this.trap.setText("text");
        EnterpriseSNMPTrapTest.assertFalse((boolean)this.trap.equals(null));
        EnterpriseSNMPTrapTest.assertFalse((boolean)this.trap.equals(new Object()));
        EnterpriseSNMPTrapTest.assertTrue((boolean)this.trap.equals((Object)this.trap));
        EnterpriseSNMPTrap enterpriseSNMPTrap = new EnterpriseSNMPTrap();
        enterpriseSNMPTrap.setType(16);
        enterpriseSNMPTrap.setServerDateTime(Timestamp.valueOf("2009-01-02 03:04:05.123456789"));
        enterpriseSNMPTrap.setSeverity("AT");
        enterpriseSNMPTrap.setText("text");
        EnterpriseSNMPTrapTest.assertTrue((boolean)this.trap.equals((Object)enterpriseSNMPTrap));
        EnterpriseSNMPTrapTest.assertTrue((boolean)enterpriseSNMPTrap.equals((Object)this.trap));
        enterpriseSNMPTrap.setType(17);
        EnterpriseSNMPTrapTest.assertFalse((boolean)this.trap.equals((Object)enterpriseSNMPTrap));
        enterpriseSNMPTrap.setType(16);
        enterpriseSNMPTrap.setServerDateTime(Timestamp.valueOf("1966-12-14 21:51:45.000000000"));
        EnterpriseSNMPTrapTest.assertFalse((boolean)this.trap.equals((Object)enterpriseSNMPTrap));
        enterpriseSNMPTrap.setServerDateTime(Timestamp.valueOf("2009-01-02 03:04:05.123456789"));
        enterpriseSNMPTrap.setSeverity("WR");
        EnterpriseSNMPTrapTest.assertFalse((boolean)this.trap.equals((Object)enterpriseSNMPTrap));
        enterpriseSNMPTrap.setSeverity("AT");
        enterpriseSNMPTrap.setText("different_text");
        EnterpriseSNMPTrapTest.assertFalse((boolean)this.trap.equals((Object)enterpriseSNMPTrap));
        enterpriseSNMPTrap.setText("text");
        EnterpriseSNMPTrapTest.assertTrue((boolean)this.trap.equals((Object)enterpriseSNMPTrap));
    }
}

