/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj.sap;

import com.helpsystems.enterprise.core.busobj.EnterpriseProxy;
import com.helpsystems.enterprise.core.busobj.sap.SAPJobStatus;
import com.helpsystems.enterprise.core.busobj.sap.SAPObject;

public class SAPJobProxy
extends EnterpriseProxy
implements SAPObject {
    private static final long serialVersionUID = -1L;
    private long OID;
    private long sapSystemDefinitionID;
    private String jobName;
    private String jobCount;
    private SAPJobStatus jobStatus;
    private String parentChildStatus;
    private long plannedStartMS;
    private long jobStartTimeMS;
    private long jobEndTimeMS;
    private boolean periodic;

    public SAPJobProxy() {
    }

    public SAPJobProxy(String string, String string2) {
        this.jobName = string;
        this.setJobCount(string2);
    }

    public SAPJobProxy(long l, String string, String string2, SAPJobStatus sAPJobStatus) {
        this.sapSystemDefinitionID = l;
        this.jobName = string;
        this.setJobCount(string2);
        this.jobStatus = sAPJobStatus;
    }

    public void setOID(long l) {
        this.OID = l;
    }

    public long getOID() {
        return this.OID;
    }

    public void setSapSystemDefinitionID(long l) {
        this.sapSystemDefinitionID = l;
    }

    public long getSapSystemDefinitionID() {
        return this.sapSystemDefinitionID;
    }

    public void setJobName(String string) {
        this.jobName = string;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobCount(String string) {
        this.jobCount = String.format("%8s", string).replace(' ', '0');
    }

    public String getJobCount() {
        return this.jobCount;
    }

    public void setJobStatus(SAPJobStatus sAPJobStatus) {
        this.jobStatus = sAPJobStatus;
    }

    public SAPJobStatus getJobStatus() {
        return this.jobStatus;
    }

    public void setParentChildStatus(String string) {
        this.parentChildStatus = string;
    }

    public String getParentChildStatus() {
        return this.parentChildStatus;
    }

    public boolean isWithChildJobs() {
        return this.parentChildStatus.equals("P") || this.parentChildStatus.equals("B");
    }

    public void setJobStatusAsString(String string) {
        this.jobStatus = SAPJobStatus.persistanceCodeToEnum(string);
    }

    public String getJobStatusAsString() {
        return this.jobStatus.persistanceCode();
    }

    public String getNameAndCount() {
        return this.getJobName() + "(" + this.getJobCount() + ")";
    }

    public long getPlannedStartMS() {
        return this.plannedStartMS;
    }

    public void setPlannedStartMS(long l) {
        this.plannedStartMS = l;
    }

    public long getJobStartTimeMS() {
        return this.jobStartTimeMS;
    }

    public void setJobStartTimeMS(long l) {
        this.jobStartTimeMS = l;
    }

    public long getJobEndTimeMS() {
        return this.jobEndTimeMS;
    }

    public void setJobEndTimeMS(long l) {
        this.jobEndTimeMS = l;
    }

    public void setPeriodicAsString(String string) {
        if (string.length() > 0) {
            this.setPeriodic(true);
        } else {
            this.setPeriodic(false);
        }
    }

    public void setPeriodic(boolean bl) {
        this.periodic = bl;
    }

    public boolean isPeriodic() {
        return this.periodic;
    }

    public boolean getPeriodic() {
        return this.periodic;
    }

    public String getPeriodicAsString() {
        if (this.periodic) {
            return "X";
        }
        return "";
    }
}

