/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj.sap;

import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.sap.SAPPollJobsInfo;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.concurrent.BlockingQueue;
import org.apache.log4j.Logger;

public abstract class SAPJobProcessor
implements Runnable {
    private static Logger logger = Logger.getLogger(SAPJobProcessor.class);
    public static final int ONE_DAY_IN_MS = 86400000;
    private static NumberFormat numberFormatter = NumberFormat.getNumberInstance();
    private SAPPollJobsInfo emptyPollInfo = new SAPPollJobsInfo(SAPPollJobsInfo.SAPPollJobType.EITHER, 0L, "", 0L);

    protected SAPPollJobsInfo getNextPollInfo(BlockingQueue<SAPPollJobsInfo> blockingQueue) throws InterruptedException {
        if (blockingQueue.isEmpty()) {
            return this.emptyPollInfo;
        }
        SAPPollJobsInfo sAPPollJobsInfo = blockingQueue.take();
        return sAPPollJobsInfo;
    }

    protected long getNewWaitTime(SAPPollJobsInfo sAPPollJobsInfo) throws NowOrPastException {
        return this.getNewWaitTime(sAPPollJobsInfo, false);
    }

    protected long getNewWaitTime(SAPPollJobsInfo sAPPollJobsInfo, boolean bl) throws NowOrPastException {
        long l = System.currentTimeMillis();
        if (sAPPollJobsInfo.getPollTimeMS() <= l) {
            throw new NowOrPastException();
        }
        long l2 = sAPPollJobsInfo.getPollTimeMS() - l;
        if (l2 < 1000L) {
            l2 += 500L;
        }
        l2 = this.roundToNearestSecond(l2);
        if (logger.isDebugEnabled()) {
            this.postPollWaitMessage(sAPPollJobsInfo, bl);
        }
        return l2;
    }

    private void postPollWaitMessage(SAPPollJobsInfo sAPPollJobsInfo, boolean bl) {
        logger.debug((Object)("Automate Schedule will now wait until " + this.getDateTimeString(sAPPollJobsInfo.getPollTimeMS()) + " to poll SAP System " + sAPPollJobsInfo.getSapSystemName() + "(" + sAPPollJobsInfo.getSapSystemDefinitionID() + ") for " + sAPPollJobsInfo.getPollJobType().getTypeString()));
        if (bl) {
            ScheduleLogEntry scheduleLogEntry = null;
            String[] stringArray = new String[]{sAPPollJobsInfo.getSapSystemName(), ScheduleLogger.formatTimeStamp(sAPPollJobsInfo.getPollTimeMS())};
            switch (sAPPollJobsInfo.getPollJobType()) {
                case SAP_TERMINAL_JOBS: {
                    scheduleLogEntry = RosettaMsg.SAP_NEXT_REMOVE_POLL_TIME.newLogEntry(stringArray);
                    logger.debug((Object)scheduleLogEntry.getMessageText());
                }
            }
            if (scheduleLogEntry != null) {
                ScheduleLogger.write(scheduleLogEntry);
            }
        }
    }

    private String getDateTimeString(long l) {
        String string = "";
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        String string2 = "";
        String string3 = "";
        string2 = numberFormatter.format(calendar.get(12));
        string3 = numberFormatter.format(calendar.get(13));
        string = calendar.get(1) + "." + (calendar.get(2) + 1) + "." + calendar.get(5) + " at " + calendar.get(11) + ":" + string2 + ":" + string3;
        return string;
    }

    private long roundToNearestSecond(long l) {
        return (l + 500L) / 1000L * 1000L;
    }

    public abstract void loadInitialPollInfoObjects();

    public abstract void stopPollingForSystem(long var1);

    protected abstract void processNextPollForThisSystem(long var1);

    public abstract void resetPollingForSystem(long var1, String var3, int var4);

    protected void removeSystemFromPollQueue(long l, BlockingQueue<SAPPollJobsInfo> blockingQueue) {
        this.reconfigurePollQueue(l, blockingQueue, null, null);
    }

    protected void removeSystemFromPollQueue(long l, BlockingQueue<SAPPollJobsInfo> blockingQueue, SAPPollJobsInfo sAPPollJobsInfo) {
        this.reconfigurePollQueue(l, blockingQueue, sAPPollJobsInfo, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reconfigurePollQueue(long l, BlockingQueue<SAPPollJobsInfo> blockingQueue, SAPPollJobsInfo sAPPollJobsInfo, SAPPollJobsInfo sAPPollJobsInfo2) {
        ArrayList arrayList = new ArrayList();
        ArrayList<SAPPollJobsInfo> arrayList2 = new ArrayList<SAPPollJobsInfo>();
        if (sAPPollJobsInfo != null) {
            arrayList2.add(sAPPollJobsInfo);
        }
        if (sAPPollJobsInfo2 != null) {
            arrayList2.add(sAPPollJobsInfo2);
        }
        BlockingQueue<SAPPollJobsInfo> blockingQueue2 = blockingQueue;
        synchronized (blockingQueue2) {
            blockingQueue.drainTo(arrayList);
            if (!arrayList.isEmpty()) {
                for (SAPPollJobsInfo sAPPollJobsInfo3 : arrayList) {
                    if (sAPPollJobsInfo3.getSapSystemDefinitionID() == l) continue;
                    arrayList2.add(sAPPollJobsInfo3);
                }
            }
            blockingQueue.addAll(arrayList2);
        }
    }

    protected void postPollInfo(SAPPollJobsInfo sAPPollJobsInfo, BlockingQueue<SAPPollJobsInfo> blockingQueue) {
        blockingQueue.offer(sAPPollJobsInfo);
        logger.debug((Object)("SAP System " + sAPPollJobsInfo.getSapSystemName() + "(" + sAPPollJobsInfo.getSapSystemDefinitionID() + ") is scheduled to poll " + sAPPollJobsInfo.getPollJobType().getTypeString() + " on " + this.getDateTimeString(sAPPollJobsInfo.getPollTimeMS())));
    }

    public abstract void processSAPSystemJobs(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSystemInPollQueue(long l, BlockingQueue<SAPPollJobsInfo> blockingQueue) {
        BlockingQueue<SAPPollJobsInfo> blockingQueue2 = blockingQueue;
        synchronized (blockingQueue2) {
            if (blockingQueue.isEmpty()) {
                return false;
            }
            for (SAPPollJobsInfo sAPPollJobsInfo : blockingQueue) {
                if (sAPPollJobsInfo.getSapSystemDefinitionID() != l) continue;
                return true;
            }
        }
        return false;
    }

    static {
        numberFormatter.setMinimumIntegerDigits(2);
    }

    public class NowOrPastException
    extends Exception {
    }
}

