/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj.actions;

import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.enterprise.core.busobj.actions.ActionEvent;
import com.helpsystems.enterprise.core.cmdlineobj.ReportCommand;
import com.helpsystems.enterprise.core.reports.ReportOutput;
import org.apache.log4j.Logger;

public class GenerateReportEvent
extends ActionEvent {
    private static final Logger logger = Logger.getLogger(GenerateReportEvent.class);
    private static final long serialVersionUID = 6585911908623825270L;
    private int reportID = -1;
    private String reportName = null;
    private Object[] params = null;
    private ReportOutput.OutputType outputType = ReportOutput.OutputType.PDF;

    public GenerateReportEvent() {
    }

    public GenerateReportEvent(String string, String string2, ReportOutput.OutputType outputType, Object[] objectArray) {
        this.setUser(string);
        this.setReportName(string2);
        this.setOutputType(outputType);
        this.params = objectArray;
    }

    public void setOutputType(ReportOutput.OutputType outputType) {
        this.outputType = outputType;
    }

    public ReportOutput.OutputType getOutputType() {
        return this.outputType;
    }

    @Override
    public void setActionCode() {
        this.setActionCode(2008);
    }

    @Override
    public String getActionString() {
        return "GenerateReportEvent";
    }

    public boolean equals(Object object) {
        return false;
    }

    public String getReportName() {
        return this.reportName;
    }

    public int getReportID() {
        return this.reportID;
    }

    public void setParams(Object[] objectArray) {
        this.params = objectArray;
    }

    public Object[] getParams() {
        return this.params;
    }

    private void setReportName(String string) {
        int n = -1;
        try {
            n = Integer.parseInt(string.trim());
        }
        catch (Exception exception) {
            throw new IllegalStateException("Report ID:" + string + " is not supported.");
        }
        logger.debug((Object)("Setting report name for Report ID: " + string));
        switch (n) {
            case 0: {
                this.reportName = "GoodMorningReport";
                this.reportID = n;
                break;
            }
            case 100: {
                this.reportName = "JobSetupReport";
                this.reportID = n;
                break;
            }
            case 1000: {
                this.reportName = "JobHistoryReport";
                this.reportID = n;
                break;
            }
            case 1001: {
                this.reportName = "AgentEventHistoryReport";
                this.reportID = n;
                break;
            }
            case 1002: {
                this.reportName = "JobMonitorHistoryReport";
                this.reportID = n;
                break;
            }
            case 1003: {
                this.reportName = "OutputDistributionHistoryReport";
                this.reportID = n;
                break;
            }
            case 1004: {
                this.reportName = "SNMPTrapMonitorHistoryReport";
                this.reportID = n;
                break;
            }
            case 1005: {
                this.reportName = "AuditHistoryReport";
                this.reportID = n;
                break;
            }
            case 1006: {
                this.reportName = "ForecastedJobRunsReport";
                this.reportID = n;
                break;
            }
            case 1007: {
                this.reportName = "ServerHistoryReport";
                this.reportID = n;
                break;
            }
            case 1008: {
                this.reportName = "ImportValidationReport";
                this.reportID = n;
                break;
            }
            case 1009: {
                this.reportName = "SAPSystemDefinitionReport";
                this.reportID = n;
                break;
            }
            case 1010: {
                this.reportName = "SAPJobDefinitionReport";
                this.reportID = n;
                break;
            }
            case 1011: {
                this.reportName = "SAPAbapStepSetReport";
                this.reportID = n;
                break;
            }
            case 1012: {
                this.reportName = "SAPInterceptedJobHistoryReport";
                this.reportID = n;
                break;
            }
            case 1013: {
                this.reportName = "SAPRunInterceptedJobsReport";
                this.reportID = n;
                break;
            }
            case 1014: {
                this.reportName = "SecurityReport";
                this.reportID = n;
                break;
            }
            default: {
                throw new IllegalStateException("Report ID:" + string + " is not supported.");
            }
        }
    }

    public ReportCommand getReportCommand() throws ActionFailedException {
        ReportCommand reportCommand = new ReportCommand(this.getReportID());
        reportCommand.setParameters(this.getParams());
        reportCommand.setRunAsUser(this.getUser());
        reportCommand.setOutputType(this.getOutputType());
        return reportCommand;
    }
}

