/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj.actions;

import com.helpsystems.enterprise.core.busobj.actions.JobQueueControlEvent;
import java.util.Arrays;
import junit.framework.TestCase;

public class ControlAgentQueueEventTest
extends TestCase {
    private JobQueueControlEvent event;

    protected void setUp() throws Exception {
        super.setUp();
        this.event = new JobQueueControlEvent();
    }

    protected void tearDown() throws Exception {
        this.event = null;
        super.tearDown();
    }

    public void testEqualsObject() {
        this.event = new JobQueueControlEvent();
        this.event.setGUID("guid");
        this.event.setActionRequest(1234567L);
        JobQueueControlEvent jobQueueControlEvent = new JobQueueControlEvent();
        jobQueueControlEvent.setGUID("guid");
        jobQueueControlEvent.setActionRequest(1234567L);
        JobQueueControlEvent jobQueueControlEvent2 = new JobQueueControlEvent();
        jobQueueControlEvent2.setGUID("different_guid");
        jobQueueControlEvent2.setActionRequest(7654321L);
        ControlAgentQueueEventTest.assertFalse((boolean)this.event.equals(null));
        ControlAgentQueueEventTest.assertFalse((boolean)this.event.equals(new Object()));
        ControlAgentQueueEventTest.assertTrue((boolean)this.event.equals((Object)jobQueueControlEvent));
        ControlAgentQueueEventTest.assertTrue((boolean)jobQueueControlEvent.equals((Object)this.event));
        ControlAgentQueueEventTest.assertFalse((boolean)this.event.equals((Object)jobQueueControlEvent2));
        jobQueueControlEvent2.setGUID(this.event.getGUID());
        ControlAgentQueueEventTest.assertFalse((boolean)this.event.equals((Object)jobQueueControlEvent2));
        jobQueueControlEvent2.setActionRequest(this.event.getActionRequest());
        jobQueueControlEvent2.setGUID("different_guid");
        ControlAgentQueueEventTest.assertFalse((boolean)this.event.equals((Object)jobQueueControlEvent2));
    }

    public void testGetActionString() {
        ControlAgentQueueEventTest.assertEquals((String)"ControlAgentQueueEvent", (String)this.event.getActionString());
    }

    public void testGetJobQueueIDs() {
        this.event.setJobQueueID(123456L);
        long[] lArray = this.event.getJobQueueIDs();
        ControlAgentQueueEventTest.assertEquals((int)1, (int)lArray.length);
        ControlAgentQueueEventTest.assertEquals((long)123456L, (long)lArray[0]);
        long[] lArray2 = new long[]{234L, 567L, 890L};
        this.event.setJobQueueIDs(lArray2);
        long[] lArray3 = this.event.getJobQueueIDs();
        ControlAgentQueueEventTest.assertEquals((int)3, (int)lArray3.length);
        ControlAgentQueueEventTest.assertTrue((boolean)Arrays.equals(lArray3, lArray2));
    }

    public void testIsHold() {
        this.event.setHold(false);
        ControlAgentQueueEventTest.assertFalse((boolean)this.event.isHold());
        this.event.setHold(true);
        ControlAgentQueueEventTest.assertTrue((boolean)this.event.isHold());
    }

    public void testParseParms() {
        this.event = new JobQueueControlEvent("user", "guid", new long[]{123L}, "PARMS:HOLD:TRUE");
        ControlAgentQueueEventTest.assertEquals((String)"user", (String)this.event.getUser());
        ControlAgentQueueEventTest.assertEquals((String)"guid", (String)this.event.getGUID());
        ControlAgentQueueEventTest.assertTrue((boolean)Arrays.equals(new long[]{123L}, this.event.getJobQueueIDs()));
        ControlAgentQueueEventTest.assertTrue((boolean)this.event.isHold());
        this.event = new JobQueueControlEvent("userx", "guidx", new long[]{123L, 456L, 789L}, "PARMS:HOLD:FALSE");
        ControlAgentQueueEventTest.assertEquals((String)"userx", (String)this.event.getUser());
        ControlAgentQueueEventTest.assertEquals((String)"guidx", (String)this.event.getGUID());
        ControlAgentQueueEventTest.assertTrue((boolean)Arrays.equals(new long[]{123L, 456L, 789L}, this.event.getJobQueueIDs()));
        ControlAgentQueueEventTest.assertFalse((boolean)this.event.isHold());
        this.event = new JobQueueControlEvent("user", "guid", new long[]{456L, 789L}, "BAD:PARMS");
        ControlAgentQueueEventTest.assertFalse((boolean)this.event.isHold());
    }
}

