/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.busobj.AgentGroup;
import com.helpsystems.enterprise.core.busobj.AgentGroupType;
import com.helpsystems.enterprise.core.busobj.BalancedAgentGroup;
import java.util.Map;
import org.apache.log4j.Logger;

public class UtilizationBalancedAgentGroup
extends BalancedAgentGroup {
    private static final Logger logger = Logger.getLogger(BalancedAgentGroup.class);
    public static int ERROR_SCORE_VALUE = 1600000000;
    public static int UNLICENSED_SCORE_VALUE = 800000000;
    public static int HELD_AGENT_SCORE_VALUE = 400000000;
    public static int OFFLINE_SCORE_VALUE = 200000000;
    public static int HELD_JOB_QUEUE_SCORE_VALUE = 100000000;
    private int[] scores;

    public UtilizationBalancedAgentGroup(AgentGroup agentGroup) {
        super(agentGroup);
        this.setAgentGroupType(AgentGroupType.UTILIZATION_BALANCED);
    }

    @Override
    public long chooseAgent() {
        if (this.agentIDs == null || this.scores == null || this.scores.length != this.agentIDs.length) {
            throw new IllegalStateException("Program error: Unable to choose an agent because the data fields have not been properly set.");
        }
        this.validateThatThereAreUnignoredAgentsToChooseFrom();
        int n = this.lastChoice;
        do {
            n = this.next(n);
        } while (this.lowestScore() < this.scores[n]);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)this.scoreString(n));
        }
        this.lastChoice = n;
        return this.agentIDs[n];
    }

    public void setScores(Map<Long, Integer> map) {
        ValidationHelper.checkForNull((String)"Scores map", map);
        if (map.size() != this.agentIDs.length) {
            throw new IllegalStateException("Program error: scoreMap size does not equal agentIDs length.");
        }
        if (this.scores == null || this.scores.length != this.agentIDs.length) {
            this.scores = new int[this.agentIDs.length];
        }
        for (int i = 0; i < this.agentIDs.length; ++i) {
            long l = this.agentIDs[i];
            Integer n = map.get(l);
            if (n == null) {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Unable to find a score for agent ID {0}.", (Object[])new Object[]{l}));
            }
            this.scores[i] = n;
        }
    }

    private int lowestScore() {
        int n = this.scores[0];
        for (int i = 0; i < this.scores.length; ++i) {
            if (this.scores[i] == 0) {
                return 0;
            }
            if (this.scores[i] >= n) continue;
            n = this.scores[i];
        }
        return n;
    }

    private String scoreString(int n) {
        int n2;
        if (this.scores.length == 0) {
            return "";
        }
        String[] stringArray = new String[this.agentIDs.length];
        for (int i = 0; i < stringArray.length; ++i) {
            n2 = this.scores[i];
            int n3 = this.utilizationScore(n2);
            String string = Long.toString(this.agentIDs[i]);
            if (n3 > 0) {
                string = string + MessageUtil.formatMsg((String)"={0}%", (Object[])new Object[]{n3});
            }
            if (n2 > n3) {
                string = string + this.constructFlagString(n2);
            }
            stringArray[i] = string;
        }
        int n4 = n;
        stringArray[n4] = stringArray[n4] + "(*)";
        StringBuilder stringBuilder = new StringBuilder();
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            stringBuilder.append(stringArray[n2]);
            if (n2 >= stringArray.length - 1) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    private String constructFlagString(int n) {
        int n2 = n;
        if (n2 >= ERROR_SCORE_VALUE) {
            return "(ERROR)";
        }
        String string = "(";
        if (n2 >= UNLICENSED_SCORE_VALUE) {
            n2 -= UNLICENSED_SCORE_VALUE;
            string = string + "U";
        }
        if (n2 >= HELD_AGENT_SCORE_VALUE) {
            n2 -= HELD_AGENT_SCORE_VALUE;
            string = string + "H";
        }
        if (n2 >= OFFLINE_SCORE_VALUE) {
            n2 -= OFFLINE_SCORE_VALUE;
            string = string + "O";
        }
        if (n2 >= HELD_JOB_QUEUE_SCORE_VALUE) {
            n2 -= HELD_JOB_QUEUE_SCORE_VALUE;
            string = string + "Q";
        }
        return string + ")";
    }

    private int utilizationScore(int n) {
        int n2 = n;
        if (n2 >= ERROR_SCORE_VALUE) {
            n2 -= ERROR_SCORE_VALUE;
        }
        if (n2 >= UNLICENSED_SCORE_VALUE) {
            n2 -= UNLICENSED_SCORE_VALUE;
        }
        if (n2 >= HELD_AGENT_SCORE_VALUE) {
            n2 -= HELD_AGENT_SCORE_VALUE;
        }
        if (n2 >= OFFLINE_SCORE_VALUE) {
            n2 -= OFFLINE_SCORE_VALUE;
        }
        if (n2 >= HELD_JOB_QUEUE_SCORE_VALUE) {
            n2 -= HELD_JOB_QUEUE_SCORE_VALUE;
        }
        return n2;
    }
}

