/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.enterprise.core.busobj.TimeHelper;
import java.util.Calendar;
import java.util.TimeZone;
import junit.framework.TestCase;

public class TimeHelperPerformanceTest
extends TestCase {
    public TimeHelperPerformanceTest(String string) {
        super(string);
    }

    public void testPerformance() {
        TimeZone timeZone = TimeZone.getDefault();
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.clear();
        calendar.set(2010, 6, 15, 12, 0, 0);
        long l = System.currentTimeMillis();
        for (int i = 0; i < 100000; ++i) {
            if (!TimeHelper.isWithinRange(calendar, 20100715, 0, 1200)) {
                throw new RuntimeException("Failed?");
            }
            if (!TimeHelper.isWithinRange(calendar, 20100715, 1200, 0)) {
                throw new RuntimeException("Failed?");
            }
            if (TimeHelper.isWithinRange(calendar, 20100715, 0, 1159)) {
                throw new RuntimeException("Failed?");
            }
            if (TimeHelper.isWithinRange(calendar, 20100715, 1201, 0)) {
                throw new RuntimeException("Failed?");
            }
            if (!TimeHelper.isWithinRange(calendar, 20100714, 2300, 1200)) {
                throw new RuntimeException("Failed?");
            }
            if (TimeHelper.isWithinRange(calendar, 20100714, 2300, 1159)) {
                throw new RuntimeException("Failed?");
            }
            if (!TimeHelper.isWithinRange(calendar, 20100715, 1201, 1200)) continue;
            throw new RuntimeException("Failed?");
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        this.log("From Keith:");
        this.log("The results for this performance test are somewhat arbitrary depending on the system.");
        this.log("On my PC, the results were surprisingly consistant: 860-890 milliseconds.");
        this.log("My PC is an Intel Core 2 Duo E4500@2.20GHz with 2GB ram.");
        this.log("");
        this.log("Performance Test Runtime (milliseconds): " + l3);
        this.log("");
        if (l3 > 1500L) {
            String string = "The performance test ran longer than 1.5 seconds.  Is this a failure?";
            this.log(string);
            TimeHelperPerformanceTest.fail((String)string);
        }
        this.log("");
    }

    public void testValidTime() {
        TimeZone timeZone = TimeZone.getDefault();
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.clear();
        this.log("");
        this.log("Test Midnight Runtime...");
        calendar.set(2010, 1, 1, 0, 0, 0);
        this.timeRangeTest(calendar, 20100201, 0, 0, true);
        this.timeRangeTest(calendar, 20100201, 0, 1, true);
        this.timeRangeTest(calendar, 20100201, 0, TimeHelper.END_OF_DAY_TIME, true);
        this.timeRangeTest(calendar, 20100131, 0, TimeHelper.END_OF_DAY_TIME, false);
        this.log("");
        this.log("Test 00:00:00.001 Runtime");
        calendar.set(2010, 1, 1, 0, 0, 0);
        calendar.set(14, 1);
        this.timeRangeTest(calendar, 20100201, 0, 0, false);
        this.timeRangeTest(calendar, 20100201, 0, 1, true);
        this.timeRangeTest(calendar, 20100201, 0, TimeHelper.END_OF_DAY_TIME, true);
        this.timeRangeTest(calendar, 20100131, 0, TimeHelper.END_OF_DAY_TIME, false);
        calendar.clear();
        calendar.set(2010, 0, 1, 1, 30, 0);
        this.log("");
        this.log("End Time Tests...");
        this.timeRangeTest(calendar, 20100101, 0, TimeHelper.END_OF_DAY_TIME, true);
        this.timeRangeTest(calendar, 20100101, 0, 1, false);
        this.timeRangeTest(calendar, 20100101, 0, 59, false);
        this.timeRangeTest(calendar, 20100101, 0, 129, false);
        this.timeRangeTest(calendar, 20100101, 0, 130, true);
        this.timeRangeTest(calendar, 20100101, 0, 131, true);
        this.timeRangeTest(calendar, 20100101, 0, 159, true);
        this.timeRangeTest(calendar, 20100101, 0, 2359, true);
        this.timeRangeTest(calendar, 20100101, 0, 1200, true);
        this.log("");
        this.log("Start Time Tests...");
        this.timeRangeTest(calendar, 20100101, 1, TimeHelper.END_OF_DAY_TIME, true);
        this.timeRangeTest(calendar, 20100101, 59, TimeHelper.END_OF_DAY_TIME, true);
        this.timeRangeTest(calendar, 20100101, 100, TimeHelper.END_OF_DAY_TIME, true);
        this.timeRangeTest(calendar, 20100101, 101, TimeHelper.END_OF_DAY_TIME, true);
        this.timeRangeTest(calendar, 20100101, 129, TimeHelper.END_OF_DAY_TIME, true);
        this.timeRangeTest(calendar, 20100101, 130, TimeHelper.END_OF_DAY_TIME, true);
        this.timeRangeTest(calendar, 20100101, 131, TimeHelper.END_OF_DAY_TIME, false);
        this.timeRangeTest(calendar, 20100101, 200, TimeHelper.END_OF_DAY_TIME, false);
        this.timeRangeTest(calendar, 20100101, 230, TimeHelper.END_OF_DAY_TIME, false);
        this.timeRangeTest(calendar, 20100101, 1200, TimeHelper.END_OF_DAY_TIME, false);
        this.timeRangeTest(calendar, 20100101, 2359, TimeHelper.END_OF_DAY_TIME, false);
        this.log("");
        this.log("Midnight Roll-over Tests");
        this.timeRangeTest(calendar, 20091231, 2300, 1, false);
        this.timeRangeTest(calendar, 20091231, 2300, 129, false);
        this.timeRangeTest(calendar, 20091231, 2300, 130, true);
        this.timeRangeTest(calendar, 20091231, 2300, 131, true);
        this.timeRangeTest(calendar, 20091231, 2300, 200, true);
        this.timeRangeTest(calendar, 20091231, 2300, 2259, true);
        this.timeRangeTest(calendar, 20091231, 131, 129, false);
        this.log("");
        this.log("** DST Fall Back Tests (Repeated Time) **");
        calendar.clear();
        calendar.set(2010, 10, 7, 0, 0, 0);
        calendar.add(11, 1);
        calendar.add(14, -1);
        this.log("");
        this.log("12:59:59.999 AM CDT 11/7/2010 (1 millisecond prior to the first 1 AM)");
        this.timeRangeTest(calendar, 20101107, 0, 100, true);
        this.timeRangeTest(calendar, 20101107, 100, 100, false);
        this.timeRangeTest(calendar, 20101107, 59, 100, true);
        this.timeRangeTest(calendar, 20101107, 101, 101, false);
        this.timeRangeTest(calendar, 20101106, 2359, 59, false);
        this.timeRangeTest(calendar, 20101106, 2359, 100, true);
        this.timeRangeTest(calendar, 20101106, 2359, 101, true);
        this.log("");
        this.log("1:00:00.000 AM CDT 11/7/2010 (the first 1 AM)");
        calendar.add(14, 1);
        this.timeRangeTest(calendar, 20101107, 0, 100, true);
        this.timeRangeTest(calendar, 20101107, 100, 100, true);
        this.timeRangeTest(calendar, 20101107, 59, 100, true);
        this.timeRangeTest(calendar, 20101107, 100, 101, true);
        this.timeRangeTest(calendar, 20101107, 101, 101, false);
        this.log("");
        this.log("1:00:00.001 AM CDT 11/7/2010 (1 millisecond after the first 1 AM)");
        calendar.add(14, 1);
        this.timeRangeTest(calendar, 20101107, 0, 100, false);
        this.timeRangeTest(calendar, 20101107, 100, 100, false);
        this.timeRangeTest(calendar, 20101107, 59, 100, false);
        this.timeRangeTest(calendar, 20101107, 100, 101, true);
        this.timeRangeTest(calendar, 20101107, 101, 101, false);
        this.log("");
        this.log("1:29:59.999 AM CDT 11/7/2010 (1 millisecond prior to the first 1:30 AM)");
        calendar.clear();
        calendar.set(2010, 10, 7, 0, 0, 0);
        calendar.add(11, 1);
        calendar.add(12, 30);
        calendar.add(14, -1);
        this.timeRangeTest(calendar, 20101107, 0, 129, false);
        this.timeRangeTest(calendar, 20101107, 0, 130, true);
        this.timeRangeTest(calendar, 20101107, 0, 131, true);
        this.timeRangeTest(calendar, 20101107, 129, 130, true);
        this.timeRangeTest(calendar, 20101107, 130, 130, false);
        this.timeRangeTest(calendar, 20101107, 130, 131, false);
        this.log("");
        this.log("1:30:00.000 AM CDT 11/7/2010 (the first 1:30 AM)");
        calendar.add(14, 1);
        this.timeRangeTest(calendar, 20101107, 0, 129, false);
        this.timeRangeTest(calendar, 20101107, 0, 130, true);
        this.timeRangeTest(calendar, 20101107, 0, 131, true);
        this.timeRangeTest(calendar, 20101107, 129, 130, true);
        this.timeRangeTest(calendar, 20101107, 130, 130, true);
        this.timeRangeTest(calendar, 20101107, 130, 131, true);
        this.log("");
        this.log("1:30:00.001 AM CDT 11/7/2010 (1 millisecond past the first 1:30 AM)");
        calendar.add(14, 1);
        this.timeRangeTest(calendar, 20101107, 0, 129, false);
        this.timeRangeTest(calendar, 20101107, 0, 130, false);
        this.timeRangeTest(calendar, 20101107, 0, 131, true);
        this.timeRangeTest(calendar, 20101107, 129, 130, false);
        this.timeRangeTest(calendar, 20101107, 130, 130, false);
        this.timeRangeTest(calendar, 20101107, 130, 131, true);
        this.log("");
        this.log("1:59:59.999 AM CDT 11/7/2010 (1 millisecond prior to the second 1 AM)");
        calendar.clear();
        calendar.set(2010, 10, 7, 0, 0, 0);
        calendar.add(11, 2);
        calendar.add(14, -1);
        this.timeRangeTest(calendar, 20101107, 0, 159, false);
        this.timeRangeTest(calendar, 20101107, 0, 200, true);
        this.timeRangeTest(calendar, 20101107, 0, 201, true);
        this.timeRangeTest(calendar, 20101107, 159, 159, false);
        this.timeRangeTest(calendar, 20101107, 159, 200, true);
        this.timeRangeTest(calendar, 20101107, 200, 200, false);
        this.timeRangeTest(calendar, 20101107, 200, 201, false);
        this.timeRangeTest(calendar, 20101107, 201, 201, false);
        this.log("");
        this.log("1:00:00.000 AM CST 11/7/2010 (the second 1 AM)");
        calendar.add(14, 1);
        this.timeRangeTest(calendar, 20101107, 0, 59, false);
        this.timeRangeTest(calendar, 20101107, 0, 100, true);
        this.timeRangeTest(calendar, 20101107, 0, 101, true);
        this.timeRangeTest(calendar, 20101107, 0, 159, true);
        this.timeRangeTest(calendar, 20101107, 0, 200, true);
        this.timeRangeTest(calendar, 20101107, 0, 201, true);
        this.timeRangeTest(calendar, 20101107, 59, 59, false);
        this.timeRangeTest(calendar, 20101107, 59, 100, true);
        this.timeRangeTest(calendar, 20101107, 100, 100, true);
        this.timeRangeTest(calendar, 20101107, 100, 101, true);
        this.timeRangeTest(calendar, 20101107, 101, 101, false);
        this.log("");
        this.log("1:00:00.001 AM CST 11/7/2010 (1 millisecond after the second 1 AM)");
        calendar.add(14, 1);
        this.timeRangeTest(calendar, 20101107, 0, 59, false);
        this.timeRangeTest(calendar, 20101107, 0, 100, false);
        this.timeRangeTest(calendar, 20101107, 0, 101, true);
        this.timeRangeTest(calendar, 20101107, 0, 159, true);
        this.timeRangeTest(calendar, 20101107, 0, 200, true);
        this.timeRangeTest(calendar, 20101107, 0, 201, true);
        this.timeRangeTest(calendar, 20101107, 59, 59, false);
        this.timeRangeTest(calendar, 20101107, 59, 100, false);
        this.timeRangeTest(calendar, 20101107, 100, 100, false);
        this.timeRangeTest(calendar, 20101107, 100, 101, true);
        this.timeRangeTest(calendar, 20101107, 101, 101, false);
    }

    private void timeRangeTest(Calendar calendar, int n, int n2, int n3, boolean bl) {
        boolean bl2 = TimeHelper.isWithinRange(calendar, n, n2, n3);
        String string = "";
        string = bl2 == bl ? "Passed: " : "Failed: ";
        string = bl2 ? string + TimeHelper.formatDate(calendar) + " was within the range on " : string + TimeHelper.formatDate(calendar) + " was not within the range on ";
        string = string + n + " between " + n2 + " and " + n3 + ".";
        this.log(string);
        TimeHelperPerformanceTest.assertEquals((String)string, (boolean)bl, (boolean)bl2);
    }

    private void log(String string) {
        System.out.println(string);
    }
}

