/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.enterprise.core.busobj.DayOfWeekTimestampFilter;
import com.helpsystems.enterprise.core.busobj.ParentType;
import com.helpsystems.enterprise.core.busobj.SpecialInstance;
import com.helpsystems.enterprise.core.busobj.SpecialInstanceDays;
import com.helpsystems.enterprise.core.busobj.SpecialInstanceType;
import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import java.util.GregorianCalendar;
import junit.framework.TestCase;

public class SpecialInstanceTest
extends TestCase {
    private SpecialInstance inst;

    protected void setUp() throws Exception {
        super.setUp();
        this.inst = new SpecialInstance();
    }

    protected void tearDown() throws Exception {
        this.inst = null;
        super.tearDown();
    }

    public void testSetId() {
        this.inst.setId(12345L);
        SpecialInstanceTest.assertEquals((long)12345L, (long)this.inst.getId());
    }

    public void testSetParentID() {
        this.inst.setParentID(345678L);
        SpecialInstanceTest.assertEquals((long)345678L, (long)this.inst.getParentId());
    }

    public void testSetParentType() {
        this.inst.setParentType(ParentType.JOBS);
        SpecialInstanceTest.assertEquals((Object)ParentType.JOBS, (Object)this.inst.getParentType());
    }

    public void testSetName() {
        this.inst.setName("special_instance_name");
        SpecialInstanceTest.assertEquals((String)"special_instance_name", (String)this.inst.getName());
    }

    public void testSetDescription() {
        this.inst.setDescription("description");
        SpecialInstanceTest.assertEquals((String)"description", (String)this.inst.getDescription());
    }

    public void testSetType() {
        this.inst.setType(SpecialInstanceType.DATE_OBJECT);
        SpecialInstanceTest.assertEquals((Object)SpecialInstanceType.DATE_OBJECT, (Object)this.inst.getType());
    }

    public void testSetSpecialInstanceDays() {
        SpecialInstanceDays specialInstanceDays = new SpecialInstanceDays();
        specialInstanceDays.setId(135L);
        specialInstanceDays.setSpecialInstanceID(246L);
        SpecialInstanceDays specialInstanceDays2 = new SpecialInstanceDays();
        specialInstanceDays2.setId(357L);
        specialInstanceDays2.setSpecialInstanceID(468L);
        SpecialInstanceDays specialInstanceDays3 = new SpecialInstanceDays();
        specialInstanceDays3.setId(579L);
        specialInstanceDays3.setSpecialInstanceID(680L);
        SpecialInstanceDays[] specialInstanceDaysArray = new SpecialInstanceDays[]{specialInstanceDays, specialInstanceDays2, specialInstanceDays3};
        this.inst.setSpecialInstanceDays(specialInstanceDaysArray);
        SpecialInstanceTest.assertEquals((Object)specialInstanceDaysArray, (Object)this.inst.getSpecialInstanceDays());
        SpecialInstanceDays[] specialInstanceDaysArray2 = this.inst.getSpecialInstanceDays();
        SpecialInstanceTest.assertEquals((int)3, (int)specialInstanceDaysArray2.length);
        SpecialInstanceTest.assertEquals((Object)specialInstanceDays, (Object)specialInstanceDaysArray2[0]);
        SpecialInstanceTest.assertEquals((Object)specialInstanceDays2, (Object)specialInstanceDaysArray2[1]);
        SpecialInstanceTest.assertEquals((Object)specialInstanceDays3, (Object)specialInstanceDaysArray2[2]);
    }

    public void testSetDateObjectID() {
        this.inst.setDateObjectID(1234789L);
        SpecialInstanceTest.assertEquals((long)1234789L, (long)this.inst.getDateObjectID());
    }

    public void testSetEndTime() {
        this.inst.setEndTime(1234);
        SpecialInstanceTest.assertEquals((int)1234, (int)this.inst.getEndTime());
    }

    public void testSetStartTime() {
        this.inst.setStartTime(4321);
        SpecialInstanceTest.assertEquals((int)4321, (int)this.inst.getStartTime());
    }

    public void testToString() {
        this.inst.setId(12345L);
        this.inst.setParentID(23456L);
        this.inst.setParentType(ParentType.SNMP_TRAP_MONITORS);
        this.inst.setName("name");
        this.inst.setDescription("description");
        this.inst.setType(SpecialInstanceType.DAY_OF_WEEK);
        this.inst.setDateObjectID(34567L);
        this.inst.setStartTime(1234);
        this.inst.setEndTime(5678);
        String string = "ID(12345).PARENT_ID(23456).PARENT_TYPE(" + ParentType.SNMP_TRAP_MONITORS.toString() + ")" + ".NAME(name)" + ".DESCRIPTION(description)" + ".TYPE(" + SpecialInstanceType.DAY_OF_WEEK.toString() + ")" + ".DATE_OBJ_ID(34567)" + ".START_TIME(1234)" + ".END_TIME(5678)";
        String string2 = this.inst.toString();
        SpecialInstanceTest.assertEquals((String)string, (String)string2);
        SpecialInstanceDays specialInstanceDays = new SpecialInstanceDays();
        specialInstanceDays.setId(357L);
        specialInstanceDays.setSpecialInstanceID(468L);
        SpecialInstanceDays[] specialInstanceDaysArray = new SpecialInstanceDays[]{specialInstanceDays};
        this.inst.setSpecialInstanceDays(specialInstanceDaysArray);
        string2 = this.inst.toString();
        string = "ID(12345).PARENT_ID(23456).PARENT_TYPE(" + ParentType.SNMP_TRAP_MONITORS.toString() + ")" + ".NAME(name)" + ".DESCRIPTION(description)" + ".TYPE(" + SpecialInstanceType.DAY_OF_WEEK.toString() + ")" + ".DATE_OBJ_ID(34567)" + ".START_TIME(1234)" + ".END_TIME(5678)" + ".DAYS_0(" + specialInstanceDays.toString() + ")";
        SpecialInstanceTest.assertEquals((String)string, (String)string2);
    }

    public void testAcceptTimestampDayOfWeekNullSpecialInstanceDays() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        CalendarObject calendarObject = new CalendarObject();
        this.inst.setType(SpecialInstanceType.DAY_OF_WEEK);
        long l = 0L;
        SpecialInstanceTest.assertTrue((boolean)this.inst.isAcceptedTimestamp(gregorianCalendar, l, calendarObject));
    }

    public void testAcceptTimestampDayOfWeekEmptySpecialInstanceDays() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        CalendarObject calendarObject = new CalendarObject();
        this.inst.setSpecialInstanceDays(new SpecialInstanceDays[0]);
        this.inst.setType(SpecialInstanceType.DAY_OF_WEEK);
        long l = 0L;
        SpecialInstanceTest.assertTrue((boolean)this.inst.isAcceptedTimestamp(gregorianCalendar, l, calendarObject));
    }

    public void testAcceptTimestampDayOfWeekSpecialInstanceDays() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(2010, 4, 14, 12, 0, 0);
        CalendarObject calendarObject = new CalendarObject();
        SpecialInstanceDays specialInstanceDays = new SpecialInstanceDays();
        specialInstanceDays.setDayOption_Fri(DayOfWeekTimestampFilter.DayOption.EVERY);
        specialInstanceDays.setStartTime(1100);
        specialInstanceDays.setEndTime(1300);
        this.inst.setSpecialInstanceDays(new SpecialInstanceDays[]{specialInstanceDays});
        this.inst.setType(SpecialInstanceType.DAY_OF_WEEK);
        long l = 0L;
        SpecialInstanceTest.assertTrue((boolean)this.inst.isAcceptedTimestamp(gregorianCalendar, l, calendarObject));
    }

    public void testRejectTimestampDayOfWeekSpecialInstanceDays() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(2010, 4, 14, 14, 0, 0);
        CalendarObject calendarObject = new CalendarObject();
        SpecialInstanceDays specialInstanceDays = new SpecialInstanceDays();
        specialInstanceDays.setDayOption_Fri(DayOfWeekTimestampFilter.DayOption.EVERY);
        specialInstanceDays.setStartTime(1100);
        specialInstanceDays.setEndTime(1300);
        this.inst.setSpecialInstanceDays(new SpecialInstanceDays[]{specialInstanceDays});
        this.inst.setType(SpecialInstanceType.DAY_OF_WEEK);
        long l = 0L;
        SpecialInstanceTest.assertFalse((boolean)this.inst.isAcceptedTimestamp(gregorianCalendar, l, calendarObject));
    }

    public void testMovedFrom_DST() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(2010, 2, 14, 3, 0, 0);
        CalendarObject calendarObject = new CalendarObject();
        SpecialInstanceDays specialInstanceDays = new SpecialInstanceDays();
        specialInstanceDays.setDayOption_Sun(DayOfWeekTimestampFilter.DayOption.EVERY);
        specialInstanceDays.setStartTime(100);
        specialInstanceDays.setEndTime(259);
        this.inst.setSpecialInstanceDays(new SpecialInstanceDays[]{specialInstanceDays});
        this.inst.setType(SpecialInstanceType.DAY_OF_WEEK);
        long l = 0L;
        SpecialInstanceTest.assertFalse((boolean)this.inst.isAcceptedTimestamp(gregorianCalendar, l, calendarObject));
        long l2 = 201003140230L;
        SpecialInstanceTest.assertTrue((boolean)this.inst.isAcceptedTimestamp(gregorianCalendar, l2, calendarObject));
    }

    public void testMovedFrom_DST_MidnightRollover() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(2010, 2, 14, 3, 0, 0);
        CalendarObject calendarObject = new CalendarObject();
        SpecialInstanceDays specialInstanceDays = new SpecialInstanceDays();
        specialInstanceDays.setDayOption_Sat(DayOfWeekTimestampFilter.DayOption.EVERY);
        specialInstanceDays.setStartTime(2200);
        specialInstanceDays.setEndTime(259);
        this.inst.setSpecialInstanceDays(new SpecialInstanceDays[]{specialInstanceDays});
        this.inst.setType(SpecialInstanceType.DAY_OF_WEEK);
        long l = 0L;
        SpecialInstanceTest.assertFalse((boolean)this.inst.isAcceptedTimestamp(gregorianCalendar, l, calendarObject));
        long l2 = 201003140230L;
        SpecialInstanceTest.assertTrue((boolean)this.inst.isAcceptedTimestamp(gregorianCalendar, l2, calendarObject));
    }

    public void testMovedFrom_Exception_Before() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(2010, 10, 24, 23, 0, 0);
        CalendarObject calendarObject = new CalendarObject();
        SpecialInstanceDays specialInstanceDays = new SpecialInstanceDays();
        specialInstanceDays.setDayOption_Thu(DayOfWeekTimestampFilter.DayOption.EVERY);
        specialInstanceDays.setStartTime(2200);
        specialInstanceDays.setEndTime(2359);
        this.inst.setSpecialInstanceDays(new SpecialInstanceDays[]{specialInstanceDays});
        this.inst.setType(SpecialInstanceType.DAY_OF_WEEK);
        long l = 0L;
        SpecialInstanceTest.assertFalse((boolean)this.inst.isAcceptedTimestamp(gregorianCalendar, l, calendarObject));
        long l2 = 201011252300L;
        SpecialInstanceTest.assertTrue((boolean)this.inst.isAcceptedTimestamp(gregorianCalendar, l2, calendarObject));
    }

    public void testMovedFrom_Exception_After() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(2010, 10, 29, 23, 0, 0);
        CalendarObject calendarObject = new CalendarObject();
        SpecialInstanceDays specialInstanceDays = new SpecialInstanceDays();
        specialInstanceDays.setDayOption_Thu(DayOfWeekTimestampFilter.DayOption.EVERY);
        specialInstanceDays.setStartTime(2200);
        specialInstanceDays.setEndTime(2359);
        this.inst.setSpecialInstanceDays(new SpecialInstanceDays[]{specialInstanceDays});
        this.inst.setType(SpecialInstanceType.DAY_OF_WEEK);
        long l = 0L;
        SpecialInstanceTest.assertFalse((boolean)this.inst.isAcceptedTimestamp(gregorianCalendar, l, calendarObject));
        long l2 = 201011252300L;
        SpecialInstanceTest.assertTrue((boolean)this.inst.isAcceptedTimestamp(gregorianCalendar, l2, calendarObject));
    }
}

