/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.SkybotVariableResolveException;
import com.helpsystems.enterprise.core.scheduler.AbstractBusinessObject;
import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.core.scheduler.CalendarObjectRangeException;
import com.helpsystems.enterprise.core.scheduler.InvalidDateTimeException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SkybotVariable
extends AbstractBusinessObject
implements BasicIdentifier {
    private static final long serialVersionUID = 1325897931345052288L;
    public static final int DYNAMIC_SCHEDULED_DATE = 1;
    public static final int VALUE_MAX_LENGTH = 4000;
    static Map<Integer, String> codedFormatString = new HashMap<Integer, String>();
    private static Logger logger = Logger.getLogger(SkybotVariable.class);
    private long oid;
    private boolean staticValue;
    private String value;
    private int dynamicType;
    private Long calendarObjectID;
    private int offsetDays;
    private CalendarObject.DayType offsetDayType;
    private boolean allowChangeByAPI = false;
    private int dateFormat;

    @Deprecated
    public SkybotVariable() {
        codedFormatString.put(1, "yyyy-MM-dd");
        codedFormatString.put(2, "MM/dd/yyyy");
        codedFormatString.put(3, "dd.MM.yyyy");
        codedFormatString.put(4, "yMd");
        codedFormatString.put(5, "yyMMdd");
        codedFormatString.put(6, "MMddyy");
        codedFormatString.put(7, "ddMMyy");
        codedFormatString.put(8, "MMddyyyy");
        codedFormatString.put(9, "ddMMyyyy");
        codedFormatString.put(10, "yyyyMMdd");
        codedFormatString.put(11, "yyyy");
        codedFormatString.put(12, "yy");
        codedFormatString.put(13, "MM");
        codedFormatString.put(14, "dd");
        codedFormatString.put(15, "yyyy MM dd");
        codedFormatString.put(16, "yyyyDDD");
        codedFormatString.put(17, "DDD");
    }

    public SkybotVariable(long l, String string, String string2, boolean bl) {
        codedFormatString.put(1, "yyyy-MM-dd");
        codedFormatString.put(2, "MM/dd/yyyy");
        codedFormatString.put(3, "dd.MM.yyyy");
        codedFormatString.put(4, "yMd");
        codedFormatString.put(5, "yyMMdd");
        codedFormatString.put(6, "MMddyy");
        codedFormatString.put(7, "ddMMyy");
        codedFormatString.put(8, "MMddyyyy");
        codedFormatString.put(9, "ddMMyyyy");
        codedFormatString.put(10, "yyyyMMdd");
        codedFormatString.put(11, "yyyy");
        codedFormatString.put(12, "yy");
        codedFormatString.put(13, "MM");
        codedFormatString.put(14, "dd");
        codedFormatString.put(15, "yyyy MM dd");
        codedFormatString.put(16, "yyyyDDD");
        codedFormatString.put(17, "DDD");
        this.setStaticValue(true);
        this.setOid(l);
        this.setName(string);
        this.setValue(string2);
        this.setAllowChangeByAPI(bl);
    }

    public SkybotVariable(long l, String string, Long l2, int n, CalendarObject.DayType dayType, int n2) {
        codedFormatString.put(1, "yyyy-MM-dd");
        codedFormatString.put(2, "MM/dd/yyyy");
        codedFormatString.put(3, "dd.MM.yyyy");
        codedFormatString.put(4, "yMd");
        codedFormatString.put(5, "yyMMdd");
        codedFormatString.put(6, "MMddyy");
        codedFormatString.put(7, "ddMMyy");
        codedFormatString.put(8, "MMddyyyy");
        codedFormatString.put(9, "ddMMyyyy");
        codedFormatString.put(10, "yyyyMMdd");
        codedFormatString.put(11, "yyyy");
        codedFormatString.put(12, "yy");
        codedFormatString.put(13, "MM");
        codedFormatString.put(14, "dd");
        codedFormatString.put(15, "yyyy MM dd");
        codedFormatString.put(16, "yyyyDDD");
        codedFormatString.put(17, "DDD");
        this.setStaticValue(false);
        this.setDynamicType(1);
        this.setOid(l);
        this.setName(string);
        this.setCalendarObjectID(l2);
        this.setOffsetDays(n);
        this.setOffsetDayType(dayType);
        this.setDateFormat(n2);
    }

    public long getOid() {
        return this.oid;
    }

    public void setOid(long l) {
        this.oid = l;
    }

    public String getValue() {
        if (!this.isStaticValue()) {
            String string = "Static value cannot be retrieved from a dynamic Automate Schedule Variable.";
            logger.error((Object)string);
            throw new IllegalStateException(string);
        }
        return this.value;
    }

    public static String getCodedFormatString(int n) {
        if (codedFormatString.containsKey(n)) {
            return codedFormatString.get(n);
        }
        return "Unknown Format - " + n;
    }

    public String getValue(CalendarObject calendarObject, Calendar calendar) throws SkybotVariableResolveException {
        Calendar calendar2;
        CalendarObject calendarObject2 = calendarObject;
        if (this.isStaticValue()) {
            String string = "Dynamic value cannot be retrieved from a static-value Automate Schedule Variable.";
            logger.error((Object)string);
            throw new IllegalStateException(string);
        }
        String string = codedFormatString.get(this.getDateFormat());
        if (string == null) {
            String string2 = "Encoded date format " + this.getDateFormat() + " is an unsupported code.";
            logger.error((Object)string2);
            throw new IllegalStateException(string2);
        }
        try {
            if (calendarObject2 == null) {
                calendarObject2 = new CalendarObject();
            }
            calendar2 = calendarObject2.addDays(this.offsetDays, this.offsetDayType, calendar);
        }
        catch (CalendarObjectRangeException calendarObjectRangeException) {
            Object[] objectArray = new String[]{this.getName(), calendarObjectRangeException.getLocalizedMessage()};
            String string3 = RosettaMsg.getMsgText(RosettaMsg.SKYBOT_VARIABLE_UNRESOLVED, objectArray);
            logger.debug((Object)string3);
            throw new SkybotVariableResolveException(calendarObjectRangeException.getLocalizedMessage(), this.getName());
        }
        catch (InvalidDateTimeException invalidDateTimeException) {
            calendar2 = invalidDateTimeException.getMovedInvalidDateTime();
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        simpleDateFormat.setTimeZone(calendar2.getTimeZone());
        String string4 = simpleDateFormat.format(calendar2.getTime());
        return string4;
    }

    public void setValue(String string) throws IllegalStateException, IllegalArgumentException {
        if (!this.isStaticValue()) {
            String string2 = "Value cannot be specified for a dynamic-value Automate Schedule variable.";
            logger.error((Object)string2);
            throw new IllegalStateException(string2);
        }
        ValidationHelper.checkForNull((String)"Value", (Object)string);
        if (string.length() > 4000) {
            Object[] objectArray = new String[]{string.substring(0, 15) + "...", this.getName(), String.valueOf(string.length()), String.valueOf(4000)};
            throw new IllegalArgumentException(RosettaMsg.getMsgText(RosettaMsg.SKYBOT_VARIABLE_VALUE_IS_TOO_LONG, objectArray));
        }
        this.value = string;
    }

    public boolean isStaticValue() {
        return this.staticValue;
    }

    private void setStaticValue(boolean bl) {
        this.staticValue = bl;
    }

    public int getDynamicType() {
        return this.dynamicType;
    }

    private void setDynamicType(int n) {
        if (this.isStaticValue()) {
            String string = "Dynamic type cannot be specified for a static-value Automate Schedule variable.";
            logger.error((Object)string);
            throw new IllegalStateException(string);
        }
        if (n != 1) {
            String string = "Undefined dynamic type = " + n;
            logger.error((Object)string);
            throw new IllegalStateException(string);
        }
        this.dynamicType = n;
    }

    public Long getCalendarObjectID() {
        return this.calendarObjectID;
    }

    public void setCalendarObjectID(Long l) {
        if (l != null && this.dynamicType != 1) {
            String string = "Calendar object ID cannot be specified with static type " + this.getDynamicType();
            logger.error((Object)string);
            throw new IllegalStateException(string);
        }
        if (l != null) {
            this.calendarObjectID = l;
        }
    }

    public int getOffsetDays() {
        return this.offsetDays;
    }

    public void setOffsetDays(int n) {
        if (n != 0 && this.dynamicType != 1) {
            String string = "Offset days cannot be specified with static type " + this.getDynamicType();
            logger.error((Object)string);
            throw new IllegalStateException(string);
        }
        this.offsetDays = n;
    }

    public CalendarObject.DayType getOffsetDayType() {
        return this.offsetDayType;
    }

    public void setOffsetDayType(CalendarObject.DayType dayType) {
        if (dayType != null && this.dynamicType != 1) {
            String string = "offsetDayType cannot be specified with static type " + this.getDynamicType();
            logger.error((Object)string);
            throw new IllegalStateException(string);
        }
        ValidationHelper.checkForNull((String)"offsetDayType", (Object)dayType);
        this.offsetDayType = dayType;
    }

    public int getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(int n) {
        if (n != 0 && this.dynamicType != 1) {
            String string = "Date format cannot be specified with static type " + this.getDynamicType();
            logger.error((Object)string);
            throw new IllegalStateException(string);
        }
        if (n == 0 && this.dynamicType == 1) {
            String string = "Date format is required with dynamic-date type " + this.getDynamicType();
            logger.error((Object)string);
            throw new IllegalStateException(string);
        }
        this.dateFormat = n;
    }

    public boolean isAllowChangeByAPI() {
        return this.allowChangeByAPI;
    }

    public void setAllowChangeByAPI(boolean bl) {
        if (!this.isStaticValue() & bl) {
            String string = "Change cannot be allowed for a non-static Automate Schedule Variable.";
            logger.error((Object)string);
            throw new IllegalStateException(string);
        }
        this.allowChangeByAPI = bl;
    }
}

