/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.enterprise.core.busobj.SimpleProxy;
import junit.framework.TestCase;

public class SimpleProxyTest
extends TestCase {
    SimpleProxy prox;

    protected void setUp() throws Exception {
        super.setUp();
        this.prox = new SimpleProxy();
    }

    protected void tearDown() throws Exception {
        this.prox = null;
        super.tearDown();
    }

    public void testGetID() {
        this.prox.setID(12345L);
        SimpleProxyTest.assertEquals((long)12345L, (long)this.prox.getID());
    }

    public void testCannotChangeIDOnceSet() {
        this.prox.setID(12345L);
        try {
            this.prox.setID(54321L);
            SimpleProxyTest.fail((String)"Allowed change to ID");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGetName() {
        this.prox.setName("some_name");
        SimpleProxyTest.assertEquals((String)"some_name", (String)this.prox.getName());
    }

    public void testGetDescription() {
        this.prox.setDescription("Some Description");
        SimpleProxyTest.assertEquals((String)"Some Description", (String)this.prox.getDescription());
    }

    public void testClone() {
        this.prox.setName("aName");
        this.prox.setDescription("aDescription");
        this.prox.setID(12345L);
        SimpleProxy simpleProxy = (SimpleProxy)this.prox.clone();
        SimpleProxyTest.assertTrue((boolean)simpleProxy.getClass().equals(this.prox.getClass()));
        SimpleProxyTest.assertFalse((simpleProxy == this.prox ? 1 : 0) != 0);
    }

    public void testToString() {
        this.prox.setName("aName");
        this.prox.setDescription("aDescription");
        this.prox.setID(12345L);
        String string = "name=aName, desc=aDescription, id=12345";
        SimpleProxyTest.assertEquals((String)string, (String)this.prox.toString());
    }
}

