/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.enterprise.core.busobj.SNMPTrapEvent;
import junit.framework.TestCase;

public class SNMPTrapEventTest
extends TestCase {
    private SNMPTrapEvent event;

    protected void setUp() throws Exception {
        super.setUp();
        this.event = new SNMPTrapEvent();
    }

    protected void tearDown() throws Exception {
        this.event = null;
        super.tearDown();
    }

    public void testConstructorSetsID() {
        SNMPTrapEvent sNMPTrapEvent = new SNMPTrapEvent(12345L, "1.2.3.4", 409409L, '*', 23456, "event data");
        SNMPTrapEventTest.assertEquals((long)12345L, (long)sNMPTrapEvent.getID());
    }

    public void testConstructorSetsSourceIPAddress() {
        SNMPTrapEvent sNMPTrapEvent = new SNMPTrapEvent(12345L, "1.2.3.4", 409409L, '*', 23456, "event data");
        SNMPTrapEventTest.assertEquals((String)"1.2.3.4", (String)sNMPTrapEvent.getSourceIPAddress());
    }

    public void testConstructorSetsTimeDetected() {
        SNMPTrapEvent sNMPTrapEvent = new SNMPTrapEvent(12345L, "1.2.3.4", 409409L, '*', 23456, "event data");
        SNMPTrapEventTest.assertEquals((long)409409L, (long)sNMPTrapEvent.getTimeDetected());
    }

    public void testConstructorSetsStatus() {
        SNMPTrapEvent sNMPTrapEvent = new SNMPTrapEvent(12345L, "1.2.3.4", 409409L, '*', 23456, "event data");
        SNMPTrapEventTest.assertEquals((char)'*', (char)sNMPTrapEvent.getReactivityStatus());
        SNMPTrapEvent sNMPTrapEvent2 = new SNMPTrapEvent(12345L, "1.2.3.4", 409409L, ' ', 23456, "event data");
        SNMPTrapEventTest.assertEquals((char)' ', (char)sNMPTrapEvent2.getReactivityStatus());
    }

    public void testConstructorSetsErrorCode() {
        SNMPTrapEvent sNMPTrapEvent = new SNMPTrapEvent(12345L, "1.2.3.4", 409409L, '*', 23456, "event data");
        SNMPTrapEventTest.assertEquals((int)23456, (int)sNMPTrapEvent.getEventErrorcode());
    }

    public void testConstructorSetsEventData() {
        SNMPTrapEvent sNMPTrapEvent = new SNMPTrapEvent(12345L, "1.2.3.4", 409409L, '*', 23456, "event data");
        SNMPTrapEventTest.assertEquals((String)"event data", (String)sNMPTrapEvent.getEventData());
    }

    public void testGetID() {
        this.event.setID(12345L);
        SNMPTrapEventTest.assertEquals((long)12345L, (long)this.event.getID());
    }

    public void testGetSNMPTrapMonitorID() {
        this.event.setSNMPTrapMonitorID(2398L);
        SNMPTrapEventTest.assertEquals((long)2398L, (long)this.event.getSNMPTrapMonitorID());
    }

    public void testGetSNMPTrapMonitorName() {
        this.event.setSNMPTrapMonitorName("monitor_name");
        SNMPTrapEventTest.assertEquals((String)"monitor_name", (String)this.event.getSNMPTrapMonitorName());
    }

    public void testIsSendEmail() {
        this.event.setSendEmail(true);
        SNMPTrapEventTest.assertTrue((boolean)this.event.isSendEmail());
        this.event.setSendEmail(false);
        SNMPTrapEventTest.assertFalse((boolean)this.event.isSendEmail());
    }

    public void testGetNotificationListID() {
        this.event.setNotificationListID(23456L);
        SNMPTrapEventTest.assertEquals((long)23456L, (long)this.event.getNotificationListID());
    }

    public void testGetTimeDetected() {
        this.event.setTimeDetected(484848L);
        SNMPTrapEventTest.assertEquals((long)484848L, (long)this.event.getTimeDetected());
    }

    public void testGetSourceIPAddress() {
        this.event.setSourceIPAddress("192.168.0.0");
        SNMPTrapEventTest.assertEquals((String)"192.168.0.0", (String)this.event.getSourceIPAddress());
    }

    public void testGetReactivityStatus() {
        this.event.setReactivityStatus('*');
        SNMPTrapEventTest.assertEquals((char)'*', (char)this.event.getReactivityStatus());
        this.event.setReactivityStatus(' ');
        SNMPTrapEventTest.assertEquals((char)' ', (char)this.event.getReactivityStatus());
    }

    public void testGetEventErrorcode() {
        this.event.setEventErrorcode(2);
        SNMPTrapEventTest.assertEquals((int)2, (int)this.event.getEventErrorcode());
    }

    public void testGetEventData() {
        this.event.setEventData("event data");
        SNMPTrapEventTest.assertEquals((String)"event data", (String)this.event.getEventData());
    }
}

