/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.enterprise.core.busobj.TimeHelper;
import com.helpsystems.enterprise.core.busobj.WindowEndOption;
import com.helpsystems.enterprise.core.busobj.WindowStartOption;
import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.core.scheduler.CalendarObjectRangeException;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobProxy;
import java.util.Calendar;
import org.apache.log4j.Logger;

public class ReactivityDayOfPeriod {
    private static final Logger logger = Logger.getLogger(ReactivityDayOfPeriod.class);
    private long id;
    private long jobID;
    private int dayNumber;
    private CalendarObject.PeriodType periodType;
    private int endTime;
    private int startTime;
    private WindowStartOption startOption = WindowStartOption.DO_NOTHING;
    private WindowEndOption endOption = WindowEndOption.DO_NOTHING;

    public long getId() {
        return this.id;
    }

    public void setId(long l) {
        this.id = l;
    }

    public long getJobID() {
        return this.jobID;
    }

    public void setJobID(long l) {
        this.jobID = l;
    }

    public int getDayNumber() {
        return this.dayNumber;
    }

    public void setDayNumber(int n) {
        this.dayNumber = n;
    }

    public CalendarObject.PeriodType getPeriodType() {
        return this.periodType;
    }

    public void setPeriodType(CalendarObject.PeriodType periodType) {
        this.periodType = periodType;
    }

    public int getEndTime() {
        return this.endTime;
    }

    public void setEndTime(int n) {
        this.endTime = n;
    }

    public int getStartTime() {
        return this.startTime;
    }

    public void setStartTime(int n) {
        this.startTime = n;
    }

    public WindowStartOption getStartOption() {
        return this.startOption;
    }

    public void setStartOption(WindowStartOption windowStartOption) {
        this.startOption = windowStartOption;
    }

    public WindowEndOption getEndOption() {
        return this.endOption;
    }

    public void setEndOption(WindowEndOption windowEndOption) {
        this.endOption = windowEndOption;
    }

    public boolean isTimeAccepted(Calendar calendar, CalendarObject calendarObject, ScheduleJobProxy scheduleJobProxy) {
        if (scheduleJobProxy == null) {
            return this.isTimeAccepted(calendar, calendarObject, CalendarObject.DayType.WORKDAYS);
        }
        return this.isTimeAccepted(calendar, calendarObject, scheduleJobProxy.getDayType());
    }

    public boolean isTimeAccepted(Calendar calendar, CalendarObject calendarObject, CalendarObject.DayType dayType) {
        if (calendarObject == null) {
            logger.debug((Object)"WARNING: Calendar object is null!");
            return true;
        }
        if (this.dayNumber == 0) {
            return false;
        }
        int n = 0;
        try {
            n = this.dayNumber > 0 ? calendarObject.relativeDayFromBeginOfPeriod(calendar, this.periodType, dayType) : calendarObject.relativeDayFromEndOfPeriod(calendar, this.periodType, dayType);
        }
        catch (CalendarObjectRangeException calendarObjectRangeException) {
            logger.warn((Object)("Reactivity day of period calendar object error: " + calendarObjectRangeException.getMessage()));
            return false;
        }
        boolean bl = false;
        int n2 = calendarObject.yyyymmdd_AdjustedForVirtualDay(calendar);
        if (n != 0 && n == Math.abs(this.dayNumber)) {
            bl = TimeHelper.isWithinRange(calendar, n2, this.getStartTime(), this.getEndTime());
        }
        if (bl) {
            return true;
        }
        Calendar calendar2 = Calendar.getInstance(calendar.getTimeZone());
        calendar2.clear();
        calendar2.setTimeInMillis(calendar.getTimeInMillis());
        calendar2.add(5, -1);
        n = 0;
        try {
            n = this.dayNumber > 0 ? calendarObject.relativeDayFromBeginOfPeriod(calendar2, this.periodType, dayType) : calendarObject.relativeDayFromEndOfPeriod(calendar2, this.periodType, dayType);
        }
        catch (CalendarObjectRangeException calendarObjectRangeException) {
            logger.warn((Object)("Reactivity day of period calendar object error on midnight rollover: " + calendarObjectRangeException.getMessage()));
            return false;
        }
        boolean bl2 = false;
        n2 = calendarObject.yyyymmdd_AdjustedForVirtualDay(calendar2);
        if (n != 0 && n == Math.abs(this.dayNumber)) {
            bl2 = TimeHelper.isWithinRange(calendar, n2, this.getStartTime(), this.getEndTime());
        }
        return bl2;
    }
}

