/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.busobj.AgentGroup;
import com.helpsystems.enterprise.core.busobj.AgentGroupAgent;
import com.helpsystems.enterprise.core.busobj.AgentGroupType;
import com.helpsystems.enterprise.core.busobj.BalancedAgentGroup;
import java.util.HashMap;
import java.util.Map;

public class PriorityBasedAgentGroup
extends BalancedAgentGroup {
    private int unlicensedScoreValue;
    private int heldAgentScoreValue;
    private int offlineScoreValue = 200000000;
    private int heldQueueScoreValue;
    private Map<Long, Integer> baseValues = new HashMap<Long, Integer>();
    private int[] scores;

    public PriorityBasedAgentGroup(AgentGroup agentGroup) {
        super(agentGroup);
        this.setAgentGroupType(AgentGroupType.PREFERRED_AGENT);
        for (AgentGroupAgent agentGroupAgent : this.getAgents()) {
            int n = agentGroupAgent.getSequence();
            this.baseValues.put(agentGroupAgent.getAgentID(), n);
        }
    }

    @Override
    public long chooseAgent() {
        if (this.agentIDs == null || this.scores == null || this.scores.length != this.agentIDs.length) {
            throw new IllegalStateException("Program error: Unable to choose an agent because the data fields have not been properly set.");
        }
        this.validateThatThereAreUnignoredAgentsToChooseFrom();
        int n = this.lastChoice;
        do {
            n = this.next(n);
        } while (this.lowestScore() < this.scores[n]);
        this.lastChoice = n;
        return this.agentIDs[n];
    }

    public int getBaseValueForAgent(long l) {
        return this.baseValues.get(l);
    }

    public int getHeldAgentScoreValue() {
        return this.heldAgentScoreValue;
    }

    public int getHeldQueueScoreValue() {
        return this.heldQueueScoreValue;
    }

    public int getOfflineScoreValue() {
        return this.offlineScoreValue;
    }

    public int getUnlicensedScoreValue() {
        return this.unlicensedScoreValue;
    }

    public void setHeldAgentScoreValue(int n) {
        this.heldAgentScoreValue = n;
    }

    public void setHeldQueueScoreValue(int n) {
        this.heldQueueScoreValue = n;
    }

    public void setOfflineScoreValue(int n) {
        this.offlineScoreValue = n;
    }

    public void setUnlicensedScoreValue(int n) {
        this.unlicensedScoreValue = n;
    }

    public void setScores(Map<Long, Integer> map) {
        ValidationHelper.checkForNull((String)"Scores map", map);
        if (map.size() != this.agentIDs.length) {
            throw new IllegalStateException("Program error: scoreMap size does not equal agentIDs length.");
        }
        if (this.scores == null || this.scores.length != this.agentIDs.length) {
            this.scores = new int[this.agentIDs.length];
        }
        for (int i = 0; i < this.agentIDs.length; ++i) {
            long l = this.agentIDs[i];
            Integer n = map.get(l);
            if (n == null) {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Unable to find a score for agent ID {0}.", (Object[])new Object[]{l}));
            }
            this.scores[i] = n;
        }
    }

    private int lowestScore() {
        int n = this.scores[0];
        for (int i = 0; i < this.scores.length; ++i) {
            if (this.scores[i] == 0) {
                return 0;
            }
            if (this.scores[i] >= n) continue;
            n = this.scores[i];
        }
        return n;
    }
}

