/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.common.core.util.Equal;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.EnterpriseProxy;
import com.helpsystems.enterprise.core.scheduler.PersistableEnum;
import com.helpsystems.enterprise.core.scheduler.PersistanceCodeToEnumMap;
import java.sql.Timestamp;
import java.util.Calendar;

public class PersistedJobQueueEntry
extends EnterpriseProxy {
    private static final long serialVersionUID = -5995477202287013050L;
    private long oid;
    private Timestamp createdAt;
    private long jobHistoryOID;
    private Action action;
    private int groupID;
    private long queueEndedTime;

    public PersistedJobQueueEntry() {
        this.setCreatedAt(new Timestamp(Calendar.getInstance().getTimeInMillis()));
    }

    public PersistedJobQueueEntry(long l, Action action) {
        this(l, action, 0);
    }

    public PersistedJobQueueEntry(long l, Action action, long l2) {
        this(l, action, 0);
        this.setQueueEndedTime(l2);
    }

    public PersistedJobQueueEntry(long l, Action action, int n) {
        this();
        this.jobHistoryOID = l;
        this.action = action;
        this.groupID = n;
    }

    public Timestamp getCreatedAt() {
        return this.createdAt;
    }

    public long getJobHistoryOID() {
        return this.jobHistoryOID;
    }

    public void setJobHistoryOID(long l) {
        this.jobHistoryOID = l;
    }

    public void setCreatedAt(Timestamp timestamp) {
        this.createdAt = timestamp;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public int getAction_asInt() {
        return this.action.persistanceCode();
    }

    public void setAction_asInt(int n) {
        this.action = Action.persistanceCodeToEnum(n);
    }

    public int getGroupID() {
        return this.groupID;
    }

    public void setGroupID(int n) {
        this.groupID = n;
    }

    public void setQueueEndedTime(long l) {
        this.queueEndedTime = l;
    }

    public long getQueueEndedTime() {
        return this.queueEndedTime;
    }

    public long getOID() {
        return this.oid;
    }

    public void setOID(long l) {
        this.oid = l;
    }

    public int hashCode() {
        return (int)(this.oid + this.jobHistoryOID + (long)this.getAction_asInt() + (long)this.groupID);
    }

    public boolean equals(Object object) {
        if (!(object instanceof PersistedJobQueueEntry)) {
            return false;
        }
        PersistedJobQueueEntry persistedJobQueueEntry = (PersistedJobQueueEntry)((Object)object);
        return Equal.isEqual((long)this.jobHistoryOID, (long)persistedJobQueueEntry.jobHistoryOID) && Equal.isEqual((Object)this.action, (Object)persistedJobQueueEntry.action) && Equal.isEqual((long)this.groupID, (long)persistedJobQueueEntry.groupID);
    }

    public String toString() {
        return "\n jobHistoryOID: " + this.jobHistoryOID + "\n action: " + this.action + "\n groupID: " + this.groupID;
    }

    public static enum Action implements PersistableEnum<Integer>
    {
        REMOVED_FROM_QUEUE(0),
        ADDED_TO_QUEUE(1),
        MOVED_TO_TOP_OF_QUEUE(2),
        MOVED_UP_ONE_ON_QUEUE(3),
        SORTED_JOBS_BY_PRIORITY(4);

        private int actionType;
        private static PersistanceCodeToEnumMap<Integer, Action> map;

        private Action(int n2) {
            this.actionType = n2;
        }

        @Override
        public Integer persistanceCode() {
            return this.actionType;
        }

        public static Action persistanceCodeToEnum(int n) {
            Action action = map.get(n);
            if (action == null) {
                String string = MessageUtil.formatMsg((String)"There is no {0} enum constant associated with code: {1}.", (Object[])new Object[]{map.getEnumName(), n});
                throw new IllegalStateException(string);
            }
            return action;
        }

        static {
            map = new PersistanceCodeToEnumMap((Enum[])Action.values());
        }
    }
}

