/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.common.core.util.SizeUnit;
import com.helpsystems.enterprise.core.busobj.AgentEventFile;
import com.helpsystems.enterprise.core.busobj.FileEvent;
import com.helpsystems.enterprise.core.busobj.ManualEvent;
import junit.framework.TestCase;

public class FileEventTest
extends TestCase {
    FileEvent fe;
    AgentEventFile aef;

    protected void setUp() throws Exception {
        super.setUp();
        this.fe = new FileEvent();
        this.fe.setTargetID(6868L);
        this.aef = new AgentEventFile();
        this.aef.setFilePath("/some/path/value");
    }

    protected void tearDown() throws Exception {
        this.fe = null;
        this.aef = null;
        super.tearDown();
    }

    public void testSetAgentEventToNullCreatesNewFileEvent() {
        this.fe.setAgentEventFile(null);
        FileEventTest.assertNotNull((Object)((Object)this.fe.getAgentEventFile()));
    }

    public void testSetOID() {
        this.fe.setOID(93939L);
        FileEventTest.assertEquals((long)93939L, (long)this.fe.getOID());
    }

    public void testValidateFileAddedRequiresHasNotChangedAtLeastCycleTime() {
        this.fe.setType(101);
        this.fe.setCycle(120);
        this.fe.setAgentEventFile(this.aef);
        this.aef.setIncreaseSize(119);
        this.aef.setIncreaseSize(120);
        this.aef.setIncreaseSize(121);
    }

    public void testValidateFileRemovedAlwaysValid() {
        this.fe.setType(102);
        this.fe.setAgentEventFile(this.aef);
    }

    public void testValidateFailsIfNoFlagSetAndSizeMatters() {
        this.fe.setType(103);
        this.fe.setType(104);
    }

    public void testValidateSizeChanges() {
        this.fe.setType(103);
        this.aef.setIncreasedFlag(true);
        this.aef.setIncreaseSize(33);
        this.aef.setDecreasedFlag(true);
        this.aef.setDecreaseSize(32);
        this.fe.setAgentEventFile(this.aef);
    }

    public void testValidateGoodIncreaseSizeThreshold() {
        this.fe.setType(104);
        AgentEventFile agentEventFile = new AgentEventFile();
        agentEventFile.setFilePath("something*");
        agentEventFile.setIncreasedFlag(true);
        agentEventFile.setDecreasedFlag(false);
        agentEventFile.setIncreaseSize(12);
        this.fe.setAgentEventFile(agentEventFile);
    }

    public void testValidateBadIncreaseSizeThreshold() {
        this.fe.setType(104);
        AgentEventFile agentEventFile = new AgentEventFile();
        agentEventFile.setFilePath("something*");
        agentEventFile.setIncreasedFlag(true);
        agentEventFile.setDecreasedFlag(false);
        this.fe.setAgentEventFile(agentEventFile);
    }

    public void testValidateGoodDecreaseSizeThreshold() {
        this.fe.setType(104);
        AgentEventFile agentEventFile = new AgentEventFile();
        agentEventFile.setFilePath("something*");
        agentEventFile.setIncreasedFlag(false);
        agentEventFile.setDecreasedFlag(true);
        agentEventFile.setDecreaseSize(24);
        this.fe.setAgentEventFile(agentEventFile);
    }

    public void testValidateBadDecreaseSizeThreshold() {
        this.fe.setType(104);
        AgentEventFile agentEventFile = new AgentEventFile();
        agentEventFile.setFilePath("something*");
        agentEventFile.setIncreasedFlag(false);
        agentEventFile.setDecreasedFlag(true);
        this.fe.setAgentEventFile(agentEventFile);
    }

    public void testSetAgentEvent() {
        this.fe.setAgentEventFile(this.aef);
        FileEventTest.assertEquals((Object)((Object)this.aef), (Object)((Object)this.fe.getAgentEventFile()));
    }

    public void testSetProductIIDint() {
        this.fe.setProductIIDInt(12345);
        FileEventTest.assertEquals((int)12345, (int)this.fe.getProductIIDInt());
    }

    public void testGetIncreaseSizeThreshold() {
        this.aef.setIncreasedFlag(true);
        this.aef.setIncreaseSize(45);
        this.fe.setType(103);
        this.fe.setAgentEventFile(this.aef);
        FileEventTest.assertEquals((Object)45.0, (Object)this.fe.getIncreaseSizeThreshold());
    }

    public void testGetDecreaseSizeThreshold() {
        this.aef.setDecreasedFlag(true);
        this.aef.setDecreaseSize(42);
        this.fe.setType(103);
        this.fe.setAgentEventFile(this.aef);
        FileEventTest.assertEquals((Object)42.0, (Object)this.fe.getDecreaseSizeThreshold());
    }

    public void testGetFileRecheckTime() {
        this.aef.setRecheckSeconds(60);
        this.fe.setAgentEventFile(this.aef);
        this.fe.setType(101);
        FileEventTest.assertEquals((int)60, (int)this.fe.getFileRecheckTimeinSeconds());
        this.fe.setType(102);
        FileEventTest.assertEquals((int)0, (int)this.fe.getFileRecheckTimeinSeconds());
        this.fe.setType(103);
        FileEventTest.assertEquals((int)0, (int)this.fe.getFileRecheckTimeinSeconds());
        this.fe.setType(104);
        FileEventTest.assertEquals((int)0, (int)this.fe.getFileRecheckTimeinSeconds());
        this.fe.setType(201);
        FileEventTest.assertEquals((int)60, (int)this.fe.getFileRecheckTimeinSeconds());
        this.fe.setType(202);
        FileEventTest.assertEquals((int)0, (int)this.fe.getFileRecheckTimeinSeconds());
        this.fe.setType(203);
        FileEventTest.assertEquals((int)0, (int)this.fe.getFileRecheckTimeinSeconds());
        this.fe.setType(204);
        FileEventTest.assertEquals((int)0, (int)this.fe.getFileRecheckTimeinSeconds());
    }

    public void testValidatePukesOnNoFileName() {
        this.aef.setFilePath("/no/file/name/");
        this.aef.setIncreaseSize(61);
        this.fe.setAgentEventFile(this.aef);
        this.fe.setType(101);
    }

    public void testClone() {
        this.fe.setAgentEventFile(this.aef);
        this.fe.setName("TESTNAME");
        this.fe.setDescription("Test description");
        FileEvent fileEvent = new FileEvent();
        fileEvent.clone(this.fe);
        FileEventTest.assertEquals((Object)((Object)this.aef), (Object)((Object)fileEvent.getAgentEventFile()));
    }

    public void testDifferentThan() {
        this.fe.setTargetID(12345L);
        this.fe.setName("Event1");
        this.fe.setDescription("A test event");
        this.fe.setProductIIDInt(9494);
        this.fe.setDisabled(true);
        this.fe.setCycle(666);
        this.fe.setOID(58493L);
        this.fe.setFromTime(1234);
        this.fe.setToTime(2468);
        this.aef.setOID(12348L);
        this.aef.setChangeDateFlag(true);
        this.aef.setDecreasedFlag(true);
        this.aef.setDecreaseSize(1000);
        this.aef.setDecreaseSizeUnit(SizeUnit.MEGABYTES);
        this.aef.setEofHexMarker("FEFE");
        this.aef.setEofTest(2);
        this.aef.setEofTextEncoding("SOME_ENCODING");
        this.aef.setEofTextMarker("AbCd");
        this.aef.setFireWhenIncreasing(1);
        this.aef.setFireWhenDecreasing(1);
        this.aef.setIncreasedFlag(true);
        this.aef.setIncreaseSize(1000);
        this.aef.setIncreaseSizeUnit(SizeUnit.MEGABYTES);
        this.aef.setGreaterThanFlag(true);
        this.aef.setLessThanFlag(true);
        this.aef.setRecheckSeconds(45);
        this.fe.setAgentEventFile(this.aef);
        ManualEvent manualEvent = new ManualEvent();
        FileEventTest.assertTrue((boolean)this.fe.isDifferentThan(manualEvent));
        AgentEventFile agentEventFile = new AgentEventFile();
        agentEventFile.setFilePath("/some/other/path/value");
        FileEvent fileEvent = new FileEvent();
        fileEvent.setAgentEventFile(agentEventFile);
        FileEventTest.assertTrue((boolean)this.fe.isDifferentThan(fileEvent));
        fileEvent.setTargetID(12345L);
        fileEvent.setName("Event1");
        fileEvent.setDescription("A test event");
        fileEvent.setProductIIDInt(9494);
        fileEvent.setDisabled(true);
        fileEvent.setCycle(666);
        fileEvent.setOID(58493L);
        fileEvent.setFromTime(1234);
        fileEvent.setToTime(2468);
        FileEventTest.assertTrue((boolean)this.fe.isDifferentThan(fileEvent));
        agentEventFile.setOID(12348L);
        FileEventTest.assertTrue((boolean)this.fe.isDifferentThan(fileEvent));
        agentEventFile.setChangeDateFlag(true);
        FileEventTest.assertTrue((boolean)this.fe.isDifferentThan(fileEvent));
        agentEventFile.setDecreasedFlag(true);
        FileEventTest.assertTrue((boolean)this.fe.isDifferentThan(fileEvent));
        agentEventFile.setDecreaseSize(1000);
        FileEventTest.assertTrue((boolean)this.fe.isDifferentThan(fileEvent));
        agentEventFile.setDecreaseSizeUnit(SizeUnit.MEGABYTES);
        FileEventTest.assertTrue((boolean)this.fe.isDifferentThan(fileEvent));
        agentEventFile.setEofHexMarker("FEFE");
        FileEventTest.assertTrue((boolean)this.fe.isDifferentThan(fileEvent));
        agentEventFile.setEofTest(2);
        FileEventTest.assertTrue((boolean)this.fe.isDifferentThan(fileEvent));
        agentEventFile.setEofTextEncoding("SOME_ENCODING");
        FileEventTest.assertTrue((boolean)this.fe.isDifferentThan(fileEvent));
        agentEventFile.setEofTextMarker("AbCd");
        FileEventTest.assertTrue((boolean)this.fe.isDifferentThan(fileEvent));
        agentEventFile.setFilePath("/some/path/value");
        FileEventTest.assertTrue((boolean)this.fe.isDifferentThan(fileEvent));
        agentEventFile.setFireWhenDecreasing(1);
        FileEventTest.assertTrue((boolean)this.fe.isDifferentThan(fileEvent));
        agentEventFile.setFireWhenIncreasing(1);
        FileEventTest.assertTrue((boolean)this.fe.isDifferentThan(fileEvent));
        agentEventFile.setGreaterThanFlag(true);
        FileEventTest.assertTrue((boolean)this.fe.isDifferentThan(fileEvent));
        agentEventFile.setIncreasedFlag(true);
        FileEventTest.assertTrue((boolean)this.fe.isDifferentThan(fileEvent));
        agentEventFile.setIncreaseSize(1000);
        FileEventTest.assertTrue((boolean)this.fe.isDifferentThan(fileEvent));
        agentEventFile.setIncreaseSizeUnit(SizeUnit.MEGABYTES);
        FileEventTest.assertTrue((boolean)this.fe.isDifferentThan(fileEvent));
        agentEventFile.setLessThanFlag(true);
        FileEventTest.assertTrue((boolean)this.fe.isDifferentThan(fileEvent));
        agentEventFile.setRecheckSeconds(45);
        FileEventTest.assertFalse((boolean)this.fe.isDifferentThan(fileEvent));
    }
}

