/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.common.core.util.Equal;
import com.helpsystems.common.core.util.SizeUnit;
import com.helpsystems.enterprise.core.busobj.AgentEventFile;
import com.helpsystems.enterprise.core.busobj.AgentEventMonitor;

public class FileEvent
extends AgentEventMonitor {
    private static final long serialVersionUID = -1909637613469018273L;
    AgentEventFile eventFile = null;

    public FileEvent() {
        this.setType(101);
        this.eventFile = new AgentEventFile();
        this.addDoNotInvoke("getChangeSize");
        this.addDoNotInvoke("getChangeType");
        this.addDoNotInvoke("getFileRecheckTimeinSeconds");
        this.addDoNotInvoke("getIncreaseSizeThreshold");
        this.addDoNotInvoke("getDecreaseSizeThreshold");
    }

    public void setAgentEventFile(AgentEventFile agentEventFile) {
        if (agentEventFile == null) {
            this.eventFile = new AgentEventFile();
            return;
        }
        this.eventFile = agentEventFile;
    }

    @Override
    public void setOID(long l) {
        super.setOID(l);
        this.eventFile.setOID(l);
    }

    public int getFileRecheckTimeinSeconds() {
        if (this.getType() == 201 || this.getType() == 101) {
            return this.eventFile.getRecheckSeconds();
        }
        return 0;
    }

    public AgentEventFile getAgentEventFile() {
        return this.eventFile;
    }

    @Override
    public void clone(AgentEventMonitor agentEventMonitor) {
        super.clone(agentEventMonitor);
        if (agentEventMonitor instanceof FileEvent) {
            this.setAgentEventFile(((FileEvent)agentEventMonitor).getAgentEventFile());
        }
    }

    public double getIncreaseSizeThreshold() {
        double d = SizeUnit.BYTES.convert((double)this.eventFile.getIncreaseSize(), this.eventFile.getIncreaseSizeUnit());
        return d;
    }

    public double getDecreaseSizeThreshold() {
        double d = SizeUnit.BYTES.convert((double)this.eventFile.getDecreaseSize(), this.eventFile.getDecreaseSizeUnit());
        return d;
    }

    @Override
    public boolean isDifferentThan(AgentEventMonitor agentEventMonitor) {
        FileEvent fileEvent = null;
        if (!(agentEventMonitor instanceof FileEvent)) {
            return true;
        }
        fileEvent = (FileEvent)agentEventMonitor;
        if (super.isDifferentThan(agentEventMonitor)) {
            return true;
        }
        if (this.eventFile.getOID() != fileEvent.eventFile.getOID()) {
            return true;
        }
        if (this.eventFile.getChangeDateFlag() != fileEvent.eventFile.getChangeDateFlag()) {
            return true;
        }
        if (this.eventFile.getDecreasedFlag() != fileEvent.eventFile.getDecreasedFlag()) {
            return true;
        }
        if (this.eventFile.getDecreaseSize() != fileEvent.eventFile.getDecreaseSize()) {
            return true;
        }
        if (!Equal.isEqual((Object)this.eventFile.getDecreaseSizeUnit(), (Object)fileEvent.eventFile.getDecreaseSizeUnit())) {
            return true;
        }
        if (!Equal.isEqual((Object)this.eventFile.getEofHexMarker(), (Object)fileEvent.eventFile.getEofHexMarker())) {
            return true;
        }
        if (this.eventFile.getEofTest() != fileEvent.eventFile.getEofTest()) {
            return true;
        }
        if (!Equal.isEqual((Object)this.eventFile.getEofTextEncoding(), (Object)fileEvent.eventFile.getEofTextEncoding())) {
            return true;
        }
        if (!Equal.isEqual((Object)this.eventFile.getEofTextMarker(), (Object)fileEvent.eventFile.getEofTextMarker())) {
            return true;
        }
        if (!Equal.isEqual((Object)this.eventFile.getFilePath(), (Object)fileEvent.eventFile.getFilePath())) {
            return true;
        }
        if (this.eventFile.getFireWhenDecreasing() != fileEvent.eventFile.getFireWhenDecreasing()) {
            return true;
        }
        if (this.eventFile.getFireWhenIncreasing() != fileEvent.eventFile.getFireWhenIncreasing()) {
            return true;
        }
        if (this.eventFile.getGreaterThanFlag() != fileEvent.eventFile.getGreaterThanFlag()) {
            return true;
        }
        if (this.eventFile.getIncreasedFlag() != fileEvent.eventFile.getIncreasedFlag()) {
            return true;
        }
        if (this.eventFile.getIncreaseSize() != fileEvent.eventFile.getIncreaseSize()) {
            return true;
        }
        if (!Equal.isEqual((Object)this.eventFile.getIncreaseSizeUnit(), (Object)fileEvent.eventFile.getIncreaseSizeUnit())) {
            return true;
        }
        if (this.eventFile.getLessThanFlag() != fileEvent.eventFile.getLessThanFlag()) {
            return true;
        }
        return this.eventFile.getRecheckSeconds() != fileEvent.eventFile.getRecheckSeconds();
    }
}

