/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.enterprise.core.busobj.JobHistory;
import com.helpsystems.enterprise.core.busobj.JobHistoryComparator;
import com.helpsystems.enterprise.core.busobj.JobQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.PriorityBlockingQueue;

public class CrossAgentJobQueue
extends JobQueue {
    private PriorityBlockingQueue<JobHistory> holdingBinQueue;
    private Set<Long> unavailableAgents = new HashSet<Long>();
    private Set<Long> lockedAgents = new HashSet<Long>();
    private HashMap<Long, HashSet<Long>> runningJobsHM = new HashMap();

    public CrossAgentJobQueue(String string) {
        super(string);
        this.initHoldingBin();
    }

    public CrossAgentJobQueue(String string, int n) {
        super(string, n);
        this.initHoldingBin();
    }

    public CrossAgentJobQueue() {
        this.initHoldingBin();
    }

    private void initHoldingBin() {
        this.holdingBinQueue = new PriorityBlockingQueue<JobHistory>(this.initialQueueCapacity, new JobHistoryComparator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobHistory poll() {
        long l;
        Object object = this.actualJobQueue;
        synchronized (object) {
            this.holdingBinQueue.addAll(this.actualJobQueue);
        }
        object = null;
        while (((object = this.holdingBinQueue.poll()) == null || !this.isAgentAvailable(l = ((JobHistory)((Object)object)).getAgentID()) || this.isAgentLocked(l)) && object != null) {
        }
        if (object == null) {
            this.holdingBinQueue.clear();
            return null;
        }
        this.holdingBinQueue.clear();
        PriorityBlockingQueue priorityBlockingQueue = this.actualJobQueue;
        synchronized (priorityBlockingQueue) {
            this.actualJobQueue.remove(object);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getActiveJobsCount() {
        int n = 0;
        HashMap<Long, HashSet<Long>> hashMap = this.runningJobsHM;
        synchronized (hashMap) {
            Collection<HashSet<Long>> collection = this.runningJobsHM.values();
            Iterator<HashSet<Long>> iterator = collection.iterator();
            while (iterator.hasNext()) {
                n += iterator.next().size();
            }
        }
        return n;
    }

    public int getActiveJobsForAgent(long l) {
        return this.getRunningJobsListForAgent(l).size();
    }

    private synchronized Set<Long> getRunningJobsListForAgent(long l) {
        if (this.runningJobsHM.get(l) == null) {
            HashSet hashSet = new HashSet();
            this.runningJobsHM.put(l, hashSet);
        }
        return this.runningJobsHM.get(l);
    }

    @Override
    public boolean decrementActiveJobs(JobHistory jobHistory) {
        if (this.getRunningJobsListForAgent(jobHistory.getAgentID()).remove(jobHistory.getId())) {
            if (this.isLimiterEnabled() && jobHistory.getJobPriority() >= this.getLimiterMinimumPriority()) {
                this.decrementPriorityLimitActiveJobs();
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean incrementActiveJobs(JobHistory jobHistory) {
        boolean bl = false;
        bl = this.getRunningJobsListForAgent(jobHistory.getAgentID()).add(jobHistory.getId());
        if (this.isLimiterEnabled() && jobHistory.getJobPriority() >= this.getLimiterMinimumPriority()) {
            this.incrementPriorityLimitActiveJobs();
        }
        return bl;
    }

    public boolean isAtMaxActiveForAgent(long l) {
        Integer n = this.getRunningJobsListForAgent(l).size();
        return n >= this.getMaxActivePerAgent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCountForAgent(long l) {
        int n = 0;
        ArrayList arrayList = new ArrayList();
        PriorityBlockingQueue priorityBlockingQueue = this.actualJobQueue;
        synchronized (priorityBlockingQueue) {
            arrayList.addAll(this.actualJobQueue);
        }
        for (JobHistory jobHistory : arrayList) {
            if (jobHistory.getAgentID() != l) continue;
            ++n;
        }
        return n;
    }

    @Override
    public void setAgentUnavailable(long l) {
        this.unavailableAgents.add(l);
    }

    @Override
    public boolean setAgentAvailable(long l) {
        return this.unavailableAgents.remove(l);
    }

    @Override
    public boolean isAgentLocked(long l) {
        return this.lockedAgents.contains(l);
    }

    public void setAgentsLocked(ArrayList<Long> arrayList) {
        this.lockedAgents.addAll(arrayList);
    }

    @Override
    public void setAgentLocked(long l) {
        this.lockedAgents.add(l);
    }

    @Override
    public boolean setAgentUnlocked(long l) {
        return this.lockedAgents.remove(l);
    }

    @Override
    public boolean isAgentAvailable(long l) {
        return !this.unavailableAgents.contains(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCurrentlyRunningJobs() {
        String string = "\nJobs Running from Queue: " + this.getNameAndID();
        HashMap<Long, HashSet<Long>> hashMap = this.runningJobsHM;
        synchronized (hashMap) {
            Set<Long> set = this.runningJobsHM.keySet();
            for (long l : set) {
                HashSet<Long> hashSet = this.runningJobsHM.get(l);
                for (long l2 : hashSet) {
                    string = string + "\n" + l + ": " + l2;
                }
            }
        }
        return string;
    }

    public String listUnavailableAgents() {
        String string = "\nUnavailable Agents:";
        Iterator<Long> iterator = this.unavailableAgents.iterator();
        while (iterator.hasNext()) {
            string = string + "\nAgentID: " + iterator.next();
        }
        return string;
    }

    public String listLockedAgents() {
        String string = "\nLocked Agents:";
        Iterator<Long> iterator = this.lockedAgents.iterator();
        while (iterator.hasNext()) {
            string = string + "\nAgentID: " + iterator.next();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearUnavailableAgents() {
        Set<Long> set = this.unavailableAgents;
        synchronized (set) {
            this.unavailableAgents.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long[] getAllActiveJobHistoryIDs() {
        ArrayList arrayList = new ArrayList();
        HashMap<Long, HashSet<Long>> hashMap = this.runningJobsHM;
        synchronized (hashMap) {
            Iterator<Map.Entry<Long, HashSet<Long>>> iterator = this.runningJobsHM.entrySet().iterator();
            while (iterator.hasNext()) {
                arrayList.addAll(iterator.next().getValue());
            }
        }
        return arrayList.toArray(new Long[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasJobsNotForAgent(long l) {
        PriorityBlockingQueue priorityBlockingQueue = this.actualJobQueue;
        synchronized (priorityBlockingQueue) {
            for (JobHistory jobHistory : this.actualJobQueue) {
                if (jobHistory.getAgentID() == l || !this.isAgentAvailable(jobHistory.getAgentID()) || this.isAgentLocked(jobHistory.getAgentID())) continue;
                return true;
            }
        }
        return false;
    }
}

