/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.core.busobj;

import com.helpsystems.enterprise.core.busobj.AgentReturnCode;
import com.helpsystems.enterprise.core.busobj.CommandSetCommand;
import junit.framework.TestCase;

public class CommandSetCommandTest
extends TestCase {
    private CommandSetCommand com;

    protected void setUp() throws Exception {
        super.setUp();
        this.com = new CommandSetCommand();
    }

    protected void tearDown() throws Exception {
        this.com = null;
        super.tearDown();
    }

    public void testGetCommand() {
        this.com.setCommandString("some command");
        CommandSetCommandTest.assertEquals((String)"some command", (String)this.com.getCommandString());
    }

    public void testGetLineNumber() {
        this.com.setLineNumber(1);
        CommandSetCommandTest.assertEquals((int)1, (int)this.com.getLineNumber());
    }

    public void testGetOid() {
        this.com.setOid(1234L);
        CommandSetCommandTest.assertEquals((long)1234L, (long)this.com.getOid());
    }

    public void testChangesToTheOidAreNotAllowed() {
        this.com.setOid(1234L);
        try {
            this.com.setOid(54321L);
            CommandSetCommandTest.fail((String)"setOid() allowed when OID was already set");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGetBytes() {
        byte[] byArray = new byte[200];
        int n = 97;
        for (int i = 0; i < 200; ++i) {
            byArray[i] = n;
            if ((n = (int)((byte)(n + 1))) <= 122) continue;
            n = 97;
        }
        this.com.setBytes(byArray);
        CommandSetCommandTest.assertEquals((Object)byArray, (Object)this.com.getBytes());
    }

    public void testContainsProtectedCharacters() {
        byte[] byArray = new byte[10];
        int n = 97;
        for (int i = 0; i < 10; ++i) {
            byArray[i] = n;
            n = (byte)(n + 1);
        }
        this.com.setCommandString(new String(byArray));
        CommandSetCommandTest.assertFalse((boolean)this.com.containsProtectedCharacters());
        byArray[5] = 0;
        this.com.setCommandString(new String(byArray));
        CommandSetCommandTest.assertTrue((boolean)this.com.containsProtectedCharacters());
    }

    public void testConstructorWithCommand() {
        String string = "some command value";
        CommandSetCommand commandSetCommand = new CommandSetCommand(string);
        CommandSetCommandTest.assertEquals((String)string, (String)commandSetCommand.getCommandString());
    }

    public void testSetCancelOnError() {
        this.com.setCancelOnError(true);
        CommandSetCommandTest.assertTrue((boolean)this.com.getCancelOnError());
        CommandSetCommandTest.assertTrue((boolean)this.com.isCancelOnError());
        this.com.setCancelOnError(false);
        CommandSetCommandTest.assertFalse((boolean)this.com.getCancelOnError());
        CommandSetCommandTest.assertFalse((boolean)this.com.isCancelOnError());
    }

    public void testSetReturnCode() {
        CommandSetCommandTest.assertNull((Object)((Object)this.com.getReturnCode()));
        CommandSetCommandTest.assertEquals((long)0L, (long)this.com.getReturnCodeOid());
        this.com.setReturnCode(null);
        CommandSetCommandTest.assertNull((Object)((Object)this.com.getReturnCode()));
        CommandSetCommandTest.assertEquals((long)0L, (long)this.com.getReturnCodeOid());
        AgentReturnCode agentReturnCode = new AgentReturnCode();
        agentReturnCode.setType(1);
        agentReturnCode.setOid(123456L);
        CommandSetCommandTest.assertTrue((boolean)agentReturnCode.isPrivateType());
        this.com.setReturnCode(agentReturnCode);
        CommandSetCommandTest.assertEquals((Object)((Object)agentReturnCode), (Object)((Object)this.com.getReturnCode()));
        CommandSetCommandTest.assertEquals((long)123456L, (long)this.com.getReturnCodeOid());
        AgentReturnCode agentReturnCode2 = new AgentReturnCode();
        agentReturnCode2.setType(1);
        agentReturnCode2.setOid(333444L);
        CommandSetCommandTest.assertTrue((boolean)agentReturnCode2.isPrivateType());
        this.com.setReturnCode(agentReturnCode2);
        CommandSetCommandTest.assertEquals((Object)((Object)agentReturnCode2), (Object)((Object)this.com.getReturnCode()));
        CommandSetCommandTest.assertEquals((long)333444L, (long)this.com.getReturnCodeOid());
        AgentReturnCode agentReturnCode3 = new AgentReturnCode();
        agentReturnCode3.setDescription("Some shared return code");
        agentReturnCode3.setOid(654321L);
        CommandSetCommandTest.assertFalse((boolean)agentReturnCode3.isPrivateType());
        this.com.setReturnCode(agentReturnCode3);
        CommandSetCommandTest.assertEquals((Object)((Object)agentReturnCode3), (Object)((Object)this.com.getReturnCode()));
        CommandSetCommandTest.assertEquals((long)654321L, (long)this.com.getReturnCodeOid());
    }
}

