/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.scheduler;

import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.core.scheduler.LocalHHMM;
import com.helpsystems.enterprise.core.scheduler.Runtimes;
import com.helpsystems.enterprise.core.scheduler.RuntimesDM;
import com.helpsystems.enterprise.core.scheduler.Runtimes_Basic;
import com.helpsystems.enterprise.core.scheduler.Runtimes_DayOfPeriod;
import com.helpsystems.enterprise.core.scheduler.Runtimes_DayOfWeek;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobProxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class RuntimesDMJdbc
extends AbstractDatabaseManager
implements RuntimesDM {
    private static final Logger logger = Logger.getLogger(RuntimesDMJdbc.class);
    private static final String BASIC_TABLE = "basic_runtimes";
    private static final String DAY_OF_PERIOD_TABLE = "day_of_period_runtimes";
    private static final String DAY_OF_WEEK_TABLE = "day_of_week_runtimes";
    private static final String FORECAST_BASIC_TABLE = "forecast_runtimes";
    private static final String FORECAST_DAY_OF_PERIOD_TABLE = "forecast_day_of_period_runtimes";
    private static final String FORECAST_DAY_OF_WEEK_TABLE = "forecast_day_of_week_runtimes";
    private String basicTable;
    private String dayOfWeekTable;
    private String dayOfPeriodTable;
    private String basicTable_Forecast;
    private String dayOfWeekTable_Forecast;
    private String dayOfPeriodTable_Forecast;

    public RuntimesDMJdbc(String string, String string2, String string3) {
        super(string);
        ValidationHelper.checkForNull((String)"Library", (Object)string2);
        ValidationHelper.checkForNull((String)"ManagerName", (Object)string3);
        this.basicTable = string2 + "." + BASIC_TABLE;
        this.dayOfWeekTable = string2 + "." + DAY_OF_WEEK_TABLE;
        this.dayOfPeriodTable = string2 + "." + DAY_OF_PERIOD_TABLE;
        this.basicTable_Forecast = string2 + "." + FORECAST_BASIC_TABLE;
        this.dayOfWeekTable_Forecast = string2 + "." + FORECAST_DAY_OF_WEEK_TABLE;
        this.dayOfPeriodTable_Forecast = string2 + "." + FORECAST_DAY_OF_PERIOD_TABLE;
        this.setName(string3);
    }

    @Override
    public Runtimes get(long l, ScheduleJobProxy.ScheduleType scheduleType, CalendarObject calendarObject, Connection connection) throws ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"Schedule Type", (Object)scheduleType);
        ValidationHelper.checkForNull((String)"Calendar Object", (Object)calendarObject);
        ValidationHelper.checkForNull((String)"Connection", (Object)connection);
        return this.internal_get(l, TypeOfSchedule.REGULAR, scheduleType, calendarObject, null, connection);
    }

    @Override
    public Runtimes get(long l, ScheduleJobProxy.ScheduleType scheduleType, CalendarObject calendarObject, CalendarObject.DayType dayType, Connection connection) throws ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"Schedule Type", (Object)scheduleType);
        ValidationHelper.checkForNull((String)"Calendar Object", (Object)calendarObject);
        ValidationHelper.checkForNull((String)"Day Type", (Object)dayType);
        ValidationHelper.checkForNull((String)"Connection", (Object)connection);
        return this.internal_get(l, TypeOfSchedule.REGULAR, scheduleType, calendarObject, dayType, connection);
    }

    @Override
    public Runtimes getForecastScheduleRuntimes(long l, ScheduleJobProxy.ScheduleType scheduleType, CalendarObject calendarObject, Connection connection) throws ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"Schedule Type", (Object)scheduleType);
        ValidationHelper.checkForNull((String)"Calendar Object", (Object)calendarObject);
        ValidationHelper.checkForNull((String)"Connection", (Object)connection);
        return this.internal_get(l, TypeOfSchedule.FORECAST, scheduleType, calendarObject, null, connection);
    }

    @Override
    public Runtimes getForecastScheduleRuntimes(long l, ScheduleJobProxy.ScheduleType scheduleType, CalendarObject calendarObject, CalendarObject.DayType dayType, Connection connection) throws ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"Schedule Type", (Object)scheduleType);
        ValidationHelper.checkForNull((String)"Calendar Object", (Object)calendarObject);
        ValidationHelper.checkForNull((String)"Day Type", (Object)dayType);
        ValidationHelper.checkForNull((String)"Connection", (Object)connection);
        return this.internal_get(l, TypeOfSchedule.FORECAST, scheduleType, calendarObject, dayType, connection);
    }

    private Runtimes basicRuntimes(long l, TypeOfSchedule typeOfSchedule, CalendarObject calendarObject, Connection connection) throws ResourceUnavailableException {
        boolean bl;
        PreparedStatement preparedStatement;
        String string;
        Runtimes_Basic runtimes_Basic = new Runtimes_Basic(calendarObject.getDayStart());
        switch (typeOfSchedule) {
            case REGULAR: {
                string = "SELECT runtime FROM " + this.basicTable + " WHERE job_id=?";
                break;
            }
            case FORECAST: {
                string = "SELECT runtime FROM " + this.basicTable_Forecast + " WHERE forecast_schedule_id=?";
                break;
            }
            default: {
                throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: Type of Schedule {0} is not supported by this method.", (Object[])new Object[]{typeOfSchedule}));
            }
        }
        if (connection != null) {
            preparedStatement = this.getDefaultPreparedStmt(string, connection);
            bl = true;
        } else {
            preparedStatement = this.getDefaultPreparedStmt(string);
            bl = false;
        }
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                LocalHHMM localHHMM = this.toLocalHHMM(resultSet.getInt("runtime"));
                runtimes_Basic.addRuntime(localHHMM);
            }
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL Error while retrieving the runtimes for {0} {1}.", (Object[])new Object[]{this.associatedObjectText(typeOfSchedule), l});
            logger.debug((Object)string2, (Throwable)sQLException);
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            if (!bl) {
                this.closeConnection(preparedStatement);
            }
        }
        return runtimes_Basic;
    }

    private Runtimes dayOfPeriodRuntimes(long l, TypeOfSchedule typeOfSchedule, CalendarObject calendarObject, CalendarObject.DayType dayType, Connection connection) throws ResourceUnavailableException {
        boolean bl;
        PreparedStatement preparedStatement;
        String string;
        Runtimes_DayOfPeriod runtimes_DayOfPeriod = new Runtimes_DayOfPeriod(calendarObject, dayType);
        switch (typeOfSchedule) {
            case REGULAR: {
                string = "SELECT runtime, day_number, period_type FROM " + this.dayOfPeriodTable + " WHERE job_id=?";
                break;
            }
            case FORECAST: {
                string = "SELECT runtime, day_number, period_type FROM " + this.dayOfPeriodTable_Forecast + " WHERE forecast_schedule_id=?";
                break;
            }
            default: {
                throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: Type of Schedule {0} is not supported by this method.", (Object[])new Object[]{typeOfSchedule}));
            }
        }
        if (connection != null) {
            preparedStatement = this.getDefaultPreparedStmt(string, connection);
            bl = true;
        } else {
            preparedStatement = this.getDefaultPreparedStmt(string);
            bl = false;
        }
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                LocalHHMM localHHMM = this.toLocalHHMM(resultSet.getInt("runtime"));
                int n = resultSet.getInt("day_number");
                CalendarObject.PeriodType periodType = CalendarObject.PeriodType.persistanceCodeToEnum(resultSet.getString("period_type"));
                runtimes_DayOfPeriod.addRuntime(periodType, n, localHHMM);
            }
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL Error while retrieving the runtimes for {0} {1}.", (Object[])new Object[]{this.associatedObjectText(typeOfSchedule), l});
            logger.debug((Object)string2, (Throwable)sQLException);
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            if (!bl) {
                this.closeConnection(preparedStatement);
            }
        }
        return runtimes_DayOfPeriod;
    }

    private Runtimes dayOfWeekRuntimes(long l, TypeOfSchedule typeOfSchedule, CalendarObject calendarObject, Connection connection) throws ResourceUnavailableException {
        boolean bl;
        PreparedStatement preparedStatement;
        String string;
        Runtimes_DayOfWeek runtimes_DayOfWeek = new Runtimes_DayOfWeek(calendarObject);
        switch (typeOfSchedule) {
            case REGULAR: {
                string = "SELECT runtime, runcode_mon, runcode_tue, runcode_wed, runcode_thu, runcode_fri, runcode_sat, runcode_sun FROM " + this.dayOfWeekTable + " WHERE job_id=?";
                break;
            }
            case FORECAST: {
                string = "SELECT runtime, runcode_mon, runcode_tue, runcode_wed, runcode_thu, runcode_fri, runcode_sat, runcode_sun FROM " + this.dayOfWeekTable_Forecast + " WHERE forecast_schedule_id=?";
                break;
            }
            default: {
                throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: Type of Schedule {0} is not supported by this method.", (Object[])new Object[]{typeOfSchedule}));
            }
        }
        if (connection != null) {
            preparedStatement = this.getDefaultPreparedStmt(string, connection);
            bl = true;
        } else {
            preparedStatement = this.getDefaultPreparedStmt(string);
            bl = false;
        }
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                LocalHHMM localHHMM = this.toLocalHHMM(resultSet.getInt("runtime"));
                Runtimes_DayOfWeek.RunCode runCode = Runtimes_DayOfWeek.RunCode.persistanceCodeToEnum(resultSet.getString("runcode_mon"));
                runtimes_DayOfWeek.addRuntime(CalendarObject.DayOfWeek.MON, runCode, localHHMM);
                runCode = Runtimes_DayOfWeek.RunCode.persistanceCodeToEnum(resultSet.getString("runcode_tue"));
                runtimes_DayOfWeek.addRuntime(CalendarObject.DayOfWeek.TUE, runCode, localHHMM);
                runCode = Runtimes_DayOfWeek.RunCode.persistanceCodeToEnum(resultSet.getString("runcode_wed"));
                runtimes_DayOfWeek.addRuntime(CalendarObject.DayOfWeek.WED, runCode, localHHMM);
                runCode = Runtimes_DayOfWeek.RunCode.persistanceCodeToEnum(resultSet.getString("runcode_thu"));
                runtimes_DayOfWeek.addRuntime(CalendarObject.DayOfWeek.THU, runCode, localHHMM);
                runCode = Runtimes_DayOfWeek.RunCode.persistanceCodeToEnum(resultSet.getString("runcode_fri"));
                runtimes_DayOfWeek.addRuntime(CalendarObject.DayOfWeek.FRI, runCode, localHHMM);
                runCode = Runtimes_DayOfWeek.RunCode.persistanceCodeToEnum(resultSet.getString("runcode_sat"));
                runtimes_DayOfWeek.addRuntime(CalendarObject.DayOfWeek.SAT, runCode, localHHMM);
                runCode = Runtimes_DayOfWeek.RunCode.persistanceCodeToEnum(resultSet.getString("runcode_sun"));
                runtimes_DayOfWeek.addRuntime(CalendarObject.DayOfWeek.SUN, runCode, localHHMM);
            }
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL Error while retrieving the runtimes for {0} {1}.", (Object[])new Object[]{this.associatedObjectText(typeOfSchedule), l});
            logger.debug((Object)string2, (Throwable)sQLException);
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            if (!bl) {
                this.closeConnection(preparedStatement);
            }
        }
        return runtimes_DayOfWeek;
    }

    private Runtimes internal_get(long l, TypeOfSchedule typeOfSchedule, ScheduleJobProxy.ScheduleType scheduleType, CalendarObject calendarObject, CalendarObject.DayType dayType, Connection connection) throws ResourceUnavailableException {
        switch (scheduleType) {
            case DAY_COUNT: {
                return this.basicRuntimes(l, typeOfSchedule, calendarObject, connection);
            }
            case DAY_OF_PERIOD: {
                return this.dayOfPeriodRuntimes(l, typeOfSchedule, calendarObject, dayType, connection);
            }
            case DAY_OF_WEEK: {
                return this.dayOfWeekRuntimes(l, typeOfSchedule, calendarObject, connection);
            }
            case DATE_LIST: {
                return this.basicRuntimes(l, typeOfSchedule, calendarObject, connection);
            }
        }
        throw new IllegalArgumentException(MessageUtil.formatMsg((String)"It is invalid to request to retrieve runtimes for Schedule Type {0}. ", (Object[])new Object[]{scheduleType}));
    }

    private LocalHHMM toLocalHHMM(int n) {
        int n2 = n / 100;
        int n3 = n - n2 * 100;
        return new LocalHHMM(n2, n3);
    }

    private String associatedObjectText(TypeOfSchedule typeOfSchedule) {
        switch (typeOfSchedule) {
            case REGULAR: {
                return "Job";
            }
            case FORECAST: {
                return "Forecast Schedule";
            }
        }
        return "??";
    }

    private static enum TypeOfSchedule {
        REGULAR,
        FORECAST;

    }
}

