/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.scheduler;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.NotSavedException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.Convert;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.busobj.JobEndedReasonCode;
import com.helpsystems.enterprise.core.busobj.JobHistory;
import com.helpsystems.enterprise.core.busobj.JobStatusCode;
import com.helpsystems.enterprise.core.busobj.JobType;
import com.helpsystems.enterprise.core.dm.ScheduleJobDM;
import com.helpsystems.enterprise.core.scheduler.DependentMember;
import com.helpsystems.enterprise.core.scheduler.DependentMemberIDAndType;
import com.helpsystems.enterprise.core.scheduler.JobSuiteDM;
import com.helpsystems.enterprise.core.scheduler.JobSuiteInstanceMember;
import com.helpsystems.enterprise.core.scheduler.JobSuiteMember;
import com.helpsystems.enterprise.core.scheduler.JobSuiteMemberJobDependencies;
import com.helpsystems.enterprise.core.scheduler.JobSuiteMemberJobSkipSpecialInstance;
import com.helpsystems.enterprise.core.scheduler.JobSuiteMemberSkipFlag;
import com.helpsystems.enterprise.core.scheduler.JobSuiteStatus;
import com.helpsystems.enterprise.core.scheduler.MemberDependencyType;
import com.helpsystems.enterprise.core.scheduler.MemberRequiredPrereqs;
import com.helpsystems.enterprise.core.scheduler.MemberStatus;
import com.helpsystems.enterprise.core.scheduler.MissingJobDataException;
import com.helpsystems.enterprise.core.scheduler.PrereqMemberIDAndType;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class JobSuiteDMJdbc
extends AbstractHelpingDatabaseManager
implements JobSuiteDM {
    private static final Logger logger = Logger.getLogger(JobSuiteDMJdbc.class);
    private Calendar cloneOnly_GMTCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
    private static final String MEMBER_JOBS_TABLE = "job_suite_member_jobs";
    private static final String MEMBER_STATUSES_TABLE = "job_suite_member_statuses";
    private static final String DEPENDENCIES_TABLE = "job_suite_dependencies";
    private static final String INSTANCE_DEPENDENCIES_TABLE = "job_suite_instance_dependencies";
    private static final String JOBS_TABLE = "jobs";
    private static final String SUITE_HISTORY_TABLE = "job_histories";
    private String memberJobsTable;
    private String memberStatusesTable;
    private String dependenciesTable;
    private String instanceDependenciesTable;
    private String jobsTable;
    private String suiteHistoryTable;
    private ScheduleJobDM scheduleJobDM;

    public JobSuiteDMJdbc(String string, String string2, String string3, ScheduleJobDM scheduleJobDM, SQLManagerHelper sQLManagerHelper) {
        super(string, string2, sQLManagerHelper);
        ValidationHelper.checkForNull((String)"Library", (Object)string2);
        ValidationHelper.checkForNull((String)"ManagerName", (Object)string3);
        ValidationHelper.checkForNull((String)"ScheduleJobDM", (Object)scheduleJobDM);
        this.memberJobsTable = string2 + "." + MEMBER_JOBS_TABLE;
        this.memberStatusesTable = string2 + "." + MEMBER_STATUSES_TABLE;
        this.dependenciesTable = string2 + "." + DEPENDENCIES_TABLE;
        this.instanceDependenciesTable = string2 + "." + INSTANCE_DEPENDENCIES_TABLE;
        this.jobsTable = string2 + "." + JOBS_TABLE;
        this.suiteHistoryTable = string2 + "." + SUITE_HISTORY_TABLE;
        this.scheduleJobDM = scheduleJobDM;
        this.setName(string3);
    }

    @Override
    public JobHistory createSuiteHistoryRecord(JobHistory jobHistory) throws ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"JobHistory", (Object)((Object)jobHistory));
        try {
            if (jobHistory.getInitiationData() != null && jobHistory.getInitiationData().length() > 4096) {
                String string = "Job Suite History Initiation Data length " + jobHistory.getInitiationData().length() + " exceeds maximum length of " + 4096 + ". Initiation Data will be cleared.";
                logger.warn((Object)string);
                jobHistory.setInitiationData("");
            }
            return (JobHistory)((Object)super.save((Object)jobHistory));
        }
        catch (DataException dataException) {
            throw new IllegalStateException("", dataException);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw new ResourceUnavailableException("", (Throwable)resourceUnavailableException);
        }
    }

    @Override
    public Map<Long, Long> createMemberStatusRecordsForSuiteInstance(long l, long l2) throws ResourceUnavailableException {
        HashMap<Long, Long> hashMap = new HashMap<Long, Long>();
        String string = "SELECT id, member_job_id, required_prereqs, failed_member_action FROM " + this.memberJobsTable + " WHERE job_suite_id =?";
        String string2 = "INSERT INTO " + this.memberStatusesTable + " (suite_instance_id, job_id, job_suite_member_job_id, required_prereqs, failed_member_action) VALUES(?,?,?,?,?)";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        PreparedStatement preparedStatement2 = null;
        try {
            preparedStatement2 = this.getPreparedStmtThatReturnsGeneratedKeys(string2, preparedStatement.getConnection());
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                long l3;
                long l4 = resultSet.getLong("member_job_id");
                long l5 = resultSet.getLong("id");
                int n = resultSet.getInt("required_prereqs");
                int n2 = resultSet.getInt("failed_member_action");
                try {
                    l3 = this.createMemberStatusRecord(preparedStatement2, l2, l4, l5, n, n2);
                }
                catch (NotSavedException notSavedException) {
                    throw new IllegalStateException(MessageUtil.formatMsg((String)"An error occurred while creating the member status rows for the {0} instance of Job Suite {1}.", (Object[])new Object[]{l2, this.getSuiteName(l)}), notSavedException);
                }
                hashMap.put(l5, l3);
            }
        }
        catch (SQLException sQLException) {
            String string3 = MessageUtil.formatMsg((String)"SQL error while creating the member status rows for the {0} instance of Job Suite {1}.", (Object[])new Object[]{l2, this.getSuiteName(l)});
            throw new ResourceUnavailableException(string3, (Throwable)sQLException);
        }
        finally {
            JobSuiteDMJdbc.closeEm(null, (Statement)preparedStatement2, null);
            this.closeConnection(preparedStatement);
        }
        return hashMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void createDependencyRecordsForSuiteInstance(long l, long l2, Map<Long, Long> map) throws ResourceUnavailableException {
        String string = "SELECT dependent_member_id, prereq_member_id, dependency_type FROM " + this.dependenciesTable + " WHERE dependent_member_id IN" + " (SELECT id FROM " + this.memberJobsTable + " WHERE job_suite_id =?)";
        String string2 = "INSERT INTO " + this.instanceDependenciesTable + " (suite_instance_id, dependent_member_id, prereq_member_id, dependency_type) VALUES(?,?,?,?)";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        PreparedStatement preparedStatement2 = null;
        try {
            preparedStatement2 = this.getDefaultPreparedStmt(string2, preparedStatement.getConnection());
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                long l3 = resultSet.getLong("dependent_member_id");
                Long l4 = map.get(l3);
                if (l4 == null) {
                    throw new IllegalStateException(MessageUtil.formatMsg((String)"Cannot find the member ID map entry for member ID {0}, of Job Suite {1}.", (Object[])new Object[]{l3, l}));
                }
                long l5 = resultSet.getLong("prereq_member_id");
                Long l6 = map.get(l5);
                if (l6 == null) {
                    throw new IllegalStateException(MessageUtil.formatMsg((String)"Cannot find the member ID map entry for member ID {0}, of Job Suite {1}.", (Object[])new Object[]{l5, l}));
                }
                int n = resultSet.getInt("dependency_type");
                try {
                    this.createInstanceDependencyRecord(preparedStatement2, l2, l4, l6, n);
                }
                catch (NotSavedException notSavedException) {
                    throw new IllegalStateException(MessageUtil.formatMsg((String)"An error occurred while creating the dependency rows for the {0} instance of Job Suite {1}.", (Object[])new Object[]{l2, this.getSuiteName(l)}), notSavedException);
                    return;
                }
            }
        }
        catch (SQLException sQLException) {
            String string3 = MessageUtil.formatMsg((String)"SQL error while creating the dependency rows for the {0} instance of Job Suite {1}.", (Object[])new Object[]{l2, this.getSuiteName(l)});
            throw new ResourceUnavailableException(string3, (Throwable)sQLException);
        }
        finally {
            JobSuiteDMJdbc.closeEm(null, (Statement)preparedStatement2, null);
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public Long[] getActiveMembers(long l) throws ResourceUnavailableException {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        String string = MessageUtil.formatMsg((String)"job_status IN (''{0}'', ''{1}'', ''{2}'')", (Object[])new Object[]{JobStatusCode.INITIATED.persistanceCode(), JobStatusCode.SUBMITTED.persistanceCode(), JobStatusCode.RUNNING.persistanceCode()});
        String string2 = "SELECT id FROM " + this.suiteHistoryTable + " WHERE job_suite_history_id =? AND " + string;
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string2);
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                arrayList.add(resultSet.getLong("id"));
            }
        }
        catch (SQLException sQLException) {
            String string3 = MessageUtil.formatMsg((String)"SQL error while retrieving the active members for suite run {0}.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string3, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return arrayList.toArray(new Long[arrayList.size()]);
    }

    @Override
    public Long[] getActiveMembersPerMemberStatuses(long l) throws ResourceUnavailableException {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        String string = "SELECT jh.id FROM " + this.memberStatusesTable + " ms JOIN " + this.suiteHistoryTable + " jh ON ms.id = job_suite_member_instance_id " + "WHERE suite_instance_id =? AND status =? AND restart_child_history_id =0";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            preparedStatement.setString(2, JobStatusCode.RUNNING.persistanceCode());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                arrayList.add(resultSet.getLong("id"));
            }
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the active members for suite run {0}.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return arrayList.toArray(new Long[arrayList.size()]);
    }

    @Override
    public List<DependentMemberIDAndType> getDependentMemberIDsAndTypes(long l) throws ResourceUnavailableException {
        ArrayList<DependentMemberIDAndType> arrayList = new ArrayList<DependentMemberIDAndType>();
        String string = "SELECT dependent_member_id, dependency_type FROM " + this.instanceDependenciesTable + " WHERE prereq_member_id =?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                long l2 = resultSet.getLong("dependent_member_id");
                MemberDependencyType memberDependencyType = MemberDependencyType.persistanceCodeToEnum(resultSet.getInt("dependency_type"));
                arrayList.add(new DependentMemberIDAndType(l2, memberDependencyType));
            }
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the members that have member instance {0} as a prerequisite.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return arrayList;
    }

    @Override
    public DependentMember getDependentMember(long l) throws ResourceUnavailableException {
        String string = "SELECT id, COALESCE(status, '') as status, required_prereqs FROM " + this.memberStatusesTable + " WHERE id =?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                long l2 = resultSet.getLong("id");
                String string2 = Convert.trimR((String)resultSet.getString("status"));
                MemberStatus memberStatus = MemberStatus.persistanceCodeToEnum(string2);
                MemberRequiredPrereqs memberRequiredPrereqs = MemberRequiredPrereqs.persistanceCodeToEnum(resultSet.getInt("required_prereqs"));
                DependentMember dependentMember = new DependentMember(l2, memberRequiredPrereqs, memberStatus);
                return dependentMember;
            }
            try {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Could not find member instance ID {0} in the member status file.", (Object[])new Object[]{l}));
            }
            catch (SQLException sQLException) {
                String string3 = MessageUtil.formatMsg((String)"SQL error while retrieving the status of member instance {0}.", (Object[])new Object[]{l});
                throw new ResourceUnavailableException(string3, (Throwable)sQLException);
            }
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public JobSuiteInstanceMember getInstanceMember(long l) throws MissingJobDataException, BadDataException, NoDataException, ResourceUnavailableException {
        JobSuiteInstanceMemberGenerator jobSuiteInstanceMemberGenerator = new JobSuiteInstanceMemberGenerator();
        String string = "SELECT job_id, job_type, name, target_id, target_type, job_queue_id, job_queue_name, default_priority, agent_environment_type, ms.id AS member_instance_id, suite_instance_id, job_suite_member_job_id, COALESCE(skip, 0) AS skip, skip_times, skipped_count, skip_until, skip_matched, ms.required_prereqs, ms.failed_member_action FROM (" + this.memberStatusesTable + " ms LEFT OUTER JOIN " + this.jobsTable + " j ON job_id = j.id) " + "LEFT OUTER JOIN " + this.memberJobsTable + " mj ON job_suite_member_job_id = mj.id " + "WHERE ms.id =?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                if (resultSet.getString("name") == null) {
                    long l2 = resultSet.getLong("job_id");
                    throw new MissingJobDataException("", l2);
                }
                JobSuiteInstanceMember jobSuiteInstanceMember = (JobSuiteInstanceMember)jobSuiteInstanceMemberGenerator.generateObject(resultSet);
                return jobSuiteInstanceMember;
            }
            try {
                throw new NoDataException(MessageUtil.formatMsg((String)"Could not find member ID {0} in the suite member status file.", (Object[])new Object[]{l}));
            }
            catch (SQLException sQLException) {
                String string2 = MessageUtil.formatMsg((String)"SQL error while constructing the instance member object for {0}.", (Object[])new Object[]{l});
                throw new ResourceUnavailableException(string2, (Throwable)sQLException);
            }
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public JobSuiteMember getMember(long l) throws NoDataException, ResourceUnavailableException {
        String string = "SELECT j.name,  jsmj.* FROM " + this.memberJobsTable + " jsmj inner join jobs j on j.id = jsmj.member_job_id WHERE jsmj.id =?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                JobSuiteMember jobSuiteMember = new JobSuiteMember();
                jobSuiteMember.setMemberID(l);
                jobSuiteMember.setJobID(resultSet.getLong("member_job_id"));
                jobSuiteMember.setName(resultSet.getString("name"));
                int n = resultSet.getInt("skip");
                jobSuiteMember.setSkipFlag(JobSuiteMemberSkipFlag.persistanceCodeToEnum(n));
                jobSuiteMember.setSkipTimes(resultSet.getInt("skip_times"));
                jobSuiteMember.setSkipCount(resultSet.getInt("skipped_count"));
                Calendar calendar = (Calendar)this.cloneOnly_GMTCalendar.clone();
                Timestamp timestamp = resultSet.getTimestamp("skip_until", calendar);
                if (timestamp != null) {
                    jobSuiteMember.setSkipUntil(timestamp.getTime());
                }
                jobSuiteMember.setRequiredPrereqs(resultSet.getInt("required_prereqs"));
                jobSuiteMember.setFailedMemberAction(resultSet.getInt("failed_member_action"));
                JobSuiteMember jobSuiteMember2 = jobSuiteMember;
                return jobSuiteMember2;
            }
            try {
                throw new NoDataException(MessageUtil.formatMsg((String)"Could not find member ID {0} in the suite member file.", (Object[])new Object[]{l}));
            }
            catch (SQLException sQLException) {
                String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the job suite member with ID {0}.", (Object[])new Object[]{l});
                throw new ResourceUnavailableException(string2, (Throwable)sQLException);
            }
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public List<JobSuiteMember> getMemberJob(long l) throws NoDataException, ResourceUnavailableException {
        String string = "SELECT * FROM " + this.memberJobsTable + " WHERE job_suite_id =?";
        ArrayList<Object> arrayList = new ArrayList<Object>();
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            Object object;
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object = new JobSuiteMember();
                ((JobSuiteMember)object).setMemberID(resultSet.getLong("member_job_id"));
                ((JobSuiteMember)object).setJobID(resultSet.getLong("id"));
                int n = resultSet.getInt("skip");
                ((JobSuiteMember)object).setSkipFlag(JobSuiteMemberSkipFlag.persistanceCodeToEnum(n));
                ((JobSuiteMember)object).setSkipTimes(resultSet.getInt("skip_times"));
                ((JobSuiteMember)object).setSkipCount(resultSet.getInt("skipped_count"));
                ((JobSuiteMember)object).setSkipMatched(resultSet.getBoolean("skip_matched"));
                ((JobSuiteMember)object).setRequiredPrereqs(resultSet.getInt("required_prereqs"));
                ((JobSuiteMember)object).setFailedMemberAction(resultSet.getInt("failed_member_action"));
                Calendar calendar = (Calendar)this.cloneOnly_GMTCalendar.clone();
                Timestamp timestamp = resultSet.getTimestamp("skip_until", calendar);
                if (timestamp != null) {
                    ((JobSuiteMember)object).setSkipUntil(timestamp.getTime());
                }
                arrayList.add(object);
            }
            object = arrayList;
            return object;
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the job suite member with ID {0}.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public MemberStatus getMemberStatus(long l) throws ResourceUnavailableException {
        String string = "SELECT COALESCE(status, '') as status FROM " + this.memberStatusesTable + " WHERE id =?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String string2 = Convert.trimR((String)resultSet.getString("status"));
                MemberStatus memberStatus = MemberStatus.persistanceCodeToEnum(string2);
                return memberStatus;
            }
            try {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Could not find member instance ID {0} in the member status file.", (Object[])new Object[]{l}));
            }
            catch (SQLException sQLException) {
                String string3 = MessageUtil.formatMsg((String)"SQL error while retrieving the status of member instance {0}.", (Object[])new Object[]{l});
                throw new ResourceUnavailableException(string3, (Throwable)sQLException);
            }
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public Set<MemberStatus> getMemberStatuses(long l) throws ResourceUnavailableException {
        HashSet<MemberStatus> hashSet = new HashSet<MemberStatus>();
        String string = "SELECT DISTINCT CASE WHEN failed_member_action = 1 AND status = 'F' THEN 'C' ELSE COALESCE(status, '') END AS status FROM " + this.memberStatusesTable + " WHERE suite_instance_id =?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2 = Convert.trimR((String)resultSet.getString("status"));
                hashSet.add(MemberStatus.persistanceCodeToEnum(string2));
            }
        }
        catch (SQLException sQLException) {
            String string3 = MessageUtil.formatMsg((String)"SQL error while retrieving the member statuses for job suite {0}.", (Object[])new Object[]{""});
            throw new ResourceUnavailableException(string3, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return hashSet;
    }

    @Override
    public Set<JobStatusCode> getMemberStatusesFromHistory(long l) throws ResourceUnavailableException {
        HashSet<JobStatusCode> hashSet = new HashSet<JobStatusCode>();
        String string = this.suiteHistoryTable;
        String string2 = "SELECT DISTINCT job_status FROM " + string + " WHERE job_suite_member_instance_id =? AND job_status <> ?" + " and restart_child_history_id = 0";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string2);
        try {
            preparedStatement.setLong(1, l);
            preparedStatement.setString(2, JobStatusCode.COMPLETED.persistanceCode());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string3 = Convert.trimR((String)resultSet.getString("job_status"));
                hashSet.add(JobStatusCode.persistanceCodeToEnum(string3));
            }
        }
        catch (SQLException sQLException) {
            String string4 = MessageUtil.formatMsg((String)"SQL error while retrieving the member statuses from history for suite member {0}.", (Object[])new Object[]{""});
            throw new ResourceUnavailableException(string4, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return hashSet;
    }

    @Override
    public List<PrereqMemberIDAndType> getPrerequisiteMemberIDsAndTypes(long l) throws ResourceUnavailableException {
        ArrayList<PrereqMemberIDAndType> arrayList = new ArrayList<PrereqMemberIDAndType>();
        String string = "SELECT prereq_member_id, dependency_type FROM " + this.instanceDependenciesTable + " WHERE dependent_member_id =?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                long l2 = resultSet.getLong("prereq_member_id");
                MemberDependencyType memberDependencyType = MemberDependencyType.persistanceCodeToEnum(resultSet.getInt("dependency_type"));
                arrayList.add(new PrereqMemberIDAndType(l2, memberDependencyType));
            }
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the members that have member instance {0} as a dependent.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return arrayList;
    }

    @Override
    public JobEndedReasonCode getSuiteEndedReasonCode(long l) throws ResourceUnavailableException {
        String string = "SELECT ended_reason_code FROM " + this.suiteHistoryTable + " WHERE id =?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            String string2;
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                string2 = Convert.trimR((String)resultSet.getString("ended_reason_code"));
                if (string2 == null) {
                    JobEndedReasonCode jobEndedReasonCode = null;
                    return jobEndedReasonCode;
                }
                JobEndedReasonCode jobEndedReasonCode = JobEndedReasonCode.persistanceCodeToEnum(string2);
                return jobEndedReasonCode;
            }
            try {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Could not find suite ID {0} in the history file.", (Object[])new Object[]{l}));
            }
            catch (SQLException sQLException) {
                string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the end reason code of the job suite with run number {0}.", (Object[])new Object[]{l});
                throw new ResourceUnavailableException(string2, (Throwable)sQLException);
            }
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public JobHistory getSuiteHistory(long l) throws DataException, ResourceUnavailableException {
        JobHistory jobHistory = new JobHistory();
        jobHistory.setId(l);
        jobHistory = (JobHistory)((Object)super.get((Object)jobHistory));
        if (jobHistory == null) {
            throw new NoDataException(MessageUtil.formatMsg((String)"The Job History for job suite run number {0} was not found.", (Object[])new Object[]{l}));
        }
        return jobHistory;
    }

    @Override
    public long getSuiteIDFromHistory(long l) throws ResourceUnavailableException {
        String string = "SELECT job_id FROM " + this.suiteHistoryTable + " WHERE id =?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                long l2 = resultSet.getLong("job_id");
                return l2;
            }
            try {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Could not find suite run ID {0} in the history file.", (Object[])new Object[]{l}));
            }
            catch (SQLException sQLException) {
                String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the ID of job suite run {0} from history.", (Object[])new Object[]{l});
                throw new ResourceUnavailableException(string2, (Throwable)sQLException);
            }
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public String getSuiteNameFromHistory(long l) throws ResourceUnavailableException {
        String string = "SELECT job_name FROM " + this.suiteHistoryTable + " WHERE id =?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String string2 = Convert.trimR((String)resultSet.getString("job_name"));
                return string2;
            }
            try {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Could not find suite ID {0} in the history file.", (Object[])new Object[]{l}));
            }
            catch (SQLException sQLException) {
                String string3 = MessageUtil.formatMsg((String)"SQL error while retrieving the name of job suite {0} from history.", (Object[])new Object[]{l});
                throw new ResourceUnavailableException(string3, (Throwable)sQLException);
            }
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public JobSuiteStatus getSuiteStatus(long l) throws ResourceUnavailableException {
        String string = "SELECT job_status FROM " + this.suiteHistoryTable + " WHERE id =?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String string2 = Convert.trimR((String)resultSet.getString("job_status"));
                JobSuiteStatus jobSuiteStatus = JobSuiteStatus.persistanceCodeToEnum(string2);
                return jobSuiteStatus;
            }
            try {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Could not find suite ID {0} in the history file.", (Object[])new Object[]{l}));
            }
            catch (SQLException sQLException) {
                String string3 = MessageUtil.formatMsg((String)"SQL error while retrieving the status of job suite {0}.", (Object[])new Object[]{""});
                throw new ResourceUnavailableException(string3, (Throwable)sQLException);
            }
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<JobSuiteInstanceMember> getInitialMembers(long l) throws ResourceUnavailableException {
        JobSuiteInstanceMemberGenerator jobSuiteInstanceMemberGenerator = new JobSuiteInstanceMemberGenerator();
        ArrayList<JobSuiteInstanceMember> arrayList = new ArrayList<JobSuiteInstanceMember>();
        String string = "SELECT job_id, job_type, name, target_id, target_type, job_queue_id, job_queue_name, default_priority, agent_environment_type, ms.id AS member_instance_id, suite_instance_id, job_suite_member_job_id, COALESCE(skip, 0) AS skip, skip_times, skipped_count, skip_until, skip_matched, ms.required_prereqs, ms.failed_member_action FROM (" + this.memberStatusesTable + " ms LEFT OUTER JOIN " + this.jobsTable + " j ON job_id = j.id) " + "LEFT OUTER JOIN " + this.memberJobsTable + " mj ON job_suite_member_job_id = mj.id " + "WHERE suite_instance_id =? AND ms.id NOT IN(" + "SELECT dependent_member_id FROM " + this.instanceDependenciesTable + " WHERE suite_instance_id =?)";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            preparedStatement.setLong(2, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                if (resultSet.getString("name") == null) {
                    throw new IllegalStateException(MessageUtil.formatMsg((String)"The job data (jobID {0}) associated with member instance {1} of suite run {2} is missing.", (Object[])new Object[]{resultSet.getLong("job_id"), resultSet.getLong("member_instance_id"), l}));
                }
                try {
                    JobSuiteInstanceMember jobSuiteInstanceMember = (JobSuiteInstanceMember)jobSuiteInstanceMemberGenerator.generateObject(resultSet);
                    arrayList.add(jobSuiteInstanceMember);
                }
                catch (BadDataException badDataException) {
                    throw new IllegalStateException(MessageUtil.formatMsg((String)"Member instance {0} of suite run {1} has corrupt data.", (Object[])new Object[]{resultSet.getLong("member_instance_id"), l}), badDataException);
                    return arrayList;
                }
            }
        }
        catch (SQLException sQLException) {
            throw new ResourceUnavailableException("SQL error while retrieving the initial members.", (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public long jobIdOfMemberJob(long l, Connection connection) throws NoDataException, ResourceUnavailableException {
        boolean bl;
        PreparedStatement preparedStatement;
        String string = "SELECT member_job_id FROM " + this.memberJobsTable + " WHERE id =?";
        if (connection != null) {
            preparedStatement = this.getDefaultPreparedStmt(string, connection);
            bl = true;
        } else {
            preparedStatement = this.getDefaultPreparedStmt(string);
            bl = false;
        }
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                long l2 = resultSet.getLong("member_job_id");
                return l2;
            }
            try {
                throw new NoDataException(MessageUtil.formatMsg((String)"Could not find the job ID associated with member job ID {0}.", (Object[])new Object[]{l}));
            }
            catch (Exception exception) {
                String string2 = MessageUtil.formatMsg((String)"Error while retrieving the job ID associated with member job ID {0}.", (Object[])new Object[]{l});
                throw new ResourceUnavailableException(string2, (Throwable)exception);
            }
        }
        finally {
            if (!bl) {
                this.closeConnection(preparedStatement);
            }
        }
    }

    @Override
    public void populateSuiteHistoryID(long l) throws NotSavedException, ResourceUnavailableException {
        String string = "UPDATE " + this.suiteHistoryTable + " SET job_suite_history_id=? WHERE id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            preparedStatement.setLong(2, l);
            int n = preparedStatement.executeUpdate();
            if (n < 1) {
                throw new NotSavedException(MessageUtil.formatMsg((String)"Suite history for run number {0} was not found.", (Object[])new Object[]{l}));
            }
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while populating the suite history ID for suite run number {0}.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public void removeEndedReasonCodeAndServerEndedTime(long l) throws ResourceUnavailableException {
        String string = "UPDATE " + this.suiteHistoryTable + " SET ended_reason_code=?, server_ended_time_utc=0 WHERE id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setNull(1, 12);
            preparedStatement.setLong(2, l);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while removing the ended reason code of the job suite with run number {0}.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public void updateMemberStatus(long l, MemberStatus memberStatus, long l2, long l3) throws NotSavedException, ResourceUnavailableException {
        String string = "UPDATE " + this.memberStatusesTable + " SET status=?, status_time_utc=?, job_history_id=? " + "WHERE id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setString(1, memberStatus.persistanceCode());
            preparedStatement.setLong(2, l2);
            preparedStatement.setLong(3, l3);
            preparedStatement.setLong(4, l);
            int n = preparedStatement.executeUpdate();
            if (n < 1) {
                throw new NotSavedException("");
            }
            if (n > 1) {
                String string2 = MessageUtil.formatMsg((String)"Program error: More than 1 suite member status was updated (ID = {0}.", (Object[])new Object[]{l});
                throw new RuntimeException(string2);
            }
        }
        catch (SQLException sQLException) {
            String string3 = MessageUtil.formatMsg((String)"SQL error while updating the suite member status for id {0}.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string3, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public void updateMemberStatusToInitiated(long l, long l2) throws NotSavedException, ResourceUnavailableException {
        String string = "UPDATE " + this.memberStatusesTable + " SET status=?, status_time_utc=? " + "WHERE id =? AND COALESCE(status, '') =?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setString(1, MemberStatus.INITIATED.persistanceCode());
            preparedStatement.setLong(2, l2);
            preparedStatement.setLong(3, l);
            preparedStatement.setString(4, MemberStatus.BLANK.persistanceCode());
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while changing the status of the member with instance ID {0} to {1}.", (Object[])new Object[]{l, MemberStatus.INITIATED});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public void updateMemberStatusToNull(long l) throws NotSavedException, ResourceUnavailableException {
        String string = "UPDATE " + this.memberStatusesTable + " SET status=?, status_time_utc=? " + "WHERE id =? AND COALESCE(status, '') =?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setString(1, null);
            preparedStatement.setLong(2, 0L);
            preparedStatement.setLong(3, l);
            preparedStatement.setString(4, MemberStatus.WILL_NOT_RUN.persistanceCode());
            int n = preparedStatement.executeUpdate();
            if (n < 1) {
                throw new NotSavedException(MessageUtil.formatMsg((String)"The status of the member with instance ID {0} was not updated to null. Note: The current status of the member must be {1} for this update to occur.", (Object[])new Object[]{l, MemberStatus.WILL_NOT_RUN}));
            }
            if (n > 1) {
                throw new RuntimeException(MessageUtil.formatMsg((String)"Program error: More than 1 suite member status was updated (ID = {0}.", (Object[])new Object[]{l}));
            }
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while changing the status of the member with instance ID {0} to null.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public void updateMemberStatusToWillNotRun(long l, long l2) throws NotSavedException, ResourceUnavailableException {
        String string = "UPDATE " + this.memberStatusesTable + " SET status=?, status_time_utc=? " + "WHERE id =? AND COALESCE(status, '') =?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setString(1, MemberStatus.WILL_NOT_RUN.persistanceCode());
            preparedStatement.setLong(2, l2);
            preparedStatement.setLong(3, l);
            preparedStatement.setString(4, MemberStatus.BLANK.persistanceCode());
            int n = preparedStatement.executeUpdate();
            if (n < 1) {
                throw new NotSavedException(MessageUtil.formatMsg((String)"The status of the member with instance ID {0} was not updated to {1}. Note: The current status of the member must be {2} for this update to occur.", (Object[])new Object[]{l, MemberStatus.WILL_NOT_RUN, MemberStatus.BLANK}));
            }
            if (n > 1) {
                throw new RuntimeException(MessageUtil.formatMsg((String)"Program error: More than 1 suite member status was updated (ID = {0}.", (Object[])new Object[]{l}));
            }
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while changing the status of the member with instance ID {0} to {1}.", (Object[])new Object[]{l, MemberStatus.WILL_NOT_RUN});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public long updateSuiteStatus(long l, JobSuiteStatus jobSuiteStatus, boolean bl) throws NotSavedException, ResourceUnavailableException {
        String string;
        boolean bl2;
        switch (jobSuiteStatus) {
            case RUNNING: {
                boolean bl3 = bl2 = !bl;
                if (bl2) {
                    string = "UPDATE " + this.suiteHistoryTable + " SET job_status=?, server_running_time_utc=? WHERE id=?";
                    break;
                }
                string = "UPDATE " + this.suiteHistoryTable + " SET job_status=? WHERE id=?";
                break;
            }
            case COMPLETED: 
            case FAILED: 
            case CANCELED: {
                string = "UPDATE " + this.suiteHistoryTable + " SET job_status=?, server_ended_time_utc=? WHERE id=?";
                bl2 = true;
                break;
            }
            default: {
                string = "UPDATE " + this.suiteHistoryTable + " SET job_status=? WHERE id=?";
                bl2 = false;
            }
        }
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            long l2 = 0L;
            preparedStatement.setString(1, jobSuiteStatus.persistanceCode());
            if (bl2) {
                l2 = System.currentTimeMillis();
                preparedStatement.setLong(2, l2);
                preparedStatement.setLong(3, l);
            } else {
                preparedStatement.setLong(2, l);
            }
            int n = preparedStatement.executeUpdate();
            if (n < 1) {
                throw new NotSavedException("");
            }
            if (n > 1) {
                String string2 = MessageUtil.formatMsg((String)"Program error: More than 1 job suite status was updated (ID = {0}.", (Object[])new Object[]{l});
                throw new RuntimeException(string2);
            }
            long l3 = l2;
            return l3;
        }
        catch (SQLException sQLException) {
            String string3 = MessageUtil.formatMsg((String)"SQL error while updating the job suite status for id {0}.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string3, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public void updateSuiteStatus(long l, JobSuiteStatus jobSuiteStatus, JobEndedReasonCode jobEndedReasonCode, long l2) throws NotSavedException, ResourceUnavailableException {
        String string = "UPDATE " + this.suiteHistoryTable + " SET job_status=?, ended_reason_code=?, server_ended_time_utc=? WHERE id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setString(1, jobSuiteStatus.persistanceCode());
            preparedStatement.setString(2, jobEndedReasonCode.persistanceCode());
            preparedStatement.setLong(3, l2);
            preparedStatement.setLong(4, l);
            int n = preparedStatement.executeUpdate();
            if (n < 1) {
                throw new NotSavedException("");
            }
            if (n > 1) {
                String string2 = MessageUtil.formatMsg((String)"Program error: More than 1 job suite status was updated (ID = {0}.", (Object[])new Object[]{l});
                throw new RuntimeException(string2);
            }
        }
        catch (SQLException sQLException) {
            String string3 = MessageUtil.formatMsg((String)"SQL error while updating the job suite status for id {0}.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string3, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    private void createInstanceDependencyRecord(PreparedStatement preparedStatement, long l, long l2, long l3, int n) throws ResourceUnavailableException, NotSavedException {
        try {
            preparedStatement.setLong(1, l);
            preparedStatement.setLong(2, l2);
            preparedStatement.setLong(3, l3);
            preparedStatement.setInt(4, n);
            int n2 = preparedStatement.executeUpdate();
            if (n2 < 1) {
                throw new NotSavedException(MessageUtil.formatMsg((String)"Unable to create an instance dependency record for instance dependent member id {0}, for Job Suite Instance {1}.", (Object[])new Object[]{l2, l}));
            }
        }
        catch (SQLException sQLException) {
            String string = MessageUtil.formatMsg((String)"SQL error while creating an instance dependency record for Job Suite Instance {0}.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string, (Throwable)sQLException);
        }
    }

    private long createMemberStatusRecord(PreparedStatement preparedStatement, long l, long l2, long l3, int n, int n2) throws ResourceUnavailableException, NotSavedException {
        try {
            preparedStatement.setLong(1, l);
            preparedStatement.setLong(2, l2);
            preparedStatement.setLong(3, l3);
            preparedStatement.setInt(4, n);
            preparedStatement.setInt(5, n2);
            int n3 = preparedStatement.executeUpdate();
            if (n3 < 1) {
                throw new NotSavedException(MessageUtil.formatMsg((String)"Unable to create a member status record for job {0}, for Job Suite Instance {1}.", (Object[])new Object[]{l2, l}));
            }
        }
        catch (SQLException sQLException) {
            String string = MessageUtil.formatMsg((String)"SQL error while creating a member status record for job {0}, for Job Suite Instance {1}.", (Object[])new Object[]{l2, l});
            throw new ResourceUnavailableException(string, (Throwable)sQLException);
        }
        return this.retrieveGeneratedKey(preparedStatement);
    }

    private String getSuiteName(long l) {
        try {
            return this.scheduleJobDM.getScheduleJobProxy(l).getName();
        }
        catch (Exception exception) {
            logger.warn((Object)MessageUtil.formatMsg((String)"Error retrieving Job Suite Name. Defaulting to Suite Number - {0}.", (Object[])new Object[]{l}), (Throwable)exception);
            return String.valueOf(l);
        }
    }

    @Override
    public void updateSuiteMemberSkipCount(long l, int n) throws ResourceUnavailableException {
        String string = "UPDATE " + this.memberJobsTable + " SET skipped_count=? where id=? and skip=?";
        logger.debug((Object)("########## Updating suite member count for suite member with OID " + l + " to count " + n));
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setInt(1, n);
            preparedStatement.setLong(2, l);
            preparedStatement.setInt(3, JobSuiteMemberSkipFlag.SKIP_X_TIMES.persistanceCode());
            long l2 = preparedStatement.executeUpdate();
            if (l2 > 1L) {
                logger.debug((Object)("More than one suite member was update with new skip count for ID: " + l));
            }
            if (l2 == 0L) {
                logger.debug((Object)("No record was updated with new skip count for ID: " + l));
            }
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while updating the job suite member skip count for member ID {0}.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public void releaseSkippedSuiteMember(long l) throws ResourceUnavailableException {
        String string = "UPDATE " + this.memberJobsTable + " SET skip=?, skipped_count=0, skip_times=0, skip_until=NULL where id=?";
        logger.debug((Object)("########### Resetting suite member skip settings for suite member with OID " + l));
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setInt(1, JobSuiteMemberSkipFlag.NOT_SKIPPED.persistanceCode());
            preparedStatement.setLong(2, l);
            long l2 = preparedStatement.executeUpdate();
            if (l2 > 1L) {
                logger.debug((Object)("More than one suite member was updated to release skip settings for ID: " + l));
            }
            if (l2 == 0L) {
                logger.debug((Object)("No record was updated release skip settings for ID: " + l));
            }
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while updating the job suite member to release skip settings for member ID {0}.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public JobSuiteMemberJobSkipSpecialInstance[] getSuiteMemberSpecialInstancesToSkip(long l) throws ResourceUnavailableException {
        String string = "SELECT * FROM skip_instances WHERE job_suite_member_job_id =?";
        ArrayList<Object> arrayList = new ArrayList<Object>();
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            Object object;
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object = new JobSuiteMemberJobSkipSpecialInstance();
                ((JobSuiteMemberJobSkipSpecialInstance)object).setOid(resultSet.getLong("id"));
                ((JobSuiteMemberJobSkipSpecialInstance)object).setJobMemberID(l);
                ((JobSuiteMemberJobSkipSpecialInstance)object).setSpecialInstanceID(resultSet.getLong("special_instance_id"));
                arrayList.add(object);
            }
            object = new JobSuiteMemberJobSkipSpecialInstance[]{};
            JobSuiteMemberJobSkipSpecialInstance[] jobSuiteMemberJobSkipSpecialInstanceArray = arrayList.toArray((T[])object);
            return jobSuiteMemberJobSkipSpecialInstanceArray;
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the job suite member special instances to skip for member ID {0}.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public JobSuiteMemberJobDependencies[] getJobSuiteMemberJobDependencies(long l) throws ResourceUnavailableException {
        String string = "Select jsd.id id, jsd.dependent_member_id dependent_member_id,jsd.prereq_member_id prereq_member_id, jsd.dependency_type dependency_type from job_suite_member_jobs jsmj inner join job_suite_dependencies jsd on jsd.dependent_member_id = jsmj.id where jsmj.job_suite_id =?";
        ArrayList<Object> arrayList = new ArrayList<Object>();
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            Object object;
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                object = new JobSuiteMemberJobDependencies();
                ((JobSuiteMemberJobDependencies)object).setOid(resultSet.getLong("id"));
                ((JobSuiteMemberJobDependencies)object).setDependentMemberId(resultSet.getLong("dependent_member_id"));
                ((JobSuiteMemberJobDependencies)object).setPrereqMemberId(resultSet.getLong("prereq_member_id"));
                ((JobSuiteMemberJobDependencies)object).setDependencyType(resultSet.getInt("dependency_type"));
                arrayList.add(object);
            }
            object = new JobSuiteMemberJobDependencies[]{};
            JobSuiteMemberJobDependencies[] jobSuiteMemberJobDependenciesArray = arrayList.toArray((T[])object);
            return jobSuiteMemberJobDependenciesArray;
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the job suite dependencies for suite ID {0}.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    private class JobSuiteInstanceMemberGenerator
    extends AbstractBusObjGenerator {
        public JobSuiteInstanceMemberGenerator() {
            super(18, "Job Suite Instance Member");
        }

        protected Object constructObject() {
            return new JobSuiteInstanceMember();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            ValidationHelper.checkForNull((String)"Object", (Object)object);
            JobSuiteInstanceMember jobSuiteInstanceMember = (JobSuiteInstanceMember)object;
            block0 : switch (n) {
                case 1: {
                    jobSuiteInstanceMember.setJobID(resultSet.getLong("job_id"));
                    break;
                }
                case 2: {
                    jobSuiteInstanceMember.setName(Convert.trimR((String)resultSet.getString("name")));
                    break;
                }
                case 3: {
                    jobSuiteInstanceMember.setSuiteInstanceID(resultSet.getLong("suite_instance_id"));
                    break;
                }
                case 4: {
                    jobSuiteInstanceMember.setMemberInstanceID(resultSet.getLong("member_instance_id"));
                    break;
                }
                case 5: {
                    JobType jobType = JobType.persistanceCodeToEnum(resultSet.getInt("job_type"));
                    switch (jobType) {
                        case SUITE_MEMBER: {
                            jobSuiteInstanceMember.setMemberType(JobSuiteMember.MemberType.JOB);
                            break block0;
                        }
                        case SUITE: {
                            jobSuiteInstanceMember.setMemberType(JobSuiteMember.MemberType.SUITE);
                            break block0;
                        }
                    }
                    throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Job Type {0} is not supported by this method.", (Object[])new Object[]{jobType}));
                }
                case 6: {
                    switch (jobSuiteInstanceMember.getMemberType()) {
                        case JOB: {
                            jobSuiteInstanceMember.setTargetID(resultSet.getLong("target_id"));
                            ScheduleInfo.TargetType targetType = ScheduleInfo.TargetType.persistanceCodeToEnum(resultSet.getString("target_type"));
                            jobSuiteInstanceMember.setTargetType(targetType);
                            break block0;
                        }
                        case SUITE: {
                            break block0;
                        }
                    }
                    throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Member Type {0} is not supported by this method.", (Object[])new Object[]{jobSuiteInstanceMember.getMemberType()}));
                }
                case 7: {
                    jobSuiteInstanceMember.setMemberID(resultSet.getLong("job_suite_member_job_id"));
                    break;
                }
                case 8: {
                    int n2 = resultSet.getInt("skip");
                    jobSuiteInstanceMember.setSkipFlag(JobSuiteMemberSkipFlag.persistanceCodeToEnum(n2));
                    break;
                }
                case 9: {
                    jobSuiteInstanceMember.setSkipTimes(resultSet.getInt("skip_times"));
                    break;
                }
                case 10: {
                    jobSuiteInstanceMember.setSkipCount(resultSet.getInt("skipped_count"));
                    break;
                }
                case 11: {
                    Calendar calendar = (Calendar)JobSuiteDMJdbc.this.cloneOnly_GMTCalendar.clone();
                    Timestamp timestamp = resultSet.getTimestamp("skip_until", calendar);
                    if (timestamp == null) break;
                    jobSuiteInstanceMember.setSkipUntil(timestamp.getTime());
                    break;
                }
                case 12: {
                    jobSuiteInstanceMember.setPriority(resultSet.getInt("default_priority"));
                    break;
                }
                case 13: {
                    jobSuiteInstanceMember.setSkipMatched(resultSet.getBoolean("skip_matched"));
                    break;
                }
                case 14: {
                    jobSuiteInstanceMember.setAgentEnvironmentType(resultSet.getString("agent_environment_type"));
                    break;
                }
                case 15: {
                    jobSuiteInstanceMember.setRequiredPrereqs(resultSet.getInt("required_prereqs"));
                    break;
                }
                case 16: {
                    jobSuiteInstanceMember.setFailedMemberAction(resultSet.getInt("failed_member_action"));
                    break;
                }
                case 17: {
                    jobSuiteInstanceMember.setJobQueueID(resultSet.getLong("job_queue_id"));
                    break;
                }
                case 18: {
                    jobSuiteInstanceMember.setJobQueueName(resultSet.getString("job_queue_name"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }
}

