/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.sap;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.sap.SAPParameterSign;
import com.helpsystems.enterprise.core.busobj.sap.SAPVariantAction;
import com.helpsystems.enterprise.core.busobj.sap.SAPVariantActionList;
import com.helpsystems.enterprise.core.dm.sap.SAPVariantActionsDM;
import java.security.InvalidParameterException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SAPVariantActionsDMJdbc
extends AbstractHelpingDatabaseManager
implements SAPVariantActionsDM {
    private static final String objDesc = "SAP Variant Action List";
    private static final String SAP_VARIANT_ACTIONS_TABLE = "sap_variant_actions";
    private static final String SAP_VARIANT_ACTION_PARAMETERS_TABLE = "sap_variant_action_parameters";
    private String sapVariantActionsTable;
    private String sapVariantActionParametersTable;

    public SAPVariantActionsDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper) {
        super(string, string2, sQLManagerHelper);
        this.setName("ENTERPRISE.SAPVariantActionsDM");
        this.sapVariantActionsTable = string2 + "." + SAP_VARIANT_ACTIONS_TABLE;
        this.sapVariantActionParametersTable = string2 + "." + SAP_VARIANT_ACTION_PARAMETERS_TABLE;
    }

    @Override
    public SAPVariantActionList getViaCommandID(long l) throws NoDataException, BadDataException, ResourceUnavailableException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        AbstractDatabaseManager.WrappedConnection wrappedConnection;
        block6: {
            SAPVariantActionList sAPVariantActionList;
            String string = "SELECT id, sap_system_environment_id, program, variant FROM " + this.sapVariantActionsTable + " WHERE command_id=?";
            SAPVariantActionListGenerator sAPVariantActionListGenerator = new SAPVariantActionListGenerator(4);
            wrappedConnection = super.getConnectionOrFail();
            preparedStatement = null;
            resultSet = null;
            preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) break block6;
            SAPVariantActionList sAPVariantActionList2 = sAPVariantActionList = (SAPVariantActionList)sAPVariantActionListGenerator.generateObject(resultSet);
            SAPVariantActionsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
            return sAPVariantActionList2;
        }
        try {
            try {
                throw new NoDataException("SAP Variant Action List not found.");
            }
            catch (SQLException sQLException) {
                String string = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for command_id {1}.", (Object[])new Object[]{objDesc, Long.toString(l)});
                throw new ResourceUnavailableException(string, (Throwable)sQLException);
            }
            catch (InvalidParameterException invalidParameterException) {
                throw new ResourceUnavailableException("Error creating SAP Variant Action List for command_id " + l, (Throwable)invalidParameterException);
            }
        }
        catch (Throwable throwable) {
            SAPVariantActionsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
            throw throwable;
        }
    }

    private void loadParametersForAction(long l, SAPVariantActionList sAPVariantActionList, Connection connection) throws SQLException, ResourceUnavailableException {
        block9: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block8: {
                String string = "SELECT parameter_name, parameter_type, parameter_sign, parameter_option, parameter_low_value, parameter_high_value FROM " + this.sapVariantActionParametersTable + " WHERE sap_variant_action_id=? ORDER BY line_number";
                Connection connection2 = connection;
                preparedStatement = null;
                resultSet = null;
                if (connection2 == null) {
                    connection2 = super.getConnectionOrFail();
                }
                try {
                    preparedStatement = this.getDefaultPreparedStmt(string, connection2);
                    preparedStatement.setLong(1, l);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        SAPVariantAction sAPVariantAction = new SAPVariantAction(sAPVariantActionList);
                        sAPVariantAction.setParameterName(resultSet.getString("parameter_name"));
                        sAPVariantAction.setParameterType(SAPVariantAction.SAPVariantParameterType.persistanceCodeToEnum(resultSet.getString("parameter_type")));
                        sAPVariantAction.setParameterSign(SAPParameterSign.persistanceCodeToEnum(resultSet.getString("parameter_sign")));
                        sAPVariantAction.setParameterOption(SAPVariantAction.SAPVariantParameterOption.persistanceCodeToEnum(resultSet.getString("parameter_option")));
                        sAPVariantAction.setParameterLowValue(resultSet.getString("parameter_low_value"));
                        sAPVariantAction.setParameterHighValue(resultSet.getString("parameter_high_value"));
                        sAPVariantActionList.addSAPVariantAction(sAPVariantAction);
                    }
                    if (connection != null) break block8;
                }
                catch (Exception exception) {
                    try {
                        String string2 = "Error while retrieving the SAP Variant Action Parameters.";
                        throw new RuntimeException(string2, exception);
                    }
                    catch (Throwable throwable) {
                        if (connection == null) {
                            SAPVariantActionsDMJdbc.closeEm((Connection)connection2, (Statement)preparedStatement, resultSet);
                        } else {
                            SAPVariantActionsDMJdbc.closeEm(null, (Statement)preparedStatement, resultSet);
                        }
                        throw throwable;
                    }
                }
                SAPVariantActionsDMJdbc.closeEm((Connection)connection2, (Statement)preparedStatement, (ResultSet)resultSet);
                break block9;
            }
            SAPVariantActionsDMJdbc.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
        }
    }

    private class SAPVariantActionListGenerator
    extends AbstractBusObjGenerator {
        public SAPVariantActionListGenerator(int n) {
            super(n, SAPVariantActionsDMJdbc.objDesc);
        }

        protected Object constructObject() {
            return new SAPVariantActionList();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            SAPVariantActionList sAPVariantActionList = (SAPVariantActionList)object;
            switch (n) {
                case 1: {
                    sAPVariantActionList.setSAPSystemEnvironmentID(resultSet.getInt("sap_system_environment_id"));
                    break;
                }
                case 2: {
                    sAPVariantActionList.setSapProgramName(resultSet.getString("program"));
                    break;
                }
                case 3: {
                    sAPVariantActionList.setSapVariant(resultSet.getString("variant"));
                    break;
                }
                case 4: {
                    long l = resultSet.getLong("id");
                    Connection connection = resultSet.getStatement().getConnection();
                    SAPVariantActionsDMJdbc.this.loadParametersForAction(l, sAPVariantActionList, connection);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }
}

