/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.sap;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.NotSavedException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.DateTranslator;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.sap.SAPInterceptedJob;
import com.helpsystems.enterprise.core.dm.sap.SAPInterceptedJobsDM;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class SAPInterceptedJobsDMJdbc
extends AbstractHelpingDatabaseManager
implements SAPInterceptedJobsDM {
    private static Logger logger = Logger.getLogger(SAPInterceptedJobsDMJdbc.class);
    private static final String objDesc = "SAP Intercepted Job";
    private static final String COMMON_SQL_SELECT = "SELECT id, sap_system_definition_id, job_owner_from_sap, job_name_from_sap, job_client_from_sap, job_count_from_sap, job_id, agent_id, job_history_id, planned_start_utc, scheduled_release_utc, status, skybot_job_name, skybot_agent_name";
    private static final String SAP_INTERCEPTED_JOBS_TABLE = "sap_intercepted_jobs";
    private String sapInterceptedJobsTable;

    public SAPInterceptedJobsDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper) {
        super(string, string2, sQLManagerHelper);
        this.setName("ENTERPRISE.SAPInterceptedJobsDM");
        this.sapInterceptedJobsTable = string2 + "." + SAP_INTERCEPTED_JOBS_TABLE;
    }

    @Override
    public SAPInterceptedJob getNextScheduledJob() throws ResourceUnavailableException, NoDataException {
        AbstractDatabaseManager.WrappedConnection wrappedConnection = super.getConnectionOrFail();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        SAPInterceptedJobGenerator sAPInterceptedJobGenerator = new SAPInterceptedJobGenerator();
        String string = "SELECT id, sap_system_definition_id, job_owner_from_sap, job_name_from_sap, job_client_from_sap, job_count_from_sap, job_id, agent_id, job_history_id, planned_start_utc, scheduled_release_utc, status, skybot_job_name, skybot_agent_name FROM " + this.sapInterceptedJobsTable + " WHERE job_id > 0 AND " + "job_history_id IS NULL AND " + "scheduled_release_utc IS NOT NULL AND " + "status = 1 " + "ORDER BY scheduled_release_utc ASC";
        preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
        try {
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                SAPInterceptedJob sAPInterceptedJob;
                SAPInterceptedJob sAPInterceptedJob2 = sAPInterceptedJob = (SAPInterceptedJob)sAPInterceptedJobGenerator.generateObject(resultSet);
                return sAPInterceptedJob2;
            }
            try {
                throw new NoDataException("SAP Intercepted Job not found.");
            }
            catch (SQLException sQLException) {
                String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the next scheduled {0} from the table {1}.", (Object[])new Object[]{objDesc, this.sapInterceptedJobsTable});
                throw new ResourceUnavailableException(string2, (Throwable)sQLException);
            }
            catch (BadDataException badDataException) {
                String string3 = MessageUtil.formatMsg((String)"Error while retrieving the next scheduled {0} from the table {1}.", (Object[])new Object[]{objDesc, this.sapInterceptedJobsTable});
                throw new ResourceUnavailableException(string3, (Throwable)badDataException);
            }
        }
        finally {
            SAPInterceptedJobsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
        }
    }

    @Override
    public ArrayList<SAPInterceptedJob> getForJobHistoryID(long l) throws NoDataException, BadDataException, ResourceUnavailableException {
        return this.getForJobHistoryID(l, false);
    }

    @Override
    public ArrayList<SAPInterceptedJob> getForJobHistoryIDOnRestart(long l) throws NoDataException, BadDataException, ResourceUnavailableException {
        return this.getForJobHistoryID(l, true);
    }

    private ArrayList<SAPInterceptedJob> getForJobHistoryID(long l, boolean bl) throws NoDataException, BadDataException, ResourceUnavailableException {
        ArrayList<SAPInterceptedJob> arrayList = new ArrayList<SAPInterceptedJob>();
        AbstractDatabaseManager.WrappedConnection wrappedConnection = super.getConnectionOrFail();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        SAPInterceptedJobGenerator sAPInterceptedJobGenerator = new SAPInterceptedJobGenerator();
        String string = "SELECT id, sap_system_definition_id, job_owner_from_sap, job_name_from_sap, job_client_from_sap, job_count_from_sap, job_id, agent_id, job_history_id, planned_start_utc, scheduled_release_utc, status, skybot_job_name, skybot_agent_name FROM " + this.sapInterceptedJobsTable + " WHERE job_history_id=?";
        if (bl) {
            string = string + " AND status = 2";
        }
        preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
        try {
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                SAPInterceptedJob sAPInterceptedJob = (SAPInterceptedJob)sAPInterceptedJobGenerator.generateObject(resultSet);
                arrayList.add(sAPInterceptedJob);
            }
        }
        catch (SQLException sQLException) {
            try {
                String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the {0}s for job history id {1}.", (Object[])new Object[]{objDesc, Long.toString(l)});
                throw new ResourceUnavailableException(string2, (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                SAPInterceptedJobsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
                throw throwable;
            }
        }
        SAPInterceptedJobsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
        return arrayList;
    }

    @Override
    public ArrayList<SAPInterceptedJob> getAllForJobID(long l) throws NoDataException, BadDataException, ResourceUnavailableException {
        ArrayList<SAPInterceptedJob> arrayList = new ArrayList<SAPInterceptedJob>();
        AbstractDatabaseManager.WrappedConnection wrappedConnection = super.getConnectionOrFail();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        SAPInterceptedJobGenerator sAPInterceptedJobGenerator = new SAPInterceptedJobGenerator();
        String string = "SELECT id, sap_system_definition_id, job_owner_from_sap, job_name_from_sap, job_client_from_sap, job_count_from_sap, job_id, agent_id, job_history_id, planned_start_utc, scheduled_release_utc, status, skybot_job_name, skybot_agent_name FROM " + this.sapInterceptedJobsTable + " WHERE job_id=? AND job_history_id IS NULL " + "ORDER BY scheduled_release_utc ASC";
        preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
        try {
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                SAPInterceptedJob sAPInterceptedJob = (SAPInterceptedJob)sAPInterceptedJobGenerator.generateObject(resultSet);
                arrayList.add(sAPInterceptedJob);
            }
        }
        catch (SQLException sQLException) {
            try {
                String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the {0}s for id {1}.", (Object[])new Object[]{objDesc, Long.toString(l)});
                throw new ResourceUnavailableException(string2, (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                SAPInterceptedJobsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
                throw throwable;
            }
        }
        SAPInterceptedJobsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
        return arrayList;
    }

    @Override
    public void update(SAPInterceptedJob sAPInterceptedJob) throws ResourceUnavailableException, DataException {
        AbstractDatabaseManager.WrappedConnection wrappedConnection = super.getConnectionOrFail();
        PreparedStatement preparedStatement = null;
        String string = "UPDATE " + this.sapInterceptedJobsTable + " SET job_id=?, agent_id=?, skybot_job_name=?, skybot_agent_name=?, " + "job_history_id=?, scheduled_release_utc=?, status=?, " + "updated_at=? WHERE id=?";
        preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
        Timestamp timestamp = new Timestamp(Calendar.getInstance().getTimeInMillis());
        try {
            preparedStatement.setLong(1, sAPInterceptedJob.getSkybotJobID());
            preparedStatement.setLong(2, sAPInterceptedJob.getSkybotAgentID());
            preparedStatement.setString(3, sAPInterceptedJob.getSkybotJobName());
            preparedStatement.setString(4, sAPInterceptedJob.getSkybotAgentName());
            if (sAPInterceptedJob.getSkybotJobHistoryID() > 0L) {
                preparedStatement.setLong(5, sAPInterceptedJob.getSkybotJobHistoryID());
            } else {
                preparedStatement.setNull(5, -5);
            }
            preparedStatement.setLong(6, sAPInterceptedJob.getSkybotScheduledReleaseMS());
            preparedStatement.setInt(7, sAPInterceptedJob.getStatus().persistanceCode());
            preparedStatement.setTimestamp(8, timestamp);
            preparedStatement.setLong(9, sAPInterceptedJob.getOID());
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            String string2 = "SQL Error updating SAP Intercepted Job " + sAPInterceptedJob.getNameAndCount();
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            SAPInterceptedJobsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        }
    }

    @Override
    public void update(ArrayList<SAPInterceptedJob> arrayList, long l, SAPInterceptedJob.InterceptedJobStatus interceptedJobStatus) throws ResourceUnavailableException, DataException {
        AbstractDatabaseManager.WrappedConnection wrappedConnection = super.getConnectionOrFail();
        String string = "UPDATE " + this.sapInterceptedJobsTable + " SET job_history_id=?, status=?, updated_at=? WHERE id=? AND status < 99";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
        Timestamp timestamp = new Timestamp(Calendar.getInstance().getTimeInMillis());
        Iterator<SAPInterceptedJob> iterator = arrayList.iterator();
        SAPInterceptedJob sAPInterceptedJob = null;
        try {
            while (iterator.hasNext()) {
                sAPInterceptedJob = iterator.next();
                preparedStatement.setLong(1, l);
                preparedStatement.setInt(2, interceptedJobStatus.persistanceCode());
                preparedStatement.setTimestamp(3, timestamp);
                preparedStatement.setLong(4, sAPInterceptedJob.getOID());
                preparedStatement.executeUpdate();
            }
        }
        catch (SQLException sQLException) {
            String string2 = "SQL Error updating SAP Intercepted Job " + sAPInterceptedJob.getNameAndCount() + " with eventID " + l;
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            SAPInterceptedJobsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        }
    }

    @Override
    public void update(ArrayList<Long> arrayList, SAPInterceptedJob.InterceptedJobStatus interceptedJobStatus) throws ResourceUnavailableException {
        AbstractDatabaseManager.WrappedConnection wrappedConnection = super.getConnectionOrFail();
        String string = "UPDATE " + this.sapInterceptedJobsTable + " SET status=?, updated_at=? WHERE id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
        Timestamp timestamp = new Timestamp(Calendar.getInstance().getTimeInMillis());
        Iterator<Long> iterator = arrayList.iterator();
        long l = 0L;
        try {
            while (iterator.hasNext()) {
                l = iterator.next();
                preparedStatement.setInt(1, interceptedJobStatus.persistanceCode());
                preparedStatement.setTimestamp(2, timestamp);
                preparedStatement.setLong(3, l);
                preparedStatement.executeUpdate();
            }
        }
        catch (SQLException sQLException) {
            String string2 = "SQL Error updating SAP Intercepted Job ID " + l + " with status " + interceptedJobStatus;
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            SAPInterceptedJobsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        }
    }

    @Override
    public void save(HashMap<String, SAPInterceptedJob> hashMap) throws ResourceUnavailableException, DataException {
        String string = "INSERT INTO " + this.sapInterceptedJobsTable + " (" + "sap_system_definition_id, job_owner_from_sap, job_name_from_sap, " + "job_client_from_sap, job_count_from_sap, " + "job_id, agent_id, skybot_job_name, skybot_agent_name, created_at, updated_at, " + "planned_start_utc, scheduled_release_utc, status) " + "VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        Timestamp timestamp = new Timestamp(Calendar.getInstance().getTimeInMillis());
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.getDefaultPreparedStmt(string);
            Collection<SAPInterceptedJob> collection = hashMap.values();
            for (SAPInterceptedJob sAPInterceptedJob : collection) {
                preparedStatement.setLong(1, sAPInterceptedJob.getSapSystemDefinitionID());
                preparedStatement.setString(2, sAPInterceptedJob.getJobOwner());
                preparedStatement.setString(3, sAPInterceptedJob.getJobName());
                preparedStatement.setString(4, sAPInterceptedJob.getClient());
                preparedStatement.setString(5, sAPInterceptedJob.getJobCount());
                preparedStatement.setLong(6, sAPInterceptedJob.getSkybotJobID());
                preparedStatement.setLong(7, sAPInterceptedJob.getSkybotAgentID());
                preparedStatement.setString(8, sAPInterceptedJob.getSkybotJobName());
                preparedStatement.setString(9, sAPInterceptedJob.getSkybotAgentName());
                preparedStatement.setTimestamp(10, timestamp);
                preparedStatement.setTimestamp(11, timestamp);
                preparedStatement.setLong(12, sAPInterceptedJob.getPlannedStartMS());
                if (sAPInterceptedJob.getSkybotScheduledReleaseMS() != 0L) {
                    preparedStatement.setLong(13, sAPInterceptedJob.getSkybotScheduledReleaseMS());
                } else {
                    preparedStatement.setNull(13, -5);
                }
                preparedStatement.setInt(14, sAPInterceptedJob.getStatus().persistanceCode());
                int n = preparedStatement.executeUpdate();
                if (n >= 1) continue;
                String string2 = MessageUtil.formatMsg((String)"Unable to add the SAP intercepted job {0}.", (Object[])new Object[]{sAPInterceptedJob.getNameAndCount()});
                throw new NotSavedException(string2);
            }
        }
        catch (SQLException sQLException) {
            throw new ResourceUnavailableException("Error saving SAPInterceptedJob. ", (Throwable)sQLException);
        }
        finally {
            super.closeConnection((Statement)preparedStatement);
        }
    }

    @Override
    public void delete(long l, String string, String string2) throws ResourceUnavailableException {
        AbstractDatabaseManager.WrappedConnection wrappedConnection = super.getConnectionOrFail();
        String string3 = "DELETE FROM " + this.sapInterceptedJobsTable + " WHERE sap_system_definition_id=? AND job_name_from_sap=? AND " + "job_count_from_sap=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string3, (Connection)wrappedConnection);
        try {
            preparedStatement.setLong(1, l);
            preparedStatement.setString(2, string);
            preparedStatement.setString(3, string2);
            int n = preparedStatement.executeUpdate();
            logger.trace((Object)("Deleted " + n + " job(s) from the Automate Schedule database."));
            if (n == 0) {
                logger.warn((Object)("SAP Intercepted Job " + string + "(" + string2 + ")" + " for SAP System Definition ID " + l + " was not deleted because it was not found in the Automate Schedule database."));
                return;
            }
        }
        catch (SQLException sQLException) {
            throw new ResourceUnavailableException("Error deleting intercepted job.", (Throwable)sQLException);
        }
        finally {
            SAPInterceptedJobsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        }
    }

    @Override
    public void purgeHistory(int n) throws ResourceUnavailableException, SQLException {
        String string = null;
        int n2 = 0;
        String string2 = RosettaMsg.PURGE_SAP_INTERCEPTED_JOB_HISTORY_NAME.newLogEntry().getMessageText();
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        try {
            long l = DateTranslator.getDaysOldAsMilliseconds((long)n);
            Date date = new Date(l);
            wrappedConnection = this.getConnection();
            String[] stringArray = new String[]{string2, String.valueOf(n)};
            ScheduleLogEntry scheduleLogEntry = RosettaMsg.PURGE_OLDER_THAN.newLogEntry(stringArray);
            logger.debug((Object)scheduleLogEntry.getMessageText());
            ScheduleLogger.write((Connection)wrappedConnection, scheduleLogEntry);
            String string3 = "DELETE FROM sap_intercepted_jobs WHERE ((planned_start_utc < ? AND status = 0) OR (scheduled_release_utc < ? AND status > 1))";
            preparedStatement = this.getDefaultPreparedStmt(string3, (Connection)wrappedConnection);
            preparedStatement.setLong(1, date.getTime());
            preparedStatement.setLong(2, date.getTime());
            n2 = preparedStatement.executeUpdate();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Purged " + n2 + " SAP intercepted job histories."));
            }
        }
        catch (SQLException sQLException) {
            try {
                String string4 = "Error while purging the SAP Intercepted Job History data.";
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)string4, (Throwable)sQLException);
                    logger.debug((Object)("SQL query: " + string));
                }
                throw new ResourceUnavailableException(string4, (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                SAPInterceptedJobsDMJdbc.closeEm(wrappedConnection, preparedStatement, null);
                throw throwable;
            }
        }
        SAPInterceptedJobsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        if (n2 > 0) {
            String[] stringArray = new String[]{String.valueOf(n2), string2};
            ScheduleLogEntry scheduleLogEntry = RosettaMsg.HISTORY_PURGE_COMPLETE.newLogEntry(stringArray);
            ScheduleLogger.write(scheduleLogEntry);
            logger.debug((Object)scheduleLogEntry.getMessageText());
        }
    }

    private class SAPInterceptedJobGenerator
    extends AbstractBusObjGenerator {
        public SAPInterceptedJobGenerator() {
            super(13, SAPInterceptedJobsDMJdbc.objDesc);
        }

        protected Object constructObject() {
            return new SAPInterceptedJob();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            SAPInterceptedJob sAPInterceptedJob = (SAPInterceptedJob)object;
            switch (n) {
                case 1: {
                    sAPInterceptedJob.setOID(resultSet.getLong("id"));
                    break;
                }
                case 2: {
                    sAPInterceptedJob.setSapSystemDefinitionID(resultSet.getLong("sap_system_definition_id"));
                    break;
                }
                case 3: {
                    sAPInterceptedJob.setJobOwner(resultSet.getString("job_owner_from_sap"));
                    break;
                }
                case 4: {
                    sAPInterceptedJob.setJobName(resultSet.getString("job_name_from_sap"));
                    break;
                }
                case 5: {
                    sAPInterceptedJob.setClient(resultSet.getString("job_client_from_sap"));
                    break;
                }
                case 6: {
                    sAPInterceptedJob.setJobCount(resultSet.getString("job_count_from_sap"));
                    break;
                }
                case 7: {
                    sAPInterceptedJob.setSkybotJobID(resultSet.getLong("job_id"));
                    break;
                }
                case 8: {
                    sAPInterceptedJob.setSkybotAgentID(resultSet.getLong("agent_id"));
                    break;
                }
                case 9: {
                    sAPInterceptedJob.setSkybotJobName(resultSet.getString("skybot_job_name"));
                    break;
                }
                case 10: {
                    sAPInterceptedJob.setSkybotAgentName(resultSet.getString("skybot_agent_name"));
                    break;
                }
                case 11: {
                    sAPInterceptedJob.setSkybotJobHistoryID(resultSet.getLong("job_history_id"));
                    break;
                }
                case 12: {
                    sAPInterceptedJob.setPlannedStartMS(resultSet.getLong("planned_start_utc"));
                    break;
                }
                case 13: {
                    sAPInterceptedJob.setSkybotScheduledReleaseMS(resultSet.getLong("scheduled_release_utc"));
                    break;
                }
                case 14: {
                    sAPInterceptedJob.setStatus(SAPInterceptedJob.InterceptedJobStatus.persistanceCodeToEnum(resultSet.getInt("status")));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }
}

