/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.logger;

import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.DataSet;
import com.helpsystems.common.core.access.DataSetException;
import com.helpsystems.common.core.access.ExistsAlreadyException;
import com.helpsystems.common.core.access.NotSavedException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.DateTranslator;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.logger.ScheduleLogDM;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class ScheduleLogDMImpl
extends AbstractHelpingDatabaseManager
implements ScheduleLogDM {
    private static final String TABLE_NAME = "schedule_logs";
    private static final Logger logger = Logger.getLogger(ScheduleLogDMImpl.class);

    public ScheduleLogDMImpl(String string, String string2, SQLManagerHelper sQLManagerHelper, String string3) {
        super(string, string3, sQLManagerHelper);
        ValidationHelper.checkForNull((String)"Manager Name", (Object)string2);
        this.setName(string2);
    }

    @Override
    public DataSet<ScheduleLogEntry> getDataSet() throws DataSetException, ResourceUnavailableException {
        try {
            ScheduleLogEntry scheduleLogEntry = new ScheduleLogEntry();
            return super.getDataSet((Object)scheduleLogEntry, null, null);
        }
        catch (SQLException sQLException) {
            throw new ResourceUnavailableException("Error loading Schedule Log Entry data set.", (Throwable)sQLException);
        }
    }

    @Override
    public void save(ScheduleLogEntry scheduleLogEntry) throws NotSavedException, ExistsAlreadyException, ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"Schedule Log Entry", (Object)scheduleLogEntry);
        this.insert(null, scheduleLogEntry);
    }

    @Override
    public void save(Connection connection, ScheduleLogEntry scheduleLogEntry) throws NotSavedException, ExistsAlreadyException, ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"Schedule Log Entry", (Object)scheduleLogEntry);
        this.insert(connection, scheduleLogEntry);
    }

    @Override
    public ScheduleLogEntry get(long l) throws DataException, ResourceUnavailableException {
        ScheduleLogEntry scheduleLogEntry = new ScheduleLogEntry();
        scheduleLogEntry.setId(l);
        return (ScheduleLogEntry)super.get((Object)scheduleLogEntry);
    }

    private void insert(Connection connection, ScheduleLogEntry scheduleLogEntry) throws NotSavedException, ExistsAlreadyException, ResourceUnavailableException {
        Connection connection2 = null;
        try {
            connection2 = connection == null ? super.getConnection() : connection;
            super.insert(connection2, (Object)scheduleLogEntry);
        }
        catch (Throwable throwable) {
            throw new NotSavedException("Schedule Log Entry was not saved.", throwable);
        }
        finally {
            if (connection == null) {
                ScheduleLogDMImpl.closeEm((Connection)connection2, null, null);
            }
        }
    }

    @Override
    public int purge(int n) throws ResourceUnavailableException {
        int n2;
        String string = RosettaMsg.PURGE_SCHEDULE_LOG_NAME.newLogEntry().getMessageText();
        String[] stringArray = new String[]{string, String.valueOf(n)};
        ScheduleLogEntry scheduleLogEntry = RosettaMsg.PURGE_OLDER_THAN.newLogEntry(stringArray);
        logger.debug((Object)scheduleLogEntry.getMessageText());
        ScheduleLogger.write(scheduleLogEntry);
        String string2 = "delete from " + this.library + "." + TABLE_NAME + " where timestamp_utc < ?";
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        try {
            wrappedConnection = super.getConnectionOrFail();
            preparedStatement = wrappedConnection.prepareStatement(string2);
            long l = DateTranslator.getDaysOldAsMilliseconds((long)n);
            preparedStatement.setLong(1, l);
            int n3 = preparedStatement.executeUpdate();
            if (n3 > 0) {
                Date date = new Date(l);
                String[] stringArray2 = new String[]{String.valueOf(n3), string, ScheduleLogger.formatTimeStamp(date)};
                ScheduleLogEntry scheduleLogEntry2 = RosettaMsg.PURGE_COMPLETE.newLogEntry(stringArray2);
                logger.debug((Object)scheduleLogEntry2.getMessageText());
                ScheduleLogger.write(scheduleLogEntry2);
            }
            n2 = n3;
        }
        catch (SQLException sQLException) {
            try {
                throw new ResourceUnavailableException("Error purging Schedule Log Entries.", (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                ScheduleLogDMImpl.closeEm((Connection)wrappedConnection, preparedStatement, null);
                throw throwable;
            }
        }
        ScheduleLogDMImpl.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        return n2;
    }
}

