/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.jdbc;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.core.busobj.UserFile;
import com.helpsystems.enterprise.core.dm.UserFileDM;
import com.helpsystems.enterprise.core.enums.FileTypeEnum;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class UserFileDMJdbc
extends AbstractHelpingDatabaseManager
implements UserFileDM {
    private static final Logger logger = Logger.getLogger(UserFileDMJdbc.class);
    private static final String TABLE_NAME = "user_files";
    private static final String objDesc = "UserFile";

    public UserFileDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper) {
        super(string, string2, sQLManagerHelper);
        this.setName("ENTERPRISE.UserFileDM");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public UserFile save(UserFile userFile) throws ResourceUnavailableException, DataException {
        UserFile userFile2 = null;
        if (userFile != null) {
            userFile.setCopiedToServerTimeUTC(System.currentTimeMillis());
            AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
            try {
                wrappedConnection = this.getConnection();
                userFile2 = (UserFile)((Object)super.save((Connection)wrappedConnection, (Object)userFile));
                return userFile2;
            }
            catch (SQLException sQLException) {
                if (!logger.isDebugEnabled()) return userFile2;
                logger.debug((Object)"Error saving userFile", (Throwable)sQLException);
                return userFile2;
            }
            finally {
                UserFileDMJdbc.closeEm((Connection)wrappedConnection, null, null);
            }
        } else {
            logger.error((Object)"UserFile object is not saved in db as it is null");
        }
        return userFile2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<UserFile> getHangedFileList(long l) {
        ArrayList<UserFile> arrayList = new ArrayList<UserFile>();
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        UserFileGenerator userFileGenerator = new UserFileGenerator();
        try {
            wrappedConnection = this.getConnection();
            preparedStatement = wrappedConnection.prepareStatement("SELECT *  FROM user_files WHERE copied_server_time_utc <=? AND status IN(?,?)");
            preparedStatement.setLong(1, l);
            preparedStatement.setInt(2, 1);
            preparedStatement.setInt(3, 4);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                UserFile userFile = (UserFile)((Object)userFileGenerator.generateObject(resultSet));
                arrayList.add(userFile);
            }
        }
        catch (Exception exception) {
            block5: {
                try {
                    if (!logger.isDebugEnabled()) break block5;
                    logger.debug((Object)"Error getting hanged files from db.", (Throwable)exception);
                }
                catch (Throwable throwable) {
                    UserFileDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, null);
                    throw throwable;
                }
            }
            UserFileDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        }
        UserFileDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makeFileFailed(UserFile userFile, int n, String string) {
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        try {
            wrappedConnection = this.getConnection();
            preparedStatement = wrappedConnection.prepareStatement("UPDATE user_files SET status=?,file_type=?,file_size=?,file_name=?,stored_location=? WHERE id=?");
            preparedStatement.setInt(1, 3);
            preparedStatement.setString(2, FileTypeEnum.LOG.getValue());
            preparedStatement.setInt(3, n);
            preparedStatement.setString(4, string);
            preparedStatement.setString(5, userFile.getStoredLocation());
            preparedStatement.setLong(6, userFile.getOid());
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            block4: {
                try {
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug((Object)"Error updating the user file's status.", (Throwable)exception);
                }
                catch (Throwable throwable) {
                    UserFileDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, null);
                    throw throwable;
                }
            }
            UserFileDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        }
        UserFileDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
    }

    @Override
    public int delete(UserFile userFile) throws ResourceUnavailableException, DataException {
        return super.delete((Object)userFile);
    }

    @Override
    public UserFile get(long l) throws ResourceUnavailableException, DataException {
        return this.get(l, null);
    }

    public UserFile get(long l, Connection connection) throws DataException, ResourceUnavailableException {
        UserFile userFile = new UserFile();
        userFile.setOid(l);
        userFile = connection != null ? (UserFile)((Object)super.get(connection, (Object)userFile)) : (UserFile)((Object)super.get((Object)userFile));
        if (userFile == null) {
            throw new NoDataException("The User File for oid " + l + " was not found.");
        }
        return userFile;
    }

    private class UserFileGenerator
    extends AbstractBusObjGenerator {
        public UserFileGenerator() {
            super(8, UserFileDMJdbc.objDesc);
        }

        protected Object constructObject() {
            return new UserFile();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            UserFile userFile = (UserFile)((Object)object);
            switch (n) {
                case 1: {
                    userFile.setOid(resultSet.getLong("id"));
                    break;
                }
                case 2: {
                    userFile.setFileName(resultSet.getString("file_name"));
                    break;
                }
                case 3: {
                    userFile.setStatus(resultSet.getInt("status"));
                    break;
                }
                case 4: {
                    userFile.setStoredLocation(resultSet.getString("stored_location"));
                    break;
                }
                case 5: {
                    userFile.setCopiedToServerTimeUTC(resultSet.getLong("copied_server_time_utc"));
                    break;
                }
                case 6: {
                    userFile.setFileSize(resultSet.getLong("file_size"));
                    break;
                }
                case 7: {
                    userFile.setFileType(resultSet.getString("file_type"));
                    break;
                }
                case 8: {
                    userFile.setUserId(resultSet.getLong("user_id"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }
}

