/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.jdbc;

import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.core.busobj.User;
import com.helpsystems.enterprise.core.dm.UserDM;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class UserDMJdbc
extends AbstractHelpingDatabaseManager
implements UserDM {
    private static final Logger logger = Logger.getLogger(UserDMJdbc.class);
    private static final String TABLE_USERS = "users";

    public UserDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper) throws ResourceUnavailableException {
        super(string, string2, sQLManagerHelper);
        this.setName("ENTERPRISE.UserDM");
    }

    @Override
    public User get(long l) throws DataException, ResourceUnavailableException {
        return this.get(l, null);
    }

    @Override
    public User get(long l, Connection connection) throws DataException, ResourceUnavailableException {
        User user = new User();
        user.setID(l);
        user = connection != null ? (User)((Object)super.get(connection, (Object)user)) : (User)((Object)super.get((Object)user));
        if (user == null) {
            throw new NoDataException("The requested User was not found.");
        }
        return user;
    }

    @Override
    public User[] getNotifyUsers() throws DataException, ResourceUnavailableException {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put("getNotifyOfSystemEvents", Boolean.TRUE);
        User[] userArray = (User[])super.search((Object)new User(), hashMap);
        return userArray;
    }

    @Override
    public User getUserByNameOrAdmin(String string) throws DataException, ResourceUnavailableException, SQLException {
        User user = null;
        String string2 = null;
        if (string != null && (string2 = string.trim()).length() > 0) {
            user = this.getUserByName(string2);
        }
        if (user == null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (string2 != null && string2.length() > 0) {
                logger.debug((Object)("Unable to find the requested user: " + string + ".  Looking for Admin."));
            }
            hashMap.put("getUsername", "admin");
            User[] userArray = (User[])super.search((Object)new User(), hashMap);
            if (userArray != null && userArray.length > 0) {
                user = userArray[0];
            }
        }
        return user;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public User getUserByName(String string) throws ResourceUnavailableException, SQLException, DataException {
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        User user = null;
        if (string == null) return null;
        if (string.trim().length() == 0) {
            return null;
        }
        try {
            String string2 = "SELECT id FROM users WHERE lower(username) = ?";
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Running Query: " + string2));
            }
            wrappedConnection = this.getConnectionOrFail();
            preparedStatement = wrappedConnection.prepareStatement(string2);
            preparedStatement.setString(1, string.toLowerCase());
            resultSet = preparedStatement.executeQuery();
            Long l = null;
            if (resultSet.next()) {
                l = resultSet.getLong("id");
            }
            if (l != null) {
                user = this.get(l, (Connection)wrappedConnection);
            }
            if (wrappedConnection == null) return user;
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            try {
                throw resourceUnavailableException;
                catch (SQLException sQLException) {
                    throw sQLException;
                }
                catch (DataException dataException) {
                    throw dataException;
                }
            }
            catch (Throwable throwable) {
                if (wrappedConnection == null) throw throwable;
                UserDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, resultSet);
                throw throwable;
            }
        }
        UserDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
        return user;
    }
}

