/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.jdbc;

import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.SkybotVariable;
import com.helpsystems.enterprise.core.dm.SkybotVariableDM;
import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SkybotVariableDMJdbc
extends AbstractDatabaseManager
implements SkybotVariableDM {
    private static final String objDesc = "Automate Schedule Variable";
    private static final String TABLE = "automate_schedule_variables";
    private String table;

    public SkybotVariableDMJdbc(String string, String string2) throws ResourceUnavailableException {
        super(string);
        this.table = string2 + "." + TABLE;
        this.setName("ENTERPRISE.SkybotVariableDM");
    }

    @Override
    public SkybotVariable get(String string) throws ResourceUnavailableException, DataException {
        String string2 = "select";
        string2 = string2 + " ID";
        string2 = string2 + ", NAME";
        string2 = string2 + ", VALUE";
        string2 = string2 + ", STATIC_VALUE";
        string2 = string2 + ", DYNAMIC_TYPE";
        string2 = string2 + ", CALENDAR_ID";
        string2 = string2 + ", OFFSET_DAYS";
        string2 = string2 + ", OFFSET_DAY_TYPE";
        string2 = string2 + ", date_format_code";
        string2 = string2 + ", ALLOW_OUTSIDE_ACCESS";
        string2 = string2 + " from " + this.table + " where name=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string2);
        try {
            preparedStatement.setString(1, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                SkybotVariable skybotVariable;
                SkybotVariable skybotVariable2 = skybotVariable = this.generateBusinessObject(resultSet);
                return skybotVariable2;
            }
            try {
                String string3 = MessageUtil.formatMsg((String)"{0} {1} not found.", (Object[])new Object[]{objDesc, string});
                throw new NoDataException(string3);
            }
            catch (SQLException sQLException) {
                String string4 = MessageUtil.formatMsg((String)"SQL error while retrieving {0} {1}.", (Object[])new Object[]{objDesc, string});
                throw new ResourceUnavailableException(string4, (Throwable)sQLException);
            }
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public SkybotVariable get(long l, Connection connection) throws DataException, ResourceUnavailableException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection2;
        block8: {
            SkybotVariable skybotVariable;
            block10: {
                block9: {
                    SkybotVariable skybotVariable2;
                    connection2 = connection;
                    preparedStatement = null;
                    resultSet = null;
                    if (connection2 == null) {
                        connection2 = super.getConnectionOrFail();
                    }
                    String string = "select";
                    string = string + " ID";
                    string = string + ", NAME";
                    string = string + ", VALUE";
                    string = string + ", STATIC_VALUE";
                    string = string + ", DYNAMIC_TYPE";
                    string = string + ", CALENDAR_ID";
                    string = string + ", OFFSET_DAYS";
                    string = string + ", OFFSET_DAY_TYPE";
                    string = string + ", date_format_code";
                    string = string + ", ALLOW_OUTSIDE_ACCESS";
                    string = string + " from " + this.table + " where id=?";
                    preparedStatement = this.getDefaultPreparedStmt(string, connection2);
                    preparedStatement.setLong(1, l);
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) break block8;
                    skybotVariable = skybotVariable2 = this.generateBusinessObject(resultSet);
                    if (connection != null) break block9;
                    SkybotVariableDMJdbc.closeEm((Connection)connection2, (Statement)preparedStatement, (ResultSet)resultSet);
                    break block10;
                }
                SkybotVariableDMJdbc.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
            }
            return skybotVariable;
        }
        try {
            try {
                String string = MessageUtil.formatMsg((String)"{0} {1} not found.", (Object[])new Object[]{objDesc, l});
                throw new NoDataException(string);
            }
            catch (SQLException sQLException) {
                String string = MessageUtil.formatMsg((String)"SQL error while retrieving {0} {1}.", (Object[])new Object[]{objDesc, l});
                throw new ResourceUnavailableException(string, (Throwable)sQLException);
            }
        }
        catch (Throwable throwable) {
            if (connection == null) {
                SkybotVariableDMJdbc.closeEm((Connection)connection2, preparedStatement, resultSet);
            } else {
                SkybotVariableDMJdbc.closeEm(null, preparedStatement, resultSet);
            }
            throw throwable;
        }
    }

    @Override
    public SkybotVariable get(long l) throws DataException, ResourceUnavailableException {
        return this.get(l, null);
    }

    private SkybotVariable generateBusinessObject(ResultSet resultSet) throws ResourceUnavailableException, DataException, SQLException {
        SkybotVariable skybotVariable = null;
        long l = resultSet.getLong("id");
        String string = resultSet.getString("name");
        boolean bl = resultSet.getBoolean("static_value");
        if (bl) {
            String string2 = resultSet.getString("value");
            boolean bl2 = resultSet.getBoolean("ALLOW_OUTSIDE_ACCESS");
            skybotVariable = new SkybotVariable(l, string, string2, bl2);
        } else {
            int n = resultSet.getInt("dynamic_type");
            if (n == 1) {
                long l2 = resultSet.getLong("calendar_id");
                Long l3 = null;
                if (l2 != 0L) {
                    l3 = new Long(l2);
                }
                int n2 = resultSet.getInt("offset_days");
                CalendarObject.DayType dayType = CalendarObject.DayType.persistanceCodeToEnum(resultSet.getString("offset_day_type"));
                int n3 = resultSet.getInt("date_format_code");
                skybotVariable = new SkybotVariable(l, string, l3, n2, dayType, n3);
            }
        }
        return skybotVariable;
    }

    @Override
    public SkybotVariable updateValue(SkybotVariable skybotVariable) throws ResourceUnavailableException, DataException {
        if (!skybotVariable.isStaticValue()) {
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Automate Schedule Variable {0} is dynamic; its value canot be modified.", (Object[])new Object[]{skybotVariable.getName()}));
        }
        if (!skybotVariable.isAllowChangeByAPI()) {
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Automate Schedule Variable {0} does not allow its value to be modified.", (Object[])new Object[]{skybotVariable.getName()}));
        }
        String string = "update " + this.table + " set value = ? where id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            SkybotVariable skybotVariable2;
            preparedStatement.setString(1, skybotVariable.getValue());
            preparedStatement.setLong(2, skybotVariable.getOid());
            preparedStatement.execute();
            SkybotVariable skybotVariable3 = skybotVariable2 = this.get(skybotVariable.getName());
            return skybotVariable3;
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while updating {0} {1}.", (Object[])new Object[]{objDesc, skybotVariable.getName()});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }
}

