/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.jdbc;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.BusinessObjectGenerator;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.Convert;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.access.jdbc.ResultSetSimpleList;
import com.helpsystems.enterprise.core.busobj.CommandSet;
import com.helpsystems.enterprise.core.busobj.JobMonitor;
import com.helpsystems.enterprise.core.busobj.JobType;
import com.helpsystems.enterprise.core.busobj.ParentType;
import com.helpsystems.enterprise.core.dm.CommandSetDM;
import com.helpsystems.enterprise.core.dm.ScheduleJobDM;
import com.helpsystems.enterprise.core.scheduler.CalendarObject;
import com.helpsystems.enterprise.core.scheduler.JobHoldFlag;
import com.helpsystems.enterprise.core.scheduler.MissedJobAction;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo;
import com.helpsystems.enterprise.core.scheduler.ScheduleJob;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobBigProxy;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobMonitorProxy;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobProxy;
import com.helpsystems.enterprise.core.scheduler.SimpleList;
import com.helpsystems.enterprise.core.util.LongConverter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class ScheduleJobDMJdbc
extends AbstractDatabaseManager
implements ScheduleJobDM {
    private static final Logger logger = Logger.getLogger(ScheduleJobDMJdbc.class);
    private static final String objDesc = "Schedule Job";
    private static final String TABLE = "jobs";
    private static final String JOB_DATE_OBJECTS_TABLE = "job_date_objects";
    private static final String DEPENDENCIES_TABLE = "dependencies";
    private static final String AGENT_EVENT_MONITORS_TABLE = "agent_event_monitors";
    private String table;
    private String jobDateObjectsTable;
    private Calendar cloneOnly_GMTCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
    BusinessObjectGenerator busObjGenerator = new ScheduleJobGenerator();
    BusinessObjectGenerator suiteGenerator = new ScheduleJobSuiteGenerator();
    BusinessObjectGenerator proxyGenerator = new ScheduleJobProxyGenerator();
    BusinessObjectGenerator scheduleJobMonitorProxyGenerator = new ScheduleJobMonitorProxyGenerator();
    BusinessObjectGenerator bigProxyGenerator = new ScheduleJobBigProxyGenerator();
    private CommandSetDM commandSetDM;

    public ScheduleJobDMJdbc(String string, String string2, CommandSetDM commandSetDM) throws ResourceUnavailableException {
        super(string);
        this.table = string2 + "." + TABLE;
        this.jobDateObjectsTable = string2 + "." + JOB_DATE_OBJECTS_TABLE;
        this.commandSetDM = commandSetDM;
        this.setName("ENTERPRISE.ScheduleJobDM");
    }

    private String getSqlStatement() {
        return "SELECT id, name, description, job_type, agent_environment_type, agent_environment_id, command_set_id, missed_action, system_defaults_for_job_history_purge, job_history_purge, job_history_runs_to_keep, copy_joblog_to_server, overrun_monitor_option, overrun_time, overrun_monitor_selected, overrun_completion_time, overrun_send_snmp_trap, overrun_send_email, overrun_end_job, overrun_notification_list_id, underrun_monitor_selected, underrun_time, underrun_send_snmp_trap, underrun_send_email, underrun_notification_list_id, late_start_monitor_selected, late_start_monitor_option, late_start_time, late_start_start_time, late_start_send_snmp_trap, late_start_send_email, late_start_end_job, late_start_notification_list_id, send_submit_snmp_trap, send_submit_email, submit_notification_list_id, send_run_snmp_trap, send_run_email, run_notification_list_id, send_complete_snmp_trap, send_complete_email, complete_notification_list_id, send_fail_snmp_trap, send_fail_email, fail_notification_list_id, send_cancel_snmp_trap, send_cancel_email, cancel_notification_list_id, hold, hold_times, held_count, hold_until, schedule_type, time_range_start, time_range_end, target_id, target_type, hold_on_failure, skip_on_not_completed, calendar_id, day_type, email_job_log, email_notification_list_id, ibmi_job_name, job_history_days_to_keep, job_history_purge_option, conditional, cond_retry, cond_retry_delay, cond_retry_count, condition_fail_status, send_retry_wait_snmp_trap, send_retry_wait_email, retry_wait_notification_list_id, timezone_type, generate_skipped_history, default_priority, send_skipped_snmp_trap, send_skipped_email, skipped_notification_list_id, variable_base_date, email_subject_running, email_body_running, send_failed_email_log, send_complete_email_log, send_canceled_email_log, send_member_failed_email_log, send_member_canceled_email_log, timezone, job_queue_id, job_queue_name,  job_parameters, non_workday_option FROM " + this.table;
    }

    private String getSqlStatementForSuite() {
        return "SELECT id, name, description, job_type, missed_action, system_defaults_for_job_history_purge, job_history_purge, job_history_runs_to_keep, copy_joblog_to_server, overrun_monitor_option, overrun_time, overrun_monitor_selected, overrun_completion_time, overrun_send_snmp_trap, overrun_send_email, overrun_end_job, overrun_notification_list_id, underrun_monitor_selected, underrun_time, underrun_send_snmp_trap, underrun_send_email, underrun_notification_list_id, late_start_monitor_selected, late_start_monitor_option, late_start_time, late_start_start_time, late_start_send_snmp_trap, late_start_send_email, late_start_end_job, late_start_notification_list_id, send_submit_snmp_trap, send_submit_email, submit_notification_list_id, send_run_snmp_trap, send_run_email, run_notification_list_id, send_complete_snmp_trap, send_complete_email, complete_notification_list_id, send_fail_snmp_trap, send_fail_email, fail_notification_list_id, send_cancel_snmp_trap, send_cancel_email, cancel_notification_list_id, hold, hold_times, held_count, hold_until, schedule_type, time_range_start, time_range_end, hold_on_failure, skip_on_not_completed, calendar_id, day_type, email_job_log, email_notification_list_id, generate_skipped_history, send_skipped_snmp_trap, send_skipped_email, skipped_notification_list_id, send_member_fail_snmp_trap, send_member_fail_email, member_fail_notification_list_id, send_member_cancel_snmp_trap, send_member_cancel_email, member_cancel_notification_list_id, variable_base_date, send_failed_email_log, send_complete_email_log, send_canceled_email_log, send_member_failed_email_log, send_member_canceled_email_log, agent_environment_type,  timezone_type, timezone,  job_parameters, non_workday_option, job_history_days_to_keep,  job_history_purge_option FROM " + this.table;
    }

    @Override
    public SimpleList<ScheduleJobProxy> getList_JobsThatReferToCalendar(long l) throws ResourceUnavailableException {
        ResultSet resultSet;
        String string = this.proxySQLSelectString() + " WHERE calendar_id=? ORDER BY id";
        PreparedStatement preparedStatement = this.getPreparedStmtForScrollableList(string);
        try {
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the list of Schedule jobs that refer to Calendar {0}.", (Object[])new Object[]{l});
            this.closeConnection(preparedStatement);
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        return new ResultSetSimpleList<ScheduleJobProxy>(resultSet, this.proxyGenerator);
    }

    @Override
    public SimpleList<ScheduleJobProxy> getList_JobsThatReferToDateObject(long l) throws ResourceUnavailableException {
        ResultSet resultSet;
        String string = "SELECT DISTINCT j.id, name, description, job_type, schedule_type, hold, hold_times, held_count, hold_until, target_type, target_id, hold_on_failure, calendar_id, skip_on_not_completed, day_type, late_start_monitor_selected, generate_skipped_history, default_priority, time_range_start, time_range_end, timezone_type, timezone, non_workday_option FROM " + this.jobDateObjectsTable + " jdo JOIN jobs j " + "ON job_id = j.id WHERE date_object_id=? ORDER BY j.id";
        PreparedStatement preparedStatement = this.getPreparedStmtForScrollableList(string);
        try {
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the list of Schedule jobs that refer to Date List {0}.", (Object[])new Object[]{l});
            this.closeConnection(preparedStatement);
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        return new ResultSetSimpleList<ScheduleJobProxy>(resultSet, this.proxyGenerator);
    }

    @Override
    public ScheduleJob get(long l) throws ResourceUnavailableException, DataException {
        String string = this.getSqlStatement() + " WHERE id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                ScheduleJob scheduleJob;
                ScheduleJob scheduleJob2 = scheduleJob = (ScheduleJob)((Object)this.busObjGenerator.generateObject(resultSet));
                return scheduleJob2;
            }
            try {
                String string2 = MessageUtil.formatMsg((String)"{0} not found for id {1}.", (Object[])new Object[]{objDesc, Long.toString(l)});
                throw new NoDataException(string2);
            }
            catch (SQLException sQLException) {
                String string3 = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for id {1}.", (Object[])new Object[]{objDesc, Long.toString(l)});
                throw new ResourceUnavailableException(string3, (Throwable)sQLException);
            }
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public ScheduleJob getSuite(long l) throws ResourceUnavailableException, DataException {
        String string = this.getSqlStatementForSuite() + " WHERE id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                ScheduleJob scheduleJob;
                ScheduleJob scheduleJob2 = scheduleJob = (ScheduleJob)((Object)this.suiteGenerator.generateObject(resultSet));
                return scheduleJob2;
            }
            try {
                String string2 = MessageUtil.formatMsg((String)"{0} not found for id {1}.", (Object[])new Object[]{objDesc, Long.toString(l)});
                throw new NoDataException(string2);
            }
            catch (SQLException sQLException) {
                String string3 = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for id {1}.", (Object[])new Object[]{objDesc, Long.toString(l)});
                throw new ResourceUnavailableException(string3, (Throwable)sQLException);
            }
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public ScheduleJobProxy getScheduleJobProxy(long l) throws NoDataException, ResourceUnavailableException {
        String string = "SELECT id, name, description, job_type, schedule_type, hold, hold_times, held_count, hold_until, target_id, target_type, job_queue_id, job_queue_name, hold_on_failure, calendar_id, skip_on_not_completed, generate_skipped_history, day_type, late_start_monitor_selected, timezone_type, missed_action, time_range_start, time_range_end, default_priority, agent_environment_type, timezone, job_parameters, non_workday_option FROM " + this.table + " WHERE id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                Object object;
                ScheduleJobProxy scheduleJobProxy = new ScheduleJobProxy();
                scheduleJobProxy.setSkybotJobNumber(l);
                scheduleJobProxy.setName(Convert.trimR((String)resultSet.getString("name")));
                scheduleJobProxy.setDescription(Convert.trimR((String)resultSet.getString("description")));
                JobType jobType = JobType.persistanceCodeToEnum(resultSet.getInt("job_type"));
                scheduleJobProxy.setJobType(jobType);
                scheduleJobProxy.setScheduleType(this.getScheduleType(l, resultSet));
                scheduleJobProxy.setJobHoldFlag(this.getJobHoldFlag(l, resultSet));
                scheduleJobProxy.setHoldTimes(resultSet.getInt("hold_times"));
                scheduleJobProxy.setHeldCount(resultSet.getInt("held_count"));
                Calendar calendar = (Calendar)this.cloneOnly_GMTCalendar.clone();
                Timestamp timestamp = resultSet.getTimestamp("hold_until", calendar);
                if (timestamp != null) {
                    scheduleJobProxy.setHoldUntil(timestamp.getTime());
                } else {
                    scheduleJobProxy.setHoldUntil(0L);
                }
                scheduleJobProxy.setHoldOnFailure(resultSet.getBoolean("hold_on_failure"));
                scheduleJobProxy.setSkipOnNotCompleted(resultSet.getBoolean("skip_on_not_completed"));
                scheduleJobProxy.setGenerateSkippedHistory(resultSet.getBoolean("generate_skipped_history"));
                scheduleJobProxy.setJobParameters(resultSet.getString("job_parameters"));
                if (!scheduleJobProxy.isSuite()) {
                    scheduleJobProxy.setTargetId(resultSet.getLong("target_id"));
                    object = ScheduleInfo.TargetType.persistanceCodeToEnum(resultSet.getString("target_type"));
                    scheduleJobProxy.setTargetType((ScheduleInfo.TargetType)object);
                    int n = resultSet.getInt("target_id");
                    if (object == ScheduleInfo.TargetType.AGENT_GROUP) {
                        scheduleJobProxy.setModel(n);
                    } else {
                        scheduleJobProxy.setSystem(n);
                    }
                    scheduleJobProxy.setJobQueueID(resultSet.getLong("job_queue_id"));
                    scheduleJobProxy.setJobQueueName(resultSet.getString("job_queue_name"));
                }
                object = resultSet.getString("timezone_type");
                ScheduleInfo.TimeZoneType timeZoneType = this.timezoneType((String)object, scheduleJobProxy.isSuite(), scheduleJobProxy.isSuiteMember());
                scheduleJobProxy.setTimezoneType(timeZoneType);
                scheduleJobProxy.setJobTimezone(Convert.trimR((String)resultSet.getString("timezone")));
                scheduleJobProxy.setCalendarID(resultSet.getLong("calendar_id"));
                String string2 = resultSet.getString("day_type");
                if (string2 != null && string2.trim().length() > 0) {
                    scheduleJobProxy.setDayType(CalendarObject.DayType.persistanceCodeToEnum(string2));
                } else {
                    scheduleJobProxy.setDayType(null);
                }
                scheduleJobProxy.setLateStartMonitorSelected(resultSet.getBoolean("late_start_monitor_selected"));
                int n = resultSet.getInt("missed_action");
                scheduleJobProxy.setMissedJobAction(MissedJobAction.persistanceCodeToEnum(n));
                int n2 = resultSet.getInt("default_priority");
                if (n2 != 0) {
                    scheduleJobProxy.setDefaultPriority(n2);
                }
                scheduleJobProxy.setAgentEnvironmentType(resultSet.getString("agent_environment_type"));
                scheduleJobProxy.setTimeRangeStart(resultSet.getInt("time_range_start"));
                scheduleJobProxy.setTimeRangeEnd(resultSet.getInt("time_range_end"));
                String string3 = Convert.trimR((String)resultSet.getString("non_workday_option"));
                if (string3 == null || string3.isEmpty()) {
                    scheduleJobProxy.setNonWorkdayOption(null);
                } else {
                    scheduleJobProxy.setNonWorkdayOption(ScheduleInfo.NonWorkdayOption.persistanceCodeToEnum(string3));
                }
                ScheduleJobProxy scheduleJobProxy2 = scheduleJobProxy;
                return scheduleJobProxy2;
            }
            try {
                String string4 = MessageUtil.formatMsg((String)"Schedule Job {0} was not found.", (Object[])new Object[]{l});
                throw new NoDataException(string4);
            }
            catch (SQLException sQLException) {
                String string5 = MessageUtil.formatMsg((String)"SQL error while retrieving Schedule Job {0}.", (Object[])new Object[]{l});
                throw new ResourceUnavailableException(string5, (Throwable)sQLException);
            }
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public ScheduleJobMonitorProxy getScheduleJobMonitorProxy(long l) throws DataException, ResourceUnavailableException {
        return this.getScheduleJobMonitorProxy(null, l);
    }

    private ScheduleJobMonitorProxy getScheduleJobMonitorProxy(Connection connection, long l) throws DataException, ResourceUnavailableException {
        String string = "SELECT id, name, missed_action, schedule_type, job_type, overrun_monitor_option, overrun_time, overrun_monitor_selected, overrun_completion_time, overrun_send_snmp_trap, overrun_send_email, overrun_end_job, overrun_notification_list_id, underrun_monitor_selected, underrun_time, underrun_send_snmp_trap, underrun_send_email, underrun_notification_list_id, late_start_monitor_selected, late_start_monitor_option, late_start_time, late_start_start_time, late_start_send_snmp_trap, late_start_send_email, late_start_end_job, late_start_notification_list_id, hold, timezone_type, target_id, target_type, email_subject_overrun, email_body_overrun, email_subject_underrun, email_body_underrun, email_subject_latestart, email_body_latestart, timezone FROM " + this.table + " WHERE id=?";
        Connection connection2 = connection;
        if (connection2 == null) {
            connection2 = super.getConnectionOrFail();
        }
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string, connection2);
        ResultSet resultSet = null;
        try {
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                ScheduleJobMonitorProxy scheduleJobMonitorProxy;
                ScheduleJobMonitorProxy scheduleJobMonitorProxy2 = scheduleJobMonitorProxy = (ScheduleJobMonitorProxy)((Object)this.scheduleJobMonitorProxyGenerator.generateObject(resultSet));
                return scheduleJobMonitorProxy2;
            }
            try {
                String string2 = MessageUtil.formatMsg((String)"{0} not found for id {1}.", (Object[])new Object[]{objDesc, Long.toString(l)});
                throw new NoDataException(string2);
            }
            catch (SQLException sQLException) {
                String string3 = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for id {1}.", (Object[])new Object[]{objDesc, Long.toString(l)});
                throw new ResourceUnavailableException(string3, (Throwable)sQLException);
            }
        }
        finally {
            if (connection != null) {
                AbstractDatabaseManager.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
            } else {
                this.closeConnection(preparedStatement);
            }
        }
    }

    @Override
    public ScheduleJobBigProxy getScheduleJobBigProxy(long l) throws DataException, ResourceUnavailableException {
        String string = "SELECT id, name, description, missed_action,  system_defaults_for_job_history_purge, job_history_purge, job_history_runs_to_keep,  overrun_monitor_option, overrun_time, overrun_monitor_selected, overrun_completion_time, overrun_send_snmp_trap, overrun_send_email, overrun_end_job, overrun_notification_list_id, underrun_monitor_selected, underrun_time, underrun_send_snmp_trap, underrun_send_email, underrun_notification_list_id, late_start_monitor_selected, late_start_monitor_option, late_start_time, late_start_start_time, late_start_send_snmp_trap, late_start_send_email, late_start_end_job, late_start_notification_list_id, send_submit_snmp_trap, send_submit_email, submit_notification_list_id, send_run_snmp_trap, send_run_email, run_notification_list_id, send_complete_snmp_trap, send_complete_email, complete_notification_list_id, send_fail_snmp_trap, send_fail_email, fail_notification_list_id, send_cancel_snmp_trap, send_cancel_email, cancel_notification_list_id, hold, hold_times, held_count, hold_until, schedule_type, hold_on_failure, email_job_log, email_notification_list_id, send_retry_wait_snmp_trap, send_retry_wait_email, retry_wait_notification_list_id, copy_joblog_to_server, skipped_notification_list_id, send_skipped_email, send_skipped_snmp_trap, default_priority, job_type, send_member_fail_snmp_trap, send_member_fail_email, member_fail_notification_list_id, send_member_cancel_snmp_trap, send_member_cancel_email, member_cancel_notification_list_id, variable_base_date, email_subject_overrun,  email_subject_underrun, email_subject_latestart, email_subject_canceled, email_subject_member_canceled,  email_subject_completed, email_subject_failed, email_subject_member_failed, email_subject_running,  email_subject_submitted, email_subject_retry_wait, email_subject_skipped,  email_body_overrun,  email_body_underrun, email_body_latestart, email_body_canceled, email_body_member_canceled,  email_body_completed, email_body_failed, email_body_member_failed, email_body_running,  email_body_submitted, email_body_retry_wait, email_body_skipped, send_failed_email_log, send_complete_email_log, send_canceled_email_log, send_member_failed_email_log, send_member_canceled_email_log, job_history_days_to_keep, job_history_purge_option FROM " + this.table + " WHERE id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                ScheduleJobBigProxy scheduleJobBigProxy;
                ScheduleJobBigProxy scheduleJobBigProxy2 = scheduleJobBigProxy = (ScheduleJobBigProxy)((Object)this.bigProxyGenerator.generateObject(resultSet));
                return scheduleJobBigProxy2;
            }
            try {
                String string2 = MessageUtil.formatMsg((String)"{0} not found for id {1}.", (Object[])new Object[]{objDesc, Long.toString(l)});
                throw new NoDataException(string2);
            }
            catch (SQLException sQLException) {
                String string3 = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for id {1}.", (Object[])new Object[]{objDesc, Long.toString(l)});
                throw new ResourceUnavailableException(string3, (Throwable)sQLException);
            }
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public void hold(long l) throws ResourceUnavailableException {
        try {
            this.updateHeldInfo(l, JobHoldFlag.HELD, 0, 0, 0L);
        }
        catch (Exception exception) {
            String string = MessageUtil.formatMsg((String)"Error holding Schedule Job {0}.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string, (Throwable)exception);
        }
    }

    @Override
    public void release(long l) throws ResourceUnavailableException {
        try {
            this.updateHeldInfo(l, JobHoldFlag.NOT_HELD, 0, 0, 0L);
        }
        catch (Exception exception) {
            String string = MessageUtil.formatMsg((String)"Error releasing Schedule Job {0}.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string, (Throwable)exception);
        }
    }

    @Override
    public void updateHeldInfo(long l, JobHoldFlag jobHoldFlag, int n, int n2, long l2) throws ResourceUnavailableException {
        String string = "UPDATE " + this.table + " SET hold=?, hold_times=?, held_count=?, hold_until=? WHERE id=?";
        int n3 = 0;
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            Object object;
            preparedStatement.setInt(1, jobHoldFlag.persistanceCode());
            preparedStatement.setInt(2, n);
            preparedStatement.setInt(3, n2);
            if (l2 == 0L) {
                preparedStatement.setNull(4, 93);
            } else {
                object = (Calendar)this.cloneOnly_GMTCalendar.clone();
                Timestamp timestamp = new Timestamp(l2);
                preparedStatement.setTimestamp(4, timestamp, (Calendar)object);
            }
            preparedStatement.setLong(5, l);
            n3 = preparedStatement.executeUpdate();
            if (n3 != 1) {
                object = MessageUtil.formatMsg((String)"Job number {0} was not found while updating hold information.", (Object[])new Object[]{l});
                throw new ResourceUnavailableException((String)object);
            }
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw resourceUnavailableException;
        }
        catch (Exception exception) {
            String string2 = MessageUtil.formatMsg((String)"Error updating hold information for Schedule Job {0}.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string2, (Throwable)exception);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    private ScheduleJobProxy.ScheduleType getScheduleType(long l, ResultSet resultSet) throws ResourceUnavailableException {
        String string;
        try {
            string = Convert.trimR((String)resultSet.getString("schedule_type"));
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving Schedule Type code for job {0}.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        if (string != null && string.length() > 0) {
            return ScheduleJobProxy.ScheduleType.persistanceCodeToEnum(string);
        }
        return ScheduleJobProxy.ScheduleType.UNSCHEDULED;
    }

    private JobHoldFlag getJobHoldFlag(long l, ResultSet resultSet) throws ResourceUnavailableException {
        int n;
        try {
            n = resultSet.getInt("hold");
        }
        catch (SQLException sQLException) {
            String string = MessageUtil.formatMsg((String)"SQL error while retrieving Job Hold Flag for job {0}.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string, (Throwable)sQLException);
        }
        return JobHoldFlag.persistanceCodeToEnum(n);
    }

    private String proxySQLSelectString() {
        return "SELECT id, name, description, job_type, schedule_type, hold, hold_times, held_count, hold_until, hold_on_failure, skip_on_not_completed, target_type, target_id, calendar_id, day_type, late_start_monitor_selected, generate_skipped_history, default_priority, time_range_start, time_range_end, timezone_type, timezone, non_workday_option FROM " + this.table;
    }

    @Override
    public long[] getJobIDsForAgentGroup(long l) throws ResourceUnavailableException {
        long[] lArray;
        String string = "select id from " + this.table + " where target_type='AgentGroup' and target_id = ? and job_type =?";
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            wrappedConnection = super.getConnectionOrFail();
            preparedStatement = super.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            preparedStatement.setLong(1, l);
            preparedStatement.setInt(2, JobType.JOB.persistanceCode());
            resultSet = preparedStatement.executeQuery();
            ArrayList<Long> arrayList = new ArrayList<Long>();
            while (resultSet.next()) {
                arrayList.add(resultSet.getLong("id"));
            }
            lArray = LongConverter.toLongArray(arrayList);
        }
        catch (SQLException sQLException) {
            try {
                throw new ResourceUnavailableException("Error retrieving Jobs for Agent Group: " + l, (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                AbstractDatabaseManager.closeEm((Connection)wrappedConnection, preparedStatement, resultSet);
                throw throwable;
            }
        }
        AbstractDatabaseManager.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
        return lArray;
    }

    @Override
    public ScheduleJobMonitorProxy[] getSuiteMembersWithLateStartMonitors(long l) throws ResourceUnavailableException {
        ScheduleJobMonitorProxy[] scheduleJobMonitorProxyArray;
        String string = "select jobs.id from (job_suite_member_jobs jsmj JOIN jobs ON jsmj.member_job_id = jobs.id) where jsmj.job_suite_id=? and jobs.late_start_monitor_option=?";
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            wrappedConnection = super.getConnectionOrFail();
            preparedStatement = super.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            preparedStatement.setLong(1, l);
            preparedStatement.setInt(2, JobMonitor.MonitorOption.RUN_DURATION.persistanceCode());
            resultSet = preparedStatement.executeQuery();
            ArrayList<ScheduleJobMonitorProxy> arrayList = new ArrayList<ScheduleJobMonitorProxy>();
            while (resultSet.next()) {
                long l2 = resultSet.getLong(1);
                try {
                    ScheduleJobMonitorProxy scheduleJobMonitorProxy = this.getScheduleJobMonitorProxy((Connection)wrappedConnection, l2);
                    arrayList.add(scheduleJobMonitorProxy);
                }
                catch (Exception exception) {
                    logger.warn((Object)("Error loading suite member: " + l2), (Throwable)exception);
                }
            }
            ScheduleJobMonitorProxy[] scheduleJobMonitorProxyArray2 = new ScheduleJobMonitorProxy[]{};
            scheduleJobMonitorProxyArray = arrayList.toArray(scheduleJobMonitorProxyArray2);
        }
        catch (SQLException sQLException) {
            try {
                throw new ResourceUnavailableException("Error retrieving members with late start monitors for Job Suite ID: " + l, (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                AbstractDatabaseManager.closeEm((Connection)wrappedConnection, preparedStatement, resultSet);
                throw throwable;
            }
        }
        AbstractDatabaseManager.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
        return scheduleJobMonitorProxyArray;
    }

    private ScheduleInfo.TimeZoneType timezoneType(String string, boolean bl, boolean bl2) {
        ScheduleInfo.TimeZoneType timeZoneType = bl ? (string == null || string.trim().isEmpty() ? ScheduleInfo.TimeZoneType.SERVER : ScheduleInfo.TimeZoneType.persistanceCodeToEnum(string)) : (bl2 ? ScheduleInfo.TimeZoneType.SERVER : ScheduleInfo.TimeZoneType.persistanceCodeToEnum(string));
        return timeZoneType;
    }

    @Override
    public long[] getDepJobIdsAffectedByAgtGroupChange(long l) throws ResourceUnavailableException {
        long[] lArray;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT dependent_job_id FROM ");
        stringBuilder.append(DEPENDENCIES_TABLE);
        stringBuilder.append(" JOIN ");
        stringBuilder.append(TABLE);
        stringBuilder.append(" ON ");
        stringBuilder.append(DEPENDENCIES_TABLE);
        stringBuilder.append(".prereq_object_id=");
        stringBuilder.append(TABLE);
        stringBuilder.append(".id AND prereq_object_type='");
        stringBuilder.append(ParentType.JOBS.persistanceCode());
        stringBuilder.append("' AND ");
        stringBuilder.append("target_type='");
        stringBuilder.append(ScheduleInfo.TargetType.AGENT_GROUP.persistanceCode());
        stringBuilder.append("' AND target_id = ? ");
        stringBuilder.append("UNION ");
        stringBuilder.append("SELECT dependent_job_id FROM ");
        stringBuilder.append(DEPENDENCIES_TABLE);
        stringBuilder.append(" JOIN ");
        stringBuilder.append(AGENT_EVENT_MONITORS_TABLE);
        stringBuilder.append(" ON ");
        stringBuilder.append(DEPENDENCIES_TABLE);
        stringBuilder.append(".prereq_object_id=");
        stringBuilder.append(AGENT_EVENT_MONITORS_TABLE);
        stringBuilder.append(".id AND prereq_object_type='");
        stringBuilder.append(ParentType.AGENT_EVENT_MONITORS.persistanceCode());
        stringBuilder.append("' AND ");
        stringBuilder.append("target_type='");
        stringBuilder.append(ScheduleInfo.TargetType.AGENT_GROUP.persistanceCode());
        stringBuilder.append("' AND target_id = ? ");
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            wrappedConnection = this.getConnection();
            preparedStatement = this.getDefaultPreparedStmt(stringBuilder.toString(), (Connection)wrappedConnection);
            preparedStatement.setLong(1, l);
            preparedStatement.setLong(2, l);
            resultSet = preparedStatement.executeQuery();
            ArrayList<Long> arrayList = new ArrayList<Long>();
            while (resultSet.next()) {
                arrayList.add(resultSet.getLong("dependent_job_id"));
            }
            lArray = LongConverter.toLongArray(arrayList);
        }
        catch (SQLException sQLException) {
            try {
                throw new ResourceUnavailableException("Error retrieving dependent jobs affected by agent group change: " + l, (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                AbstractDatabaseManager.closeEm((Connection)wrappedConnection, preparedStatement, resultSet);
                throw throwable;
            }
        }
        AbstractDatabaseManager.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
        return lArray;
    }

    private class ScheduleJobBigProxyGenerator
    extends AbstractBusObjGenerator {
        public ScheduleJobBigProxyGenerator() {
            super(95, ScheduleJobDMJdbc.objDesc);
        }

        protected Object constructObject() {
            return new ScheduleJobBigProxy();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            ScheduleJobBigProxy scheduleJobBigProxy = (ScheduleJobBigProxy)((Object)object);
            switch (n) {
                case 1: {
                    String string = resultSet.getString("name").trim();
                    scheduleJobBigProxy.setSkybotJobName(string);
                    break;
                }
                case 2: {
                    scheduleJobBigProxy.setSkybotJobNumber(resultSet.getLong("id"));
                    break;
                }
                case 3: {
                    scheduleJobBigProxy.setDescription(Convert.trimR((String)resultSet.getString("description")));
                    break;
                }
                case 4: {
                    int n2 = resultSet.getInt("missed_action");
                    scheduleJobBigProxy.setMissedJobAction(MissedJobAction.persistanceCodeToEnum(n2));
                    break;
                }
                case 5: {
                    int n3 = resultSet.getInt("job_history_purge_option");
                    if (n3 == 0) {
                        scheduleJobBigProxy.setJobHistoriesToKeep(resultSet.getInt("job_history_runs_to_keep"));
                        break;
                    }
                    scheduleJobBigProxy.setJobHistoryDaysToKeep(resultSet.getInt("job_history_days_to_keep"));
                    break;
                }
                case 6: {
                    short s = resultSet.getShort("overrun_monitor_option");
                    scheduleJobBigProxy.setOverrunMonitorOption(JobMonitor.MonitorOption.persistanceCodeToEnum(s));
                    break;
                }
                case 7: {
                    int n4 = resultSet.getInt("overrun_time");
                    scheduleJobBigProxy.setOverrunMaximumMinutes(n4);
                    break;
                }
                case 8: {
                    scheduleJobBigProxy.setOverrunMonitorSelected(resultSet.getBoolean("overrun_monitor_selected"));
                    break;
                }
                case 9: {
                    int n5 = resultSet.getInt("overrun_completion_time");
                    scheduleJobBigProxy.setOverrunTargetCompletionTime(n5);
                    break;
                }
                case 10: {
                    scheduleJobBigProxy.setOverrunSendSNMPTrap(resultSet.getBoolean("overrun_send_snmp_trap"));
                    break;
                }
                case 11: {
                    scheduleJobBigProxy.setOverrunSendEmail(resultSet.getBoolean("overrun_send_email"));
                    break;
                }
                case 12: {
                    scheduleJobBigProxy.setOverrunEndJob(resultSet.getBoolean("overrun_end_job"));
                    break;
                }
                case 13: {
                    long l = resultSet.getLong("overrun_notification_list_id");
                    scheduleJobBigProxy.setOverrunNotificationListID(l);
                    break;
                }
                case 14: {
                    scheduleJobBigProxy.setUnderrunMonitorSelected(resultSet.getBoolean("underrun_monitor_selected"));
                    break;
                }
                case 15: {
                    int n6 = resultSet.getInt("underrun_time");
                    scheduleJobBigProxy.setUnderrunMinimumMinutes(n6);
                    break;
                }
                case 16: {
                    scheduleJobBigProxy.setUnderrunSendSNMPTrap(resultSet.getBoolean("underrun_send_snmp_trap"));
                    break;
                }
                case 17: {
                    scheduleJobBigProxy.setUnderrunSendEmail(resultSet.getBoolean("underrun_send_email"));
                    break;
                }
                case 18: {
                    long l = resultSet.getLong("underrun_notification_list_id");
                    scheduleJobBigProxy.setUnderrunNotificationListID(l);
                    break;
                }
                case 19: {
                    scheduleJobBigProxy.setLateStartMonitorSelected(resultSet.getBoolean("late_start_monitor_selected"));
                    break;
                }
                case 20: {
                    int n7 = resultSet.getInt("late_start_monitor_option");
                    scheduleJobBigProxy.setLateStartMonitorOption(JobMonitor.MonitorOption.persistanceCodeToEnum(n7));
                    break;
                }
                case 21: {
                    int n8 = resultSet.getInt("late_start_time");
                    scheduleJobBigProxy.setLateStartMaximumMinutes(n8);
                    break;
                }
                case 22: {
                    int n9 = resultSet.getInt("late_start_start_time");
                    scheduleJobBigProxy.setLateStartTargetStartTime(n9);
                    break;
                }
                case 23: {
                    scheduleJobBigProxy.setLateStartSendSNMPTrap(resultSet.getBoolean("late_start_send_snmp_trap"));
                    break;
                }
                case 24: {
                    scheduleJobBigProxy.setLateStartSendEmail(resultSet.getBoolean("late_start_send_email"));
                    break;
                }
                case 25: {
                    scheduleJobBigProxy.setLateStartEndJob(resultSet.getBoolean("late_start_end_job"));
                    break;
                }
                case 26: {
                    long l = resultSet.getLong("late_start_notification_list_id");
                    scheduleJobBigProxy.setLateStartNotificationListID(l);
                    break;
                }
                case 27: {
                    scheduleJobBigProxy.setSendSubmitSNMPTrap(resultSet.getBoolean("send_submit_snmp_trap"));
                    break;
                }
                case 28: {
                    scheduleJobBigProxy.setSendSubmitEmail(resultSet.getBoolean("send_submit_email"));
                    break;
                }
                case 29: {
                    long l = resultSet.getLong("submit_notification_list_id");
                    scheduleJobBigProxy.setSubmitNotificationListID(l);
                    break;
                }
                case 30: {
                    scheduleJobBigProxy.setSendRunSNMPTrap(resultSet.getBoolean("send_run_snmp_trap"));
                    break;
                }
                case 31: {
                    scheduleJobBigProxy.setSendRunEmail(resultSet.getBoolean("send_run_email"));
                    break;
                }
                case 32: {
                    long l = resultSet.getLong("run_notification_list_id");
                    scheduleJobBigProxy.setRunNotificationListID(l);
                    break;
                }
                case 33: {
                    scheduleJobBigProxy.setSendCompleteSNMPTrap(resultSet.getBoolean("send_complete_snmp_trap"));
                    break;
                }
                case 34: {
                    scheduleJobBigProxy.setSendCompleteEmail(resultSet.getBoolean("send_complete_email"));
                    break;
                }
                case 35: {
                    long l = resultSet.getLong("complete_notification_list_id");
                    scheduleJobBigProxy.setCompleteNotificationListID(l);
                    break;
                }
                case 36: {
                    scheduleJobBigProxy.setSendFailSNMPTrap(resultSet.getBoolean("send_fail_snmp_trap"));
                    break;
                }
                case 37: {
                    scheduleJobBigProxy.setSendFailEmail(resultSet.getBoolean("send_fail_email"));
                    break;
                }
                case 38: {
                    long l = resultSet.getLong("fail_notification_list_id");
                    scheduleJobBigProxy.setFailNotificationListID(l);
                    break;
                }
                case 39: {
                    scheduleJobBigProxy.setSendCancelSNMPTrap(resultSet.getBoolean("send_cancel_snmp_trap"));
                    break;
                }
                case 40: {
                    scheduleJobBigProxy.setSendCancelEmail(resultSet.getBoolean("send_cancel_email"));
                    break;
                }
                case 41: {
                    long l = resultSet.getLong("cancel_notification_list_id");
                    scheduleJobBigProxy.setCancelNotificationListID(l);
                    break;
                }
                case 42: {
                    int n10 = resultSet.getInt("hold");
                    scheduleJobBigProxy.setJobHoldFlag(JobHoldFlag.persistanceCodeToEnum(n10));
                    break;
                }
                case 43: {
                    int n11 = resultSet.getInt("hold_times");
                    scheduleJobBigProxy.setHoldTimes(n11);
                    break;
                }
                case 44: {
                    int n12 = resultSet.getInt("held_count");
                    scheduleJobBigProxy.setHeldCount(n12);
                    break;
                }
                case 45: {
                    scheduleJobBigProxy.setPurgeJobHistory(resultSet.getBoolean("job_history_purge"));
                    break;
                }
                case 46: {
                    scheduleJobBigProxy.setUseDefaultsForJobHistoryPurge(resultSet.getBoolean("system_defaults_for_job_history_purge"));
                    break;
                }
                case 47: {
                    scheduleJobBigProxy.setScheduleType(ScheduleJobDMJdbc.this.getScheduleType(scheduleJobBigProxy.getSkybotJobNumber(), resultSet));
                    break;
                }
                case 48: {
                    scheduleJobBigProxy.setHoldOnFailure(resultSet.getBoolean("hold_on_failure"));
                    break;
                }
                case 49: {
                    scheduleJobBigProxy.setEmailJobLog(resultSet.getBoolean("email_job_log"));
                    break;
                }
                case 50: {
                    scheduleJobBigProxy.setEmailNotificationListId(resultSet.getLong("email_notification_list_id"));
                    break;
                }
                case 51: {
                    scheduleJobBigProxy.setSendRetryWaitSNMPTrap(resultSet.getBoolean("send_retry_wait_snmp_trap"));
                    break;
                }
                case 52: {
                    scheduleJobBigProxy.setSendRetryWaitEmail(resultSet.getBoolean("send_retry_wait_email"));
                    break;
                }
                case 53: {
                    long l = resultSet.getLong("retry_wait_notification_list_id");
                    scheduleJobBigProxy.setRetryWaitNotificationListID(l);
                    break;
                }
                case 54: {
                    Calendar calendar = (Calendar)ScheduleJobDMJdbc.this.cloneOnly_GMTCalendar.clone();
                    Timestamp timestamp = resultSet.getTimestamp("hold_until", calendar);
                    if (timestamp != null) {
                        scheduleJobBigProxy.setHoldUntil(timestamp.getTime());
                        break;
                    }
                    scheduleJobBigProxy.setHoldUntil(0L);
                    break;
                }
                case 55: {
                    scheduleJobBigProxy.setSendSkippedSNMPTrap(resultSet.getBoolean("send_skipped_snmp_trap"));
                    break;
                }
                case 56: {
                    scheduleJobBigProxy.setSendSkippedEmail(resultSet.getBoolean("send_skipped_email"));
                    break;
                }
                case 57: {
                    scheduleJobBigProxy.setSkippedNotificationListID(resultSet.getLong("skipped_notification_list_id"));
                    break;
                }
                case 58: {
                    boolean bl = resultSet.getBoolean("copy_joblog_to_server");
                    scheduleJobBigProxy.setCopyJobLogToServer(bl);
                    break;
                }
                case 59: {
                    int n13 = resultSet.getInt("default_priority");
                    scheduleJobBigProxy.setDefaultPriority(n13);
                    break;
                }
                case 60: {
                    JobType jobType = JobType.persistanceCodeToEnum(resultSet.getInt("job_type"));
                    scheduleJobBigProxy.setJobType(jobType);
                    break;
                }
                case 61: {
                    scheduleJobBigProxy.setSendMemberFailSNMPTrap(resultSet.getBoolean("send_member_fail_snmp_trap"));
                    break;
                }
                case 62: {
                    scheduleJobBigProxy.setSendMemberFailEmail(resultSet.getBoolean("send_member_fail_email"));
                    break;
                }
                case 63: {
                    scheduleJobBigProxy.setMemberFailNotificationListID(resultSet.getLong("member_fail_notification_list_id"));
                    break;
                }
                case 64: {
                    scheduleJobBigProxy.setSendMemberCancelSNMPTrap(resultSet.getBoolean("send_member_cancel_snmp_trap"));
                    break;
                }
                case 65: {
                    scheduleJobBigProxy.setSendMemberCancelEmail(resultSet.getBoolean("send_member_cancel_email"));
                    break;
                }
                case 66: {
                    scheduleJobBigProxy.setMemberCancelNotificationListID(resultSet.getLong("member_cancel_notification_list_id"));
                    break;
                }
                case 67: {
                    scheduleJobBigProxy.setEmailSubjectOverrun(resultSet.getString("email_subject_overrun"));
                    break;
                }
                case 68: {
                    scheduleJobBigProxy.setEmailSubjectUnderrun(resultSet.getString("email_subject_underrun"));
                    break;
                }
                case 69: {
                    scheduleJobBigProxy.setEmailSubjectLatestart(resultSet.getString("email_subject_latestart"));
                    break;
                }
                case 70: {
                    scheduleJobBigProxy.setEmailSubjectCanceled(resultSet.getString("email_subject_canceled"));
                    break;
                }
                case 71: {
                    scheduleJobBigProxy.setEmailSubjectMemberCanceled(resultSet.getString("email_subject_member_canceled"));
                    break;
                }
                case 72: {
                    scheduleJobBigProxy.setEmailSubjectCompleted(resultSet.getString("email_subject_completed"));
                    break;
                }
                case 73: {
                    scheduleJobBigProxy.setEmailSubjectFailed(resultSet.getString("email_subject_failed"));
                    break;
                }
                case 74: {
                    scheduleJobBigProxy.setEmailSubjectMemberFailed(resultSet.getString("email_subject_member_failed"));
                    break;
                }
                case 75: {
                    scheduleJobBigProxy.setEmailSubjectRunning(resultSet.getString("email_subject_running"));
                    break;
                }
                case 76: {
                    scheduleJobBigProxy.setEmailSubjectSubmitted(resultSet.getString("email_subject_submitted"));
                    break;
                }
                case 77: {
                    scheduleJobBigProxy.setEmailSubjectRetryWait(resultSet.getString("email_subject_retry_wait"));
                    break;
                }
                case 78: {
                    scheduleJobBigProxy.setEmailSubjectSkipped(resultSet.getString("email_subject_skipped"));
                    break;
                }
                case 79: {
                    scheduleJobBigProxy.setEmailBodyOverrun(resultSet.getString("email_body_overrun"));
                    break;
                }
                case 80: {
                    scheduleJobBigProxy.setEmailBodyUnderrun(resultSet.getString("email_body_underrun"));
                    break;
                }
                case 81: {
                    scheduleJobBigProxy.setEmailBodyLatestart(resultSet.getString("email_body_latestart"));
                    break;
                }
                case 82: {
                    scheduleJobBigProxy.setEmailBodyCanceled(resultSet.getString("email_body_canceled"));
                    break;
                }
                case 83: {
                    scheduleJobBigProxy.setEmailBodyMemberCanceled(resultSet.getString("email_body_member_canceled"));
                    break;
                }
                case 84: {
                    scheduleJobBigProxy.setEmailBodyCompleted(resultSet.getString("email_body_completed"));
                    break;
                }
                case 85: {
                    scheduleJobBigProxy.setEmailBodyFailed(resultSet.getString("email_body_failed"));
                    break;
                }
                case 86: {
                    scheduleJobBigProxy.setEmailBodyMemberFailed(resultSet.getString("email_body_member_failed"));
                    break;
                }
                case 87: {
                    scheduleJobBigProxy.setEmailBodyRunning(resultSet.getString("email_body_running"));
                    break;
                }
                case 88: {
                    scheduleJobBigProxy.setEmailBodySubmitted(resultSet.getString("email_body_submitted"));
                    break;
                }
                case 89: {
                    scheduleJobBigProxy.setEmailBodyRetryWait(resultSet.getString("email_body_retry_wait"));
                    break;
                }
                case 90: {
                    scheduleJobBigProxy.setEmailBodySkipped(resultSet.getString("email_body_skipped"));
                    break;
                }
                case 91: {
                    scheduleJobBigProxy.setSendFailJobLog(resultSet.getBoolean("send_failed_email_log"));
                    break;
                }
                case 92: {
                    scheduleJobBigProxy.setSendCompleteJobLog(resultSet.getBoolean("send_complete_email_log"));
                    break;
                }
                case 93: {
                    scheduleJobBigProxy.setSendCancelJobLog(resultSet.getBoolean("send_canceled_email_log"));
                    break;
                }
                case 94: {
                    scheduleJobBigProxy.setSendMemberFailedEmailLog(resultSet.getBoolean("send_member_failed_email_log"));
                    break;
                }
                case 95: {
                    scheduleJobBigProxy.setSendMemberCanceledEmailLog(resultSet.getBoolean("send_member_canceled_email_log"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }

    private class ScheduleJobMonitorProxyGenerator
    extends AbstractBusObjGenerator {
        public ScheduleJobMonitorProxyGenerator() {
            super(37, ScheduleJobDMJdbc.objDesc);
        }

        protected Object constructObject() {
            return new ScheduleJobMonitorProxy();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            ScheduleJobMonitorProxy scheduleJobMonitorProxy = (ScheduleJobMonitorProxy)((Object)object);
            switch (n) {
                case 1: {
                    String string = resultSet.getString("name").trim();
                    scheduleJobMonitorProxy.setSkybotJobName(string);
                    break;
                }
                case 2: {
                    scheduleJobMonitorProxy.setSkybotJobNumber(resultSet.getLong("id"));
                    break;
                }
                case 3: {
                    int n2 = resultSet.getInt("missed_action");
                    scheduleJobMonitorProxy.setMissedJobAction(MissedJobAction.persistanceCodeToEnum(n2));
                    break;
                }
                case 4: {
                    scheduleJobMonitorProxy.setScheduleType(ScheduleJobDMJdbc.this.getScheduleType(scheduleJobMonitorProxy.getSkybotJobNumber(), resultSet));
                    break;
                }
                case 5: {
                    short s = resultSet.getShort("overrun_monitor_option");
                    scheduleJobMonitorProxy.setOverrunMonitorOption(JobMonitor.MonitorOption.persistanceCodeToEnum(s));
                    break;
                }
                case 6: {
                    int n3 = resultSet.getInt("overrun_time");
                    scheduleJobMonitorProxy.setOverrunMaximumMinutes(n3);
                    break;
                }
                case 7: {
                    scheduleJobMonitorProxy.setOverrunMonitorSelected(resultSet.getBoolean("overrun_monitor_selected"));
                    break;
                }
                case 8: {
                    int n4 = resultSet.getInt("overrun_completion_time");
                    scheduleJobMonitorProxy.setOverrunTargetCompletionTime(n4);
                    break;
                }
                case 9: {
                    scheduleJobMonitorProxy.setOverrunSendSNMPTrap(resultSet.getBoolean("overrun_send_snmp_trap"));
                    break;
                }
                case 10: {
                    scheduleJobMonitorProxy.setOverrunSendEmail(resultSet.getBoolean("overrun_send_email"));
                    break;
                }
                case 11: {
                    scheduleJobMonitorProxy.setOverrunEndJob(resultSet.getBoolean("overrun_end_job"));
                    break;
                }
                case 12: {
                    long l = resultSet.getLong("overrun_notification_list_id");
                    scheduleJobMonitorProxy.setOverrunNotificationListID(l);
                    break;
                }
                case 13: {
                    scheduleJobMonitorProxy.setUnderrunMonitorSelected(resultSet.getBoolean("underrun_monitor_selected"));
                    break;
                }
                case 14: {
                    int n5 = resultSet.getInt("underrun_time");
                    scheduleJobMonitorProxy.setUnderrunMinimumMinutes(n5);
                    break;
                }
                case 15: {
                    scheduleJobMonitorProxy.setUnderrunSendSNMPTrap(resultSet.getBoolean("underrun_send_snmp_trap"));
                    break;
                }
                case 16: {
                    scheduleJobMonitorProxy.setUnderrunSendEmail(resultSet.getBoolean("underrun_send_email"));
                    break;
                }
                case 17: {
                    long l = resultSet.getLong("underrun_notification_list_id");
                    scheduleJobMonitorProxy.setUnderrunNotificationListID(l);
                    break;
                }
                case 18: {
                    scheduleJobMonitorProxy.setLateStartMonitorSelected(resultSet.getBoolean("late_start_monitor_selected"));
                    break;
                }
                case 19: {
                    int n6 = resultSet.getInt("late_start_monitor_option");
                    scheduleJobMonitorProxy.setLateStartMonitorOption(JobMonitor.MonitorOption.persistanceCodeToEnum(n6));
                    break;
                }
                case 20: {
                    int n7 = resultSet.getInt("late_start_time");
                    scheduleJobMonitorProxy.setLateStartMaximumMinutes(n7);
                    break;
                }
                case 21: {
                    int n8 = resultSet.getInt("late_start_start_time");
                    scheduleJobMonitorProxy.setLateStartTargetStartTime(n8);
                    break;
                }
                case 22: {
                    scheduleJobMonitorProxy.setLateStartSendSNMPTrap(resultSet.getBoolean("late_start_send_snmp_trap"));
                    break;
                }
                case 23: {
                    scheduleJobMonitorProxy.setLateStartSendEmail(resultSet.getBoolean("late_start_send_email"));
                    break;
                }
                case 24: {
                    scheduleJobMonitorProxy.setLateStartEndJob(resultSet.getBoolean("late_start_end_job"));
                    break;
                }
                case 25: {
                    long l = resultSet.getLong("late_start_notification_list_id");
                    scheduleJobMonitorProxy.setLateStartNotificationListID(l);
                    break;
                }
                case 26: {
                    int n9 = resultSet.getInt("hold");
                    scheduleJobMonitorProxy.setJobHoldFlag(JobHoldFlag.persistanceCodeToEnum(n9));
                    break;
                }
                case 27: {
                    JobType jobType = JobType.persistanceCodeToEnum(resultSet.getInt("job_type"));
                    scheduleJobMonitorProxy.setJobType(jobType);
                    break;
                }
                case 28: {
                    String string = Convert.trimR((String)resultSet.getString("timezone_type"));
                    ScheduleInfo.TimeZoneType timeZoneType = ScheduleJobDMJdbc.this.timezoneType(string, scheduleJobMonitorProxy.isSuite(), scheduleJobMonitorProxy.isSuiteMember());
                    scheduleJobMonitorProxy.setTimezoneType(timeZoneType);
                    break;
                }
                case 29: {
                    scheduleJobMonitorProxy.setTargetID(resultSet.getLong("target_id"));
                    break;
                }
                case 30: {
                    if (scheduleJobMonitorProxy.isSuite()) break;
                    scheduleJobMonitorProxy.setTargetType(resultSet.getString("target_type"));
                    break;
                }
                case 31: {
                    scheduleJobMonitorProxy.setEmailSubjectOverrun(resultSet.getString("email_subject_overrun"));
                    break;
                }
                case 32: {
                    scheduleJobMonitorProxy.setEmailBodyOverrun(resultSet.getString("email_body_overrun"));
                    break;
                }
                case 33: {
                    scheduleJobMonitorProxy.setEmailSubjectUnderrun(resultSet.getString("email_subject_underrun"));
                    break;
                }
                case 34: {
                    scheduleJobMonitorProxy.setEmailBodyUnderrun(resultSet.getString("email_body_underrun"));
                    break;
                }
                case 35: {
                    scheduleJobMonitorProxy.setEmailSubjectLatestart(resultSet.getString("email_subject_latestart"));
                    break;
                }
                case 36: {
                    scheduleJobMonitorProxy.setEmailBodyLatestart(resultSet.getString("email_body_latestart"));
                    break;
                }
                case 37: {
                    scheduleJobMonitorProxy.setJobTimezone(Convert.trimR((String)resultSet.getString("timezone")));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }

    private class ScheduleJobProxyGenerator
    extends AbstractBusObjGenerator {
        public ScheduleJobProxyGenerator() {
            super(22, "Schedule Job Proxy");
        }

        protected Object constructObject() {
            return new ScheduleJobProxy();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            ValidationHelper.checkForNull((String)"ResultSet", (Object)resultSet);
            ValidationHelper.checkForNull((String)"Object", (Object)object);
            ScheduleJobProxy scheduleJobProxy = (ScheduleJobProxy)((Object)object);
            switch (n) {
                case 1: {
                    scheduleJobProxy.setSkybotJobNumber(resultSet.getLong("id"));
                    break;
                }
                case 2: {
                    scheduleJobProxy.setName(Convert.trimR((String)resultSet.getString("name")));
                    break;
                }
                case 3: {
                    scheduleJobProxy.setDescription(Convert.trimR((String)resultSet.getString("description")));
                    break;
                }
                case 4: {
                    long l = scheduleJobProxy.getSkybotJobNumber();
                    scheduleJobProxy.setScheduleType(ScheduleJobDMJdbc.this.getScheduleType(l, resultSet));
                    break;
                }
                case 5: {
                    long l = scheduleJobProxy.getSkybotJobNumber();
                    scheduleJobProxy.setJobHoldFlag(ScheduleJobDMJdbc.this.getJobHoldFlag(l, resultSet));
                    break;
                }
                case 6: {
                    scheduleJobProxy.setHoldTimes(resultSet.getInt("hold_times"));
                    break;
                }
                case 7: {
                    scheduleJobProxy.setHeldCount(resultSet.getInt("held_count"));
                    break;
                }
                case 8: {
                    String string = resultSet.getString("target_Type");
                    int n2 = resultSet.getInt("target_id");
                    if (string != null && string.equals("AgentGroup")) {
                        scheduleJobProxy.setModel(n2);
                        break;
                    }
                    scheduleJobProxy.setSystem(n2);
                    break;
                }
                case 9: {
                    scheduleJobProxy.setHoldOnFailure(resultSet.getBoolean("hold_on_failure"));
                    break;
                }
                case 10: {
                    scheduleJobProxy.setSkipOnNotCompleted(resultSet.getBoolean("skip_on_not_completed"));
                    break;
                }
                case 11: {
                    scheduleJobProxy.setCalendarID(resultSet.getLong("calendar_id"));
                    break;
                }
                case 12: {
                    String string = resultSet.getString("day_type");
                    if (string != null && string.trim().length() > 0) {
                        scheduleJobProxy.setDayType(CalendarObject.DayType.persistanceCodeToEnum(string));
                        break;
                    }
                    scheduleJobProxy.setDayType(null);
                    break;
                }
                case 13: {
                    scheduleJobProxy.setLateStartMonitorSelected(resultSet.getBoolean("late_start_monitor_selected"));
                    break;
                }
                case 14: {
                    Calendar calendar = (Calendar)ScheduleJobDMJdbc.this.cloneOnly_GMTCalendar.clone();
                    Timestamp timestamp = resultSet.getTimestamp("hold_until", calendar);
                    if (timestamp != null) {
                        scheduleJobProxy.setHoldUntil(timestamp.getTime());
                        break;
                    }
                    scheduleJobProxy.setHoldUntil(0L);
                    break;
                }
                case 15: {
                    scheduleJobProxy.setGenerateSkippedHistory(resultSet.getBoolean("generate_skipped_history"));
                    break;
                }
                case 16: {
                    scheduleJobProxy.setDefaultPriority(resultSet.getInt("default_priority"));
                    break;
                }
                case 17: {
                    JobType jobType = JobType.persistanceCodeToEnum(resultSet.getInt("job_type"));
                    scheduleJobProxy.setJobType(jobType);
                    break;
                }
                case 18: {
                    scheduleJobProxy.setTimeRangeStart(resultSet.getInt("time_range_start"));
                    break;
                }
                case 19: {
                    scheduleJobProxy.setTimeRangeEnd(resultSet.getInt("time_range_end"));
                    break;
                }
                case 20: {
                    String string = Convert.trimR((String)resultSet.getString("timezone_type"));
                    ScheduleInfo.TimeZoneType timeZoneType = ScheduleJobDMJdbc.this.timezoneType(string, scheduleJobProxy.isSuite(), scheduleJobProxy.isSuiteMember());
                    scheduleJobProxy.setTimezoneType(timeZoneType);
                    break;
                }
                case 21: {
                    scheduleJobProxy.setJobTimezone(Convert.trimR((String)resultSet.getString("timezone")));
                    break;
                }
                case 22: {
                    String string = Convert.trimR((String)resultSet.getString("non_workday_option"));
                    if (string == null || string.isEmpty()) {
                        scheduleJobProxy.setNonWorkdayOption(null);
                        break;
                    }
                    scheduleJobProxy.setNonWorkdayOption(ScheduleInfo.NonWorkdayOption.persistanceCodeToEnum(string));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }

    private class ScheduleJobSuiteGenerator
    extends AbstractBusObjGenerator {
        public ScheduleJobSuiteGenerator() {
            super(79, ScheduleJobDMJdbc.objDesc);
        }

        protected Object constructObject() {
            return new ScheduleJob();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            ScheduleJob scheduleJob = (ScheduleJob)((Object)object);
            switch (n) {
                case 1: {
                    String string = resultSet.getString("name").trim();
                    scheduleJob.setSkybotJobName(string);
                    break;
                }
                case 2: {
                    scheduleJob.setSkybotJobNumber(resultSet.getLong("id"));
                    break;
                }
                case 3: {
                    scheduleJob.setDescription(Convert.trimR((String)resultSet.getString("description")));
                    break;
                }
                case 4: {
                    int n2 = resultSet.getInt("missed_action");
                    scheduleJob.setMissedJobAction(MissedJobAction.persistanceCodeToEnum(n2));
                    break;
                }
                case 5: {
                    int n3 = resultSet.getInt("job_history_purge_option");
                    if (n3 == 0) {
                        scheduleJob.setJobHistoriesToKeep(resultSet.getInt("job_history_runs_to_keep"));
                        break;
                    }
                    scheduleJob.setJobHistoryDaysToKeep(resultSet.getInt("job_history_days_to_keep"));
                    break;
                }
                case 6: {
                    boolean bl = resultSet.getBoolean("copy_joblog_to_server");
                    scheduleJob.setCopyJobLogToServer(bl);
                    break;
                }
                case 7: {
                    short s = resultSet.getShort("overrun_monitor_option");
                    scheduleJob.setOverrunMonitorOption(JobMonitor.MonitorOption.persistanceCodeToEnum(s));
                    break;
                }
                case 8: {
                    int n4 = resultSet.getInt("overrun_time");
                    scheduleJob.setOverrunMaximumMinutes(n4);
                    break;
                }
                case 9: {
                    scheduleJob.setOverrunMonitorSelected(resultSet.getBoolean("overrun_monitor_selected"));
                    break;
                }
                case 10: {
                    int n5 = resultSet.getInt("overrun_completion_time");
                    scheduleJob.setOverrunTargetCompletionTime(n5);
                    break;
                }
                case 11: {
                    scheduleJob.setOverrunSendSNMPTrap(resultSet.getBoolean("overrun_send_snmp_trap"));
                    break;
                }
                case 12: {
                    scheduleJob.setOverrunSendEmail(resultSet.getBoolean("overrun_send_email"));
                    break;
                }
                case 13: {
                    scheduleJob.setOverrunEndJob(resultSet.getBoolean("overrun_end_job"));
                    break;
                }
                case 14: {
                    long l = resultSet.getLong("overrun_notification_list_id");
                    scheduleJob.setOverrunNotificationListID(l);
                    break;
                }
                case 15: {
                    scheduleJob.setUnderrunMonitorSelected(resultSet.getBoolean("underrun_monitor_selected"));
                    break;
                }
                case 16: {
                    int n6 = resultSet.getInt("underrun_time");
                    scheduleJob.setUnderrunMinimumMinutes(n6);
                    break;
                }
                case 17: {
                    scheduleJob.setUnderrunSendSNMPTrap(resultSet.getBoolean("underrun_send_snmp_trap"));
                    break;
                }
                case 18: {
                    scheduleJob.setUnderrunSendEmail(resultSet.getBoolean("underrun_send_email"));
                    break;
                }
                case 19: {
                    long l = resultSet.getLong("underrun_notification_list_id");
                    scheduleJob.setUnderrunNotificationListID(l);
                    break;
                }
                case 20: {
                    scheduleJob.setLateStartMonitorSelected(resultSet.getBoolean("late_start_monitor_selected"));
                    break;
                }
                case 21: {
                    int n7 = resultSet.getInt("late_start_monitor_option");
                    scheduleJob.setLateStartMonitorOption(JobMonitor.MonitorOption.persistanceCodeToEnum(n7));
                    break;
                }
                case 22: {
                    int n8 = resultSet.getInt("late_start_time");
                    scheduleJob.setLateStartMaximumMinutes(n8);
                    break;
                }
                case 23: {
                    int n9 = resultSet.getInt("late_start_start_time");
                    scheduleJob.setLateStartTargetStartTime(n9);
                    break;
                }
                case 24: {
                    scheduleJob.setLateStartSendSNMPTrap(resultSet.getBoolean("late_start_send_snmp_trap"));
                    break;
                }
                case 25: {
                    scheduleJob.setLateStartSendEmail(resultSet.getBoolean("late_start_send_email"));
                    break;
                }
                case 26: {
                    scheduleJob.setLateStartEndJob(resultSet.getBoolean("late_start_end_job"));
                    break;
                }
                case 27: {
                    long l = resultSet.getLong("late_start_notification_list_id");
                    scheduleJob.setLateStartNotificationListID(l);
                    break;
                }
                case 28: {
                    scheduleJob.setSendSubmitSNMPTrap(resultSet.getBoolean("send_submit_snmp_trap"));
                    break;
                }
                case 29: {
                    scheduleJob.setSendSubmitEmail(resultSet.getBoolean("send_submit_email"));
                    break;
                }
                case 30: {
                    long l = resultSet.getLong("submit_notification_list_id");
                    scheduleJob.setSubmitNotificationListID(l);
                    break;
                }
                case 31: {
                    scheduleJob.setSendRunSNMPTrap(resultSet.getBoolean("send_run_snmp_trap"));
                    break;
                }
                case 32: {
                    scheduleJob.setSendRunEmail(resultSet.getBoolean("send_run_email"));
                    break;
                }
                case 33: {
                    long l = resultSet.getLong("run_notification_list_id");
                    scheduleJob.setRunNotificationListID(l);
                    break;
                }
                case 34: {
                    scheduleJob.setSendCompleteSNMPTrap(resultSet.getBoolean("send_complete_snmp_trap"));
                    break;
                }
                case 35: {
                    scheduleJob.setSendCompleteEmail(resultSet.getBoolean("send_complete_email"));
                    break;
                }
                case 36: {
                    long l = resultSet.getLong("complete_notification_list_id");
                    scheduleJob.setCompleteNotificationListID(l);
                    break;
                }
                case 37: {
                    scheduleJob.setSendFailSNMPTrap(resultSet.getBoolean("send_fail_snmp_trap"));
                    break;
                }
                case 38: {
                    scheduleJob.setSendFailEmail(resultSet.getBoolean("send_fail_email"));
                    break;
                }
                case 39: {
                    long l = resultSet.getLong("fail_notification_list_id");
                    scheduleJob.setFailNotificationListID(l);
                    break;
                }
                case 40: {
                    scheduleJob.setSendCancelSNMPTrap(resultSet.getBoolean("send_cancel_snmp_trap"));
                    break;
                }
                case 41: {
                    scheduleJob.setSendCancelEmail(resultSet.getBoolean("send_cancel_email"));
                    break;
                }
                case 42: {
                    long l = resultSet.getLong("cancel_notification_list_id");
                    scheduleJob.setCancelNotificationListID(l);
                    break;
                }
                case 43: {
                    int n10 = resultSet.getInt("hold");
                    scheduleJob.setJobHoldFlag(JobHoldFlag.persistanceCodeToEnum(n10));
                    break;
                }
                case 44: {
                    int n11 = resultSet.getInt("hold_times");
                    scheduleJob.setHoldTimes(n11);
                    break;
                }
                case 45: {
                    int n12 = resultSet.getInt("held_count");
                    scheduleJob.setHeldCount(n12);
                    break;
                }
                case 46: {
                    scheduleJob.setPurgeJobHistory(resultSet.getBoolean("job_history_purge"));
                    break;
                }
                case 47: {
                    scheduleJob.setUseDefaultsForJobHistoryPurge(resultSet.getBoolean("system_defaults_for_job_history_purge"));
                    break;
                }
                case 48: {
                    scheduleJob.setScheduleType(ScheduleJobDMJdbc.this.getScheduleType(scheduleJob.getSkybotJobNumber(), resultSet));
                    break;
                }
                case 49: {
                    int n13 = resultSet.getInt("time_range_start");
                    scheduleJob.setTimeRangeStart(n13);
                    break;
                }
                case 50: {
                    int n14 = resultSet.getInt("time_range_end");
                    scheduleJob.setTimeRangeEnd(n14);
                    break;
                }
                case 51: {
                    JobType jobType = JobType.persistanceCodeToEnum(resultSet.getInt("job_type"));
                    scheduleJob.setJobType(jobType);
                    break;
                }
                case 52: {
                    scheduleJob.setHoldOnFailure(resultSet.getBoolean("hold_on_failure"));
                    break;
                }
                case 53: {
                    scheduleJob.setSkipOnNotCompleted(resultSet.getBoolean("skip_on_not_completed"));
                    break;
                }
                case 54: {
                    scheduleJob.setCalendarID(resultSet.getLong("calendar_id"));
                    break;
                }
                case 55: {
                    String string = resultSet.getString("day_type");
                    if (string != null && string.trim().length() > 0) {
                        scheduleJob.setDayType(CalendarObject.DayType.persistanceCodeToEnum(string));
                        break;
                    }
                    scheduleJob.setDayType(null);
                    break;
                }
                case 56: {
                    scheduleJob.setEmailJobLog(resultSet.getBoolean("email_job_log"));
                    break;
                }
                case 57: {
                    scheduleJob.setEmailNotificationListId(resultSet.getLong("email_notification_list_id"));
                    break;
                }
                case 58: {
                    Calendar calendar = (Calendar)ScheduleJobDMJdbc.this.cloneOnly_GMTCalendar.clone();
                    Timestamp timestamp = resultSet.getTimestamp("hold_until", calendar);
                    if (timestamp != null) {
                        scheduleJob.setHoldUntil(timestamp.getTime());
                        break;
                    }
                    scheduleJob.setHoldUntil(0L);
                    break;
                }
                case 59: {
                    scheduleJob.setGenerateSkippedHistory(resultSet.getBoolean("generate_skipped_history"));
                    break;
                }
                case 60: {
                    scheduleJob.setSendSkipSNMPTrap(resultSet.getBoolean("send_skipped_snmp_trap"));
                    break;
                }
                case 61: {
                    scheduleJob.setSendSkipEmail(resultSet.getBoolean("send_skipped_email"));
                    break;
                }
                case 62: {
                    scheduleJob.setSkipNotificationListID(resultSet.getLong("skipped_notification_list_id"));
                    break;
                }
                case 63: {
                    scheduleJob.setSendMemberFailSNMPTrap(resultSet.getBoolean("send_member_fail_snmp_trap"));
                    break;
                }
                case 64: {
                    scheduleJob.setSendMemberFailEmail(resultSet.getBoolean("send_member_fail_email"));
                    break;
                }
                case 65: {
                    scheduleJob.setMemberFailNotificationListID(resultSet.getLong("member_fail_notification_list_id"));
                    break;
                }
                case 66: {
                    scheduleJob.setSendMemberCancelSNMPTrap(resultSet.getBoolean("send_member_cancel_snmp_trap"));
                    break;
                }
                case 67: {
                    scheduleJob.setSendMemberCancelEmail(resultSet.getBoolean("send_member_cancel_email"));
                    break;
                }
                case 68: {
                    scheduleJob.setMemberCancelNotificationListID(resultSet.getLong("member_cancel_notification_list_id"));
                    break;
                }
                case 69: {
                    scheduleJob.setVariableBaseDate(resultSet.getInt("variable_base_date"));
                    break;
                }
                case 70: {
                    scheduleJob.setSendFailJobLog(resultSet.getBoolean("send_failed_email_log"));
                    break;
                }
                case 71: {
                    scheduleJob.setSendCompleteJobLog(resultSet.getBoolean("send_complete_email_log"));
                    break;
                }
                case 72: {
                    scheduleJob.setSendCancelJobLog(resultSet.getBoolean("send_canceled_email_log"));
                    break;
                }
                case 73: {
                    scheduleJob.setSendMemberFailedEmailLog(resultSet.getBoolean("send_member_failed_email_log"));
                    break;
                }
                case 74: {
                    scheduleJob.setSendMemberCanceledEmailLog(resultSet.getBoolean("send_member_canceled_email_log"));
                    break;
                }
                case 75: {
                    scheduleJob.setAgentEnvironmentType(resultSet.getString("agent_environment_type"));
                    break;
                }
                case 76: {
                    String string = Convert.trimR((String)resultSet.getString("timezone_type"));
                    ScheduleInfo.TimeZoneType timeZoneType = string == null || string.isEmpty() ? ScheduleInfo.TimeZoneType.SERVER : ScheduleInfo.TimeZoneType.persistanceCodeToEnum(string);
                    scheduleJob.setTimezoneType(timeZoneType);
                    break;
                }
                case 77: {
                    scheduleJob.setJobTimezone(Convert.trimR((String)resultSet.getString("timezone")));
                    break;
                }
                case 78: {
                    scheduleJob.setJobParameters(resultSet.getString("job_parameters"));
                    break;
                }
                case 79: {
                    String string = Convert.trimR((String)resultSet.getString("non_workday_option"));
                    if (string == null || string.isEmpty()) {
                        scheduleJob.setNonWorkdayOption(null);
                        break;
                    }
                    scheduleJob.setNonWorkdayOption(ScheduleInfo.NonWorkdayOption.persistanceCodeToEnum(string));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }

    private class ScheduleJobGenerator
    extends AbstractBusObjGenerator {
        public ScheduleJobGenerator() {
            super(91, ScheduleJobDMJdbc.objDesc);
        }

        protected Object constructObject() {
            return new ScheduleJob();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            ScheduleJob scheduleJob = (ScheduleJob)((Object)object);
            switch (n) {
                case 1: {
                    String string = resultSet.getString("name").trim();
                    scheduleJob.setSkybotJobName(string);
                    break;
                }
                case 2: {
                    scheduleJob.setSkybotJobNumber(resultSet.getLong("id"));
                    break;
                }
                case 3: {
                    scheduleJob.setDescription(Convert.trimR((String)resultSet.getString("description")));
                    break;
                }
                case 4: {
                    scheduleJob.setAgentEnvironmentID(resultSet.getLong("agent_environment_id"));
                    break;
                }
                case 5: {
                    long l = resultSet.getLong("command_set_id");
                    if (l <= 0L) break;
                    Connection connection = resultSet.getStatement().getConnection();
                    try {
                        CommandSet commandSet = ScheduleJobDMJdbc.this.commandSetDM.get(l, connection);
                        scheduleJob.setCommandSet(commandSet);
                        break;
                    }
                    catch (Exception exception) {
                        String string = "Error while constructing the Command Set from ID " + l;
                        logger.error((Object)string, (Throwable)exception);
                        throw new RuntimeException(string, exception);
                    }
                }
                case 6: {
                    int n2 = resultSet.getInt("missed_action");
                    scheduleJob.setMissedJobAction(MissedJobAction.persistanceCodeToEnum(n2));
                    break;
                }
                case 7: {
                    int n3 = resultSet.getInt("job_history_purge_option");
                    if (n3 == 0) {
                        scheduleJob.setJobHistoriesToKeep(resultSet.getInt("job_history_runs_to_keep"));
                        break;
                    }
                    scheduleJob.setJobHistoryDaysToKeep(resultSet.getInt("job_history_days_to_keep"));
                    break;
                }
                case 8: {
                    boolean bl = resultSet.getBoolean("copy_joblog_to_server");
                    scheduleJob.setCopyJobLogToServer(bl);
                    break;
                }
                case 9: {
                    short s = resultSet.getShort("overrun_monitor_option");
                    scheduleJob.setOverrunMonitorOption(JobMonitor.MonitorOption.persistanceCodeToEnum(s));
                    break;
                }
                case 10: {
                    int n4 = resultSet.getInt("overrun_time");
                    scheduleJob.setOverrunMaximumMinutes(n4);
                    break;
                }
                case 11: {
                    scheduleJob.setOverrunMonitorSelected(resultSet.getBoolean("overrun_monitor_selected"));
                    break;
                }
                case 12: {
                    int n5 = resultSet.getInt("overrun_completion_time");
                    scheduleJob.setOverrunTargetCompletionTime(n5);
                    break;
                }
                case 13: {
                    scheduleJob.setOverrunSendSNMPTrap(resultSet.getBoolean("overrun_send_snmp_trap"));
                    break;
                }
                case 14: {
                    scheduleJob.setOverrunSendEmail(resultSet.getBoolean("overrun_send_email"));
                    break;
                }
                case 15: {
                    scheduleJob.setOverrunEndJob(resultSet.getBoolean("overrun_end_job"));
                    break;
                }
                case 16: {
                    long l = resultSet.getLong("overrun_notification_list_id");
                    scheduleJob.setOverrunNotificationListID(l);
                    break;
                }
                case 17: {
                    scheduleJob.setUnderrunMonitorSelected(resultSet.getBoolean("underrun_monitor_selected"));
                    break;
                }
                case 18: {
                    int n6 = resultSet.getInt("underrun_time");
                    scheduleJob.setUnderrunMinimumMinutes(n6);
                    break;
                }
                case 19: {
                    scheduleJob.setUnderrunSendSNMPTrap(resultSet.getBoolean("underrun_send_snmp_trap"));
                    break;
                }
                case 20: {
                    scheduleJob.setUnderrunSendEmail(resultSet.getBoolean("underrun_send_email"));
                    break;
                }
                case 21: {
                    long l = resultSet.getLong("underrun_notification_list_id");
                    scheduleJob.setUnderrunNotificationListID(l);
                    break;
                }
                case 22: {
                    scheduleJob.setLateStartMonitorSelected(resultSet.getBoolean("late_start_monitor_selected"));
                    break;
                }
                case 23: {
                    int n7 = resultSet.getInt("late_start_monitor_option");
                    scheduleJob.setLateStartMonitorOption(JobMonitor.MonitorOption.persistanceCodeToEnum(n7));
                    break;
                }
                case 24: {
                    int n8 = resultSet.getInt("late_start_time");
                    scheduleJob.setLateStartMaximumMinutes(n8);
                    break;
                }
                case 25: {
                    int n9 = resultSet.getInt("late_start_start_time");
                    scheduleJob.setLateStartTargetStartTime(n9);
                    break;
                }
                case 26: {
                    scheduleJob.setLateStartSendSNMPTrap(resultSet.getBoolean("late_start_send_snmp_trap"));
                    break;
                }
                case 27: {
                    scheduleJob.setLateStartSendEmail(resultSet.getBoolean("late_start_send_email"));
                    break;
                }
                case 28: {
                    scheduleJob.setLateStartEndJob(resultSet.getBoolean("late_start_end_job"));
                    break;
                }
                case 29: {
                    long l = resultSet.getLong("late_start_notification_list_id");
                    scheduleJob.setLateStartNotificationListID(l);
                    break;
                }
                case 30: {
                    scheduleJob.setSendSubmitSNMPTrap(resultSet.getBoolean("send_submit_snmp_trap"));
                    break;
                }
                case 31: {
                    scheduleJob.setSendSubmitEmail(resultSet.getBoolean("send_submit_email"));
                    break;
                }
                case 32: {
                    long l = resultSet.getLong("submit_notification_list_id");
                    scheduleJob.setSubmitNotificationListID(l);
                    break;
                }
                case 33: {
                    scheduleJob.setSendRunSNMPTrap(resultSet.getBoolean("send_run_snmp_trap"));
                    break;
                }
                case 34: {
                    scheduleJob.setSendRunEmail(resultSet.getBoolean("send_run_email"));
                    break;
                }
                case 35: {
                    long l = resultSet.getLong("run_notification_list_id");
                    scheduleJob.setRunNotificationListID(l);
                    break;
                }
                case 36: {
                    scheduleJob.setSendCompleteSNMPTrap(resultSet.getBoolean("send_complete_snmp_trap"));
                    break;
                }
                case 37: {
                    scheduleJob.setSendCompleteEmail(resultSet.getBoolean("send_complete_email"));
                    break;
                }
                case 38: {
                    long l = resultSet.getLong("complete_notification_list_id");
                    scheduleJob.setCompleteNotificationListID(l);
                    break;
                }
                case 39: {
                    scheduleJob.setSendFailSNMPTrap(resultSet.getBoolean("send_fail_snmp_trap"));
                    break;
                }
                case 40: {
                    scheduleJob.setSendFailEmail(resultSet.getBoolean("send_fail_email"));
                    break;
                }
                case 41: {
                    long l = resultSet.getLong("fail_notification_list_id");
                    scheduleJob.setFailNotificationListID(l);
                    break;
                }
                case 42: {
                    scheduleJob.setSendCancelSNMPTrap(resultSet.getBoolean("send_cancel_snmp_trap"));
                    break;
                }
                case 43: {
                    scheduleJob.setSendCancelEmail(resultSet.getBoolean("send_cancel_email"));
                    break;
                }
                case 44: {
                    long l = resultSet.getLong("cancel_notification_list_id");
                    scheduleJob.setCancelNotificationListID(l);
                    break;
                }
                case 45: {
                    int n10 = resultSet.getInt("hold");
                    scheduleJob.setJobHoldFlag(JobHoldFlag.persistanceCodeToEnum(n10));
                    break;
                }
                case 46: {
                    int n11 = resultSet.getInt("hold_times");
                    scheduleJob.setHoldTimes(n11);
                    break;
                }
                case 47: {
                    int n12 = resultSet.getInt("held_count");
                    scheduleJob.setHeldCount(n12);
                    break;
                }
                case 48: {
                    scheduleJob.setPurgeJobHistory(resultSet.getBoolean("job_history_purge"));
                    break;
                }
                case 49: {
                    scheduleJob.setUseDefaultsForJobHistoryPurge(resultSet.getBoolean("system_defaults_for_job_history_purge"));
                    break;
                }
                case 50: {
                    scheduleJob.setScheduleType(ScheduleJobDMJdbc.this.getScheduleType(scheduleJob.getSkybotJobNumber(), resultSet));
                    break;
                }
                case 51: {
                    int n13 = resultSet.getInt("time_range_start");
                    scheduleJob.setTimeRangeStart(n13);
                    break;
                }
                case 52: {
                    int n14 = resultSet.getInt("time_range_end");
                    scheduleJob.setTimeRangeEnd(n14);
                    break;
                }
                case 53: {
                    JobType jobType = JobType.persistanceCodeToEnum(resultSet.getInt("job_type"));
                    scheduleJob.setJobType(jobType);
                    break;
                }
                case 54: {
                    if (scheduleJob.isSuite()) break;
                    scheduleJob.setTargetId(resultSet.getLong("target_id"));
                    ScheduleInfo.TargetType targetType = ScheduleInfo.TargetType.persistanceCodeToEnum(resultSet.getString("target_type"));
                    scheduleJob.setTargetType(targetType);
                    int n15 = resultSet.getInt("target_id");
                    if (targetType == ScheduleInfo.TargetType.AGENT_GROUP) {
                        scheduleJob.setModel(n15);
                        break;
                    }
                    scheduleJob.setSystem(n15);
                    break;
                }
                case 55: {
                    scheduleJob.setHoldOnFailure(resultSet.getBoolean("hold_on_failure"));
                    break;
                }
                case 56: {
                    scheduleJob.setSkipOnNotCompleted(resultSet.getBoolean("skip_on_not_completed"));
                    break;
                }
                case 57: {
                    scheduleJob.setCalendarID(resultSet.getLong("calendar_id"));
                    break;
                }
                case 58: {
                    String string = resultSet.getString("day_type");
                    if (string != null && string.trim().length() > 0) {
                        scheduleJob.setDayType(CalendarObject.DayType.persistanceCodeToEnum(string));
                        break;
                    }
                    scheduleJob.setDayType(null);
                    break;
                }
                case 59: {
                    scheduleJob.setConditional(resultSet.getBoolean("conditional"));
                    break;
                }
                case 60: {
                    scheduleJob.setCondRetry(resultSet.getBoolean("cond_retry"));
                    break;
                }
                case 61: {
                    scheduleJob.setCondRetryDelay(resultSet.getInt("cond_retry_delay"));
                    break;
                }
                case 62: {
                    scheduleJob.setCondRetryCount(resultSet.getInt("cond_retry_count"));
                    break;
                }
                case 63: {
                    scheduleJob.setConditionFailStatus(resultSet.getInt("condition_fail_status"));
                    break;
                }
                case 64: {
                    break;
                }
                case 65: {
                    scheduleJob.setEmailJobLog(resultSet.getBoolean("email_job_log"));
                    break;
                }
                case 66: {
                    scheduleJob.setEmailNotificationListId(resultSet.getLong("email_notification_list_id"));
                    break;
                }
                case 67: {
                    scheduleJob.setSendRetryWaitSNMPTrap(resultSet.getBoolean("send_retry_wait_snmp_trap"));
                    break;
                }
                case 68: {
                    scheduleJob.setSendRetryWaitEmail(resultSet.getBoolean("send_retry_wait_email"));
                    break;
                }
                case 69: {
                    long l = resultSet.getLong("retry_wait_notification_list_id");
                    scheduleJob.setRetryWaitNotificationListID(l);
                    break;
                }
                case 70: {
                    Calendar calendar = (Calendar)ScheduleJobDMJdbc.this.cloneOnly_GMTCalendar.clone();
                    Timestamp timestamp = resultSet.getTimestamp("hold_until", calendar);
                    if (timestamp != null) {
                        scheduleJob.setHoldUntil(timestamp.getTime());
                        break;
                    }
                    scheduleJob.setHoldUntil(0L);
                    break;
                }
                case 71: {
                    String string = Convert.trimR((String)resultSet.getString("timezone_type"));
                    ScheduleInfo.TimeZoneType timeZoneType = ScheduleJobDMJdbc.this.timezoneType(string, scheduleJob.isSuite(), scheduleJob.isSuiteMember());
                    scheduleJob.setTimezoneType(timeZoneType);
                    break;
                }
                case 72: {
                    scheduleJob.setGenerateSkippedHistory(resultSet.getBoolean("generate_skipped_history"));
                    break;
                }
                case 73: {
                    int n16 = resultSet.getInt("default_priority");
                    scheduleJob.setDefaultPriority(n16);
                    break;
                }
                case 74: {
                    scheduleJob.setSendSkipSNMPTrap(resultSet.getBoolean("send_skipped_snmp_trap"));
                    break;
                }
                case 75: {
                    scheduleJob.setSendSkipEmail(resultSet.getBoolean("send_skipped_email"));
                    break;
                }
                case 76: {
                    scheduleJob.setSkipNotificationListID(resultSet.getLong("skipped_notification_list_id"));
                    break;
                }
                case 77: {
                    scheduleJob.setVariableBaseDate(resultSet.getInt("variable_base_date"));
                    break;
                }
                case 78: {
                    scheduleJob.setEmailSubjectRunning(resultSet.getString("email_subject_running"));
                    break;
                }
                case 79: {
                    scheduleJob.setEmailBodyRunning(resultSet.getString("email_body_running"));
                    break;
                }
                case 80: {
                    scheduleJob.setSendFailJobLog(resultSet.getBoolean("send_failed_email_log"));
                    break;
                }
                case 81: {
                    scheduleJob.setSendCompleteJobLog(resultSet.getBoolean("send_complete_email_log"));
                    break;
                }
                case 82: {
                    scheduleJob.setSendCancelJobLog(resultSet.getBoolean("send_canceled_email_log"));
                    break;
                }
                case 83: {
                    scheduleJob.setSendMemberFailedEmailLog(resultSet.getBoolean("send_member_failed_email_log"));
                    break;
                }
                case 84: {
                    scheduleJob.setSendMemberCanceledEmailLog(resultSet.getBoolean("send_member_canceled_email_log"));
                    break;
                }
                case 85: {
                    scheduleJob.setAgentEnvironmentType(resultSet.getString("agent_environment_type"));
                    break;
                }
                case 86: {
                    scheduleJob.setIBMiJobName(resultSet.getString("ibmi_job_name"));
                    break;
                }
                case 87: {
                    if (scheduleJob.isSuite()) break;
                    scheduleJob.setJobQueueID(resultSet.getLong("job_queue_id"));
                    break;
                }
                case 88: {
                    if (scheduleJob.isSuite()) break;
                    scheduleJob.setJobQueueName(resultSet.getString("job_queue_name"));
                    break;
                }
                case 89: {
                    scheduleJob.setJobTimezone(Convert.trimR((String)resultSet.getString("timezone")));
                    break;
                }
                case 90: {
                    scheduleJob.setJobParameters(resultSet.getString("job_parameters"));
                    break;
                }
                case 91: {
                    String string = Convert.trimR((String)resultSet.getString("non_workday_option"));
                    if (string == null || string.isEmpty()) {
                        scheduleJob.setNonWorkdayOption(null);
                        break;
                    }
                    scheduleJob.setNonWorkdayOption(ScheduleInfo.NonWorkdayOption.persistanceCodeToEnum(string));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }
}

