/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.jdbc;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.DayOfWeekTimestampFilter;
import com.helpsystems.enterprise.core.busobj.ReactivityDays;
import com.helpsystems.enterprise.core.busobj.TimeHelper;
import com.helpsystems.enterprise.core.busobj.WindowEndOption;
import com.helpsystems.enterprise.core.busobj.WindowStartOption;
import com.helpsystems.enterprise.core.dm.ReactivityDaysDM;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class ReactivityDaysDMJdbc
extends AbstractDatabaseManager
implements ReactivityDaysDM {
    private static final String description = "Reactivity Days";
    private String table;
    ReactivityDaysGenerator boGenerator = new ReactivityDaysGenerator();

    public ReactivityDaysDMJdbc(String string, String string2) throws ResourceUnavailableException {
        super(string);
        this.table = string2 + "." + "REACTIVITY_DAYS";
        this.setName("ENTERPRISE.ReactivityDaysDM");
    }

    private String getSql() {
        return "SELECT id, job_id, runcode_mon, runcode_tue, runcode_wed, runcode_thu, runcode_fri, runcode_sat, runcode_sun, react_after, react_before, react_after_option, react_before_option  FROM " + this.table;
    }

    @Override
    public ReactivityDays[] get(long l) throws ResourceUnavailableException, DataException {
        String string = this.getSql() + " where job_id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            ReactivityDays[] reactivityDaysArray;
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            ArrayList<ReactivityDays[]> arrayList = new ArrayList<ReactivityDays[]>();
            while (resultSet.next()) {
                reactivityDaysArray = (ReactivityDays[])this.boGenerator.generateObject(resultSet);
                arrayList.add(reactivityDaysArray);
            }
            if (arrayList.size() > 1) {
                throw new IllegalArgumentException("More than one object was loaded for Job ID " + l);
            }
            reactivityDaysArray = new ReactivityDays[]{};
            ReactivityDays[] reactivityDaysArray2 = reactivityDaysArray = arrayList.toArray(reactivityDaysArray);
            return reactivityDaysArray2;
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for id {1}.", (Object[])new Object[]{description, Long.toString(l)});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    private class ReactivityDaysGenerator
    extends AbstractBusObjGenerator {
        public ReactivityDaysGenerator() {
            super(13, ReactivityDaysDMJdbc.description);
        }

        protected Object constructObject() {
            return new ReactivityDays();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            ReactivityDays reactivityDays = (ReactivityDays)object;
            switch (n) {
                case 1: {
                    reactivityDays.setId(resultSet.getLong("id"));
                    break;
                }
                case 2: {
                    reactivityDays.setJobID(resultSet.getLong("job_id"));
                    break;
                }
                case 3: {
                    reactivityDays.setDayOption_Mon(DayOfWeekTimestampFilter.DayOption.persistanceCodeToEnum(resultSet.getString("runcode_mon")));
                    break;
                }
                case 4: {
                    reactivityDays.setDayOption_Tue(DayOfWeekTimestampFilter.DayOption.persistanceCodeToEnum(resultSet.getString("runcode_tue")));
                    break;
                }
                case 5: {
                    reactivityDays.setDayOption_Wed(DayOfWeekTimestampFilter.DayOption.persistanceCodeToEnum(resultSet.getString("runcode_wed")));
                    break;
                }
                case 6: {
                    reactivityDays.setDayOption_Thu(DayOfWeekTimestampFilter.DayOption.persistanceCodeToEnum(resultSet.getString("runcode_thu")));
                    break;
                }
                case 7: {
                    reactivityDays.setDayOption_Fri(DayOfWeekTimestampFilter.DayOption.persistanceCodeToEnum(resultSet.getString("runcode_fri")));
                    break;
                }
                case 8: {
                    reactivityDays.setDayOption_Sat(DayOfWeekTimestampFilter.DayOption.persistanceCodeToEnum(resultSet.getString("runcode_sat")));
                    break;
                }
                case 9: {
                    reactivityDays.setDayOption_Sun(DayOfWeekTimestampFilter.DayOption.persistanceCodeToEnum(resultSet.getString("runcode_sun")));
                    break;
                }
                case 10: {
                    reactivityDays.setStartTime(resultSet.getInt("react_after"));
                    break;
                }
                case 11: {
                    reactivityDays.setEndTime(resultSet.getInt("react_before"));
                    if (!resultSet.wasNull()) break;
                    reactivityDays.setEndTime(TimeHelper.END_OF_DAY_TIME);
                    break;
                }
                case 12: {
                    int n2 = resultSet.getInt("react_after_option");
                    reactivityDays.setStartOption(WindowStartOption.persistanceCodeToEnum(n2));
                    break;
                }
                case 13: {
                    int n3 = resultSet.getInt("react_before_option");
                    reactivityDays.setEndOption(WindowEndOption.persistanceCodeToEnum(n3));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }
}

