/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.jdbc;

import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.core.busobj.RecordActionType;
import com.helpsystems.enterprise.core.dm.JobStartEndRollupDM;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.util.DateConverter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class JobStartEndRollupDMJdbc
extends AbstractHelpingDatabaseManager
implements JobStartEndRollupDM {
    private static final String TABLE = "job_start_end_rollups";
    private static final Logger logger = Logger.getLogger(JobStartEndRollupDMJdbc.class);
    private Object lockObject = new Object();

    public JobStartEndRollupDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper) throws ResourceUnavailableException {
        super(string, string2, sQLManagerHelper);
        this.setName("ENTERPRISE.JobStartEndRollupDM");
    }

    @Override
    public void saveStartCount(long l) throws ResourceUnavailableException, DataException {
        String string = "start_count";
        this.updateInsertRow(l, string);
    }

    @Override
    public void saveSubmitCount(long l) throws ResourceUnavailableException, DataException {
        String string = "submit_count";
        this.updateInsertRow(l, string);
    }

    @Override
    public void saveEndCount(long l) throws ResourceUnavailableException, DataException {
        String string = "end_count";
        this.updateInsertRow(l, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateInsertRow(long l, String string) {
        long l2 = DateConverter.calculateTime(l);
        Object object = this.lockObject;
        synchronized (object) {
            RecordActionType recordActionType = this.getCurrentRowAction(l2);
            if (recordActionType == RecordActionType.UPDATE) {
                this.updateRow(l2, string);
            } else if (recordActionType == RecordActionType.INSERT) {
                this.insertRow(l2, string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private RecordActionType getCurrentRowAction(long l) {
        RecordActionType recordActionType = RecordActionType.IGNORE;
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            String string = "SELECT 1 FROM job_start_end_rollups WHERE chunk_start_time = ?";
            wrappedConnection = this.getConnectionOrFail();
            preparedStatement = wrappedConnection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            recordActionType = resultSet.next() ? RecordActionType.UPDATE : RecordActionType.INSERT;
            if (wrappedConnection == null) return recordActionType;
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)"Error Getting Connection ", (Throwable)resourceUnavailableException);
            if (wrappedConnection == null) return recordActionType;
            JobStartEndRollupDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
            return recordActionType;
        }
        catch (SQLException sQLException) {
            logger.error((Object)"Error Selecting Job Start And End Data for specified time", (Throwable)sQLException);
            if (wrappedConnection == null) return recordActionType;
            {
                catch (Throwable throwable) {
                    if (wrappedConnection == null) throw throwable;
                    JobStartEndRollupDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, resultSet);
                    throw throwable;
                }
            }
            JobStartEndRollupDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
            return recordActionType;
        }
        JobStartEndRollupDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
        return recordActionType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateRow(long l, String string) {
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        try {
            wrappedConnection = this.getConnectionOrFail();
            String string2 = "UPDATE job_start_end_rollups SET " + string + " = " + string + " + 1 " + "WHERE chunk_start_time = ?";
            preparedStatement = wrappedConnection.prepareStatement(string2);
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            if (wrappedConnection == null) return;
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)"Error Getting Connection ", (Throwable)resourceUnavailableException);
            return;
        }
        catch (SQLException sQLException) {
            logger.error((Object)"Error Updating Job Start And End Data for specified time", (Throwable)sQLException);
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (wrappedConnection != null) {
                JobStartEndRollupDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, null);
            }
        }
        JobStartEndRollupDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void insertRow(long l, String string) {
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        String string2 = null;
        PreparedStatement preparedStatement = null;
        try {
            string2 = "INSERT INTO job_start_end_rollups (chunk_start_time," + string + ") values (?, 1)";
            wrappedConnection = this.getConnectionOrFail();
            preparedStatement = wrappedConnection.prepareStatement(string2);
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
            if (wrappedConnection == null) return;
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)"Error Getting Connection ", (Throwable)resourceUnavailableException);
            return;
        }
        catch (SQLException sQLException) {
            logger.error((Object)"Error Inserting to Job Start And End Data ", (Throwable)sQLException);
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (wrappedConnection != null) {
                JobStartEndRollupDMJdbc.closeEm(wrappedConnection, preparedStatement, null);
            }
        }
        JobStartEndRollupDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void manualJobStartEndPurge(long l) throws ResourceUnavailableException, DataException {
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        try {
            long l2 = DateConverter.getCompDay(l);
            logger.debug((Object)("Purging Job Start And End Rollup older than: " + ScheduleLogger.formatTimeStamp(l2)));
            wrappedConnection = this.getConnectionOrFail();
            String string = "DELETE FROM job_start_end_rollups WHERE chunk_start_time < ?";
            preparedStatement = wrappedConnection.prepareStatement(string);
            preparedStatement.setLong(1, l2);
            preparedStatement.executeUpdate();
            if (wrappedConnection == null) return;
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)"Error Getting Connection ", (Throwable)resourceUnavailableException);
            return;
        }
        catch (SQLException sQLException) {
            logger.error((Object)"Error Deleting from Job Start And End table", (Throwable)sQLException);
            return;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (wrappedConnection != null) {
                JobStartEndRollupDMJdbc.closeEm(wrappedConnection, preparedStatement, null);
            }
        }
        JobStartEndRollupDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        return;
    }
}

