/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.jdbc;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.JobHistory;
import com.helpsystems.enterprise.core.busobj.JobMonitor;
import com.helpsystems.enterprise.core.dm.JobMonitorDM;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class JobMonitorDMJdbc
extends AbstractHelpingDatabaseManager
implements JobMonitorDM {
    private static Logger logger = Logger.getLogger(JobMonitorDMJdbc.class);
    private static final String objDesc = "JobMonitor";

    public JobMonitorDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper) {
        super(string, string2, sQLManagerHelper);
        this.setName("ENTERPRISE.JobMonitorDM");
    }

    @Override
    public int delete(JobMonitor jobMonitor) throws DataException, ResourceUnavailableException {
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        int n = 0;
        try {
            wrappedConnection = this.getConnectionOrFail();
            String string = null;
            long l = 0L;
            if (jobMonitor.getJobSuiteHistoryID() != 0L) {
                string = "and job_suite_history_id = ?";
                l = jobMonitor.getJobSuiteHistoryID();
            } else {
                string = "and scheduled_time_utc = ?";
                l = jobMonitor.getScheduledTime();
            }
            String string2 = "delete from job_monitors where job_id = ? and agent_id = ? " + string + " and monitor_type=?";
            logger.trace((Object)("JobMonitorDM.delete sql: " + string2));
            preparedStatement = wrappedConnection.prepareStatement(string2);
            preparedStatement.setLong(1, jobMonitor.getJobID());
            preparedStatement.setLong(2, jobMonitor.getAgentID());
            preparedStatement.setLong(3, l);
            preparedStatement.setInt(4, jobMonitor.getMonitorTypeAsInt());
            n = preparedStatement.executeUpdate();
            logger.debug((Object)("Total " + jobMonitor.getMonitorType().name() + " Job Monitors deleted = " + n));
        }
        catch (SQLException sQLException) {
            try {
                throw new ResourceUnavailableException("Unable to delete job monitor record", (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                JobMonitorDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, null);
                throw throwable;
            }
        }
        JobMonitorDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        return n;
    }

    @Override
    public void deleteAllJobMonitorsForJobHistoryID(long l) throws DataException, ResourceUnavailableException {
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        try {
            wrappedConnection = this.getConnectionOrFail();
            preparedStatement = wrappedConnection.prepareStatement("delete from job_monitors where job_history_id = ? or (job_history_id = 0 and job_suite_history_id = ?)");
            preparedStatement.setLong(1, l);
            preparedStatement.setLong(2, l);
            int n = preparedStatement.executeUpdate();
            logger.debug((Object)("Total Job Monitors deleted for jobHistoryID " + l + " = " + n));
        }
        catch (SQLException sQLException) {
            try {
                throw new ResourceUnavailableException("Unable to delete job monitor records for jobHistoryID " + l, (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                JobMonitorDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, null);
                throw throwable;
            }
        }
        JobMonitorDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
    }

    @Override
    public void deleteAllJobMonitorsForJobID(long l) throws DataException, ResourceUnavailableException {
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        try {
            wrappedConnection = this.getConnectionOrFail();
            preparedStatement = wrappedConnection.prepareStatement("delete from job_monitors where job_id = ? ");
            preparedStatement.setLong(1, l);
            int n = preparedStatement.executeUpdate();
            logger.debug((Object)("Total Job Monitors deleted for jobID " + l + " = " + n));
        }
        catch (SQLException sQLException) {
            try {
                throw new ResourceUnavailableException("Unable to delete job monitor records for jobID " + l, (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                JobMonitorDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, null);
                throw throwable;
            }
        }
        JobMonitorDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
    }

    @Override
    public void deleteAllNonQueuedLateStartJMs(long l, Long l2) throws DataException, ResourceUnavailableException {
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        try {
            wrappedConnection = this.getConnectionOrFail();
            preparedStatement = wrappedConnection.prepareStatement("delete from job_monitors where job_id = ? and agent_id = ? and monitor_type = 3 AND job_history_id = 0");
            preparedStatement.setLong(1, l);
            preparedStatement.setLong(2, l2);
            int n = preparedStatement.executeUpdate();
            logger.debug((Object)("Total non-queued Late Start job monitors deleted for jobID " + l + " and agentID " + l2 + " = " + n));
        }
        catch (SQLException sQLException) {
            try {
                throw new ResourceUnavailableException("Unable to delete non-queued late start job monitor records for jobID " + l + " and agentID " + l2, (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                JobMonitorDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, null);
                throw throwable;
            }
        }
        JobMonitorDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
    }

    @Override
    public void deleteAllLateStartJMs(long l) throws DataException, ResourceUnavailableException {
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        try {
            wrappedConnection = this.getConnectionOrFail();
            preparedStatement = wrappedConnection.prepareStatement("delete from job_monitors where job_id = ? and monitor_type = 3");
            preparedStatement.setLong(1, l);
            int n = preparedStatement.executeUpdate();
            logger.debug((Object)("Total Late Start Job Monitors deleted for jobID " + l + " = " + n));
        }
        catch (SQLException sQLException) {
            try {
                throw new ResourceUnavailableException("Unable to delete late start job monitor records for jobID " + l, (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                JobMonitorDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, null);
                throw throwable;
            }
        }
        JobMonitorDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
    }

    @Override
    public void deleteAllNonQueuedLateStartJMs(long l) throws DataException, ResourceUnavailableException {
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        try {
            wrappedConnection = this.getConnectionOrFail();
            preparedStatement = wrappedConnection.prepareStatement("delete from job_monitors where job_id = ? and monitor_type = 3 AND job_history_id = 0");
            preparedStatement.setLong(1, l);
            int n = preparedStatement.executeUpdate();
            logger.debug((Object)("Total non-queued Late Start job monitors deleted for jobID " + l + " = " + n));
        }
        catch (SQLException sQLException) {
            try {
                throw new ResourceUnavailableException("Unable to delete non-queued late start job monitor records for jobID " + l, (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                JobMonitorDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, null);
                throw throwable;
            }
        }
        JobMonitorDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
    }

    @Override
    public int updateAgentOnLateStart(long l, long l2, long l3) throws ResourceUnavailableException {
        String string = "UPDATE job_monitors SET agent_id=? WHERE job_history_id=0 AND job_id=? AND agent_id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l3);
            preparedStatement.setLong(2, l);
            preparedStatement.setLong(3, l2);
            int n = preparedStatement.executeUpdate();
            String string2 = MessageUtil.formatMsg((String)"The Job Monitor record for jobID {0}, agentID {1}, was updated with new agentID {2}", (Object[])new Object[]{l, l2, l3});
            if (n < 1) {
                string2 = MessageUtil.formatMsg((String)"The Job Monitor record for jobID {0}, agentID {1} was not found.", (Object[])new Object[]{l, l2});
            } else if (n > 1) {
                string2 = MessageUtil.formatMsg((String)"Program error: More than 1 Job Monitor record was updated (jobID= {0}, agentID= {1}", (Object[])new Object[]{l, l2});
            }
            logger.debug((Object)string2);
            int n2 = n;
            return n2;
        }
        catch (SQLException sQLException) {
            String string3 = MessageUtil.formatMsg((String)"SQL error while updating the {0} information for jobID {1}, agentID {2}.", (Object[])new Object[]{objDesc, l, l2});
            logger.error((Object)string3, (Throwable)sQLException);
            throw new ResourceUnavailableException(string3, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public long getMonitorTime(long l, long l2, long l3) throws DataException, ResourceUnavailableException {
        long l4 = 0L;
        String string = "SELECT monitor_time_utc FROM job_monitors WHERE job_id=? AND agent_id=? AND scheduled_time_utc=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            preparedStatement.setLong(2, l2);
            preparedStatement.setLong(3, l3);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                l4 = resultSet.getLong("monitor_time_utc");
            }
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} objects from the table {1}.", (Object[])new Object[]{objDesc, "job_monitors"});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return l4;
    }

    @Override
    public JobMonitor[] get(long l) throws DataException, ResourceUnavailableException {
        ArrayList<JobMonitor> arrayList = new ArrayList<JobMonitor>();
        JobMonitorGenerator jobMonitorGenerator = new JobMonitorGenerator();
        String string = "SELECT job_id, agent_id, scheduled_time_utc, monitor_time_utc, monitor_type, monitor_option, start_time_utc, job_history_id, job_suite_history_id FROM job_monitors WHERE job_history_id = ?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                JobMonitor jobMonitor = (JobMonitor)((Object)jobMonitorGenerator.generateObject(resultSet));
                arrayList.add(jobMonitor);
            }
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} objects from the table {1}.", (Object[])new Object[]{objDesc, "job_monitors"});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return arrayList.toArray(new JobMonitor[arrayList.size()]);
    }

    @Override
    public JobMonitor[] getNonQueuedLSJMs(long l) throws DataException, ResourceUnavailableException {
        ArrayList<JobMonitor> arrayList = new ArrayList<JobMonitor>();
        JobMonitorGenerator jobMonitorGenerator = new JobMonitorGenerator();
        String string = "SELECT job_id, agent_id, scheduled_time_utc, monitor_time_utc, monitor_type, monitor_option, start_time_utc, job_history_id, job_suite_history_id FROM job_monitors WHERE job_id = ? and monitor_type = 3 and job_history_id = ?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            preparedStatement.setLong(2, 0L);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                JobMonitor jobMonitor = (JobMonitor)((Object)jobMonitorGenerator.generateObject(resultSet));
                arrayList.add(jobMonitor);
            }
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the next job monitor from the table {0}.", (Object[])new Object[]{"job_monitors"});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return arrayList.toArray(new JobMonitor[arrayList.size()]);
    }

    @Override
    public JobMonitor getNext() throws DataException, ResourceUnavailableException {
        JobMonitorGenerator jobMonitorGenerator = new JobMonitorGenerator();
        String string = "SELECT job_id, agent_id, scheduled_time_utc, monitor_time_utc, monitor_type, monitor_option, start_time_utc, job_history_id, job_suite_history_id FROM job_monitors ORDER BY monitor_time_utc";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                JobMonitor jobMonitor;
                JobMonitor jobMonitor2 = jobMonitor = (JobMonitor)((Object)jobMonitorGenerator.generateObject(resultSet));
                return jobMonitor2;
            }
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the next job monitor from the table {0}.", (Object[])new Object[]{"job_monitors"});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return new JobMonitor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(JobMonitor jobMonitor) throws DataException, ResourceUnavailableException {
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        try {
            wrappedConnection = this.getConnection();
            super.save((Connection)wrappedConnection, (Object)jobMonitor);
            logger.trace((Object)("JobMonitor saved for jobID " + jobMonitor.getJobID() + "(" + jobMonitor.getJobHistoryID() + ")."));
        }
        catch (SQLException sQLException) {
            logger.error((Object)"error on JobMonitorDM.save ", (Throwable)sQLException);
        }
        finally {
            JobMonitorDMJdbc.closeEm((Connection)wrappedConnection, null, null);
        }
    }

    @Override
    public int updateTimes(long l, long l2, long l3, long l4, long l5) throws DataException, ResourceUnavailableException {
        String string = "UPDATE job_monitors SET scheduled_time_utc=?, monitor_time_utc=? WHERE job_id=? AND agent_id=? AND scheduled_time_utc=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        String string2 = String.valueOf(l3);
        try {
            preparedStatement.setLong(1, l4);
            preparedStatement.setLong(2, l5);
            preparedStatement.setLong(3, l);
            preparedStatement.setLong(4, l2);
            preparedStatement.setLong(5, l3);
            int n = preparedStatement.executeUpdate();
            string2 = ScheduleLogger.formatTimeStampSecs(l3);
            String string3 = ScheduleLogger.formatTimeStampSecs(l4);
            String string4 = ScheduleLogger.formatTimeStampSecs(l5);
            String string5 = MessageUtil.formatMsg((String)"The Job Monitor record for jobID {0}, agentID {1}, scheduledTime {2} was updated with new scheduledTime {3} and monitorTime {4}.", (Object[])new Object[]{l, l2, string2, string3, string4});
            if (n < 1) {
                string5 = MessageUtil.formatMsg((String)"The Job Monitor record for jobID {0}, agentID {1}, scheduledTime {2} was not found.", (Object[])new Object[]{l, l2, string2});
            } else if (n > 1) {
                string5 = MessageUtil.formatMsg((String)"Program error: More than 1 Job Monitor record was updated (jobID= {0}, agentID= {1}, scheduledTime= {2}.", (Object[])new Object[]{l, l2, string2});
            }
            logger.debug((Object)string5);
            int n2 = n;
            return n2;
        }
        catch (SQLException sQLException) {
            String string6 = MessageUtil.formatMsg((String)"SQL error while updating the {0} information for jobID {1}, agentID {2}, scheduledTime {3}.", (Object[])new Object[]{objDesc, l, l2, string2});
            logger.error((Object)string6, (Throwable)sQLException);
            throw new ResourceUnavailableException(string6, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    private JobMonitor getLateStartJM(JobHistory jobHistory) throws DataException, ResourceUnavailableException {
        JobMonitor jobMonitor = null;
        JobMonitorGenerator jobMonitorGenerator = new JobMonitorGenerator();
        String string = "SELECT job_id, agent_id, scheduled_time_utc, monitor_time_utc, monitor_type, monitor_option, start_time_utc, job_history_id, job_suite_history_id FROM job_monitors WHERE job_id=? AND agent_id=?";
        long l = 0L;
        if (jobHistory.isJobSuiteMember()) {
            string = string + " AND job_suite_history_id=?";
            l = jobHistory.getJobSuiteHistoryID();
        } else {
            string = string + " AND scheduled_time_utc=?";
            l = jobHistory.getScheduledTime();
        }
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, jobHistory.getJobID());
            preparedStatement.setLong(2, jobHistory.getAgentID());
            preparedStatement.setLong(3, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                JobMonitor jobMonitor2 = jobMonitor = (JobMonitor)((Object)jobMonitorGenerator.generateObject(resultSet));
                return jobMonitor2;
            }
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving a job monitor from the table {0}.", (Object[])new Object[]{"job_monitors"});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return jobMonitor;
    }

    @Override
    public JobMonitor addJobHistoryID(JobHistory jobHistory) throws DataException, ResourceUnavailableException {
        if (jobHistory.isJobSuiteMember()) {
            return this.addSuiteMemberHistoryID(jobHistory);
        }
        return this.addNormalJobHistoryID(jobHistory);
    }

    private JobMonitor addSuiteMemberHistoryID(JobHistory jobHistory) throws DataException, ResourceUnavailableException {
        PreparedStatement preparedStatement;
        PreparedStatement preparedStatement2;
        JobMonitor jobMonitor;
        int n;
        block13: {
            n = 0;
            jobMonitor = null;
            String string = "UPDATE job_monitors t1 SET job_history_id=? FROM (SELECT id FROM job_monitors WHERE job_id=? AND agent_id=? AND job_suite_history_id=? AND job_history_id=0 OR job_history_id IS NULL LIMIT 1 FOR UPDATE) sub WHERE t1.id = sub.id";
            preparedStatement2 = this.getDefaultPreparedStmt(string);
            String string2 = "UPDATE job_monitors t1 SET job_history_id=?, agent_id=? FROM (SELECT id FROM job_monitors WHERE job_id=? AND agent_id=0 AND job_suite_history_id=? AND job_history_id=0 OR job_history_id IS NULL LIMIT 1 FOR UPDATE) sub WHERE t1.id = sub.id";
            preparedStatement = null;
            long l = jobHistory.getId();
            long l2 = jobHistory.getJobID();
            long l3 = jobHistory.getAgentID();
            long l4 = jobHistory.getJobSuiteHistoryID();
            try {
                preparedStatement2.setLong(1, l);
                preparedStatement2.setLong(2, l2);
                preparedStatement2.setLong(3, l3);
                preparedStatement2.setLong(4, l4);
                n = preparedStatement2.executeUpdate();
                if (n < 1) {
                    String string3 = MessageUtil.formatMsg((String)"The Job Suite Member Monitor record with Job Suite Member ID: {0}, agentID: {1}, and Job Suite History ID: {2} was not found.", (Object[])new Object[]{l2, l3, l4});
                    logger.debug((Object)string3);
                    preparedStatement = this.getDefaultPreparedStmt(string2);
                    preparedStatement.setLong(1, l);
                    preparedStatement.setLong(2, l3);
                    preparedStatement.setLong(3, l2);
                    preparedStatement.setLong(4, l4);
                    n = preparedStatement.executeUpdate();
                    if (n == 0) {
                        string3 = MessageUtil.formatMsg((String)"The Job Suite Member Monitor record for Job Suite Member ID: {0}, agentID: zero, and Job Suite History ID: {1} was not found.", (Object[])new Object[]{l2, l4});
                        logger.debug((Object)string3);
                    } else if (n > 1) {
                        string3 = MessageUtil.formatMsg((String)"Program error: More than 1 Job Monitor record was updated (jobID= {0}, agentID=zero, jobSuiteHistoryID= {1}.", (Object[])new Object[]{l2, l4});
                        logger.error((Object)string3);
                    } else {
                        string3 = MessageUtil.formatMsg((String)"The Job Suite Member Monitor record with Job Suite Member ID: {0}, agentID: zero, and Job Suite History ID: {1} was updated with Agent ID:{2} and Job History ID: {3}", (Object[])new Object[]{l2, l4, l3, l});
                        logger.debug((Object)string3);
                    }
                    break block13;
                }
                if (n > 1) {
                    String string4 = MessageUtil.formatMsg((String)"Program error: More than 1 Job Monitor record was updated (jobID= {0}, agentID= {1}, jobSuiteHistoryID= {2}.", (Object[])new Object[]{l2, l3, l4});
                    logger.debug((Object)string4);
                    break block13;
                }
                String string5 = MessageUtil.formatMsg((String)"The Job Suite Member Monitor record with Job Suite Member ID: {0}, agentID: {1}, and Job Suite History ID: {2} was updated with Job History ID: {3}", (Object[])new Object[]{l2, l3, l4, l});
                logger.debug((Object)string5);
            }
            catch (SQLException sQLException) {
                try {
                    String string6 = MessageUtil.formatMsg((String)"SQL error while updating the {0} information for jobID: {1}, agentID: {2}, jobSuiteHistoryID: {3}.", (Object[])new Object[]{objDesc, l2, l3, l4});
                    logger.error((Object)string6, (Throwable)sQLException);
                    throw new ResourceUnavailableException(string6, (Throwable)sQLException);
                }
                catch (Throwable throwable) {
                    this.closeConnection(preparedStatement2);
                    if (preparedStatement != null) {
                        this.closeConnection(preparedStatement);
                    }
                    throw throwable;
                }
            }
        }
        this.closeConnection(preparedStatement2);
        if (preparedStatement != null) {
            this.closeConnection(preparedStatement);
        }
        if (n == 1) {
            jobMonitor = this.getLateStartJM(jobHistory);
        }
        return jobMonitor;
    }

    private JobMonitor addNormalJobHistoryID(JobHistory jobHistory) throws DataException, ResourceUnavailableException {
        PreparedStatement preparedStatement;
        PreparedStatement preparedStatement2;
        JobMonitor jobMonitor;
        int n;
        block14: {
            n = 0;
            jobMonitor = null;
            String string = "UPDATE job_monitors t1 SET job_history_id=? FROM (SELECT id FROM job_monitors WHERE job_id=? AND agent_id=? AND scheduled_time_utc=? AND job_history_id=0 OR job_history_id IS NULL LIMIT 1 FOR UPDATE) sub WHERE t1.id = sub.id";
            preparedStatement2 = this.getDefaultPreparedStmt(string);
            String string2 = "UPDATE job_monitors t1 SET job_history_id=?, agent_id=? FROM (SELECT id FROM job_monitors WHERE job_id=? AND agent_id=0 AND scheduled_time_utc=? AND job_history_id=0 OR job_history_id IS NULL LIMIT 1 FOR UPDATE) sub WHERE t1.id = sub.id";
            preparedStatement = null;
            long l = jobHistory.getId();
            long l2 = jobHistory.getJobID();
            long l3 = jobHistory.getAgentID();
            long l4 = jobHistory.getScheduledTime();
            try {
                preparedStatement2.setLong(1, l);
                preparedStatement2.setLong(2, l2);
                preparedStatement2.setLong(3, l3);
                preparedStatement2.setLong(4, l4);
                n = preparedStatement2.executeUpdate();
                if (n < 1) {
                    String string3 = MessageUtil.formatMsg((String)"The Job Monitor record with jobID: {0}, agentID: {1}, and scheduledTime: {2} was not found.", (Object[])new Object[]{l2, l3, l4});
                    logger.debug((Object)string3);
                    if (l3 != 0L) {
                        preparedStatement = this.getDefaultPreparedStmt(string2);
                        preparedStatement.setLong(1, l);
                        preparedStatement.setLong(2, l3);
                        preparedStatement.setLong(3, l2);
                        preparedStatement.setLong(4, l4);
                        n = preparedStatement.executeUpdate();
                        if (n < 0) {
                            string3 = MessageUtil.formatMsg((String)"The Job Monitor record with jobID: {0}, agentID: zero, and scheduledTime: {1} was not found.", (Object[])new Object[]{l2, l4});
                            logger.debug((Object)string3);
                        } else if (n > 1) {
                            string3 = MessageUtil.formatMsg((String)"Program error: More than 1 Job Monitor record was updated (jobID= {0}, agentID=zero, scheduledTime= {1}.", (Object[])new Object[]{l2, l4});
                            logger.error((Object)string3);
                        } else {
                            string3 = MessageUtil.formatMsg((String)"The Job Monitor record with jobID: {0}, agentID: zero, and scheduledTime: {1} was updated with Agent ID: {2} and Job History ID: {3}", (Object[])new Object[]{l2, l4, l3, l});
                            logger.debug((Object)string3);
                        }
                    }
                    break block14;
                }
                if (n > 1) {
                    String string4 = MessageUtil.formatMsg((String)"Program error: More than 1 Job Monitor record was updated (jobID= {0}, agentID= {1}, scheduledTime= {2}.", (Object[])new Object[]{l2, l3, l4});
                    logger.error((Object)string4);
                    break block14;
                }
                String string5 = MessageUtil.formatMsg((String)"The Job Monitor record with jobID: {0}, agentID: {1}, and scheduledTime: {2} was updated with Job History ID: {3}", (Object[])new Object[]{l2, l3, l4, l});
                logger.debug((Object)string5);
            }
            catch (SQLException sQLException) {
                try {
                    String string6 = MessageUtil.formatMsg((String)"SQL error while updating the {0} information for jobID: {1}, agentID: {2}, scheduledTime: {3}.", (Object[])new Object[]{objDesc, l2, l3, l4});
                    logger.error((Object)string6, (Throwable)sQLException);
                    throw new ResourceUnavailableException(string6, (Throwable)sQLException);
                }
                catch (Throwable throwable) {
                    this.closeConnection(preparedStatement2);
                    if (preparedStatement != null) {
                        this.closeConnection(preparedStatement);
                    }
                    throw throwable;
                }
            }
        }
        this.closeConnection(preparedStatement2);
        if (preparedStatement != null) {
            this.closeConnection(preparedStatement);
        }
        if (n == 1) {
            jobMonitor = this.getLateStartJM(jobHistory);
        }
        return jobMonitor;
    }

    @Override
    public void deleteAllSuiteInstanceMonitors(long l) throws DataException, ResourceUnavailableException {
        if (l == 0L) {
            throw new IllegalArgumentException("Cannot remove job suite monitors for suiteHistoryID = 0!");
        }
        String string = "delete from job_monitors where job_history_id = ?";
        String string2 = "delete from job_monitors where job_suite_history_id = ? and job_history_id = 0";
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        try {
            wrappedConnection = this.getConnectionOrFail();
            preparedStatement = wrappedConnection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            int n = preparedStatement.executeUpdate();
            logger.debug((Object)("Total Job Suite Monitors deleted for Job Suite History ID: " + l + " = " + n));
            JobMonitorDMJdbc.closeEm(null, (Statement)preparedStatement, null);
            preparedStatement = wrappedConnection.prepareStatement(string2);
            preparedStatement.setLong(1, l);
            int n2 = preparedStatement.executeUpdate();
            logger.debug((Object)("Total Job Suite Member Monitors deleted for Job Suite History ID: " + l + " = " + n2));
        }
        catch (SQLException sQLException) {
            try {
                throw new ResourceUnavailableException("Unable to delete job monitor records for Job Suite History ID: " + l, (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                JobMonitorDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, null);
                throw throwable;
            }
        }
        JobMonitorDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
    }

    private class JobMonitorGenerator
    extends AbstractBusObjGenerator {
        public JobMonitorGenerator() {
            super(9, JobMonitorDMJdbc.objDesc);
        }

        protected Object constructObject() {
            return new JobMonitor();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            JobMonitor jobMonitor = (JobMonitor)((Object)object);
            switch (n) {
                case 1: {
                    jobMonitor.setJobID(resultSet.getLong("job_id"));
                    break;
                }
                case 2: {
                    jobMonitor.setAgentID(resultSet.getLong("agent_id"));
                    break;
                }
                case 3: {
                    jobMonitor.setScheduledTime(resultSet.getLong("scheduled_time_utc"));
                    break;
                }
                case 4: {
                    jobMonitor.setMonitorTime(resultSet.getLong("monitor_time_utc"));
                    break;
                }
                case 5: {
                    jobMonitor.setMonitorTypeAsInt(resultSet.getInt("monitor_type"));
                    break;
                }
                case 6: {
                    jobMonitor.setMonitorOptionAsInt(resultSet.getInt("monitor_option"));
                    break;
                }
                case 7: {
                    jobMonitor.setJobStartTime(resultSet.getLong("start_time_utc"));
                    break;
                }
                case 8: {
                    jobMonitor.setJobHistoryID(resultSet.getLong("job_history_id"));
                    break;
                }
                case 9: {
                    jobMonitor.setJobSuiteHistoryID(resultSet.getLong("job_suite_history_id"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }
}

