/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.jdbc;

import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.core.busobj.Agent;
import com.helpsystems.enterprise.core.dm.AgentDM;
import com.helpsystems.enterprise.core.dm.ImportFileDM;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class ImportFileDMJdbc
extends AbstractHelpingDatabaseManager
implements ImportFileDM {
    private static final String TABLE = "import_files";
    private static final Logger logger = Logger.getLogger(ImportFileDMJdbc.class);
    private Object lockObject = new Object();

    public ImportFileDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper) throws ResourceUnavailableException {
        super(string, string2, sQLManagerHelper);
        this.setName("ENTERPRISE.ImportFileDM");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveFileToDB(String string, byte[] byArray, String string2, long l) throws ResourceUnavailableException, DataException {
        Object object = this.lockObject;
        synchronized (object) {
            this.insertRow(string, byArray, string2, l);
        }
        object = (AgentDM)ManagerRegistry.getManagerStartsWith((String)"ENTERPRISE.AgentDM");
        Agent agent = object.get(l);
        logger.info((Object)("Crontab file " + string + " uploaded from agent " + agent.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void insertRow(String string, byte[] byArray, String string2, long l) {
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        String string3 = null;
        PreparedStatement preparedStatement = null;
        try {
            string3 = "INSERT INTO import_files (server_file_content, agent_file_path, created_at_utc, agent_id, scheduler) values (?, ?, ?, ?, ?)";
            wrappedConnection = this.getConnectionOrFail();
            preparedStatement = wrappedConnection.prepareStatement(string3);
            preparedStatement.setBytes(1, byArray);
            preparedStatement.setString(2, string);
            preparedStatement.setLong(3, System.currentTimeMillis());
            preparedStatement.setLong(4, l);
            preparedStatement.setString(5, string2);
            preparedStatement.executeUpdate();
            if (wrappedConnection == null) return;
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.debug((Object)"Error Getting Connection ", (Throwable)resourceUnavailableException);
            if (wrappedConnection == null) return;
            ImportFileDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
            return;
        }
        catch (SQLException sQLException) {
            logger.debug((Object)"Error Inserting to import_files table ", (Throwable)sQLException);
            if (wrappedConnection == null) return;
            {
                catch (Throwable throwable) {
                    if (wrappedConnection == null) throw throwable;
                    ImportFileDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, null);
                    throw throwable;
                }
            }
            ImportFileDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
            return;
        }
        ImportFileDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        return;
    }
}

