/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.jdbc;

import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.Proxy;
import com.helpsystems.common.core.util.DateTranslator;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.AgentEventHistory;
import com.helpsystems.enterprise.core.busobj.AgentEventHistoryInfo;
import com.helpsystems.enterprise.core.busobj.AgentEventMonitorProxy;
import com.helpsystems.enterprise.core.busobj.AgentGroupAgent;
import com.helpsystems.enterprise.core.busobj.traps.AgentEventSNMPTrap;
import com.helpsystems.enterprise.core.busobj.traps.DirectoryAgentEventSNMPTrap;
import com.helpsystems.enterprise.core.busobj.traps.FileAgentEventSNMPTrap;
import com.helpsystems.enterprise.core.busobj.traps.ManualAgentEventSNMPTrap;
import com.helpsystems.enterprise.core.busobj.traps.ProcessAgentEventSNMPTrap;
import com.helpsystems.enterprise.core.dm.AgentDM;
import com.helpsystems.enterprise.core.dm.AgentEventHistoryAM;
import com.helpsystems.enterprise.core.dm.AgentEventHistoryInfoDM;
import com.helpsystems.enterprise.core.dm.AgentEventMonitorDM;
import com.helpsystems.enterprise.core.dm.AgentGroupDM;
import com.helpsystems.enterprise.core.dm.EnterpriseEmailAM;
import com.helpsystems.enterprise.core.dm.EnterpriseSNMPTrapAM;
import com.helpsystems.enterprise.core.dm.NotificationListDM;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class AgentEventHistoryAMJdbc
extends AbstractDatabaseManager
implements AgentEventHistoryAM {
    private static Logger logger = Logger.getLogger(AgentEventHistoryAMJdbc.class);
    private AgentDM agentDM;
    private AgentGroupDM agentGroupDM;
    private AgentEventHistoryInfoDM agentEventHistoryInfoDM;
    private AgentEventMonitorDM agentEventMonitorDM;
    private EnterpriseSNMPTrapAM enterpriseSNMPTrapAM;
    private EnterpriseEmailAM enterpriseEmailAM;

    public AgentEventHistoryAMJdbc(String string, AgentDM agentDM, AgentGroupDM agentGroupDM, AgentEventHistoryInfoDM agentEventHistoryInfoDM, AgentEventMonitorDM agentEventMonitorDM) {
        super(string);
        this.setName("ENTERPRISE.AgentEventHistoryAM");
        this.agentDM = agentDM;
        this.agentGroupDM = agentGroupDM;
        this.agentEventHistoryInfoDM = agentEventHistoryInfoDM;
        this.agentEventMonitorDM = agentEventMonitorDM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] sendEvents(AgentEventHistory[] agentEventHistoryArray) throws ResourceUnavailableException {
        int n;
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        ArrayList<Long> arrayList = new ArrayList<Long>();
        try {
            wrappedConnection = this.getConnection();
            n = agentEventHistoryArray.length;
            for (int i = 0; i < n; ++i) {
                try {
                    ScheduleLogEntry scheduleLogEntry;
                    String[] stringArray;
                    String[] stringArray2;
                    Object object;
                    Proxy proxy;
                    logger.debug((Object)("Processing Agent Event " + agentEventHistoryArray[i].toString()));
                    boolean bl = agentEventHistoryArray[i].isFromSendStatus();
                    AgentEventHistoryInfo agentEventHistoryInfo = new AgentEventHistoryInfo(agentEventHistoryArray[i]);
                    String string = "";
                    TimeZone timeZone = TimeZone.getDefault();
                    String string2 = timeZone.getID();
                    if (agentEventHistoryInfo.getAgentOID() != 0L) {
                        proxy = this.agentDM.get(agentEventHistoryInfo.getAgentOID(), (Connection)wrappedConnection);
                        string = proxy.getName();
                        string2 = proxy.getTimeZone();
                        timeZone = TimeZone.getTimeZone(string2);
                    } else {
                        logger.debug((Object)"Agent ID is zero.");
                    }
                    agentEventHistoryInfo.setAgentName(string);
                    proxy = this.agentEventMonitorDM.get(agentEventHistoryInfo.getEventOID(), (Connection)wrappedConnection);
                    boolean bl2 = true;
                    ScheduleInfo.TimeZoneType timeZoneType = proxy.getTimeZoneType();
                    agentEventHistoryInfo.setTimezoneType(timeZoneType.persistanceCode());
                    long l = System.currentTimeMillis();
                    agentEventHistoryInfo.setServerTimeStamp(l);
                    agentEventHistoryInfo.setAgentTimezone(string2);
                    agentEventHistoryInfo.setEventMonitorName(proxy.getName());
                    agentEventHistoryInfo.setEventType(proxy.getType());
                    if (proxy.getTargetType() == ScheduleInfo.TargetType.AGENT_GROUP) {
                        agentEventHistoryInfo.setAgentGroupOID(proxy.getTargetID());
                        object = this.agentGroupDM.getProxy(proxy.getTargetID());
                        agentEventHistoryInfo.setAgentGroupName(object.getName());
                        try {
                            stringArray2 = this.agentGroupDM.getAgentGroupAgent(proxy.getTargetID(), agentEventHistoryInfo.getAgentOID(), (Connection)wrappedConnection);
                            long l2 = System.currentTimeMillis();
                            this.agentGroupDM.releaseIfHeldExpired((AgentGroupAgent)stringArray2, timeZone);
                            if (stringArray2.currentlyIgnored(l2)) {
                                bl2 = false;
                                stringArray = new StringBuilder("Received event from excluded agent '");
                                stringArray.append(string);
                                stringArray.append("' in '");
                                stringArray.append(object.getName());
                                stringArray.append("' agent group");
                                logger.info((Object)stringArray.toString());
                            }
                        }
                        catch (Exception exception) {
                            logger.error((Object)("Can not retrieve AgentGroupAgent from AgentGroup " + object.getName()));
                        }
                    }
                    arrayList.add(agentEventHistoryInfo.getAgentTimeStamp());
                    if (!bl2) continue;
                    if (!bl) {
                        if (proxy.isDisabled()) {
                            agentEventHistoryInfo.setErrorStatus(4);
                            logger.debug((Object)("Agent Event Monitor " + proxy.getName() + " is disabled"));
                        } else {
                            object = DateTranslator.packTime((Date)new Date(l), (TimeZone)timeZone);
                            int n2 = Integer.parseInt((String)object);
                            if (proxy.getToTime() > proxy.getFromTime()) {
                                if (n2 < proxy.getFromTime() || n2 >= proxy.getToTime()) {
                                    agentEventHistoryInfo.setErrorStatus(3);
                                    logger.debug((Object)("Agent Event is outside time range for Agent Event Monitor " + proxy.getName()));
                                }
                            } else if (n2 < proxy.getFromTime() && n2 >= proxy.getToTime()) {
                                agentEventHistoryInfo.setErrorStatus(3);
                                logger.debug((Object)("Agent Event is outside time range for Agent Event Monitor " + proxy.getName()));
                            }
                        }
                    }
                    this.agentEventHistoryInfoDM.save((Connection)wrappedConnection, agentEventHistoryInfo);
                    object = String.valueOf(agentEventHistoryInfo.getOID());
                    stringArray2 = new String[]{AgentEventMonitorProxy.getTypeDescription(agentEventHistoryInfo.getEventType()), agentEventHistoryInfo.getEventMonitorName(), object, agentEventHistoryInfo.getAgentName()};
                    switch (agentEventHistoryInfo.getErrorStatus()) {
                        case 4: {
                            scheduleLogEntry = RosettaMsg.AGENT_EVENT_OCCURRED_HELD.newLogEntry(stringArray2);
                            break;
                        }
                        case 3: {
                            scheduleLogEntry = RosettaMsg.AGENT_EVENT_OCCURRED_TIME_RANGE.newLogEntry(stringArray2);
                            break;
                        }
                        default: {
                            scheduleLogEntry = RosettaMsg.AGENT_EVENT_OCCURRED.newLogEntry(stringArray2);
                        }
                    }
                    scheduleLogEntry.setAgentID(agentEventHistoryInfo.getAgentOID());
                    ScheduleLogger.write((Connection)wrappedConnection, scheduleLogEntry);
                    if (agentEventHistoryInfo.getErrorStatus() == 0 && proxy.isSendSNMPTrap()) {
                        this.sendSNMPTrap(agentEventHistoryInfo, scheduleLogEntry.getMessageText());
                    }
                    if (agentEventHistoryInfo.getErrorStatus() != 0 || !proxy.isSendEmail() || proxy.getNotificationListID() <= 0L) continue;
                    NotificationListDM notificationListDM = (NotificationListDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.NotificationListDM");
                    stringArray = null;
                    try {
                        stringArray = notificationListDM.get(proxy.getNotificationListID()).getListOfUniqueEmails();
                    }
                    catch (Exception exception) {
                        logger.error((Object)"Error retrieving Agent Notification Options.", (Throwable)exception);
                    }
                    if (stringArray.length <= 0) continue;
                    String string3 = scheduleLogEntry.getMessageText();
                    this.sendEmail(stringArray, "Automate Schedule Agent Event Notice " + string3, string3 + "<br/>Event Data:  " + agentEventHistoryInfo.getEventData().trim());
                    continue;
                }
                catch (Exception exception) {
                    logger.error((Object)"Error processing Agent Event History", (Throwable)exception);
                }
            }
        }
        catch (Exception exception) {
            logger.error((Object)"Error processing Agent Event History list", (Throwable)exception);
        }
        finally {
            AgentEventHistoryAMJdbc.closeEm((Connection)wrappedConnection, null, null);
        }
        long[] lArray = new long[arrayList.size()];
        for (n = 0; n < lArray.length; ++n) {
            lArray[n] = (Long)arrayList.get(n);
        }
        return lArray;
    }

    private void sendEmail(String[] stringArray, String string, String string2) {
        try {
            this.getEnterpriseEmailAM().sendMessage(stringArray, string, string2);
        }
        catch (Exception exception) {
            logger.error((Object)"Error sending an email.", (Throwable)exception);
        }
    }

    private void sendSNMPTrap(AgentEventHistoryInfo agentEventHistoryInfo, String string) {
        AgentEventSNMPTrap agentEventSNMPTrap;
        ManualAgentEventSNMPTrap manualAgentEventSNMPTrap = null;
        int n = AgentEventMonitorProxy.getTypeCategory(agentEventHistoryInfo.getEventType());
        if (n == 0) {
            manualAgentEventSNMPTrap = agentEventSNMPTrap = new ManualAgentEventSNMPTrap();
        }
        if (n == 1) {
            manualAgentEventSNMPTrap = agentEventSNMPTrap = new FileAgentEventSNMPTrap(agentEventHistoryInfo.getEventType());
        }
        if (n == 2) {
            manualAgentEventSNMPTrap = agentEventSNMPTrap = new DirectoryAgentEventSNMPTrap(agentEventHistoryInfo.getEventType());
        }
        if (n == 3) {
            manualAgentEventSNMPTrap = agentEventSNMPTrap = new ProcessAgentEventSNMPTrap(agentEventHistoryInfo.getEventType());
        }
        if (manualAgentEventSNMPTrap != null) {
            manualAgentEventSNMPTrap.setEventID(agentEventHistoryInfo.getEventOID());
            manualAgentEventSNMPTrap.setEventName(agentEventHistoryInfo.getEventMonitorName());
            manualAgentEventSNMPTrap.setAgentID(agentEventHistoryInfo.getAgentOID());
            manualAgentEventSNMPTrap.setAgentName(agentEventHistoryInfo.getAgentName());
            manualAgentEventSNMPTrap.setEventData(agentEventHistoryInfo.getEventData());
            manualAgentEventSNMPTrap.setText(string);
            try {
                this.getEnterpriseSNMPTrapAM().sendSNMPTrap(manualAgentEventSNMPTrap);
            }
            catch (Exception exception) {
                logger.error((Object)"Error sending an Agent Event SNMP Trap.", (Throwable)exception);
            }
        }
    }

    private EnterpriseEmailAM getEnterpriseEmailAM() {
        if (this.enterpriseEmailAM == null) {
            this.enterpriseEmailAM = (EnterpriseEmailAM)ManagerRegistry.getManagerStartsWith((String)"ENTERPRISE.EnterpriseEmailAM");
        }
        return this.enterpriseEmailAM;
    }

    private EnterpriseSNMPTrapAM getEnterpriseSNMPTrapAM() {
        if (this.enterpriseSNMPTrapAM == null) {
            this.enterpriseSNMPTrapAM = (EnterpriseSNMPTrapAM)ManagerRegistry.getManagerStartsWith((String)"ENTERPRISE.EnterpriseSNMPTrapAM");
        }
        return this.enterpriseSNMPTrapAM;
    }
}

