/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.ibmi;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.Convert;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.IBMiAgentEnvironment;
import com.helpsystems.enterprise.core.dm.IBMiAgentEnvironmentDM;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class IBMiAgentEnvironmentDMJdbc
extends AbstractDatabaseManager
implements IBMiAgentEnvironmentDM {
    private static final Logger logger = Logger.getLogger(IBMiAgentEnvironmentDMJdbc.class);
    private static final String objDesc = "IBM i Agent Environment";
    private final String JOBS_TABLE = "jobs";
    private String environmentTable;
    private String jobsTable;

    public IBMiAgentEnvironmentDMJdbc(String string, String string2) throws ResourceUnavailableException {
        super(string);
        this.setName("ENTERPRISE.IBMiAgentEnvironmentDM");
        this.environmentTable = string2 + "." + "ibmi_agent_environments";
        this.jobsTable = string2 + "." + "jobs";
    }

    @Override
    public IBMiAgentEnvironment get(long l) throws DataException, ResourceUnavailableException {
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        IBMiAgentEnvironmentGenerator iBMiAgentEnvironmentGenerator = new IBMiAgentEnvironmentGenerator();
        String string = "SELECT";
        string = string + "  id ";
        string = string + ", coalesce( name, '')";
        string = string + ", coalesce( description, '')";
        string = string + ", job_description";
        string = string + ", job_queue";
        string = string + ", job_queue_priority";
        string = string + ", output_queue";
        string = string + ", message_queue";
        string = string + ", user_profile";
        string = string + ", message_reply";
        string = string + ", accounting_code";
        string = string + ", current_library";
        string = string + ", initial_asp_group";
        string = string + ", library_list";
        string = string + " from " + this.environmentTable + " where id=?";
        try {
            wrappedConnection = this.getConnection();
            PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            logger.debug((Object)("Running " + string + " with " + l));
            logger.trace((Object)("Running " + string + " with " + l));
            preparedStatement.setLong(1, l);
            Object object = preparedStatement.executeQuery();
            if (object.next()) {
                IBMiAgentEnvironment iBMiAgentEnvironment;
                IBMiAgentEnvironment iBMiAgentEnvironment2 = iBMiAgentEnvironment = (IBMiAgentEnvironment)((Object)iBMiAgentEnvironmentGenerator.generateObject((ResultSet)object));
                return iBMiAgentEnvironment2;
            }
            try {
                throw new NoDataException("IBM i Agent Environment not found for id " + l + ".");
            }
            catch (SQLException sQLException) {
                object = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for id {1}.", (Object[])new Object[]{objDesc, Long.toString(l)});
                throw new ResourceUnavailableException((String)object, (Throwable)sQLException);
            }
        }
        finally {
            IBMiAgentEnvironmentDMJdbc.closeEm((Connection)wrappedConnection, null, null);
        }
    }

    @Override
    public IBMiAgentEnvironment getByJobId(long l) throws DataException, ResourceUnavailableException {
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        IBMiAgentEnvironmentGenerator iBMiAgentEnvironmentGenerator = new IBMiAgentEnvironmentGenerator();
        String string = "SELECT";
        string = string + "  ae.id ";
        string = string + ", coalesce( ae.name, '')";
        string = string + ", coalesce( ae.description, '')";
        string = string + ", ae.environment_type";
        string = string + ", ae.user_profile";
        string = string + ", ae.working_path";
        string = string + ", coalesce( ae.referenced_shared_id, 0)";
        string = string + ", ae.encrypted_password";
        string = string + ", run_type_option";
        string = string + " from " + this.environmentTable + " as ae join " + this.jobsTable + " as j on j.agent_environment_id = ae.id where j.id=?";
        try {
            wrappedConnection = this.getConnection();
            PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            logger.trace((Object)("Running " + string + " with " + l));
            preparedStatement.setLong(1, l);
            Object object = preparedStatement.executeQuery();
            if (object.next()) {
                IBMiAgentEnvironment iBMiAgentEnvironment;
                IBMiAgentEnvironment iBMiAgentEnvironment2 = iBMiAgentEnvironment = (IBMiAgentEnvironment)((Object)iBMiAgentEnvironmentGenerator.generateObject((ResultSet)object));
                return iBMiAgentEnvironment2;
            }
            try {
                throw new NoDataException("Agent Environment not found.");
            }
            catch (SQLException sQLException) {
                object = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for id {1}.", (Object[])new Object[]{objDesc, Long.toString(l)});
                throw new ResourceUnavailableException((String)object, (Throwable)sQLException);
            }
        }
        finally {
            IBMiAgentEnvironmentDMJdbc.closeEm((Connection)wrappedConnection, null, null);
        }
    }

    private class IBMiAgentEnvironmentGenerator
    extends AbstractBusObjGenerator {
        public IBMiAgentEnvironmentGenerator() {
            super(14, IBMiAgentEnvironmentDMJdbc.objDesc);
        }

        protected Object constructObject() {
            return new IBMiAgentEnvironment();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            IBMiAgentEnvironment iBMiAgentEnvironment = (IBMiAgentEnvironment)((Object)object);
            switch (n) {
                case 1: {
                    iBMiAgentEnvironment.setOid(resultSet.getLong(1));
                    break;
                }
                case 2: {
                    iBMiAgentEnvironment.setName(resultSet.getString(2).trim());
                    break;
                }
                case 3: {
                    iBMiAgentEnvironment.setDescription(Convert.trimR((String)resultSet.getString(3)));
                    break;
                }
                case 4: {
                    iBMiAgentEnvironment.setJobDescription(Convert.trimR((String)resultSet.getString(4)));
                    break;
                }
                case 5: {
                    iBMiAgentEnvironment.setJobQueue(Convert.trimR((String)resultSet.getString(5)));
                    break;
                }
                case 6: {
                    iBMiAgentEnvironment.setJobQueuePriority(resultSet.getInt(6));
                    break;
                }
                case 7: {
                    iBMiAgentEnvironment.setOutputQueue(Convert.trimR((String)resultSet.getString(7)));
                    break;
                }
                case 8: {
                    iBMiAgentEnvironment.setMessageQueue(Convert.trimR((String)resultSet.getString(8)));
                    break;
                }
                case 9: {
                    iBMiAgentEnvironment.setUserProfile(Convert.trimR((String)resultSet.getString(9)));
                    break;
                }
                case 10: {
                    iBMiAgentEnvironment.setMessageReply(Convert.trimR((String)resultSet.getString(10)));
                    break;
                }
                case 11: {
                    iBMiAgentEnvironment.setAccountingCode(Convert.trimR((String)resultSet.getString(11)));
                    break;
                }
                case 12: {
                    iBMiAgentEnvironment.setCurrentLibrary(Convert.trimR((String)resultSet.getString(12)));
                    break;
                }
                case 13: {
                    iBMiAgentEnvironment.setInitialASPGroup(Convert.trimR((String)resultSet.getString(13)));
                    break;
                }
                case 14: {
                    iBMiAgentEnvironment.setLibraryList(Convert.trimR((String)resultSet.getString(14)));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }
}

