/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.automate;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.automate.AutoMateSystemDefinition;
import com.helpsystems.enterprise.core.busobj.automate.AutoMateSystemType;
import com.helpsystems.enterprise.core.dm.automate.AutoMateSystemDefinitionsDM;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class AutoMateSystemDefinitionsDMJdbc
extends AbstractHelpingDatabaseManager
implements AutoMateSystemDefinitionsDM {
    private static Logger logger = Logger.getLogger(AutoMateSystemDefinitionsDMJdbc.class);
    private static final String objDesc = "AutoMate System Definition";
    private static final String AUTOMATE_SYSTEM_DEFINITIONS_TABLE = "automate_system_definitions";
    private String automateSystemDefinitionsTable;

    public AutoMateSystemDefinitionsDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper) {
        super(string, string2, sQLManagerHelper);
        this.setName("ENTERPRISE.AutoMateSystemDefinitionsDM");
        this.automateSystemDefinitionsTable = string2 + "." + AUTOMATE_SYSTEM_DEFINITIONS_TABLE;
    }

    @Override
    public AutoMateSystemDefinition getAutoMateSystemDefinition(long l) throws NoDataException, ResourceUnavailableException, BadDataException {
        AutoMateSystemDefinition autoMateSystemDefinition = this.getAutoMateSystemDefinition(l, null);
        if (autoMateSystemDefinition.getAutoMateSystemType().isV11Type()) {
            autoMateSystemDefinition.setVersion(11000);
        }
        return autoMateSystemDefinition;
    }

    @Override
    public AutoMateSystemDefinition getAutoMateSystemDefinition(long l, Connection connection) throws NoDataException, ResourceUnavailableException, BadDataException {
        Connection connection2 = connection;
        if (connection2 == null) {
            connection2 = super.getConnectionOrFail();
        }
        String string = "SELECT id, name, description, system_type, endpoint_url, username, encrypted_password, password_salt, status_polling_interval FROM " + this.automateSystemDefinitionsTable + " WHERE id=?";
        AutoMateSystemDefinitionGenerator autoMateSystemDefinitionGenerator = new AutoMateSystemDefinitionGenerator(9);
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string, connection2);
        ResultSet resultSet = null;
        try {
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                AutoMateSystemDefinition autoMateSystemDefinition;
                AutoMateSystemDefinition autoMateSystemDefinition2 = autoMateSystemDefinition = (AutoMateSystemDefinition)autoMateSystemDefinitionGenerator.generateObject(resultSet);
                return autoMateSystemDefinition2;
            }
            try {
                throw new NoDataException("AutoMate System Definition not found for ID " + l + ".");
            }
            catch (SQLException sQLException) {
                String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for id {1}.", (Object[])new Object[]{objDesc, Long.toString(l)});
                logger.error((Object)string2, (Throwable)sQLException);
                throw new ResourceUnavailableException(string2, (Throwable)sQLException);
            }
        }
        finally {
            if (connection == null) {
                AutoMateSystemDefinitionsDMJdbc.closeEm((Connection)connection2, (Statement)preparedStatement, (ResultSet)resultSet);
            }
        }
    }

    private class AutoMateSystemDefinitionGenerator
    extends AbstractBusObjGenerator {
        public AutoMateSystemDefinitionGenerator(int n) {
            super(n, AutoMateSystemDefinitionsDMJdbc.objDesc);
        }

        protected Object constructObject() {
            return new AutoMateSystemDefinition();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            AutoMateSystemDefinition autoMateSystemDefinition = (AutoMateSystemDefinition)object;
            switch (n) {
                case 1: {
                    autoMateSystemDefinition.setOID(resultSet.getLong("id"));
                    break;
                }
                case 2: {
                    String string = resultSet.getString("name");
                    if (string == null) {
                        string = "";
                    }
                    autoMateSystemDefinition.setName(string);
                    break;
                }
                case 3: {
                    String string = resultSet.getString("description");
                    if (string == null) {
                        string = "";
                    }
                    autoMateSystemDefinition.setDescription(string);
                    break;
                }
                case 4: {
                    autoMateSystemDefinition.setAutoMateSystemType(AutoMateSystemType.persistanceCodeToEnum(resultSet.getInt("system_type")));
                    break;
                }
                case 5: {
                    autoMateSystemDefinition.setEndPointURL(resultSet.getString("endpoint_url"));
                    break;
                }
                case 6: {
                    autoMateSystemDefinition.setUsername(resultSet.getString("username"));
                    break;
                }
                case 7: {
                    String string = resultSet.getString("encrypted_password");
                    if (string == null) {
                        string = "";
                    }
                    autoMateSystemDefinition.setEncryptedPassword(string);
                    break;
                }
                case 8: {
                    String string = resultSet.getString("password_salt");
                    if (string == null) {
                        string = "";
                    }
                    autoMateSystemDefinition.setPasswordSalt(string);
                    break;
                }
                case 9: {
                    autoMateSystemDefinition.setStatusPollingInterval(resultSet.getInt("status_polling_interval"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }
}

