/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access;

import com.helpsystems.common.access.service.JdbcServiceDescriptor;
import com.helpsystems.common.access.service.JdbcServiceStarter;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.encryption.EncryptUtil;
import com.helpsystems.common.core.service.Service;
import com.helpsystems.common.core.service.ServiceDescriptor;
import com.helpsystems.common.core.service.ServiceException;
import com.helpsystems.enterprise.access.ManagerLoaderJDBC;
import com.helpsystems.enterprise.core.db.JDBC_Descriptor_ID;
import com.helpsystems.enterprise.core.db.PostgresqlDB;
import com.helpsystems.enterprise.core.util.UnacodeMash;
import org.apache.log4j.Logger;

public abstract class EnterpriseDatabase {
    private static final Logger logger = Logger.getLogger(EnterpriseDatabase.class);
    static JdbcServiceStarter jdbcServiceStarter = null;

    public static Service start(JdbcServiceDescriptor jdbcServiceDescriptor) throws ResourceUnavailableException {
        Object object;
        Service service = null;
        logger.debug((Object)("Using Database Driver  . . : " + jdbcServiceDescriptor.getDriverClassname()));
        logger.debug((Object)("Using Database URL . . . . : " + jdbcServiceDescriptor.getUrl()));
        try {
            jdbcServiceStarter = new JdbcServiceStarter();
            object = UnacodeMash.getForDataManagers();
            jdbcServiceStarter.useEncryption((EncryptUtil)object);
            service = jdbcServiceStarter.startService((ServiceDescriptor)jdbcServiceDescriptor);
        }
        catch (ServiceException serviceException) {
            String string = "Error starting up the JDBC Connection pool.";
            throw new ResourceUnavailableException(string, (Throwable)serviceException);
        }
        object = new ManagerLoaderJDBC("jdbc:apache:commons:dbcp:" + jdbcServiceDescriptor.getName(), jdbcServiceDescriptor);
        ((ManagerLoaderJDBC)((Object)object)).loadAll();
        return service;
    }

    public static void stop(JdbcServiceDescriptor jdbcServiceDescriptor, Service service) throws ServiceException {
        logger.debug((Object)("Stopping Database Driver  . . : " + jdbcServiceDescriptor.getDriverClassname()));
        logger.debug((Object)("Stopping Database URL . . . . : " + jdbcServiceDescriptor.getUrl()));
        if (jdbcServiceStarter != null) {
            jdbcServiceStarter.stopService(service);
        }
    }

    public static JdbcServiceDescriptor createDefaultJDBCServiceDescriptor(JDBC_Descriptor_ID jDBC_Descriptor_ID) {
        PostgresqlDB postgresqlDB = new PostgresqlDB(jDBC_Descriptor_ID);
        if (postgresqlDB == null) {
            throw new RuntimeException("Database info for JDBC Service Descriptor is not available.");
        }
        String string = postgresqlDB.getDriver();
        String string2 = postgresqlDB.getURL();
        String string3 = "select count(*) from system_settings";
        JdbcServiceDescriptor jdbcServiceDescriptor = new JdbcServiceDescriptor();
        jdbcServiceDescriptor.setName(jDBC_Descriptor_ID.toString());
        jdbcServiceDescriptor.setUrl(string2);
        jdbcServiceDescriptor.setAutoCommit(true);
        jdbcServiceDescriptor.setAutoStartup(false);
        jdbcServiceDescriptor.setDriverClassname(string);
        jdbcServiceDescriptor.setUsername(postgresqlDB.getUser());
        jdbcServiceDescriptor.setEncryptedPassword(postgresqlDB.getPassword());
        jdbcServiceDescriptor.setMaxConnections(postgresqlDB.getMaxConnections());
        jdbcServiceDescriptor.setMinEvictableIdleTimeMillis(60000L);
        jdbcServiceDescriptor.setTestQuery(string3);
        jdbcServiceDescriptor.setSwapToRBTUSER(false);
        jdbcServiceDescriptor.setSchemaName(postgresqlDB.getSchema());
        return jdbcServiceDescriptor;
    }
}

