/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.transport.moduleimpl.processor;

import com.helpsystems.common.core.access.BadDataArrayException;
import com.helpsystems.common.core.access.DataSet;
import com.helpsystems.common.core.access.DataSetException;
import com.helpsystems.common.core.access.dataset.DataSetClosedException;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.transport.moduleimpl.processor.RemoteLingeringObject;

public class RemoteLingeringDataSet
extends RemoteLingeringObject
implements DataSet {
    private static final long serialVersionUID = 6500143704458943821L;
    protected int size;

    public RemoteLingeringDataSet() {
    }

    public RemoteLingeringDataSet(String string, PeerID peerID) {
        super(string, peerID);
        this.size = -1;
    }

    public Object[] get(int n, int n2) throws DataSetException, BadDataArrayException {
        this.checkIfExpired();
        try {
            return (Object[])this.invokeMethod("get", new Class[]{Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(n), new Integer(n2)});
        }
        catch (RuntimeException runtimeException) {
            this.checkIfDataSetException(runtimeException);
            this.checkIfBadDataException(runtimeException);
            throw new DataSetException("Unable to retrieve the data from the remote DataSet", (Throwable)runtimeException);
        }
    }

    protected void checkIfExpired() throws DataSetException {
        if (this.isExpired()) {
            throw new DataSetClosedException("This DataSet is closed.");
        }
    }

    @Override
    public void close() throws DataSetException {
        if (this.isExpired()) {
            return;
        }
        try {
            this.invokeMethod("close", null, null, false, true);
        }
        catch (RuntimeException runtimeException) {
            this.checkIfDataSetException(runtimeException);
            throw new DataSetException("Unable to close the remote DataSet", (Throwable)runtimeException);
        }
        finally {
            this.setExpired(true);
        }
    }

    public void setSize(int n) {
        this.size = n;
    }

    public int size() throws DataSetException {
        if (this.size == -1) {
            this.checkIfExpired();
            try {
                Integer n = (Integer)this.invokeMethod("size", null, null);
                this.size = n;
            }
            catch (RuntimeException runtimeException) {
                this.checkIfDataSetException(runtimeException);
                throw new DataSetException("Unable to retrieve the size from the remote DataSet", (Throwable)runtimeException);
            }
        }
        return this.size;
    }

    protected void checkIfBadDataException(RuntimeException runtimeException) throws BadDataArrayException {
        Throwable throwable = runtimeException.getCause();
        if (throwable != null && throwable instanceof BadDataArrayException) {
            throw (BadDataArrayException)throwable;
        }
    }

    protected void checkIfDataSetException(RuntimeException runtimeException) throws DataSetException {
        Throwable throwable = runtimeException.getCause();
        if (throwable != null && throwable instanceof DataSetException) {
            throw (DataSetException)throwable;
        }
    }
}

