/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoCustomDestination;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.rt.InternalDestination;
import com.sap.conn.jco.rt.RfcDestination;
import java.util.Properties;

public class RfcCustomDestination
extends RfcDestination
implements JCoCustomDestination.SncConfigurationData,
JCoCustomDestination.UserData,
JCoCustomDestination {
    protected RfcCustomDestination(String name, Properties properties, String propertiesProvider, RfcDestination parent) {
        super(name, properties, propertiesProvider, parent);
    }

    protected RfcCustomDestination(String name, Properties properties, String propertiesProvider) {
        super(name, properties, propertiesProvider);
    }

    public JCoCustomDestination.SncConfigurationData getSNCConfiguration() {
        return this;
    }

    public JCoCustomDestination.UserData getUserLogonData() {
        return this;
    }

    private void checkState() {
        if (this.isInitialized) {
            throw new JCoRuntimeException(136, "JCO_ERROR_ILLEGAL_STATE", "Destination instance is already connected to a backend, hence changes in the destination parameters are not allowed. If you need to change a setting, create a new instance with createCustomDestination().");
        }
    }

    public void setCodepage(String codepage) {
        this.checkState();
        if (codepage == null) {
            this.properties.remove("jco.client.codepage");
        } else {
            this.properties.setProperty("jco.client.codepage", codepage);
        }
    }

    public void setTrace(boolean trace) {
        this.checkState();
        this.properties.setProperty("jco.client.trace", trace ? "1" : "0");
    }

    public void setUseSapGui(boolean useSapGui) {
        this.checkState();
        this.properties.setProperty("jco.client.use_sapgui", useSapGui ? "2" : "0");
    }

    public void setRepositoryDestination(JCoDestination destination) {
        if (destination == null) {
            this.properties.remove("jco.destination.repository_destination");
        } else {
            if (destination.getType() != '3') {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Only destinations to an ABAP backend are allowed as repository destination.");
            }
            if ("custom destination".equals(this.properties.getProperty("propertiesProvider"))) {
                this.properties.remove("jco.destination.repository_destination");
            } else {
                this.properties.setProperty("jco.destination.repository_destination", destination.getDestinationName());
            }
            if (destination instanceof InternalDestination) {
                this.repositoryDestination = (InternalDestination)destination;
            } else {
                throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "setRepositoryDestination accepts only JCoDestination instances created by JCoRuntime. Encountered " + destination.getClass().getName());
            }
        }
    }

    public void setSncLibrary(String sncLibrary) {
        this.checkState();
        if (sncLibrary != null) {
            this.properties.setProperty("jco.client.snc_lib", sncLibrary);
        }
    }

    public void setSncMode(String sncMode) {
        this.checkState();
        if (sncMode.equals("1")) {
            this.properties.setProperty("jco.client.snc_mode", "1");
        } else if (sncMode.equals("0")) {
            this.properties.setProperty("jco.client.snc_mode", "0");
            this.properties.remove("jco.client.snc_qop");
            this.properties.remove("jco.client.snc_myname");
            this.properties.remove("jco.client.snc_partnername");
            this.properties.remove("jco.client.snc_lib");
        } else {
            throw new IllegalArgumentException("sncMode can be 1 or 0");
        }
    }

    public void setSncMyName(String sncMyName) {
        this.checkState();
        if (sncMyName != null) {
            this.properties.setProperty("jco.client.snc_myname", sncMyName);
        }
    }

    public void setSncPartnerName(String sncPartnerName) {
        this.checkState();
        if (sncPartnerName != null) {
            this.properties.setProperty("jco.client.snc_partnername", sncPartnerName);
        }
    }

    public void setSncQOP(String sncQOP) {
        this.checkState();
        this.properties.setProperty("jco.client.snc_qop", sncQOP);
    }

    public void setX509Certificate(String base64CodedCertificate) {
        this.checkState();
        if (base64CodedCertificate == null) {
            this.properties.remove("jco.client.x509cert");
        } else {
            this.properties.setProperty("jco.client.x509cert", base64CodedCertificate);
        }
    }

    public void setAliasUser(String aliasUser) {
        this.checkState();
        this.properties.setProperty("jco.client.alias_user", aliasUser);
    }

    public void setClient(String client) {
        this.checkState();
        if (client != null) {
            this.properties.setProperty("jco.client.client", client);
        }
    }

    public void setLanguage(String lang) {
        this.checkState();
        if (lang != null) {
            this.properties.setProperty("jco.client.lang", lang);
        }
    }

    public void setPassword(String passwd) {
        this.checkState();
        if (passwd != null) {
            this.properties.setProperty("jco.client.passwd", passwd);
        }
    }

    public void setUser(String user) {
        this.checkState();
        if (user != null) {
            this.properties.setProperty("jco.client.user", user);
        }
    }

    public void setLogonCheck(int lcheck) {
        this.checkState();
        if (lcheck == 0) {
            this.properties.setProperty("jco.client.lcheck", "0");
        } else {
            this.properties.remove("jco.client.lcheck");
        }
    }

    public void requestSSOTicket(boolean request) {
        this.checkState();
        if (request) {
            this.properties.setProperty("jco.client.getsso2", "1");
        } else {
            this.properties.remove("jco.client.getsso2");
        }
    }
}

