/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.ext.PasswordChangeHandler;
import com.sap.conn.jco.rt.ClientConnection;
import com.sap.conn.jco.rt.ClientFactory;
import com.sap.conn.jco.rt.InternalDestination;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.JCoRuntimeFactory;
import com.sap.conn.jco.rt.MonitoredConnectionData;
import com.sap.conn.jco.rt.PoolingFactory;
import com.sap.conn.jco.rt.RfcDestination;
import com.sap.conn.jco.rt.RuntimeEnvironment;
import com.sap.conn.jco.rt.Trace;
import com.sap.conn.rfc.engine.PasswordState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ConnectionManager {
    private static HashMap<String, ClientFactory> mFactories = new HashMap();
    private static final HashSet<String> friendlyClasses = ConnectionManager.getFriendlyClasses();
    private static ConnectionManager singleton;

    private static HashSet<String> getFriendlyClasses() {
        HashSet<String> friends = new HashSet<String>();
        friends.add("com.sap.conn.jco.rt.JCoJ2EERuntime");
        friends.add("com.sap.conn.jco.rt.DefaultJCoRuntime");
        friends.add("com.sap.conn.jco.rt.JCoVMCRuntime");
        friends.add("com.sap.conn.jco.rt.VMCConnectionManager");
        friends.add("com.sap.conn.jco.rt.DefaultConnectionManager");
        return friends;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConnectionManager() {
        if (!JCoRuntime.checkAccess(friendlyClasses, "com.sap.conn.jco.rt.ConnectionManager")) {
            throw new UnsupportedOperationException("It is not allowed to extend the ConnectionManager class");
        }
        Class<ConnectionManager> clazz = ConnectionManager.class;
        synchronized (ConnectionManager.class) {
            if (singleton == null) {
                singleton = this;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static ConnectionManager getConnectionManager() {
        if (singleton == null) {
            JCoRuntimeFactory.getRuntime();
        }
        return singleton;
    }

    protected final ClientConnection getClient(JCoDestination destination) throws JCoException {
        return this.getClient((InternalDestination)destination, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final ClientConnection getClient(InternalDestination destination, boolean forRepository, boolean forChangePassword) throws JCoException {
        try {
            ClientFactory factory = this.getFactory(destination, forRepository, true);
            ClientConnection client = factory.getClient();
            PasswordState passwordState = client.rfcHandle.getPasswordState();
            if (passwordState != null && (passwordState == PasswordState.INITIAL || passwordState == PasswordState.EXPIRED || passwordState == PasswordState.RULES_ENFORCED)) {
                PasswordChangeHandler changeHandler = RuntimeEnvironment.getPasswordChangeHandler();
                if (changeHandler != null && !forRepository) {
                    destination.setInPasswordChangeHandler(true);
                    try {
                        if (this.doPasswortChangeWithHandler(changeHandler, destination, client)) {
                            ClientConnection clientConnection = client;
                            Object var10_11 = null;
                            destination.setInPasswordChangeHandler(false);
                            return clientConnection;
                        }
                        Object var10_12 = null;
                        destination.setInPasswordChangeHandler(false);
                    }
                    catch (Throwable throwable) {
                        Object var10_13 = null;
                        destination.setInPasswordChangeHandler(false);
                        throw throwable;
                    }
                }
                if ("1".equals(client.properties.getProperty("jco.client.deny_initial_password")) && !forChangePassword) {
                    StringBuilder message = new StringBuilder();
                    switch (passwordState) {
                        case INITIAL: {
                            message.append("The current password is initial.");
                            break;
                        }
                        case EXPIRED: {
                            message.append("The current password is expired.");
                            break;
                        }
                        case RULES_ENFORCED: {
                            message.append("The password rules have changed.");
                            break;
                        }
                    }
                    message.append(" Please change your password in the ABAP backend, as well as in your local destination configuration.");
                    throw new JCoException(138, message.toString());
                }
            }
            return client;
        }
        catch (ClassCastException e) {
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Unsupported class " + destination.getClass().getName() + " encountered. Use DestinationManager to obtain destination instances");
        }
    }

    private boolean doPasswortChangeWithHandler(PasswordChangeHandler changeHandler, InternalDestination destination, ClientConnection client) {
        String[] passwords;
        boolean successfulChange = false;
        Exception previous = null;
        for (int i = 0; i < 5 && (passwords = changeHandler.promptPassword(destination, previous)) != null && passwords.length >= 2; ++i) {
            try {
                client.changeBackendPassword(destination.getUser(), passwords[0], passwords[1]);
                successfulChange = true;
                break;
            }
            catch (Exception e) {
                previous = e;
                continue;
            }
        }
        return successfulChange;
    }

    protected final void releaseClient(ClientConnection client) throws JCoException {
        if (client == null) {
            Trace.fireTraceCritical("client is null in releaseClient", true);
            return;
        }
        client.sessionId = null;
        ClientFactory pool = client.pool;
        if (pool == null) {
            if (client.isAlive()) {
                client.disconnect(false);
            }
            return;
        }
        pool.releaseClient(client);
    }

    protected final void releaseWithCancel(ClientConnection client) throws JCoException {
        if (client == null) {
            Trace.fireTraceCritical("client is null in releaseWithCancel", true);
            return;
        }
        client.sessionId = null;
        if (client.pool != null) {
            client.pool.detachFromPool(client);
        }
        client.cancel();
    }

    protected final void clearClient(ClientConnection client) throws JCoException {
        if (client == null) {
            Trace.fireTraceCritical("client is null in clearClient", true);
            return;
        }
        ClientFactory pool = client.pool;
        if (pool != null) {
            pool.detachFromPool(client);
        }
        client.free();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void restoreClient(ClientConnection client, String destinationId, boolean allocate) throws JCoException {
        if (client == null) {
            Trace.fireTraceCritical("client is null in restoreClient", true);
            return;
        }
        ClientFactory factory = null;
        HashMap<String, ClientFactory> hashMap = mFactories;
        synchronized (hashMap) {
            factory = mFactories.get(destinationId);
        }
        if (factory != null) {
            factory.attachToPool(client, allocate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClientFactory getFactory(InternalDestination destination, boolean forRepository, boolean create) throws JCoException {
        String key = forRepository ? destination.getRepositoryKey() : destination.getDestinationID();
        ClientFactory factory = null;
        HashMap<String, ClientFactory> hashMap = mFactories;
        synchronized (hashMap) {
            factory = mFactories.get(key);
        }
        if (factory == null && create) {
            factory = this.createFactory(destination, forRepository);
            hashMap = mFactories;
            synchronized (hashMap) {
                ClientFactory cachedFactory = mFactories.get(key);
                if (cachedFactory != null) {
                    block11: {
                        try {
                            factory.clear();
                        }
                        catch (Exception e) {
                            if (!Trace.isOn(4)) break block11;
                            Trace.fireTrace(4, "[JCoAPI] ConnectionMananger.getFactory() failed to cleanup duplicate factory");
                        }
                    }
                    factory = cachedFactory;
                } else {
                    mFactories.put(key, factory);
                }
            }
        }
        return factory;
    }

    protected ClientFactory createFactory(InternalDestination destination, boolean forRepository) throws JCoException {
        PoolingFactory factory = new PoolingFactory(destination, forRepository);
        ((ClientFactory)factory).init(destination);
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFactories(InternalDestination destination) {
        ClientFactory removed = null;
        ClientFactory removedRepositoryFactory = null;
        HashMap<String, ClientFactory> hashMap = mFactories;
        synchronized (hashMap) {
            removed = mFactories.remove(destination.getDestinationID());
            removedRepositoryFactory = mFactories.remove(destination.getRepositoryKey());
        }
        if (removed != null) {
            removed.clear();
        }
        if (removedRepositoryFactory != null) {
            removedRepositoryFactory.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClientFactory removeFactory(ClientFactory factory) {
        String destinationKey = null;
        ClientFactory removed = null;
        boolean found = false;
        HashMap<String, ClientFactory> hashMap = mFactories;
        synchronized (hashMap) {
            Iterator<String> it = mFactories.keySet().iterator();
            while (it.hasNext() && !found) {
                destinationKey = it.next();
                if (!mFactories.get(destinationKey).equals(factory)) continue;
                found = true;
                break;
            }
            if (found && factory.getCurrentPoolSize() == 0) {
                removed = mFactories.remove(destinationKey);
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void updateFactory(RfcDestination oldDestination, RfcDestination newDestination) {
        ClientFactory oldFactory = mFactories.get(oldDestination.getDestinationID());
        if (oldFactory == null) {
            throw new JCoRuntimeException(108, "JCO_ERROR_INTERNAL", "error in ConnectionManager.updateFactory: no factory found for the given destination");
        }
        if (oldDestination.equals(newDestination)) {
            HashMap<String, ClientFactory> hashMap = mFactories;
            synchronized (hashMap) {
                mFactories.remove(oldDestination.getDestinationID());
                mFactories.put(newDestination.getDestinationID(), oldFactory);
            }
            oldFactory.updateDestination(newDestination);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void internalExecute(JCoFunction function, JCoDestination destination, boolean repositoryCall) throws JCoException {
        ClientConnection client = null;
        if (destination == null) {
            throw new JCoException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "call cannot be executed because the destination is null.");
        }
        try {
            client = ConnectionManager.getConnectionManager().getClient((InternalDestination)destination, repositoryCall, false);
            client.execute(function, destination.getRepository());
            Object var6_5 = null;
            if (client == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (client == null) throw throwable;
            ConnectionManager.getConnectionManager().releaseClient(client);
            throw throwable;
        }
        ConnectionManager.getConnectionManager().releaseClient(client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getMonitoredData(List<MonitoredConnectionData> monitoredData) {
        ArrayList<ClientFactory> factories = new ArrayList<ClientFactory>();
        HashMap<String, ClientFactory> hashMap = mFactories;
        synchronized (hashMap) {
            factories.addAll(mFactories.values());
        }
        Iterator it = factories.iterator();
        while (it.hasNext()) {
            ((ClientFactory)it.next()).getMonitoredData(monitoredData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ClientFactory> getCopyOfAllFactories() {
        ArrayList<ClientFactory> factories = new ArrayList<ClientFactory>();
        HashMap<String, ClientFactory> hashMap = mFactories;
        synchronized (hashMap) {
            factories.addAll(mFactories.values());
        }
        return factories;
    }

    ClientFactory getFactoryByDestinationID(String destinationID) {
        if (destinationID != null) {
            ClientFactory clientFactory = mFactories.get(destinationID);
            return clientFactory;
        }
        return null;
    }
}

