/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.server.auth;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.UserIdentity;
import com.helpsystems.common.core.dm.IUserListManager;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class LdapUserListManager
extends AbstractManager
implements IUserListManager {
    protected String serverName;
    protected String username;
    protected String password;
    private String searchBase;
    private String objectClass;
    private String attributeName;

    public LdapUserListManager(String string, String string2, String string3) {
        this.setName(string);
        this.serverName = string2;
        this.searchBase = string3;
        this.setUsername(null);
        this.setPassword(null);
        this.setObjectClass(null);
        this.setAttributeName(null);
    }

    protected DirContext getContext() throws NamingException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        hashtable.put("java.naming.provider.url", "ldap://" + this.serverName);
        hashtable.put("java.naming.security.authentication", "simple");
        if (this.username != null) {
            hashtable.put("java.naming.security.principal", this.username);
        }
        if (this.password != null) {
            hashtable.put("java.naming.security.credentials", this.password);
        }
        InitialDirContext initialDirContext = new InitialDirContext(hashtable);
        return initialDirContext;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getObjectClass() {
        return this.objectClass;
    }

    public String getSearchBase() {
        return this.searchBase;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public String[] getUsers(UserIdentity userIdentity, String string) throws ResourceUnavailableException {
        Object[] objectArray;
        Vector<String> vector = new Vector<String>();
        try {
            objectArray = this.getContext();
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            String string2 = "(objectClass=" + this.objectClass + ")";
            NamingEnumeration<SearchResult> namingEnumeration = objectArray.search(this.searchBase, string2, searchControls);
            while (namingEnumeration.hasMore()) {
                String string3;
                SearchResult searchResult = namingEnumeration.next();
                Attributes attributes = searchResult.getAttributes();
                Attribute attribute = attributes.get(this.attributeName);
                if (attribute == null || (string3 = (String)attribute.get()) == null) continue;
                string3 = string3.toUpperCase();
                vector.add(string3);
            }
        }
        catch (NamingException namingException) {
            throw new ResourceUnavailableException("Unable to retrieve the user list", (Throwable)namingException);
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public String getUserAttribute(String string, String string2) throws NamingException {
        DirContext dirContext = this.getContext();
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        String string3 = "(" + this.attributeName + "=" + string + ")";
        NamingEnumeration<SearchResult> namingEnumeration = dirContext.search(this.searchBase, string3, searchControls);
        if (namingEnumeration.hasMore()) {
            SearchResult searchResult = namingEnumeration.next();
            Attributes attributes = searchResult.getAttributes();
            if (attributes == null) {
                return null;
            }
            Attribute attribute = attributes.get(string2);
            if (attribute == null) {
                return null;
            }
            Object object = attribute.get();
            if (object == null) {
                return null;
            }
            return object.toString();
        }
        return null;
    }

    public void setAttributeName(String string) {
        this.attributeName = string == null || string.length() == 0 ? "sAMAccountName" : string;
    }

    public void setObjectClass(String string) {
        this.objectClass = string == null || string.length() == 0 ? "user" : string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setSearchBase(String string) {
        this.searchBase = string;
    }

    public void setServerName(String string) {
        this.serverName = string;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public static void main(String[] stringArray) {
        PrintStream printStream = System.out;
        if (stringArray.length < 2) {
            LdapUserListManager.showHelp();
            return;
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        string = stringArray[0];
        string2 = stringArray[1];
        if (stringArray.length > 2) {
            for (int i = 2; i < stringArray.length; ++i) {
                if ("-u".equals(stringArray[i])) {
                    if (i + 1 > stringArray.length) {
                        printStream.println("Please specify the username after the -u flag.");
                        LdapUserListManager.showHelp();
                        return;
                    }
                    string3 = stringArray[++i];
                }
                if ("-p".equals(stringArray[i])) {
                    if (i + 1 > stringArray.length) {
                        printStream.println("Please specify the password after the -p flag.");
                        LdapUserListManager.showHelp();
                        return;
                    }
                    string4 = stringArray[++i];
                }
                if ("-o".equals(stringArray[i])) {
                    if (i + 1 > stringArray.length) {
                        printStream.println("Please specify the objectClass after the -o flag.");
                        LdapUserListManager.showHelp();
                        return;
                    }
                    ++i;
                }
                if ("-a".equals(stringArray[i])) {
                    if (i + 1 > stringArray.length) {
                        printStream.println("Please specify the attribute name after the -a flag.");
                        LdapUserListManager.showHelp();
                        return;
                    }
                    string5 = stringArray[++i];
                }
                if (!"-x".equals(stringArray[i])) continue;
                if (i + 2 > stringArray.length) {
                    printStream.println("Please specify the username and the extra attribute name after the -x flag.");
                    LdapUserListManager.showHelp();
                    return;
                }
                ++i;
                ++i;
            }
        }
        LdapUserListManager ldapUserListManager = new LdapUserListManager(null, string, string2);
        ldapUserListManager.setUsername(string3);
        ldapUserListManager.setPassword(string4);
        ldapUserListManager.setSearchBase(string2);
        ldapUserListManager.setAttributeName(string5);
        String[] stringArray2 = null;
        try {
            stringArray2 = ldapUserListManager.getUsers(null, null);
        }
        catch (Exception exception) {
            printStream.println("Error retrieving user list:");
            exception.printStackTrace();
        }
        if (stringArray2 != null) {
            printStream.println(stringArray2.length + " matches");
            for (int i = 0; i < stringArray2.length; ++i) {
                printStream.println("\t" + stringArray2[i]);
            }
        }
    }

    public static void showHelp() {
        PrintStream printStream = System.out;
        printStream.println("Usage:");
        printStream.println("\tserverName\t The name of the LDAP server, like MyLdap or MyLdap:389");
        printStream.println("\tsearchBase\t The node where to start searching for users.");
        printStream.println("\t\t\t Like: dc=mydomain,dc=com");
        printStream.println("\t\t\t   Or: o=mydomain,c=us");
        printStream.println("\t-u username\t If the LDAP server does not allow anonymous queries, then");
        printStream.println("\t\t\t a username is required.");
        printStream.println("\t-p password\t The password for the specified username");
        printStream.println("\t-o objectClass\t The object class for users. Default is \"user\"");
        printStream.println("\t-a attribute\t The attribute that contains the username.");
        printStream.println("\t\t\t Default is \"sAMAccountName\"");
    }
}

