/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.server.access;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.busobj.UserIdentity;
import com.helpsystems.common.server.access.ServerInfoDMImpl;
import com.helpsystems.common.server.busobj.LinuxServer;
import com.helpsystems.common.server.busobj.Server;
import com.helpsystems.common.server.dm.ServerInfoDM;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

public class LinuxServerInfoDMImpl
extends AbstractManager
implements ServerInfoDM {
    public LinuxServerInfoDMImpl() throws IOException {
        File file = new File("/proc");
        if (!file.exists()) {
            throw new IOException("The virtual directory /proc does not exist.");
        }
        if (!file.isDirectory()) {
            throw new IOException("The entry /proc is a file, but should be a directory.");
        }
        this.setName("COMMON.ServerInfoDM");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillCPUInfo(LinuxServer linuxServer) throws IOException {
        FileReader fileReader = new FileReader("/proc/cpuinfo");
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        ArrayList<CPUInfo> arrayList = new ArrayList<CPUInfo>();
        CPUInfo cPUInfo = null;
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.startsWith("model name")) {
                    cPUInfo = new CPUInfo();
                    arrayList.add(cPUInfo);
                    cPUInfo.name = this.parseValue(string);
                    if (cPUInfo.name == null) {
                        cPUInfo.name = "unknown (" + string + ")";
                    }
                }
                if (!string.startsWith("cpu MHz")) continue;
                cPUInfo.speed = this.parseValue(string);
                if (cPUInfo.speed != null) continue;
                cPUInfo.speed = "unknown (" + string + ")";
            }
            String[] stringArray = new String[arrayList.size()];
            String[] stringArray2 = new String[arrayList.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                cPUInfo = (CPUInfo)arrayList.get(i);
                stringArray[i] = cPUInfo.name;
                stringArray2[i] = cPUInfo.speed;
            }
            linuxServer.setProcessorType(stringArray);
            linuxServer.setProcessorSpeed(stringArray2);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {}
            try {
                fileReader.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillMemInfo(LinuxServer linuxServer) throws IOException {
        block13: {
            FileReader fileReader = new FileReader("/proc/meminfo");
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            try {
                String string;
                do {
                    if ((string = bufferedReader.readLine()) != null) continue;
                    break block13;
                } while (!string.startsWith("MemTotal"));
                String string2 = this.parseValue(string);
                if (string2 == null) {
                    string2 = "unknown (" + string + ")";
                }
                linuxServer.setPhysicalMemory(string2);
            }
            finally {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
                try {
                    fileReader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public Server getServerInfo(UserIdentity userIdentity) throws IOException {
        LinuxServer linuxServer = new LinuxServer();
        ServerInfoDMImpl.fillDefaultValues(linuxServer);
        this.fillCPUInfo(linuxServer);
        return linuxServer;
    }

    protected String parseValue(String string) {
        int n = string.indexOf(":");
        if (n > 0) {
            if (n + 1 < string.length()) {
                return string.substring(n + 1).trim();
            }
            return null;
        }
        return null;
    }

    class CPUInfo {
        String name;
        String speed;

        CPUInfo() {
        }
    }
}

