/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.remoteserver;

import com.helpsystems.common.core.access.ManagerNotFoundException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.common.tl.Peer;
import com.helpsystems.common.tl.PeerDescriptor;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.common.tl.ex.RemoteManagerNotFoundException;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.remoteserver.RemoteServerException;
import com.helpsystems.enterprise.core.remoteserver.RemoteServerStatus;
import com.helpsystems.enterprise.core.remoteserver.RemoteServerType;
import com.helpsystems.enterprise.core.remoteserver.RemoteServerUnreachableException;
import com.helpsystems.enterprise.core.remoteserver.RemoteServersDM;
import com.helpsystems.enterprise.core.remoteserver.RemoteSkybotServer;
import com.helpsystems.enterprise.core.remoteserver.RemoteSkybotServerDM;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class RemoteSkybotServerConnector {
    private static final Logger logger = Logger.getLogger(RemoteSkybotServerConnector.class);
    private RemoteServersDM remoteServersDM;
    private Peer peer;
    private Object connectLock = new Object();
    ScheduledThreadPoolExecutor connectionExecutor = new ScheduledThreadPoolExecutor(1);
    private Map<Long, ConnectorTask> connectorTasks = new HashMap<Long, ConnectorTask>();
    private Map<Long, ScheduledFuture> workerTasks = new HashMap<Long, ScheduledFuture>();

    public RemoteSkybotServerConnector(RemoteServersDM remoteServersDM, Peer peer) {
        ValidationHelper.checkForNull((String)"RemoteServersDM", (Object)remoteServersDM);
        ValidationHelper.checkForNull((String)"Peer", (Object)peer);
        this.remoteServersDM = remoteServersDM;
        this.peer = peer;
    }

    public void approve(long l, String string) throws RemoteServerUnreachableException, RemoteServerException {
        RemoteServersDM remoteServersDM;
        RemoteSkybotServer remoteSkybotServer;
        try {
            remoteSkybotServer = (RemoteSkybotServer)this.remoteServersDM.getServer(l);
        }
        catch (Exception exception) {
            throw new RemoteServerException(MessageUtil.formatMsg((String)"Approval process failed. There is a problem loading the information for the remote server with id={0}.", (Object[])new Object[]{l}), (Throwable)exception);
        }
        if (remoteSkybotServer.getStatus() != RemoteServerStatus.APPROVAL_REQUIRED) {
            throw new RemoteServerException("Approval process failed. The remote server must be in the approval required status.");
        }
        try {
            remoteServersDM = (RemoteServersDM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)remoteSkybotServer, (String)"ENTERPRISE.RemoteServersDM");
        }
        catch (ManagerNotFoundException managerNotFoundException) {
            throw new RemoteServerUnreachableException("Approval process failed. The remote server is offline.");
        }
        catch (Exception exception) {
            throw new RemoteServerException("Approval process failed.", (Throwable)exception);
        }
        try {
            long l2 = this.ourRemoteServerIDInTheirDatabase(remoteSkybotServer);
            remoteServersDM.recordApproval(l2);
            this.remoteServersDM.recordApproval(l);
        }
        catch (Exception exception) {
            throw new RemoteServerException("Approval process failed.", (Throwable)exception);
        }
        RosettaMsg rosettaMsg = RosettaMsg.REMOTE_SERVER_APPROVED;
        String[] stringArray = new String[]{remoteSkybotServer.getName(), string};
        ScheduleLogEntry scheduleLogEntry = new ScheduleLogEntry(rosettaMsg, stringArray);
        ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
        logger.info((Object)scheduleLogEntry.getMessageText());
    }

    public void register(long l) throws RemoteServerUnreachableException, RemoteServerException {
        RemoteSkybotServerDM remoteSkybotServerDM;
        RemoteSkybotServer remoteSkybotServer;
        try {
            remoteSkybotServer = (RemoteSkybotServer)this.remoteServersDM.getServer(l);
        }
        catch (Exception exception) {
            throw new RemoteServerException(MessageUtil.formatMsg((String)"Registration failed. There is a problem loading the information for the remote server with id={0}.", (Object[])new Object[]{l}), (Throwable)exception);
        }
        if (remoteSkybotServer.getStatus() != RemoteServerStatus.REGISTRATION_REQUIRED) {
            throw new RemoteServerException("Registration failed. The remote server must be in the registration required status.");
        }
        PeerID peerID = this.retrieveExistingConnection(remoteSkybotServer);
        if (peerID == null) {
            throw new RemoteServerUnreachableException("Registration failed. The remote server is offline.");
        }
        if (this.isPointsToItself(peerID)) {
            throw new RemoteServerException("Registration failed. The remote server points to itself.");
        }
        try {
            remoteSkybotServerDM = (RemoteSkybotServerDM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)remoteSkybotServer, (String)"ENTERPRISE.RemoteSkybotServerDM");
        }
        catch (RemoteManagerNotFoundException remoteManagerNotFoundException) {
            if (remoteManagerNotFoundException.getExtendedErrorCode() == 1 || remoteManagerNotFoundException.getExtendedErrorCode() == 3) {
                throw new RemoteServerUnreachableException("Registration failed. The remote server is offline.");
            }
            throw new RemoteServerException("Registration failed. The remote server does not support this feature.");
        }
        catch (ManagerNotFoundException managerNotFoundException) {
            throw new RemoteServerException("Registration failed. The remote server does not support this feature.");
        }
        catch (Exception exception) {
            throw new RemoteServerException("Registration failed.", (Throwable)exception);
        }
        long l2 = System.currentTimeMillis();
        long l3 = remoteSkybotServerDM.register(l, l2, this.thisServerName());
        try {
            this.remoteServersDM.recordRegistrationInfo(l, l2, l3);
        }
        catch (Exception exception) {
            throw new RemoteServerException("Registration incomplete. Error while trying to record the registration information and update the status.", (Throwable)exception);
        }
        try {
            RemoteServersDM remoteServersDM = (RemoteServersDM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)remoteSkybotServer, (String)"ENTERPRISE.RemoteServersDM");
            long l4 = l3;
            PeerID peerID2 = this.peer.getRemotePeerID();
            String string = peerID2.getHardwareHash();
            String string2 = peerID2.getInstanceIdentifier().toString();
            remoteServersDM.updateHardwareInfo(l4, string, string2);
        }
        catch (Exception exception) {
            logger.error((Object)MessageUtil.formatMsg((String)"Registration incomplete. Error while trying to record our hardware information in the database of remote server {0}.", (Object[])new Object[]{remoteSkybotServer.getName()}), (Throwable)exception);
        }
        this.notifyConnectorTaskOfRegistration(l, l2, l3);
    }

    public void remoteServerChangedOrAdded(long l) {
        try {
            boolean bl;
            RemoteSkybotServer remoteSkybotServer = (RemoteSkybotServer)this.remoteServersDM.getServer(l);
            boolean bl2 = bl = !remoteSkybotServer.isCreatedByRemoteServer();
            if (bl) {
                if (this.connectorTasks.containsKey(l)) {
                    this.remoteServerUpdated(remoteSkybotServer);
                } else {
                    this.addConnectorTask(remoteSkybotServer);
                }
            }
        }
        catch (Exception exception) {
            logger.error((Object)MessageUtil.formatMsg((String)"The Automate Schedule Server has been notified that the database entry for remote server {0} has been changed or created. However, an error occurred while trying to process this information.", (Object[])new Object[]{this.remoteServerName(l)}), (Throwable)exception);
        }
    }

    public void remoteServerDeleted(long l, String string, String string2, String string3) {
        String[] stringArray;
        RosettaMsg rosettaMsg = null;
        ConnectorTask connectorTask = this.removeConnectorTask(l);
        PeerID peerID = this.getActiveConnectionToServer(string2, string3);
        if (peerID != null) {
            if (!this.isOtherConnectorTaskToThisServerThatIsConnected()) {
                rosettaMsg = RosettaMsg.REMOTE_SERVER_DELETED_AND_ACTIVE_CONNECTION;
                this.peer.disconnectFromPeer(peerID);
            } else {
                stringArray = MessageUtil.formatMsg((String)"The database entry for remote server {0} (ID = {1}) was deleted. There is an active connection to that remote server and it will not be ended because another remote server entry is using the connection.", (Object[])new Object[]{string, l});
                logger.info((Object)stringArray);
            }
        } else {
            rosettaMsg = RosettaMsg.REMOTE_SERVER_DELETED_AND_NO_ACTIVE_CONNECTION;
        }
        if (rosettaMsg != null) {
            try {
                stringArray = new String[]{string, Long.toString(l)};
                ScheduleLogEntry scheduleLogEntry = new ScheduleLogEntry(rosettaMsg, stringArray);
                ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
                logger.info((Object)scheduleLogEntry.getMessageText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void addConnectorTask(long l) {
        try {
            RemoteSkybotServer remoteSkybotServer = (RemoteSkybotServer)this.remoteServersDM.getServer(l);
            this.addConnectorTask(remoteSkybotServer);
        }
        catch (Exception exception) {
            logger.error((Object)MessageUtil.formatMsg((String)"Unable to start a task to connect to remote server {0}.", (Object[])new Object[]{this.remoteServerName(l)}), (Throwable)exception);
        }
    }

    private void addConnectorTask(RemoteSkybotServer remoteSkybotServer) {
        ConnectorTask connectorTask = new ConnectorTask(remoteSkybotServer);
        ScheduledFuture<?> scheduledFuture = this.connectionExecutor.scheduleWithFixedDelay(connectorTask, 0L, 60L, TimeUnit.SECONDS);
        this.workerTasks.put(remoteSkybotServer.getId(), scheduledFuture);
        this.connectorTasks.put(remoteSkybotServer.getId(), connectorTask);
    }

    private PeerID getActiveConnectionToServer(String string, String string2) {
        PeerID peerID = null;
        if (string != null && string2 != null) {
            PeerID[] peerIDArray = this.peer.searchRoutingTableFor(string, (Serializable)((Object)string2));
            if (peerIDArray.length > 1) {
                logger.warn((Object)MessageUtil.formatMsg((String)"Found more than one PeerID that matches {0}:{1}. {2) {3}", (Object[])new Object[]{string, string2, peerIDArray[0], peerIDArray[1]}));
            }
            if (peerIDArray.length > 0) {
                peerID = peerIDArray[0];
            }
        }
        return peerID;
    }

    private boolean isAddressOrPortChanged(RemoteSkybotServer remoteSkybotServer, RemoteSkybotServer remoteSkybotServer2) {
        String string = remoteSkybotServer.getIpAddress().trim();
        String string2 = remoteSkybotServer2.getIpAddress().trim();
        boolean bl = !string2.equalsIgnoreCase(string);
        boolean bl2 = remoteSkybotServer2.getListenPort() != remoteSkybotServer.getListenPort();
        return bl || bl2;
    }

    private boolean isOtherConnectorTaskToThisServerThatIsConnected() {
        return false;
    }

    private boolean isPointsToItself(PeerID peerID) {
        if (peerID == null) {
            return false;
        }
        PeerID peerID2 = this.peer.getRemotePeerID();
        String string = peerID2.getHardwareHash();
        String string2 = peerID.getHardwareHash();
        return string2.equals(string);
    }

    private void notifyConnectorTaskOfRegistration(long l, long l2, long l3) {
        ConnectorTask connectorTask = this.connectorTasks.get(l);
        if (connectorTask != null) {
            RemoteSkybotServer remoteSkybotServer = connectorTask.remoteSkybotServer;
            remoteSkybotServer.setRegistered_utc(l2);
            remoteSkybotServer.setStatus(RemoteServerStatus.PENDING_REMOTE_APPROVAL);
            remoteSkybotServer.setAssignedRemoteID(l3);
        }
    }

    private long ourRemoteServerIDInTheirDatabase(RemoteSkybotServer remoteSkybotServer) throws NoDataException, ResourceUnavailableException {
        RemoteServersDM remoteServersDM = (RemoteServersDM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)remoteSkybotServer, (String)"ENTERPRISE.RemoteServersDM");
        return remoteServersDM.getServerID(remoteSkybotServer.getRegistered_utc(), RemoteServerType.SKYBOT);
    }

    private ConnectorTask removeConnectorTask(long l) {
        ConnectorTask connectorTask = this.connectorTasks.remove(l);
        ScheduledFuture scheduledFuture = this.workerTasks.remove(l);
        if (scheduledFuture != null) {
            boolean bl = false;
            scheduledFuture.cancel(bl);
        }
        return connectorTask;
    }

    private void remoteServerUpdated(RemoteSkybotServer remoteSkybotServer) {
        RemoteSkybotServer remoteSkybotServer2;
        long l = remoteSkybotServer.getId();
        ConnectorTask connectorTask = this.connectorTasks.get(l);
        if (connectorTask != null && this.isAddressOrPortChanged(remoteSkybotServer2 = connectorTask.remoteSkybotServer, remoteSkybotServer)) {
            this.removeConnectorTask(l);
            String string = remoteSkybotServer2.getHardwareHash();
            String string2 = remoteSkybotServer2.getInstanceIdentifier();
            PeerID peerID = this.getActiveConnectionToServer(string, string2);
            if (peerID != null && !this.isOtherConnectorTaskToThisServerThatIsConnected()) {
                this.peer.disconnectFromPeer(peerID);
            }
            try {
                RosettaMsg rosettaMsg = RosettaMsg.REMOTE_SERVER_FORCED_DISCONNECT;
                String[] stringArray = new String[]{remoteSkybotServer.getName(), Long.toString(l)};
                ScheduleLogEntry scheduleLogEntry = new ScheduleLogEntry(rosettaMsg, stringArray);
                ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
                logger.warn((Object)scheduleLogEntry.getMessageText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.addConnectorTask(remoteSkybotServer);
        }
    }

    private String remoteServerName(long l) {
        return this.remoteServersDM.getServerName(l);
    }

    private PeerID retrieveExistingConnection(RemoteSkybotServer remoteSkybotServer) {
        PeerDescriptor peerDescriptor = new PeerDescriptor();
        peerDescriptor.setType(6);
        peerDescriptor.addAddress(remoteSkybotServer.getIpAddress());
        peerDescriptor.setPort(remoteSkybotServer.getListenPort());
        PeerID[] peerIDArray = this.peer.searchRoutingTableFor(peerDescriptor);
        if (peerIDArray.length > 0) {
            return peerIDArray[0];
        }
        return null;
    }

    private String thisServerName() {
        String string = null;
        try {
            string = System.getenv("COMPUTERNAME");
            if (string == null || string.isEmpty()) {
                try {
                    InetAddress inetAddress = InetAddress.getLocalHost();
                    string = inetAddress.getHostName();
                }
                catch (UnknownHostException unknownHostException) {}
            }
        }
        catch (Exception exception) {
            logger.warn((Object)"Error retrieving server name.", (Throwable)exception);
        }
        if (string == null || string.isEmpty()) {
            string = "UNKNOWN SERVER";
        }
        int n = 256;
        if (string.length() > n) {
            string = string.substring(0, n);
        }
        return string;
    }

    static RemoteSkybotServerConnector createAndStartConnector(Peer peer) {
        long[] lArray;
        RemoteServersDM remoteServersDM = (RemoteServersDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.RemoteServersDM");
        try {
            lArray = remoteServersDM.getRemoteServersThatWeInitiateConnectionTo();
            if (lArray.length == 0) {
                return null;
            }
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)"Unable to create and start the Remote Automate Schedule Server Connector process. Error while trying to get a list of the remote servers that we connect to.", (Throwable)resourceUnavailableException);
            return null;
        }
        RemoteSkybotServerConnector remoteSkybotServerConnector = new RemoteSkybotServerConnector(remoteServersDM, peer);
        for (long l : lArray) {
            remoteSkybotServerConnector.addConnectorTask(l);
        }
        return remoteSkybotServerConnector;
    }

    static boolean testAccessToRemoteServer(RemoteSkybotServer remoteSkybotServer) throws RemoteServerUnreachableException {
        InetAddress inetAddress;
        ValidationHelper.checkForNull((String)"Remote Skybot Server", (Object)remoteSkybotServer);
        ValidationHelper.validateReqFieldForNullAndBlank((String)"IP Address", (String)remoteSkybotServer.getIpAddress());
        String string = remoteSkybotServer.getIpAddress();
        int n = remoteSkybotServer.getListenPort();
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            throw new RemoteServerUnreachableException(MessageUtil.formatMsg((String)"Unable to resolve the IP address for server/host name {0}.", (Object[])new Object[]{string}));
        }
        if (inetAddress.isLoopbackAddress()) {
            throw new RemoteServerUnreachableException(MessageUtil.formatMsg((String)"You are trying to test a connection to yourself. {0} ({1}).", (Object[])new Object[]{string, inetAddress.getHostAddress()}));
        }
        Socket socket = null;
        try {
            socket = new Socket();
            InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress.getHostAddress(), n);
            socket.connect(inetSocketAddress, 5000);
        }
        catch (Exception exception) {
            throw new RemoteServerUnreachableException(MessageUtil.formatMsg((String)"Unable to access the server at {0}:{1}.", (Object[])new Object[]{inetAddress.getHostAddress(), n}), (Throwable)exception);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    private class ConnectorTask
    implements Runnable {
        private boolean connected;
        private boolean synched;
        private int synchUpCount;
        private PeerID synchedToPeerID;
        private long mostRecentConnect;
        private long firstConnectAttempt;
        private Exception lastFailureReason;
        private RemoteSkybotServer remoteSkybotServer;
        private PeerDescriptor pd = new PeerDescriptor();
        private PeerID credentials;
        private int connectAttemptFailureCount = 0;
        private int connectAttemptFailureMessageMax = 1;

        private ConnectorTask(RemoteSkybotServer remoteSkybotServer) {
            this.remoteSkybotServer = remoteSkybotServer;
            this.pd.setType(6);
            this.pd.addAddress(remoteSkybotServer.getIpAddress());
            this.pd.setPort(remoteSkybotServer.getListenPort());
            this.credentials = RemoteSkybotServerConnector.this.peer.getRemotePeerID();
        }

        @Override
        public void run() {
            try {
                this.maintainConnection();
            }
            catch (Throwable throwable) {
                if (throwable instanceof ThreadDeath) {
                    throw (ThreadDeath)throwable;
                }
                try {
                    logger.info((Object)MessageUtil.formatMsg((String)"The Connector task to remote server {0} has encountered an unexpected error.", (Object[])new Object[]{this.serverDescription(), throwable}));
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void maintainConnection() {
            PeerID peerID;
            Object object = RemoteSkybotServerConnector.this.connectLock;
            synchronized (object) {
                peerID = this.retrieveExistingConnection();
                if (peerID != null) {
                    this.connected = true;
                    boolean bl = this.synched = peerID == this.synchedToPeerID;
                    if (!this.synched) {
                        this.synchUpCount = 0;
                        this.synchedToPeerID = null;
                    }
                } else {
                    this.connected = false;
                    this.synched = false;
                    this.synchUpCount = 0;
                    this.synchedToPeerID = null;
                    peerID = this.doConnect();
                    if (peerID != null && (peerID = this.retrieveExistingConnection()) == null) {
                        logger.warn((Object)"Unable to find the peerID in the routing table.");
                        this.connected = false;
                    }
                }
            }
            if (this.synchUpRequired()) {
                this.synchUp(peerID);
            }
            if (!this.connected) {
                // empty if block
            }
        }

        private PeerID doConnect() {
            PeerID peerID;
            block6: {
                if (this.firstConnectAttempt == 0L) {
                    this.firstConnectAttempt = System.currentTimeMillis();
                }
                peerID = null;
                try {
                    peerID = RemoteSkybotServerConnector.this.peer.connectToPeer(this.pd, (Serializable)this.credentials);
                    this.connected = true;
                    if (this.mostRecentConnect == 0L) {
                        this.mostRecentConnect = System.currentTimeMillis();
                    }
                    this.connectAttemptFailureCount = 0;
                }
                catch (Exception exception) {
                    this.lastFailureReason = exception;
                    if (++this.connectAttemptFailureCount > this.connectAttemptFailureMessageMax) break block6;
                    try {
                        RosettaMsg rosettaMsg = RosettaMsg.REMOTE_SERVER_UNABLE_TO_CONNECT;
                        ScheduleLogEntry scheduleLogEntry = new ScheduleLogEntry(rosettaMsg, this.serverDescription());
                        ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
                        logger.warn((Object)scheduleLogEntry.getMessageText());
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
            }
            return peerID;
        }

        private void ensureTheirHardwareInfoIsCurrentInOurDatabase(PeerID peerID) {
            String string = peerID.getHardwareHash();
            String string2 = this.remoteSkybotServer.getHardwareHash();
            String string3 = peerID.getInstanceIdentifier().toString();
            String string4 = this.remoteSkybotServer.getInstanceIdentifier();
            boolean bl = false;
            if (this.isMissingHardwareInfo(string2, string4)) {
                bl = true;
            } else if (!string2.equals(string) || !string4.equals(string3)) {
                logger.info((Object)MessageUtil.formatMsg((String)"Detected a change in hardware information for remote server {0}. From {1} to {2}.", (Object[])new Object[]{this.remoteSkybotServer.getName(), string4 + "@" + string2, string3 + "@" + string}));
                bl = true;
            }
            if (bl) {
                long l = this.remoteSkybotServer.getId();
                try {
                    RemoteSkybotServerConnector.this.remoteServersDM.updateHardwareInfo(l, string, string3);
                }
                catch (Exception exception) {
                    logger.error((Object)MessageUtil.formatMsg((String)"Unable to update the hardware information in the database for remote server {0} Details: {1}.", (Object[])new Object[]{this.remoteSkybotServer.getName(), exception.getMessage()}));
                }
                this.remoteSkybotServer.setHardwareHash(string);
                this.remoteSkybotServer.setInstanceIdentifier(string3);
            }
        }

        private void ensureOurHardwareInfoIsCurrentInTheirDatabase() {
            if (this.remoteSkybotServer.isRegistered()) {
                try {
                    RemoteServersDM remoteServersDM = (RemoteServersDM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)this.remoteSkybotServer, (String)"ENTERPRISE.RemoteServersDM");
                    long l = RemoteSkybotServerConnector.this.ourRemoteServerIDInTheirDatabase(this.remoteSkybotServer);
                    PeerID peerID = RemoteSkybotServerConnector.this.peer.getRemotePeerID();
                    String string = peerID.getHardwareHash();
                    String string2 = peerID.getInstanceIdentifier().toString();
                    remoteServersDM.updateHardwareInfo(l, string, string2);
                }
                catch (Exception exception) {
                    logger.error((Object)MessageUtil.formatMsg((String)"Unable to update our hardware information in the database of remote server {0}. Details: {1}", (Object[])new Object[]{this.remoteSkybotServer.getName(), exception.getMessage()}));
                }
            }
        }

        private void handleMissingRemoteServerEntry(PeerID peerID) {
            String string;
            RemoteSkybotServerConnector.this.removeConnectorTask(this.remoteSkybotServer.getId());
            if (!RemoteSkybotServerConnector.this.isOtherConnectorTaskToThisServerThatIsConnected()) {
                RemoteSkybotServerConnector.this.peer.disconnectFromPeer(peerID);
                string = "and it will be ended";
            } else {
                string = "and it will not be ended because another remote server entry is using the connection";
            }
            logger.warn((Object)MessageUtil.formatMsg((String)"The database entry corresponding to remote server {0} (ID = {1}) was not found on the remote system. There is an active connection to that remote server {2}. One possibility is that it was deleted. If that is not the case, please see if the IP address has been changed and now points to a remote server that is not the one that we originally registered on. Note: The task that attempts to connect to this remote server has been ended. To restart it, select edit for the remote server and press save. No field values have to be changed.", (Object[])new Object[]{this.remoteSkybotServer.getName(), this.remoteSkybotServer.getId(), string}));
        }

        private boolean isMissingHardwareInfo(String string, String string2) {
            return string == null || string.isEmpty() || string2 == null || string2.isEmpty();
        }

        private boolean ourRemoteServerEntryExistsOnTheirSide() {
            try {
                RemoteServersDM remoteServersDM = (RemoteServersDM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)this.remoteSkybotServer, (String)"ENTERPRISE.RemoteServersDM");
                remoteServersDM.getServerID(this.remoteSkybotServer.getRegistered_utc(), RemoteServerType.SKYBOT);
            }
            catch (NoDataException noDataException) {
                return false;
            }
            catch (Exception exception) {
                logger.error((Object)MessageUtil.formatMsg((String)"Unable to determine if the database entry for our remote server exists on remote server {0} Details: {1}.", (Object[])new Object[]{this.remoteSkybotServer, exception.getMessage()}));
                return false;
            }
            return true;
        }

        private PeerID retrieveExistingConnection() {
            PeerID[] peerIDArray = RemoteSkybotServerConnector.this.peer.searchRoutingTableFor(this.pd);
            if (peerIDArray.length > 0) {
                return peerIDArray[0];
            }
            return null;
        }

        private String serverDescription() {
            return MessageUtil.formatMsg((String)"{0} ({1}:{2})", (Object[])new Object[]{this.remoteSkybotServer.getName(), this.remoteSkybotServer.getIpAddress(), this.remoteSkybotServer.getListenPort()});
        }

        private void setTheConnectedStateOnBothSidesToActive() {
            try {
                RemoteSkybotServerConnector.this.remoteServersDM.setConnectedStateToActive(this.remoteSkybotServer.getId());
            }
            catch (Exception exception) {
                logger.error((Object)MessageUtil.formatMsg((String)"Unable to set the connected state to ACTIVE for remote server {0}. Details: {1}", (Object[])new Object[]{this.remoteSkybotServer.getName(), exception.getMessage()}));
            }
            if (this.remoteSkybotServer.isRegistered()) {
                try {
                    RemoteServersDM remoteServersDM = (RemoteServersDM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)this.remoteSkybotServer, (String)"ENTERPRISE.RemoteServersDM");
                    remoteServersDM.setConnectedStateToActive(RemoteSkybotServerConnector.this.ourRemoteServerIDInTheirDatabase(this.remoteSkybotServer));
                }
                catch (Exception exception) {
                    logger.error((Object)MessageUtil.formatMsg((String)"Unable to set the connected state to ACTIVE on remote server {0}. Details: {1}", (Object[])new Object[]{this.remoteSkybotServer.getName(), exception.getMessage()}));
                }
            }
        }

        private void synchUp(PeerID peerID) {
            this.ensureTheirHardwareInfoIsCurrentInOurDatabase(peerID);
            if (this.remoteSkybotServer.isRegistered()) {
                if (this.ourRemoteServerEntryExistsOnTheirSide()) {
                    this.ensureOurHardwareInfoIsCurrentInTheirDatabase();
                    this.setTheConnectedStateOnBothSidesToActive();
                } else {
                    this.handleMissingRemoteServerEntry(peerID);
                }
            }
            this.synchedToPeerID = peerID;
            ++this.synchUpCount;
        }

        private boolean synchUpRequired() {
            return this.connected && (!this.synched || this.synchUpCount < 2);
        }
    }
}

