/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.remoteserver;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.IAbstractManager;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.common.tl.Peer;
import com.helpsystems.common.tl.PeerDescriptor;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.enterprise.core.busobj.PrereqEventType;
import com.helpsystems.enterprise.core.busobj.UnknownEnumException;
import com.helpsystems.enterprise.core.busobj.rbtschedule.RemoteEvent;
import com.helpsystems.enterprise.core.dm.rbtschedule.RemoteEventDM;
import com.helpsystems.enterprise.core.remoteserver.RemoteDependencyNotification;
import com.helpsystems.enterprise.core.remoteserver.RemoteDependencyNotification_TL;
import com.helpsystems.enterprise.core.remoteserver.RemoteEventType;
import com.helpsystems.enterprise.core.remoteserver.RemoteObject;
import com.helpsystems.enterprise.core.remoteserver.RemoteScheduleServer;
import com.helpsystems.enterprise.core.remoteserver.RemoteServer;
import com.helpsystems.enterprise.core.remoteserver.RemoteServerAM;
import com.helpsystems.enterprise.core.remoteserver.RemoteServerDM;
import com.helpsystems.enterprise.core.remoteserver.RemoteServerException;
import com.helpsystems.enterprise.core.remoteserver.RemoteServerNotConfiguredException;
import com.helpsystems.enterprise.core.remoteserver.RemoteServerStatus;
import com.helpsystems.enterprise.core.remoteserver.RemoteServerType;
import com.helpsystems.enterprise.core.remoteserver.RemoteServerUnreachableException;
import com.helpsystems.enterprise.core.remoteserver.RemoteServersDM;
import com.helpsystems.enterprise.core.remoteserver.RemoteSkybotServer;
import com.helpsystems.enterprise.core.scheduler.PrereqDM;
import com.helpsystems.enterprise.core.scheduler.PrereqStatusType;
import com.helpsystems.enterprise.remoteserver.RemoteScheduleServerInstaller;
import com.helpsystems.enterprise.remoteserver.RemoteServerDMScheduleImpl;
import com.helpsystems.enterprise.remoteserver.RemoteServerDMScheduleImplSimulator;
import com.helpsystems.enterprise.remoteserver.RemoteServerNotificationMonitor;
import com.helpsystems.enterprise.remoteserver.RemoteServerRequestMonitor;
import com.helpsystems.enterprise.remoteserver.RemoteSkybotServerConnector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class RemoteServerAMImpl
extends AbstractManager
implements RemoteServerAM {
    private static final Logger logger = Logger.getLogger(RemoteServerAMImpl.class);
    private RemoteServersDM remoteServersDM;
    private RemoteSkybotServerConnector remoteSkybotServerConnector;
    private Peer peer;
    private final Map<Long, Thread> startedNotificationMonitors = new HashMap<Long, Thread>();
    private Thread requestMonitorThread;

    public RemoteServerAMImpl(RemoteServersDM remoteServersDM, Peer peer) {
        ValidationHelper.checkForNull((String)"RemoteServersDM", (Object)remoteServersDM);
        ValidationHelper.checkForNull((String)"Peer", (Object)peer);
        this.setName("ENTERPRISE.RemoteServerAM");
        this.remoteServersDM = remoteServersDM;
        this.peer = peer;
    }

    public void approve(long l, String string) throws RemoteServerUnreachableException, RemoteServerException {
        RemoteServerType remoteServerType = this.getRemoteServerType(l);
        switch (remoteServerType) {
            case SKYBOT: {
                this.remoteSkybotServerConnector().approve(l, string);
                break;
            }
            case SCHEDULE: {
                break;
            }
            default: {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Remote Server Type {0} is not supported by this method.", (Object[])new Object[]{remoteServerType}));
            }
        }
    }

    public RemoteObject[] getEvents(long l, RemoteEventType remoteEventType) throws RemoteServerNotConfiguredException, RemoteServerUnreachableException, RemoteServerException {
        RemoteServerDM remoteServerDM = this.remoteServerDM(l);
        try {
            return remoteServerDM.getEvents(remoteEventType);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw new RemoteServerException(MessageUtil.formatMsg((String)"Error while retrieving the {0} type events on remote server {1}.", (Object[])new Object[]{remoteEventType, this.getRemoteServerName(l)}), (Throwable)resourceUnavailableException);
        }
    }

    public RemoteObject[] getEvents(long l, RemoteEventType remoteEventType, String string, int n, int n2) throws RemoteServerNotConfiguredException, RemoteServerUnreachableException, RemoteServerException {
        RemoteServerDM remoteServerDM = this.remoteServerDM(l);
        try {
            return remoteServerDM.getEvents(remoteEventType, string, n, n2);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw new RemoteServerException(MessageUtil.formatMsg((String)"Error while retrieving the {0} type events on remote server {1}.", (Object[])new Object[]{remoteEventType, this.getRemoteServerName(l)}), (Throwable)resourceUnavailableException);
        }
    }

    public RemoteEventType[] getNotifiableEventTypes(RemoteServerType remoteServerType) {
        ValidationHelper.checkForNull((String)"RemoteServerType", (Object)remoteServerType);
        switch (remoteServerType) {
            case SCHEDULE: {
                return new RemoteEventType[]{RemoteEventType.JOB_STATUS_CHANGE, RemoteEventType.GROUP_JOB_STATUS_CHANGE};
            }
            case SKYBOT: {
                return new RemoteEventType[]{RemoteEventType.JOB_STATUS_CHANGE, RemoteEventType.JOB_SUITE_STATUS_CHANGE, RemoteEventType.JOB_SUITE_MEMBER_STATUS_CHANGE, RemoteEventType.AGENT_EVENT, RemoteEventType.JOB_MONITOR_EVENT, RemoteEventType.JOB_SUITE_MONITOR_EVENT, RemoteEventType.JOB_SUITE_MEMBER_MONITOR_EVENT};
            }
        }
        throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Remote Server Type {0} is not supported by this method.", (Object[])new Object[]{remoteServerType}));
    }

    public RemoteEventType[] getNotifiableEventTypes(long l) throws RemoteServerUnreachableException, RemoteServerException {
        RemoteServerDM remoteServerDM = this.remoteServerDM(l);
        int[] nArray = remoteServerDM.getNotifiableEventTypes();
        return RemoteEventType.intArrayToEnumArray((int[])nArray);
    }

    public PrereqStatusType[] getNotifiableEventStatuses(long l, RemoteEventType remoteEventType) throws RemoteServerUnreachableException, RemoteServerException {
        RemoteServerDM remoteServerDM = this.remoteServerDM(l);
        String[] stringArray = remoteServerDM.getNotifiableEventStatuses(remoteEventType);
        ArrayList<PrereqStatusType> arrayList = new ArrayList<PrereqStatusType>();
        for (String string : stringArray) {
            try {
                arrayList.add(PrereqStatusType.persistanceCodeToEnum((String)string));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return arrayList.toArray(new PrereqStatusType[arrayList.size()]);
    }

    public RemoteServerType getRemoteServerType(long l) throws RemoteServerException {
        try {
            return this.remoteServersDM.getServerType(l);
        }
        catch (NoDataException noDataException) {
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Remote server with id = {0} not found.", (Object[])new Object[]{l}));
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw new RemoteServerException("Error while trying to retrieve the server type field.", (Throwable)resourceUnavailableException);
        }
    }

    public RemoteObject[] getSuiteMembers(long l, long l2) throws RemoteServerUnreachableException, RemoteServerException {
        RemoteServerDM remoteServerDM = this.remoteServerDM(l);
        try {
            return remoteServerDM.getSuiteMembers(l2);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw new RemoteServerException(MessageUtil.formatMsg((String)"Error while retrieving the members for the suite with ID {0} on remote server {1}.", (Object[])new Object[]{l2, this.getRemoteServerName(l)}), (Throwable)resourceUnavailableException);
        }
    }

    public RemoteObject[] getSuiteMembers(long l, long l2, String string, int n, int n2) throws RemoteServerUnreachableException, RemoteServerException {
        RemoteServerDM remoteServerDM = this.remoteServerDM(l);
        try {
            return remoteServerDM.getSuiteMembers(l2, string, n, n2);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw new RemoteServerException(MessageUtil.formatMsg((String)"Error while retrieving the members for the suite with ID {0} on remote server {1}.", (Object[])new Object[]{l2, this.getRemoteServerName(l)}), (Throwable)resourceUnavailableException);
        }
    }

    public boolean isAccessible(long l) throws RemoteServerException {
        try {
            RemoteServerDM remoteServerDM = this.remoteServerDM(l);
            return remoteServerDM.areYouThere();
        }
        catch (Exception exception) {
            throw new RemoteServerException(MessageUtil.formatMsg((String)"Error while checking if remote server {0} is accessible.", (Object[])new Object[]{this.getRemoteServerName(l)}), (Throwable)exception);
        }
    }

    public boolean isObjectExists(long l, RemoteEventType remoteEventType, long l2) throws RemoteServerException {
        try {
            RemoteServer remoteServer = this.getRemoteServer(l);
            RemoteServerDM remoteServerDM = this.remoteServerDM(remoteServer);
            switch (remoteServer.getType()) {
                case SCHEDULE: {
                    return remoteServerDM.isObjectExists(remoteEventType, l2);
                }
                case SKYBOT: {
                    long l3 = ((RemoteSkybotServer)remoteServer).getRegistered_utc();
                    int n = remoteEventType.persistanceCode();
                    return remoteServerDM.isObjectExists(n, l2, l3);
                }
            }
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Remote Server Type {0} is not supported by this method.", (Object[])new Object[]{remoteServer.getType()}));
        }
        catch (Exception exception) {
            throw new RemoteServerException(MessageUtil.formatMsg((String)"Error while checking if the {0} with ID {1} exists in the database on remote server {2}.", (Object[])new Object[]{this.toEventType_forMessageString(remoteEventType), l2, this.getRemoteServerName(l)}), (Throwable)exception);
        }
    }

    public void notifyOfDependency(long l, RemoteEventType remoteEventType, long l2) throws RemoteServerNotConfiguredException, RemoteServerUnreachableException, RemoteServerException {
        try {
            RemoteServer remoteServer = this.getRemoteServer(l);
            RemoteServerDM remoteServerDM = this.remoteServerDM(remoteServer);
            switch (remoteServer.getType()) {
                case SCHEDULE: {
                    this.startRemoteServerNotificationMonitor(l);
                    remoteServerDM.notifyOfDependency(remoteEventType, l2);
                    break;
                }
                case SKYBOT: {
                    long l3 = ((RemoteSkybotServer)remoteServer).getRegistered_utc();
                    int n = remoteEventType.persistanceCode();
                    remoteServerDM.notifyOfDependency(n, l2, l3);
                    break;
                }
                default: {
                    throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Remote Server Type {0} is not supported by this method.", (Object[])new Object[]{remoteServer.getType()}));
                }
            }
        }
        catch (Exception exception) {
            throw new RemoteServerException(MessageUtil.formatMsg((String)"Error while notifying remote server {0} of a dependency for the {1} with ID {2}.", (Object[])new Object[]{this.getRemoteServerName(l), this.toEventType_forMessageString(remoteEventType), l2}), (Throwable)exception);
        }
    }

    public void notifyOfDependencyRemoval(long l) throws RemoteServerNotConfiguredException, RemoteServerUnreachableException, RemoteServerException {
        block9: {
            try {
                RemoteEventDM remoteEventDM = (RemoteEventDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.RemoteEventDM");
                RemoteEvent remoteEvent = remoteEventDM.get(l);
                if (this.eventIsAPrerequisite(l)) break block9;
                long l2 = remoteEvent.getRemoteServerID();
                RemoteServer remoteServer = this.getRemoteServer(l2);
                try {
                    RemoteServerDM remoteServerDM = this.remoteServerDM(remoteServer);
                    switch (remoteServer.getType()) {
                        case SCHEDULE: {
                            long l3 = ((RemoteScheduleServer)remoteServer).getInstalledDateTime();
                            int n = remoteServerDM.removeDependency(remoteEvent.getRemoteObjectID(), remoteEvent.getEventType(), l3);
                            logger.info((Object)("Robot-Automate Schedule deleted count for Remote Event ID " + l + " for Remote Object " + remoteEvent.getRemoteObjectName() + " (" + remoteEvent.getRemoteObjectID() + ")" + " type " + remoteEvent.getEventType() + ": " + n));
                            break;
                        }
                        case SKYBOT: {
                            int n = remoteEvent.getTypeAsInt();
                            long l4 = remoteEvent.getRemoteObjectID();
                            long l5 = ((RemoteSkybotServer)remoteServer).getRegistered_utc();
                            remoteServerDM.removeDependency(n, l4, l5);
                            break;
                        }
                        default: {
                            throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Remote Server Type {0} is not supported by this method.", (Object[])new Object[]{remoteServer.getType()}));
                        }
                    }
                }
                catch (Exception exception) {
                    String string = MessageUtil.formatMsg((String)"{0} for the object {1}", (Object[])new Object[]{remoteEvent.getEventType(), remoteEvent.getRemoteObjectName()});
                    logger.warn((Object)MessageUtil.formatMsg((String)"Unable to notify remote server {0} to stop notifying us when {1} occurs. Another attempt will be made if/when that remote server tries to notify us of the event occurring.", (Object[])new Object[]{remoteServer.getName(), string}), (Throwable)exception);
                }
                int n = remoteEventDM.delete(l);
                if (n > 0) {
                    logger.info((Object)MessageUtil.formatMsg((String)"Remote event {0} was deleted, because it is no longer used as a prerequisite.", (Object[])new Object[]{this.toString(remoteEvent)}));
                }
            }
            catch (Exception exception) {
                throw new RemoteServerException(MessageUtil.formatMsg((String)"Error while processing the notification that a dependency on the remote event with ID {0} has been removed.", (Object[])new Object[]{l}), (Throwable)exception);
            }
        }
    }

    public long notifyOfEvent(RemoteDependencyNotification remoteDependencyNotification) throws RemoteServerNotConfiguredException, RemoteServerUnreachableException, RemoteServerException, UnknownEnumException {
        long l = remoteDependencyNotification.getServerID();
        try {
            RemoteServer remoteServer = this.getRemoteServer(l);
            RemoteServerDM remoteServerDM = this.remoteServerDM(remoteServer);
            switch (remoteServer.getType()) {
                case SCHEDULE: {
                    return remoteServerDM.notifyOfEvent(remoteDependencyNotification);
                }
                case SKYBOT: {
                    long l2 = ((RemoteSkybotServer)remoteServer).getRegistered_utc();
                    RemoteDependencyNotification_TL remoteDependencyNotification_TL = RemoteDependencyNotification_TL.fromRemoteDependencyNotification((RemoteDependencyNotification)remoteDependencyNotification);
                    return remoteServerDM.notifyOfEvent(remoteDependencyNotification_TL, l2);
                }
            }
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Remote Server Type {0} is not supported by this method.", (Object[])new Object[]{remoteServer.getType()}));
        }
        catch (UnknownEnumException unknownEnumException) {
            throw unknownEnumException;
        }
        catch (Exception exception) {
            throw new RemoteServerException(MessageUtil.formatMsg((String)"Error while notifying remote server {0} of event {1}.", (Object[])new Object[]{this.getRemoteServerName(l), remoteDependencyNotification}), (Throwable)exception);
        }
    }

    public void install(long l) throws RemoteServerUnreachableException, RemoteServerException {
        RemoteServerType remoteServerType = this.getRemoteServerType(l);
        switch (remoteServerType) {
            case SCHEDULE: {
                long l2 = 0L;
                RemoteServerDM remoteServerDM = this.getDataManager(l);
                if (remoteServerDM instanceof RemoteServerDMScheduleImpl) {
                    RemoteServerDMScheduleImpl remoteServerDMScheduleImpl = (RemoteServerDMScheduleImpl)remoteServerDM;
                    l2 = new RemoteScheduleServerInstaller().install(l, remoteServerDMScheduleImpl);
                } else {
                    logger.warn((Object)("=========> Registering a simulated Server? " + remoteServerDM.getClass().getName()));
                    l2 = System.currentTimeMillis();
                }
                try {
                    this.remoteServersDM.recordInstalledDateTime(l, l2);
                    break;
                }
                catch (ResourceUnavailableException resourceUnavailableException) {
                    throw new RemoteServerException(MessageUtil.formatMsg((String)"Error while trying to record the installation date/time for remote server {0}.", (Object[])new Object[]{this.getRemoteServerName(l)}), (Throwable)resourceUnavailableException);
                }
            }
            case SKYBOT: {
                this.remoteSkybotServerConnector().register(l);
                break;
            }
            default: {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Remote Server Type {0} is not supported by this method.", (Object[])new Object[]{remoteServerType}));
            }
        }
    }

    public void remoteServerChangedOrAdded(long l) {
        RemoteServerType remoteServerType = null;
        try {
            remoteServerType = this.remoteServersDM.getServerType(l);
        }
        catch (NoDataException noDataException) {
            logger.warn((Object)MessageUtil.formatMsg((String)"The server was notified that the remote server with ID {0} has changed or been added, but that ID was not found.", (Object[])new Object[]{l}));
        }
        catch (Exception exception) {
            logger.error((Object)MessageUtil.formatMsg((String)"Unable to process the notification that the remote server with ID {0} has changed or been added.", (Object[])new Object[]{l}), (Throwable)exception);
        }
        if (remoteServerType != null) {
            switch (remoteServerType) {
                case SKYBOT: {
                    this.remoteSkybotServerConnector().remoteServerChangedOrAdded(l);
                    break;
                }
                case SCHEDULE: {
                    break;
                }
                default: {
                    throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Remote Server Type {0} is not supported by this method.", (Object[])new Object[]{remoteServerType}));
                }
            }
        }
    }

    public void remoteSkybotServerDeleted(long l, String string, String string2, String string3) {
        try {
            this.remoteSkybotServerConnector().remoteServerDeleted(l, string, string2, string3);
        }
        catch (Exception exception) {
            logger.error((Object)MessageUtil.formatMsg((String)"Unable to process the notification that the remote server with ID {0} has been deleted.", (Object[])new Object[]{l}), (Throwable)exception);
        }
    }

    public void startRemoteServerNotificationMonitors() {
        long[] lArray;
        try {
            lArray = this.remoteServersDM.getRemoteServersThatRequireNotificationMonitoring();
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)"Unable to start the Remote Server Notification Monitors. Error while trying to get a list of the remote servers that require notification monitoring.", (Throwable)resourceUnavailableException);
            return;
        }
        for (long l : lArray) {
            try {
                this.startRemoteServerNotificationMonitor(l);
            }
            catch (Exception exception) {
                logger.error((Object)MessageUtil.formatMsg((String)"Unable to start Notification Monitoring for remote server {0}.", (Object[])new Object[]{this.getRemoteServerName(l)}), (Throwable)exception);
            }
        }
    }

    public void startRemoteSkybotServerConnectorProcess() {
        this.remoteSkybotServerConnector = RemoteSkybotServerConnector.createAndStartConnector(this.peer);
    }

    public boolean testAccessToRemoteServer(RemoteServer remoteServer) throws RemoteServerUnreachableException {
        ValidationHelper.checkForNull((String)"Remote Server", (Object)remoteServer);
        ValidationHelper.checkForNull((String)"Remote Server Type", (Object)remoteServer.getType());
        switch (remoteServer.getType()) {
            case SCHEDULE: {
                return RemoteScheduleServerInstaller.testAccessToRemoteServer((RemoteScheduleServer)remoteServer);
            }
            case SKYBOT: {
                return RemoteSkybotServerConnector.testAccessToRemoteServer((RemoteSkybotServer)remoteServer);
            }
        }
        throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Remote Server Type {0} is not supported by this method.", (Object[])new Object[]{remoteServer.getType()}));
    }

    public void uninstall(long l) throws RemoteServerUnreachableException, RemoteServerException, RemoteServerNotConfiguredException {
        RemoteServerType remoteServerType = this.getRemoteServerType(l);
        switch (remoteServerType) {
            case SCHEDULE: {
                Long l2;
                try {
                    l2 = this.remoteServersDM.getInstalledDateTime(l);
                    if (l2 == null || l2 == 0L) {
                        logger.info((Object)("Uninstalling a Remote Server that was not registered: " + l));
                        return;
                    }
                }
                catch (ResourceUnavailableException resourceUnavailableException) {
                    throw new RuntimeException("Error checking remote server installation.", resourceUnavailableException);
                }
                l2 = this.getDataManager(l);
                if (l2 instanceof RemoteServerDMScheduleImpl) {
                    RemoteServerDMScheduleImpl remoteServerDMScheduleImpl = (RemoteServerDMScheduleImpl)((Object)l2);
                    new RemoteScheduleServerInstaller().uninstall(l, remoteServerDMScheduleImpl);
                } else {
                    logger.error((Object)"****** WARNING: remoteServerDM is not an instance of RemoteServerDMScheduleImpl. (Simulator?) *****");
                }
                try {
                    this.remoteServersDM.clearInstalledDateTime(l);
                    break;
                }
                catch (ResourceUnavailableException resourceUnavailableException) {
                    throw new RemoteServerException(MessageUtil.formatMsg((String)"Error while trying to clear the installation date/time for remote server {0}.", (Object[])new Object[]{this.getRemoteServerName(l)}), (Throwable)resourceUnavailableException);
                }
            }
            case SKYBOT: {
                break;
            }
            default: {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Remote Server Type {0} is not supported by this method.", (Object[])new Object[]{remoteServerType}));
            }
        }
    }

    private boolean eventIsAPrerequisite(long l) {
        try {
            PrereqDM prereqDM = (PrereqDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.PrereqDM");
            return prereqDM.eventIsPrerequisite(null, l, PrereqEventType.REMOTE_EVENT);
        }
        catch (Exception exception) {
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Unable to determine if the remote event with ID {0} is used as a prerequisite.", (Object[])new Object[]{l}), exception);
        }
    }

    private RemoteServerDM getDataManager(long l) throws RemoteServerUnreachableException, RemoteServerException {
        RemoteServerType remoteServerType = this.getRemoteServerType(l);
        RemoteServerDM remoteServerDM = null;
        switch (remoteServerType) {
            case SCHEDULE: {
                String string = Long.toString(l);
                remoteServerDM = (RemoteServerDM)ManagerRegistry.getManager((String)"ENTERPRISE.RemoteServerDM", (String)string);
                if (remoteServerDM != null) break;
                remoteServerDM = this.simulation(l) ? new RemoteServerDMScheduleImplSimulator(l, string) : new RemoteServerDMScheduleImpl(l, string);
                ManagerRegistry.registerManager((IAbstractManager)remoteServerDM);
                break;
            }
            case SKYBOT: {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Remote Server Type {0} is not supported by this method.", (Object[])new Object[]{remoteServerType}));
            }
            default: {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Remote Server Type {0} is not supported by this method.", (Object[])new Object[]{remoteServerType}));
            }
        }
        return remoteServerDM;
    }

    private RemoteServer getRemoteServer(long l) throws RemoteServerException {
        try {
            return this.remoteServersDM.getServer(l);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw new RemoteServerException(MessageUtil.formatMsg((String)"Error while trying to retrieve the database entry for the remote server with id={0}.", (Object[])new Object[]{l}), (Throwable)resourceUnavailableException);
        }
    }

    private String getRemoteServerName(long l) {
        return this.remoteServersDM.getServerName(l);
    }

    private boolean isConnectedToRemoteServer(RemoteSkybotServer remoteSkybotServer) {
        PeerDescriptor peerDescriptor = new PeerDescriptor();
        peerDescriptor.setType(6);
        peerDescriptor.addAddress(remoteSkybotServer.getIpAddress());
        peerDescriptor.setPort(remoteSkybotServer.getListenPort());
        PeerID[] peerIDArray = this.peer.searchRoutingTableFor(peerDescriptor);
        return peerIDArray.length > 0;
    }

    private RemoteServerDM remoteServerDM(long l) throws RemoteServerException, RemoteServerUnreachableException {
        RemoteServer remoteServer = this.getRemoteServer(l);
        return this.remoteServerDM(remoteServer);
    }

    private RemoteServerDM remoteServerDM(RemoteServer remoteServer) throws RemoteServerException, RemoteServerUnreachableException {
        RemoteServerDM remoteServerDM;
        block1 : switch (remoteServer.getType()) {
            case SCHEDULE: {
                long l = remoteServer.getId();
                String string = Long.toString(l);
                remoteServerDM = (RemoteServerDM)ManagerRegistry.getManager((String)"ENTERPRISE.RemoteServerDM", (String)string);
                if (remoteServerDM != null) break;
                remoteServerDM = this.simulation(l) ? new RemoteServerDMScheduleImplSimulator(l, string) : new RemoteServerDMScheduleImpl(l, string);
                ManagerRegistry.registerManager((IAbstractManager)remoteServerDM);
                break;
            }
            case SKYBOT: {
                RemoteSkybotServer remoteSkybotServer = (RemoteSkybotServer)remoteServer;
                RemoteServerStatus remoteServerStatus = remoteSkybotServer.getStatus();
                switch (remoteServerStatus) {
                    case ACTIVE: {
                        try {
                            remoteServerDM = (RemoteServerDM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)remoteSkybotServer, (String)"ENTERPRISE.RemoteServerDM");
                            break block1;
                        }
                        catch (Exception exception) {
                            throw new RemoteServerUnreachableException(MessageUtil.formatMsg((String)"Unable to get a reference to the RemoteServerDM on remote server {0}.", (Object[])new Object[]{remoteServer.getName()}));
                        }
                    }
                    case FAILED: {
                        throw new RemoteServerUnreachableException(MessageUtil.formatMsg((String)"Remote server {0} is not connected to this server.", (Object[])new Object[]{remoteServer.getName()}));
                    }
                    case APPROVAL_REQUIRED: 
                    case PENDING_REMOTE_APPROVAL: {
                        throw new RemoteServerException(MessageUtil.formatMsg((String)"An attempt was made to communicate with remote server {0}. However, that remote server is registered, but not yet approved.", (Object[])new Object[]{remoteServer.getName()}));
                    }
                    case REGISTRATION_REQUIRED: {
                        throw new RemoteServerException(MessageUtil.formatMsg((String)"An attempt was made to communicate with remote server {0}. However, that remote server is unregistered.", (Object[])new Object[]{remoteServer.getName()}));
                    }
                }
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Remote Server Status {0} is not supported by this method.", (Object[])new Object[]{remoteServerStatus}));
            }
            default: {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Remote Server Type {0} is not supported by this method.", (Object[])new Object[]{remoteServer.getType()}));
            }
        }
        return remoteServerDM;
    }

    private RemoteSkybotServerConnector remoteSkybotServerConnector() {
        if (this.remoteSkybotServerConnector == null) {
            this.remoteSkybotServerConnector = new RemoteSkybotServerConnector(this.remoteServersDM, this.peer);
        }
        return this.remoteSkybotServerConnector;
    }

    private boolean simulation(long l) throws RemoteServerException {
        try {
            RemoteScheduleServer remoteScheduleServer = (RemoteScheduleServer)this.remoteServersDM.getServer(l);
            return remoteScheduleServer.getSystemName().equalsIgnoreCase("SIMULATE");
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw new RemoteServerException(MessageUtil.formatMsg((String)"Error while trying to retrieve information about remote server {0}.", (Object[])new Object[]{this.getRemoteServerName(l)}), (Throwable)resourceUnavailableException);
        }
    }

    private void startRemoteServerNotificationMonitor(long l) throws RemoteServerUnreachableException, RemoteServerException {
        if (this.startedNotificationMonitors.containsKey(l)) {
            Thread thread = this.startedNotificationMonitors.get(l);
            if (thread != null && thread.getState() == Thread.State.NEW) {
                thread.start();
            }
        } else {
            RemoteServerNotificationMonitor remoteServerNotificationMonitor = new RemoteServerNotificationMonitor(l, this.getDataManager(l), this.startedNotificationMonitors);
            String string = "RemoteServerNotificationMonitor_" + l;
            Thread thread = new Thread((Runnable)remoteServerNotificationMonitor, string);
            this.startedNotificationMonitors.put(l, thread);
            thread.start();
        }
    }

    private void startRemoteServerRequestMonitor(long l) throws RemoteServerUnreachableException, RemoteServerException {
        if (this.requestMonitorThread == null || !this.requestMonitorThread.isAlive()) {
            RemoteServerRequestMonitor remoteServerRequestMonitor = new RemoteServerRequestMonitor(l);
            this.requestMonitorThread = new Thread(remoteServerRequestMonitor);
            this.requestMonitorThread.setName("RemoteServerRequestMonitor");
            this.requestMonitorThread.start();
        }
    }

    private String toEventType_forMessageString(RemoteEventType remoteEventType) {
        if (remoteEventType == null) {
            return "null";
        }
        switch (remoteEventType) {
            case JOB_STATUS_CHANGE: {
                return "Job";
            }
            case JOB_SUITE_STATUS_CHANGE: {
                return "Job Suite";
            }
            case JOB_SUITE_MEMBER_STATUS_CHANGE: {
                return "Job Suite Member";
            }
            case AGENT_EVENT: {
                return "Agent Event";
            }
            case SNMP_TRAP_EVENT: {
                return "SNMP Trap Event";
            }
            case JOB_MONITOR_EVENT: {
                return "Job Monitor Event";
            }
            case JOB_SUITE_MONITOR_EVENT: {
                return "Job Suite Monitor Event";
            }
            case JOB_SUITE_MEMBER_MONITOR_EVENT: {
                return "Job Suite Member Monitor Event";
            }
            case SAP_MONITOR_EVENT: {
                return "SAP Monitor Event";
            }
        }
        return remoteEventType.toString();
    }

    private String toString(RemoteEvent remoteEvent) {
        if (remoteEvent != null) {
            String string = this.remoteServersDM.getServerName(remoteEvent.getRemoteServerID());
            return MessageUtil.formatMsg((String)"{0} for the object {1} on remote server {2}", (Object[])new Object[]{remoteEvent.getEventType(), remoteEvent.getRemoteObjectName(), string});
        }
        return "";
    }
}

