/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.remoteserver;

import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.remoteserver.RemoteDependencyNotification;
import com.helpsystems.enterprise.core.remoteserver.RemoteScheduleServer;
import com.helpsystems.enterprise.core.remoteserver.RemoteServerException;
import com.helpsystems.enterprise.core.remoteserver.RemoteServerUnreachableException;
import com.helpsystems.enterprise.core.scheduler.PrereqStatusType;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin8;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class RemoteScheduleServerNotifier {
    private static final Logger logger = Logger.getLogger(RemoteScheduleServerNotifier.class);
    private static String programName = "RBT669";
    private static String formatterString = "yyyyMMddHHmmss";
    private static SimpleDateFormat formatter = new SimpleDateFormat(formatterString);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long notifyOfEvent(RemoteDependencyNotification remoteDependencyNotification, RemoteScheduleServer remoteScheduleServer) throws RemoteServerException, RemoteServerUnreachableException {
        long l;
        block13: {
            l = 0L;
            ValidationHelper.checkForNull((String)"Remote Dependency Notification", (Object)remoteDependencyNotification);
            ValidationHelper.checkForNull((String)"Remote Schedule Server", (Object)remoteScheduleServer);
            String string = remoteDependencyNotification.getObjectName();
            String string2 = remoteDependencyNotification.getUserJobName();
            if (string2 == null || string2.trim().length() == 0) {
                string2 = RemoteDependencyNotification.convertSkybotNameToUserJobName((String)string);
            }
            String string3 = remoteScheduleServer.getLibrary();
            String string4 = new QSYSObjectPathName(string3, programName, "PGM").getPath();
            AS400Bin8 aS400Bin8 = new AS400Bin8();
            ProgramParameter[] programParameterArray = new ProgramParameter[7];
            programParameterArray[0] = new ProgramParameter(new AS400Text(50).toBytes((Object)string));
            programParameterArray[1] = new ProgramParameter(new AS400Bin8().toBytes(remoteDependencyNotification.getEventSourceID()));
            programParameterArray[2] = new ProgramParameter(new AS400Text(10).toBytes((Object)string2));
            String string5 = RemoteScheduleServerNotifier.mapPrereqStatusToScheduleStatus(remoteDependencyNotification.getEventStatus());
            programParameterArray[3] = new ProgramParameter(new AS400Text(1).toBytes((Object)string5));
            long l2 = RemoteScheduleServerNotifier.convertTimestamp(remoteDependencyNotification.getStatusTimestamp());
            programParameterArray[4] = new ProgramParameter(new AS400Bin8().toBytes(l2));
            programParameterArray[5] = new ProgramParameter(new AS400Text(1).toBytes((Object)" "));
            programParameterArray[6] = new ProgramParameter(aS400Bin8.toBytes(0L));
            try {
                programParameterArray[5].setOutputDataLength(1);
                programParameterArray[6].setOutputDataLength(8);
            }
            catch (PropertyVetoException propertyVetoException) {
                logger.warn((Object)"Error setting parameter length.", (Throwable)propertyVetoException);
            }
            AS400 aS400 = RemoteScheduleServerNotifier.establishAS400Connection(remoteScheduleServer);
            try {
                ProgramCall programCall = new ProgramCall(aS400, string4, programParameterArray);
                try {
                    if (!programCall.run()) {
                        logger.error((Object)"An error occurred while sending status to Robot SCHEDULE.");
                        RemoteScheduleServerNotifier.logMessageList(programCall.getMessageList());
                        break block13;
                    }
                    byte[] byArray = programCall.getParameterList()[5].getOutputData();
                    String string6 = new AS400Text(1).toObject(byArray).toString();
                    if (string6 != null && string6.trim().length() == 0) {
                        byte[] byArray2 = programCall.getParameterList()[6].getOutputData();
                        l = aS400Bin8.toLong(byArray2);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Status " + remoteDependencyNotification.getEventStatus() + " for object " + remoteDependencyNotification.getObjectName() + " was sent to remote server " + remoteScheduleServer.getName() + " with timestamp " + l2 + " and processed with receipt ID " + l + "."));
                        }
                        break block13;
                    }
                    if ("1".equals(string6)) {
                        String string7 = "Robot SCHEDULE User Job Name " + string2 + " is not used as a prerequisite. Status was ignored.";
                        logger.warn((Object)string7);
                        break block13;
                    }
                    if ("2".equals(string6)) {
                        String string8 = "Robot SCHEDULE rejected the status code: " + remoteDependencyNotification.getEventStatus();
                        logger.warn((Object)string8);
                        break block13;
                    }
                    String string9 = "Undefined return code (" + string6 + ") returned from RBT669.";
                    logger.warn((Object)string9);
                }
                catch (Exception exception) {
                    logger.warn((Object)"Error notifying Robot SCHEDULE of status.", (Throwable)exception);
                }
            }
            finally {
                aS400.disconnectAllServices();
            }
        }
        return l;
    }

    private static void addLibraryListEntry(AS400 aS400, String string) throws PropertyVetoException, InterruptedException, IOException, ErrorCompletingRequestException, AS400SecurityException {
        CommandCall commandCall = new CommandCall(aS400);
        if (!commandCall.run("ADDLIBLE " + string)) {
            boolean bl = true;
            AS400Message[] aS400MessageArray = commandCall.getMessageList();
            if (RemoteScheduleServerNotifier.messageListContains(aS400MessageArray, "CPF2103")) {
                bl = false;
            }
            if (bl) {
                logger.error((Object)("Error adding library to library list: " + string));
                RemoteScheduleServerNotifier.logMessageList(commandCall.getMessageList());
            }
        }
    }

    private static long convertTimestamp(long l) {
        if (l > 0L) {
            Date date = new Date(l);
            String string = formatter.format(date);
            return Long.parseLong(string);
        }
        return 0L;
    }

    private static AS400 establishAS400Connection(RemoteScheduleServer remoteScheduleServer) throws RemoteServerException, RemoteServerUnreachableException {
        String string = remoteScheduleServer.getUser();
        AS400 aS400 = new AS400(remoteScheduleServer.getSystemName(), string, remoteScheduleServer.getPwd());
        try {
            aS400.setGuiAvailable(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            logger.debug((Object)"Warning: The AS400 object rejected the property setGuiAvailable(false). Unwanted GUI prompting may occur.");
        }
        AS400.setPasswordExpirationWarningDays((int)-1);
        try {
            aS400.validateSignon();
        }
        catch (Exception exception) {
            String string2 = MessageUtil.formatMsg((String)"Error trying to create a connection for user {0} on server {1}. Unable to validate the user.", (Object[])new Object[]{string, remoteScheduleServer.getSystemName()});
            throw new RemoteServerException(string2, (Throwable)exception);
        }
        try {
            RemoteScheduleServerNotifier.addLibraryListEntry(aS400, remoteScheduleServer.getLibrary());
        }
        catch (Exception exception) {
            logger.warn((Object)"Error setting library list.", (Throwable)exception);
        }
        return aS400;
    }

    private static void logMessageList(AS400Message[] aS400MessageArray) {
        if (aS400MessageArray == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < aS400MessageArray.length; ++i) {
            stringBuffer.setLength(0);
            stringBuffer.append(aS400MessageArray[i].getID() + ": ");
            stringBuffer.append(aS400MessageArray[i].getText());
            logger.warn((Object)stringBuffer.toString());
        }
    }

    private static String mapPrereqStatusToScheduleStatus(PrereqStatusType prereqStatusType) {
        switch (prereqStatusType) {
            case SUBMITTED: {
                return "S";
            }
            case RUNNING: {
                return "R";
            }
            case COMPLETED: {
                return "C";
            }
            case FAILED: {
                return "T";
            }
            case SKIPPED: {
                return "K";
            }
            case BLANK: {
                return " ";
            }
            case CANCELED: {
                throw new IllegalStateException("Program error: Canceled status not allowed to be sent to R/Schedule.");
            }
        }
        throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Prereq status type {0} is not supported by this method.", (Object[])new Object[]{prereqStatusType}));
    }

    private static boolean messageListContains(AS400Message[] aS400MessageArray, String string) {
        for (int i = 0; i < aS400MessageArray.length; ++i) {
            if (!string.equals(aS400MessageArray[i].getID())) continue;
            return true;
        }
        return false;
    }
}

