/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.access.alert;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.ResultSetDataSet;
import com.helpsystems.common.access.SQLWhereClause;
import com.helpsystems.common.core.access.DataSet;
import com.helpsystems.common.core.access.DataSetException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.alert.Recipient;
import com.helpsystems.common.core.alert.RecipientDM;
import com.helpsystems.common.core.busobj.Proxy;
import com.helpsystems.common.core.busobj.UserIdentity;
import com.helpsystems.common.core.filter.DataFilter;
import com.helpsystems.common.core.filter.GenericSortField;
import com.helpsystems.common.core.filter.SortField;
import com.helpsystems.common.core.util.ResourceBundleHandler;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class RecipientJDBC
extends AbstractDatabaseManager
implements RecipientDM {
    private static ResourceBundleHandler rbh = ResourceBundleHandler.getHandler((String)RecipientJDBC.class.getName());
    private static final Logger logger = Logger.getLogger(RecipientJDBC.class);
    protected String libraryName;
    private static final SortField[] SORT_FIELDS = new SortField[]{new GenericSortField(10101, 0), new GenericSortField(52, 0), new GenericSortField(20202, 0)};

    public RecipientJDBC(String string, String string2, String string3) {
        super(string);
        this.setName(string3);
        this.libraryName = string2;
    }

    public Recipient getRecipient(String string) throws NoDataException, ResourceUnavailableException {
        Recipient recipient;
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            Object object;
            wrappedConnection = this.getConnection();
            String string2 = "select ditopg as name, didesc as description, '1' as type from " + this.libraryName + ".rbadi where ditopg=?";
            preparedStatement = wrappedConnection.prepareStatement(string2);
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                resultSet.close();
                preparedStatement.close();
                object = "select blbrnm as name, blbrds as description, '2' as type from " + this.libraryName + ".rbabl where blbrnm=?";
                preparedStatement = wrappedConnection.prepareStatement((String)object);
                preparedStatement.setString(1, string);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) {
                    throw new NoDataException(rbh.getMsg("invalid_alert_device", (Object)string));
                }
            }
            object = new RecipientGenerator();
            recipient = (Recipient)object.generateObject(resultSet);
        }
        catch (Exception exception) {
            try {
                throw new ResourceUnavailableException("Unable to load Recipient " + string, (Throwable)exception);
            }
            catch (Throwable throwable) {
                RecipientJDBC.closeEm(wrappedConnection, preparedStatement, resultSet);
                throw throwable;
            }
        }
        RecipientJDBC.closeEm(wrappedConnection, preparedStatement, resultSet);
        return recipient;
    }

    public DataSet getDataSet(UserIdentity userIdentity, DataFilter dataFilter, SortField sortField) throws DataSetException, ResourceUnavailableException {
        return this.getRecipientList(dataFilter, sortField);
    }

    public DataSet getRecipientList(DataFilter dataFilter, SortField sortField) throws ResourceUnavailableException {
        String string = "SELECT DITOPG AS NAME, DIDESC AS DESCRIPTION, '1' AS TYPE FROM " + this.libraryName + ".RBADI";
        String string2 = "SELECT BLBRNM AS NAME, BLBRDS AS DESCRIPTION, '2' AS TYPE FROM " + this.libraryName + ".RBABL";
        String string3 = string + " UNION ALL " + string2;
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        try {
            wrappedConnection = this.getConnection();
            String string4 = "";
            if (dataFilter != null && !dataFilter.isEmpty()) {
                string4 = " where " + SQLWhereClause.getSQL(dataFilter, true) + " ";
            }
            String string5 = "select count (*) from (" + string3 + ") as joinqry " + string4;
            logger.trace((Object)("Count String: " + string5));
            PreparedStatement preparedStatement = wrappedConnection.prepareStatement(string5);
            if (string4.length() > 0) {
                SQLWhereClause.prepareSQLWhereClause(preparedStatement, 1, dataFilter);
            }
            String string6 = this.getRecipientSortSQL(sortField);
            String string7 = "select * from (" + string3 + ") as joinqry " + string4 + string6;
            logger.trace((Object)("Query String: " + string7));
            PreparedStatement preparedStatement2 = wrappedConnection.prepareStatement(string7, 1004, 1007);
            if (string4.length() > 0) {
                SQLWhereClause.prepareSQLWhereClause(preparedStatement2, 1, dataFilter);
            }
            int n = -1;
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            resultSet = preparedStatement2.executeQuery();
            RecipientGenerator recipientGenerator = new RecipientGenerator();
            return ResultSetDataSet.createDataSet(resultSet, recipientGenerator, n);
        }
        catch (Exception exception) {
            RecipientJDBC.closeEm(wrappedConnection, null, null);
            throw new ResourceUnavailableException("Recipient list query failed.", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Proxy[] getPage2WayDevicesAsProxies() {
        String string = " left join " + this.libraryName + ".rbavm" + " on DIVEND = vmvend left join " + this.libraryName + ".rbaph on vmptnm = PHPTNM " + "WHERE (phprot = 1 AND vmihst <> '') OR (phprot = 0 AND phtwwy = 2)";
        String string2 = "select distinct DITOPG AS NAME, DIDESC AS DESCRIPTION, '1' AS TYPE from " + this.libraryName + ".rbadi" + string;
        String string3 = "SELECT distinct BLBRNM AS NAME, BLBRDS AS DESCRIPTION, '2' AS TYPE FROM " + this.libraryName + ".RBABL left join " + this.libraryName + ".rbabj on blbrnm = bjbrnm left join " + this.libraryName + ".rbadi on bjtopg = ditopg" + string;
        String string4 = string2 + " UNION ALL " + string3 + " ORDER BY NAME";
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.getDefaultPreparedStmt(string4);
            RecipientGenerator recipientGenerator = new RecipientGenerator();
            ResultSet resultSet = preparedStatement.executeQuery();
            Proxy[] proxyArray = (Proxy[])recipientGenerator.generateObjectArray(resultSet);
            return proxyArray;
        }
        catch (Exception exception) {
            String string5 = "Error loading list of 2-way devices.";
            logger.debug((Object)string5, (Throwable)exception);
            Proxy[] proxyArray = null;
            return proxyArray;
        }
        finally {
            if (preparedStatement != null) {
                this.closeConnection(preparedStatement);
            }
        }
    }

    public SortField[] getSortFields() {
        return SORT_FIELDS;
    }

    private String getRecipientSortSQL(SortField sortField) {
        String string = "order by name";
        if (sortField == null) {
            return string;
        }
        String string2 = "";
        if (sortField.getDirection() == 1) {
            string2 = "desc ";
        }
        switch (sortField.getField()) {
            case 10101: {
                string = "order by name " + string2;
                break;
            }
            case 20202: {
                string = "order by description " + string2 + ", name ";
                break;
            }
            case 52: {
                string = "order by type " + string2 + ", name ";
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Sort Order: " + sortField.getField());
            }
        }
        return string;
    }

    class RecipientGenerator
    extends AbstractBusObjGenerator {
        RecipientGenerator() {
            super(3, Recipient.class.getName());
        }

        @Override
        protected Object constructObject() {
            return new Recipient();
        }

        @Override
        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException {
            Recipient recipient = (Recipient)object;
            switch (n) {
                case 1: {
                    recipient.setName(resultSet.getString("name"));
                    break;
                }
                case 2: {
                    recipient.setDescription(resultSet.getString("description"));
                    break;
                }
                case 3: {
                    recipient.setType(resultSet.getInt("type"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass #" + n + " exceeds maximum.");
                }
            }
        }
    }
}

