/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.access;

import com.helpsystems.common.access.BusinessObjectGenerator;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.BadDataArrayException;
import com.helpsystems.common.core.access.BadDataException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;

public class SQLHelperGenerator
implements BusinessObjectGenerator {
    private Class objectClass;
    private SQLManagerHelper helper;
    private HashMap<String, Object> hints;

    public SQLHelperGenerator(Class clazz, SQLManagerHelper sQLManagerHelper) {
        if (clazz == null) {
            throw new NullPointerException("The object class passed in is null.");
        }
        this.objectClass = clazz;
        if (sQLManagerHelper == null) {
            throw new NullPointerException("The SQL Helper passed in is null.");
        }
        this.helper = sQLManagerHelper;
        this.hints = new HashMap();
    }

    public Object generateObject(ResultSet resultSet) throws BadDataException, SQLException {
        Object object = this.createAnInstance();
        this.helper.loadObject(object, resultSet, this.hints);
        return object;
    }

    public Object[] generateObjectArray(ResultSet resultSet) throws BadDataArrayException, SQLException {
        Object object = this.createAnInstance();
        return this.helper.loadArray(object, resultSet);
    }

    private Object createAnInstance() throws SQLException {
        try {
            return this.objectClass.newInstance();
        }
        catch (Exception exception) {
            SQLException sQLException = new SQLException("The generator was unable to create an instance of " + this.objectClass.getName());
            sQLException.initCause(exception);
            throw sQLException;
        }
    }
}

